/*
 * Decompiled with CFR 0.152.
 */
package commvault.web.core.util;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import commvault.cte.common.xml.XMLEncoder;
import commvault.web.core.filter.RequestContext;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.HashSet;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class CVCoreUtil {
    private static final Logger logger = Logger.getLogger((String)"commvault.web");
    private static String webappCanonicalPath;
    private static String webinfCanonicalPath;
    private static HashSet<String> validResources;

    public static long convertMinutesToMs(long l) {
        return l * 60000L;
    }

    public static boolean isSafeInclude(String string) {
        if (string == null || string.isEmpty()) {
            return false;
        }
        if (webappCanonicalPath == null || webinfCanonicalPath == null) {
            try {
                webappCanonicalPath = new File(RequestContext.getRequest().getServletContext().getRealPath("/")).getCanonicalPath();
                webinfCanonicalPath = new File(RequestContext.getRequest().getServletContext().getRealPath("/WEB-INF")).getCanonicalPath();
            }
            catch (IOException iOException) {
                logger.error((Object)("Failed to get canonical path from servelet context. " + iOException.getMessage()));
            }
        }
        if (string.startsWith(RequestContext.getRequest().getContextPath())) {
            string = string.substring(RequestContext.getRequest().getContextPath().length());
        }
        String string2 = "";
        try {
            string2 = new File(RequestContext.getRequest().getServletContext().getRealPath(string)).getCanonicalPath();
        }
        catch (Exception exception) {
            logger.error((Object)("Failed to get canonical path of include. Path: " + string), (Throwable)exception);
            return false;
        }
        if (string2.startsWith(webappCanonicalPath) && !string2.startsWith(webinfCanonicalPath)) {
            if (validResources.contains(string2)) {
                return true;
            }
            if (Files.exists(Paths.get(string2, new String[0]), new LinkOption[0])) {
                validResources.add(string2);
                return true;
            }
        }
        logger.error((Object)("Removing insecure include. Path: " + string));
        return false;
    }

    public static <T> T lookup(Class<T> clazz) {
        Object object;
        BeanManager beanManager = null;
        try {
            object = new InitialContext();
            beanManager = (BeanManager)((Context)object.lookup("java:comp/env")).lookup("BeanManager");
        }
        catch (NamingException namingException) {
            logger.error((Object)"ERROR loading BM", (Throwable)namingException);
            throw new RuntimeException("Can't initialize bean manager.");
        }
        object = beanManager.getBeans(clazz, new Annotation[0]).iterator();
        if (!object.hasNext()) {
            throw new IllegalStateException("CDI BeanManager cannot find an instance of requested type " + clazz.getName());
        }
        Bean bean = (Bean)object.next();
        CreationalContext creationalContext = beanManager.createCreationalContext((Contextual)bean);
        return (T)beanManager.getReference(bean, clazz, creationalContext);
    }

    public static String encodeXml(Object object) {
        try {
            return XMLEncoder.encode((Object)object);
        }
        catch (Exception exception) {
            logger.error((Object)"Exception encoding XML: ", (Throwable)exception);
            return null;
        }
    }

    public static String urlEncode(String string) {
        try {
            URL uRL = new URL(string);
            URI uRI = new URI(uRL.getProtocol(), uRL.getAuthority(), uRL.getPath(), uRL.getQuery(), uRL.getRef());
            return uRI.toURL().toString();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static final String getJsonForObject(Object object) {
        String string = "";
        if (object != null) {
            try {
                string = CVCoreUtil.buildGson().toJson(object, object.getClass());
            }
            catch (Exception exception) {
                logger.error((Object)"object to json", (Throwable)exception);
            }
        }
        return string;
    }

    public static final String getJsonForObjectNonHTMLEscape(Object object) {
        String string = "";
        if (object != null) {
            try {
                string = CVCoreUtil.buildNonHTMLEscapeGson().toJson(object, object.getClass());
            }
            catch (Exception exception) {
                logger.error((Object)"object to json", (Throwable)exception);
            }
        }
        return string;
    }

    public static Gson buildGson() {
        return new GsonBuilder().setExclusionStrategies(new ExclusionStrategy[]{new ExclusionStrategy(){

            public boolean shouldSkipField(FieldAttributes fieldAttributes) {
                return fieldAttributes.getName().equals("_type_");
            }

            public boolean shouldSkipClass(Class<?> clazz) {
                return clazz.getName().equals("commvault.web.creconn.entity.EntityType");
            }
        }}).create();
    }

    public static Gson buildNonHTMLEscapeGson() {
        return new GsonBuilder().setExclusionStrategies(new ExclusionStrategy[]{new ExclusionStrategy(){

            public boolean shouldSkipField(FieldAttributes fieldAttributes) {
                return fieldAttributes.getName().equals("_type_");
            }

            public boolean shouldSkipClass(Class<?> clazz) {
                return clazz.getName().equals("commvault.web.creconn.entity.EntityType");
            }
        }}).disableHtmlEscaping().create();
    }

    public static <T> Object getRespObjectFromJson(Class<T> clazz, String string) {
        try {
            return CVCoreUtil.buildGson().fromJson(string, clazz);
        }
        catch (Exception exception) {
            logger.error((Object)("Failed to convert JSON string into " + clazz + ": " + string), (Throwable)exception);
            return null;
        }
    }

    public static String streamToString(InputStream inputStream) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        while (bufferedInputStream.available() != 0) {
            stringBuilder.append((char)bufferedInputStream.read());
        }
        return stringBuilder.toString().trim();
    }

    public static JsonElement parseJson(String string) {
        JsonElement jsonElement = null;
        if (string != null) {
            try {
                JsonParser jsonParser = new JsonParser();
                jsonElement = jsonParser.parse(string);
            }
            catch (Exception exception) {
                logger.error((Object)"Failed to create json tree.");
                logger.error((Object)"", (Throwable)exception);
            }
        } else {
            throw new RuntimeException("Failed to create json tree");
        }
        return jsonElement;
    }

    protected static void write(String string, String string2) {
        try {
            HttpServletResponse httpServletResponse = RequestContext.getResponse();
            httpServletResponse.setContentType(string2);
            httpServletResponse.setCharacterEncoding("UTF-8");
            PrintWriter printWriter = httpServletResponse.getWriter();
            printWriter.write(string);
            printWriter.flush();
        }
        catch (IOException iOException) {
            logger.error((Object)"Error", (Throwable)iOException);
            throw new RuntimeException(iOException);
        }
    }

    public static void write(String string) {
        CVCoreUtil.write(string, "text/plain");
    }

    static {
        validResources = new HashSet();
    }
}

