/*
 * Decompiled with CFR 0.152.
 */
package commvault.web.core.net;

import commvault.web.core.net.RequestMethod;
import commvault.web.core.util.CVCoreUtil;
import java.util.Map;
import org.apache.log4j.Logger;

public class RequestObject {
    private String api;
    private String reqPayload;
    private String reqContentType = "application/xml";
    private String respContentType = "application/xml";
    private String url;
    private Object reqObject;
    private Boolean cacheable;
    private long cacheLifeInNanoSeconds = 14400000000000L;
    private RequestMethod requestMethod = RequestMethod.POST;
    private String cacheContext;
    private boolean requestLoggingDisabled;
    private boolean responseLoggingDisabled;
    private boolean suppressAllLogging;
    private String overrideCookieToken;
    private String sharedItemToken;
    private String acceptHeader;
    private Map<String, String> customHeaders;
    private Map<String, String> paramMap;
    private boolean skipEncoding = false;
    private Integer timeout;
    private boolean isWebServiceMonitoringRequest = false;
    private boolean customHeadersMaskingEnabled;
    private static final Logger logger = Logger.getLogger((String)"commvault.web");

    public static RequestObject post(String string, Object object) {
        RequestObject requestObject = new RequestObject(string, object);
        requestObject.setRequestMethod(RequestMethod.POST);
        return requestObject;
    }

    public static RequestObject put(String string, Object object) {
        RequestObject requestObject = new RequestObject(string, object);
        requestObject.setRequestMethod(RequestMethod.PUT);
        return requestObject;
    }

    public static RequestObject get(String string) {
        RequestObject requestObject = new RequestObject(string);
        requestObject.setRequestMethod(RequestMethod.GET);
        return requestObject;
    }

    public static RequestObject delete(String string) {
        RequestObject requestObject = new RequestObject(string);
        requestObject.setRequestMethod(RequestMethod.DELETE);
        return requestObject;
    }

    public synchronized String getReqPayload() throws Exception {
        if (this.reqPayload == null) {
            if (this.reqObject == null) {
                this.reqPayload = "";
            } else if (this.reqObject instanceof String) {
                this.reqPayload = (String)this.reqObject;
            } else if (this.reqObject instanceof byte[]) {
                this.reqPayload = "";
            } else if (this.reqContentType == "application/json") {
                this.reqPayload = CVCoreUtil.getJsonForObject(this.reqObject);
            } else if (this.reqContentType == "application/xml") {
                this.reqPayload = CVCoreUtil.encodeXml(this.reqObject);
            }
        }
        return this.reqPayload;
    }

    public Map<String, String> getParamMap() {
        return this.paramMap;
    }

    public void setParamMap(Map<String, String> map) {
        this.paramMap = map;
    }

    public RequestObject(String string) {
        this.url = string;
    }

    public RequestObject(String string, Object object) {
        this(string);
        this.reqObject = object;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String string) {
        this.url = string;
    }

    public Object getReqObject() {
        return this.reqObject;
    }

    public String getReqContentType() {
        return this.reqContentType;
    }

    public void setReqContentType(String string) {
        this.reqContentType = string;
    }

    public Boolean isCacheable() {
        return this.cacheable;
    }

    public void setCacheable(Boolean bl) {
        this.cacheable = bl;
    }

    public long getCacheLifeInNanoSeconds() {
        return this.cacheLifeInNanoSeconds;
    }

    public void setCacheLifeInNanoSeconds(long l) {
        this.cacheLifeInNanoSeconds = l;
    }

    public String getRespContentType() {
        return this.respContentType;
    }

    public void setRespContentType(String string) {
        this.respContentType = string;
    }

    public RequestMethod getRequestMethod() {
        return this.requestMethod;
    }

    public void setRequestMethod(RequestMethod requestMethod) {
        this.requestMethod = requestMethod;
    }

    public void setCacheContext(String string) {
        this.cacheContext = string;
    }

    public String getCacheContext() {
        return this.cacheContext;
    }

    public void setCacheInfo(String string, long l) {
        this.cacheContext = string;
        this.cacheLifeInNanoSeconds = l;
        this.cacheable = true;
    }

    public boolean isRequestLoggingDisabled() {
        return this.requestLoggingDisabled;
    }

    public void setRequestLoggingDisabled(boolean bl) {
        this.requestLoggingDisabled = bl;
    }

    public boolean isResponseLoggingDisabled() {
        return this.responseLoggingDisabled;
    }

    public void setResponseLoggingDisabled(boolean bl) {
        this.responseLoggingDisabled = bl;
    }

    public String getOverrideCookieToken() {
        return this.overrideCookieToken;
    }

    public void setOverrideCookieToken(String string) {
        this.overrideCookieToken = string;
    }

    public String getSharedItemToken() {
        return this.sharedItemToken;
    }

    public void setSharedItemToken(String string) {
        this.sharedItemToken = string;
    }

    public String getAcceptHeader() {
        return this.acceptHeader;
    }

    public void setAcceptHeader(String string) {
        this.acceptHeader = string;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> map) {
        this.customHeaders = map;
    }

    public boolean isSkipEncoding() {
        return this.skipEncoding;
    }

    public void setSkipEncoding(boolean bl) {
        this.skipEncoding = bl;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Integer n) {
        this.timeout = n;
    }

    public boolean isWebServiceMonitoringRequest() {
        return this.isWebServiceMonitoringRequest;
    }

    public void setIsWebServiceMonitoringRequest(boolean bl) {
        this.isWebServiceMonitoringRequest = bl;
    }

    public boolean isSuppressAllLogging() {
        return this.suppressAllLogging;
    }

    public void setSuppressAllLogging(boolean bl) {
        this.suppressAllLogging = bl;
    }

    public boolean isCustomHeadersMaskingEnabled() {
        return this.customHeadersMaskingEnabled;
    }
}

