/*
 * Decompiled with CFR 0.152.
 */
package commvault.web.core.net;

import commvault.web.core.Constants;
import commvault.web.core.filter.RequestContext;
import commvault.web.core.msg.CheckCredentialResp;
import commvault.web.core.net.RequestMethod;
import commvault.web.core.net.RequestObject;
import commvault.web.core.net.ServerException;
import commvault.web.core.util.CVCoreUtil;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.jstl.core.Config;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apache.log4j.Logger;

@ApplicationScoped
public class HttpHelper {
    private static final Logger logger = Logger.getLogger((String)"commvault.web");
    private static int timeout;

    @PostConstruct
    public void init() {
        timeout = (int)CVCoreUtil.convertMinutesToMs(Constants.SERVERCALL_TIMEOUT);
    }

    public static boolean isCausedBy(Throwable throwable, Class<?> clazz) {
        while (throwable != null) {
            if (clazz.isAssignableFrom(throwable.getClass())) {
                return true;
            }
            throwable = throwable.getCause();
        }
        return false;
    }

    public HttpResponse getResponse(RequestObject requestObject) throws Exception {
        HttpResponse httpResponse = null;
        String string = requestObject.getUrl();
        String string2 = requestObject.getReqPayload();
        try {
            Object object;
            Object object2;
            CloseableHttpClient closeableHttpClient = HttpClientBuilder.create().build();
            Integer n = requestObject.getTimeout();
            if (n == null) {
                n = timeout;
            }
            RequestConfig.Builder builder = RequestConfig.custom();
            builder.setConnectionRequestTimeout(n.intValue());
            builder.setConnectTimeout(n.intValue());
            HttpGet httpGet = null;
            if (!requestObject.isSkipEncoding()) {
                string = CVCoreUtil.urlEncode(string);
            }
            HttpEntity httpEntity = null;
            if (requestObject.getRequestMethod() == RequestMethod.POST) {
                object2 = new HttpPost(string);
                httpEntity = this.setParamsAndBuildEntity(requestObject, string2, (HttpRequestBase)object2);
                object2.setEntity(httpEntity);
                httpGet = object2;
            } else if (requestObject.getRequestMethod() == RequestMethod.GET) {
                httpGet = new HttpGet(string);
            } else if (requestObject.getRequestMethod() == RequestMethod.PUT) {
                object2 = new HttpPut(string);
                httpEntity = this.setParamsAndBuildEntity(requestObject, string2, (HttpRequestBase)object2);
                object2.setEntity(httpEntity);
                httpGet = object2;
            } else {
                httpEntity = this.buildEntity(requestObject, string2);
                object2 = new HttpDeleteWithBody(string);
                object2.setEntity(httpEntity);
                httpGet = object2;
            }
            object2 = requestObject.getReqContentType();
            if (object2 == null) {
                object2 = "application/xml";
            }
            if (httpEntity != null && httpEntity instanceof UrlEncodedFormEntity) {
                httpGet.setHeader("Content-Type", "application/x-www-form-urlencoded");
            } else {
                httpGet.setHeader("Content-Type", (String)object2);
            }
            if (RequestContext.getRequest() != null && RequestContext.getRequest().getSession() != null) {
                object = (CheckCredentialResp)RequestContext.getRequest().getSession().getAttribute("LOGIN_TOKEN_INFO");
                if (object != null) {
                    httpGet.setHeader("Cookie2", ((CheckCredentialResp)object).getToken());
                }
                Locale locale = (Locale)Config.get((ServletRequest)RequestContext.getRequest(), (String)"javax.servlet.jsp.jstl.fmt.locale");
                String string3 = null;
                if (locale != null) {
                    string3 = locale.toString();
                }
                if (string3 == null) {
                    string3 = "en_US";
                }
                httpGet.setHeader("locale", string3);
            }
            if (requestObject.getOverrideCookieToken() != null) {
                httpGet.setHeader("Cookie2", requestObject.getOverrideCookieToken());
            }
            if (requestObject.getAcceptHeader() != null && !requestObject.getAcceptHeader().isEmpty()) {
                httpGet.setHeader("Accept", requestObject.getAcceptHeader());
            }
            if (requestObject.getCustomHeaders() != null && (object = requestObject.getCustomHeaders()) != null && !object.isEmpty()) {
                for (String string3 : object.keySet()) {
                    String string4 = (String)object.get(string3);
                    if (logger.isDebugEnabled()) {
                        boolean bl = string3 != null && string3.toLowerCase().contains("password");
                        logger.debug((Object)("Custom header: " + string3 + "=" + (bl ? "[password omitted from logs]" : string4)));
                    }
                    httpGet.setHeader(string3, string4);
                }
            }
            if (RequestContext.getRequest() != null) {
                httpGet.setHeader("User-Agent", RequestContext.getRequest().getHeader("User-Agent"));
            }
            httpResponse = closeableHttpClient.execute((HttpUriRequest)httpGet);
            return httpResponse;
        }
        catch (Exception exception) {
            logger.error((Object)"Error", (Throwable)exception);
            throw new RuntimeException(exception);
        }
    }

    private HttpEntity buildEntity(RequestObject requestObject, String string) throws UnsupportedEncodingException {
        StringEntity stringEntity = null;
        if (requestObject.getReqContentType() == "application/octet-stream") {
            logger.debug((Object)"Binary content type");
            Object object = requestObject.getReqObject();
            if (object instanceof byte[]) {
                stringEntity = new ByteArrayEntity((byte[])requestObject.getReqObject());
            } else {
                throw new RuntimeException("Invalid request. Req content type is binary but the payload isn't byte array. When building the RequestObject with new RequestObject(String url, Object reqObject) instance pass the second arguement as byte[].");
            }
        }
        if (stringEntity == null) {
            stringEntity = new StringEntity(string, StandardCharsets.UTF_8);
        }
        return stringEntity;
    }

    private HttpEntity setParamsAndBuildEntity(RequestObject requestObject, String string, HttpRequestBase httpRequestBase) throws UnsupportedEncodingException {
        Object object;
        Map<String, String> map = requestObject.getParamMap();
        StringEntity stringEntity = null;
        if ((string == null || string.isEmpty()) && map != null && !map.isEmpty()) {
            object = new ArrayList();
            for (String string2 : map.keySet()) {
                object.add(new BasicNameValuePair(string2, map.get(string2)));
            }
            stringEntity = new UrlEncodedFormEntity((List)object);
        }
        if (requestObject.getReqContentType() == "application/octet-stream") {
            logger.debug((Object)"Binary content type");
            object = requestObject.getReqObject();
            if (object instanceof byte[]) {
                stringEntity = new ByteArrayEntity((byte[])requestObject.getReqObject());
            } else {
                throw new RuntimeException("Invalid request. Req content type is binary but the payload isn't byte array. When building the RequestObject with new RequestObject(String url, Object reqObject) instance pass the second arguement as byte[].");
            }
        }
        if (stringEntity == null) {
            stringEntity = new StringEntity(string, StandardCharsets.UTF_8);
        }
        return stringEntity;
    }

    public boolean sendError(PageContext pageContext) {
        return this.sendError(pageContext, (String)null);
    }

    public boolean sendError(PageContext pageContext, ServerException serverException) {
        if (serverException.isShowErrorMessageToUser()) {
            return this.sendError(pageContext, serverException.getMessage());
        }
        return this.sendError(pageContext, (String)null);
    }

    public boolean sendError(PageContext pageContext, String string) {
        if (pageContext != null) {
            HttpServletResponse httpServletResponse = (HttpServletResponse)pageContext.getResponse();
            try {
                if (string == null) {
                    httpServletResponse.sendError(500);
                } else {
                    httpServletResponse.sendError(500, string);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("sendError completed: errorMessage=" + string));
                }
                return true;
            }
            catch (Exception exception) {
                logger.info((Object)("sendError failed: errorMessage=" + string), (Throwable)exception);
            }
        }
        return false;
    }

    public boolean sendRedirectWithMessage(HttpServletResponse httpServletResponse, HttpSession httpSession, String string, String string2) {
        try {
            httpSession.setAttribute("LOCALIZED_ERROR_MSG", (Object)string2);
            httpServletResponse.sendRedirect(string);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("sendRedirect completed: target=" + string + ", message=" + string2));
            }
            return true;
        }
        catch (Exception exception) {
            logger.info((Object)("sendRedirect failed: target=" + string + ", message=" + string2));
            return false;
        }
    }

    static class HttpDeleteWithBody
    extends HttpEntityEnclosingRequestBase {
        public static final String METHOD_NAME = "DELETE";

        public String getMethod() {
            return METHOD_NAME;
        }

        public HttpDeleteWithBody(String string) {
            this.setURI(URI.create(string));
        }

        public HttpDeleteWithBody(URI uRI) {
            this.setURI(uRI);
        }

        public HttpDeleteWithBody() {
        }
    }
}

