/*
 * Decompiled with CFR 0.152.
 */
package commvault.web.core.filter;

import commvault.web.core.util.UriUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.annotation.WebInitParam;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.log4j.Logger;
import org.owasp.validator.html.AntiSamy;
import org.owasp.validator.html.CleanResults;
import org.owasp.validator.html.Policy;
import org.owasp.validator.html.PolicyException;

@WebFilter(filterName="requestSanitizingFilter", asyncSupported=true, initParams={@WebInitParam(name="lenient", value=""), @WebInitParam(name="exclude", value="")})
public class RequestSanitizingFilter
implements Filter {
    private static final Logger logger = Logger.getLogger((String)"commvault.web");
    private static AntiSamy antiSamy;
    private static AntiSamy lenientAntiSamy;
    private static Set<String> lenientUrls;
    private static Set<String> excludeUrls;
    private static final Pattern COMMA;

    public RequestSanitizingFilter() {
        try {
            Policy policy = Policy.getInstance(this.getClass().getClassLoader().getResourceAsStream("antisamy.xml"));
            Policy policy2 = Policy.getInstance(this.getClass().getClassLoader().getResourceAsStream("antisamy-editable.xml"));
            antiSamy = new AntiSamy(policy);
            lenientAntiSamy = new AntiSamy(policy2);
        }
        catch (PolicyException policyException) {
            throw new IllegalStateException(policyException.getMessage(), policyException);
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.initializeLenientUrls(filterConfig);
        this.initializeExcludeUrls(filterConfig);
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        CleanServletRequest cleanServletRequest = new CleanServletRequest((HttpServletRequest)servletRequest);
        filterChain.doFilter((ServletRequest)cleanServletRequest, servletResponse);
    }

    public void destroy() {
    }

    private void initializeLenientUrls(FilterConfig filterConfig) {
        String string = filterConfig.getInitParameter("lenient");
        if (string != null) {
            String[] stringArray = COMMA.split(string);
            lenientUrls = new HashSet<String>(stringArray.length);
            for (String string2 : stringArray) {
                lenientUrls.add(string2.trim());
            }
        } else {
            lenientUrls = new HashSet<String>(0);
        }
    }

    private void initializeExcludeUrls(FilterConfig filterConfig) {
        String string = filterConfig.getInitParameter("exclude");
        if (string != null) {
            String[] stringArray = COMMA.split(string);
            excludeUrls = new HashSet<String>(stringArray.length);
            for (String string2 : stringArray) {
                excludeUrls.add(string2.trim());
            }
        } else {
            excludeUrls = new HashSet<String>(0);
        }
    }

    static {
        COMMA = Pattern.compile(",");
    }

    public static class CleanServletRequest
    extends HttpServletRequestWrapper {
        CleanServletRequest(HttpServletRequest httpServletRequest) {
            super(httpServletRequest);
        }

        public String[] getParameterValues(String string) {
            AntiSamy antiSamy = this.getAntiSamy();
            String[] stringArray = super.getParameterValues(string);
            if (stringArray == null) {
                return null;
            }
            ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
            for (String string2 : stringArray) {
                arrayList.add(this.filterString(string2, antiSamy));
            }
            return arrayList.toArray(new String[arrayList.size()]);
        }

        public Map getParameterMap() {
            Map map = super.getParameterMap();
            ConcurrentHashMap<String, String[]> concurrentHashMap = new ConcurrentHashMap<String, String[]>(map.size());
            for (String string : map.keySet()) {
                concurrentHashMap.put(string, this.getParameterValues(string));
            }
            return Collections.unmodifiableMap(concurrentHashMap);
        }

        public String getParameter(String string) {
            AntiSamy antiSamy = this.getAntiSamy();
            String string2 = super.getParameter(string);
            return this.filterString(string2, antiSamy);
        }

        public String getQueryString() {
            String string = super.getQueryString();
            StringBuffer stringBuffer = new StringBuffer();
            String string2 = null;
            if (string != null && !string.isEmpty()) {
                String[] stringArray;
                for (String string3 : stringArray = string.split("&")) {
                    int n = string3.indexOf("=");
                    if (n == -1) {
                        stringBuffer.append(string3);
                    } else {
                        String string4 = string3.substring(0, string3.indexOf("="));
                        stringBuffer.append(string4);
                        stringBuffer.append("=");
                        if (n < string3.length() - 1) {
                            String string5 = string3.substring(string3.indexOf("=") + 1, string3.length());
                            if ((string5 = this.filterString(UriUtil.decodeURIComponent(string5), this.getAntiSamy())) != null) {
                                stringBuffer.append(UriUtil.encodeURIComponent(string5));
                            }
                        }
                    }
                    stringBuffer.append("&");
                }
                string2 = stringBuffer.substring(0, stringBuffer.lastIndexOf("&"));
            } else if (string != null && string.isEmpty()) {
                string2 = "";
            }
            logger.trace((Object)("input querystring:{" + string + "}:filtered querystring:{" + string2 + "}"));
            return string2;
        }

        private String filterString(String string, AntiSamy antiSamy) {
            if (string == null) {
                return null;
            }
            if (antiSamy == null) {
                return string;
            }
            try {
                String string2;
                CleanResults cleanResults = antiSamy.scan(StringEscapeUtils.unescapeXml((String)string));
                if (cleanResults.getNumberOfErrors() > 0) {
                    logger.warn((Object)("antisamy encountered problem with input: " + cleanResults.getErrorMessages()));
                }
                if ((string2 = cleanResults.getCleanHTML()) != null) {
                    string2 = StringEscapeUtils.unescapeHtml4((String)string2);
                }
                return string2;
            }
            catch (Exception exception) {
                throw new IllegalStateException(exception.getMessage(), exception);
            }
        }

        private AntiSamy getAntiSamy() {
            HttpServletRequest httpServletRequest = (HttpServletRequest)super.getRequest();
            AntiSamy antiSamy = null;
            antiSamy = excludeUrls.contains(httpServletRequest.getServletPath()) || excludeUrls.contains(httpServletRequest.getPathInfo()) ? null : (lenientUrls.contains(httpServletRequest.getServletPath()) || lenientUrls.contains(httpServletRequest.getPathInfo()) ? lenientAntiSamy : antiSamy);
            return antiSamy;
        }
    }
}

