/*
 * Decompiled with CFR 0.152.
 */
package commvault.web.core.filter;

import commvault.web.core.config.ConfigProperties;
import commvault.web.core.filter.RequestContext;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Random;
import javax.inject.Inject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.jstl.core.Config;
import org.apache.log4j.Logger;

@WebFilter(filterName="cvContextFilter", asyncSupported=true)
public class CVContextFilter
implements Filter {
    private static final Logger logger = Logger.getLogger(CVContextFilter.class);
    @Inject
    private ConfigProperties config;
    private Random random;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        logger.trace((Object)"Making context level checks");
        try {
            boolean bl;
            servletRequest.setCharacterEncoding("UTF-8");
            logger.trace((Object)("Setting context. Locale: " + servletRequest.getLocale() + "..." + ((HttpServletRequest)servletRequest).getHeader("Accept-Language") + "..." + Config.get((ServletRequest)servletRequest, (String)"javax.servlet.jsp.jstl.fmt.locale")));
            HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
            String string = this.config.getIsForceHttps();
            if (string == null) {
                string = "true";
            }
            if ((bl = Boolean.parseBoolean(string)) && !servletRequest.getScheme().equals("https")) {
                if (!servletResponse.isCommitted()) {
                    HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
                    StringBuffer stringBuffer = httpServletRequest.getRequestURL();
                    String string2 = httpServletRequest.getQueryString();
                    if (string2 != null) {
                        stringBuffer.append('?').append(string2).toString();
                    }
                    httpServletResponse.setStatus(301);
                    httpServletResponse.setHeader("Location", stringBuffer.toString().replaceFirst("http", "https"));
                }
                return;
            }
            RequestContext.setReqAndResp((HttpServletRequest)servletRequest, (HttpServletResponse)servletResponse);
            httpServletResponse.addHeader("X-Frame-Options", "SAMEORIGIN");
            httpServletResponse.addHeader("Content-Security-Policy", this.getCSPString());
            httpServletResponse.addHeader("Referrer-Policy", "strict-origin-when-cross-origin");
            httpServletResponse.setHeader("Cache-Control", "no-cache, no-store, must-revalidate");
            httpServletResponse.setHeader("Pragma", "no-cache");
            httpServletResponse.setDateHeader("Expires", 0L);
            filterChain.doFilter(servletRequest, (ServletResponse)httpServletResponse);
        }
        finally {
            RequestContext.clear();
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.random = new SecureRandom();
    }

    public void destroy() {
    }

    private String getCSPString() {
        String string;
        String string2 = string = RequestContext.getRequest().getServerName() + ":" + RequestContext.getRequest().getServerPort();
        String string3 = null;
        HashMap<String, String> hashMap = (HashMap<String, String>)RequestContext.getRequest().getSession().getAttribute("CSP_MAP");
        if (hashMap == null) {
            hashMap = new HashMap<String, String>();
            RequestContext.getRequest().getSession().setAttribute("CSP_MAP", hashMap);
        } else {
            string3 = (String)hashMap.get(string2);
        }
        if (RequestContext.getRequest().getServerPort() == 80 || RequestContext.getRequest().getServerPort() == 443) {
            string = RequestContext.getRequest().getServerName();
        }
        if (string3 == null) {
            string3 = this.createCSPString(string);
            hashMap.put(string2, string3);
        }
        return string3;
    }

    private String createCSPString(String string) {
        String string2 = "";
        String string3 = "/webconsole";
        string2 = this.getCSPScriptNonceString();
        String string4 = RequestContext.getRequest().isSecure() ? " https:" : " http:";
        String string5 = "";
        string5 = RequestContext.getRequest().isSecure() ? "wss:" : "ws:";
        String string6 = this.config.getCSPExcludeUrls();
        if (string6 == null) {
            string6 = "";
        }
        string3 = string4 + "//" + string + string3;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("base-uri 'self' 'unsafe-eval' 'strict-dynamic' " + string2 + string4 + "//www.commvault.com/ https://fonts.gstatic.com " + "https://chatbeta.commvault.com/ https://maps.googleapis.com https://appsforoffice.microsoft.com " + "https://fonts.googleapis.com " + string4 + "//www.google-analytics.com https://edit.commvault.com:11316 https://browser.pipe.aria.microsoft.com " + string4 + "//webanalytics.commvault.com/webconsole/ " + string4 + "//*.mapbox.com/ https://*.gstatic.com " + string4 + "//webdocs.commvault.com/images/ " + string4 + "//www.google-analytics.com " + string4 + "//webdocs.commvault.com/fonts/webfonts/ " + string4 + "//code.highcharts.com https://telemetryservice.firstpartyapps.oaspapps.com " + string6 + string3 + "; ");
        stringBuilder.append("default-src 'self' " + string6);
        if (RequestContext.getRequest().isSecure()) {
            stringBuilder.append(string4);
        }
        stringBuilder.append("; ");
        stringBuilder.append("script-src 'self' 'unsafe-eval' 'strict-dynamic' " + string2 + string4 + "//www.commvault.com/ https://chatbeta.commvault.com/ https://maps.googleapis.com https://appsforoffice.microsoft.com https://fonts.googleapis.com " + string4 + "//www.google-analytics.com " + string4 + "//webanalytics.commvault.com/webconsole/ " + string4 + "//code.highcharts.com " + string6 + string3 + "; ");
        stringBuilder.append("style-src 'self' 'unsafe-inline' https://fonts.googleapis.com " + string4 + "//webdocs.commvault.com/fonts/ " + string6 + string3 + "; ");
        stringBuilder.append("font-src 'self' https://fonts.googleapis.com https://fonts.gstatic.com " + string4 + "//webdocs.commvault.com/fonts/webfonts/ " + string6 + string3 + "; ");
        stringBuilder.append("img-src 'self' data: " + string4 + "//*.mapbox.com/ https://*.gstatic.com " + string4 + "//webdocs.commvault.com/images/ " + string4 + "//www.google-analytics.com " + string6 + string3 + "; ");
        stringBuilder.append("connect-src 'self' " + string4 + "//*.mapbox.com/ https://edit.commvault.com:11316 https://browser.pipe.aria.microsoft.com" + " " + string5 + "//" + string + " " + string6 + string3 + "; ");
        stringBuilder.append("object-src 'none'; ");
        stringBuilder.append("frame-src 'self' mailto: https://telemetryservice.firstpartyapps.oaspapps.com " + string6 + string3 + "; ");
        stringBuilder.append("form-action 'self' " + string6 + string3 + "; ");
        if (RequestContext.getRequest().isSecure()) {
            stringBuilder.append("upgrade-insecure-requests; ");
        }
        return stringBuilder.toString();
    }

    private String getCSPScriptNonceString() {
        String string = "";
        HttpSession httpSession = RequestContext.getRequest().getSession();
        if (httpSession == null) {
            logger.error((Object)("Request session is null - unable to get CSP Nonce. Request URI=" + RequestContext.getRequest().getRequestURI()));
        } else {
            if (httpSession.getAttribute("cspNonce") == null) {
                httpSession.setAttribute("cspNonce", (Object)Long.toString(this.random.nextLong(), 36));
            }
            string = " 'nonce-" + (String)httpSession.getAttribute("cspNonce") + "' ";
        }
        return string;
    }
}

