/*
 * Decompiled with CFR 0.152.
 */
package commvault.web.core.config;

import commvault.web.core.config.ConfigProp;
import commvault.web.core.config.ConfigProperties;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class ConfigChangeNotificationTask
extends TimerTask {
    private ConfigProperties configProps;
    private static final Logger logger = Logger.getLogger(ConfigChangeNotificationTask.class);
    private static ConfigChangeNotificationTask singleInstance;

    private ConfigChangeNotificationTask(ConfigProperties configProperties) {
        this.configProps = configProperties;
    }

    public static synchronized void initiateTask(ConfigProperties configProperties) {
        if (singleInstance == null) {
            singleInstance = new ConfigChangeNotificationTask(configProperties);
            Timer timer = new Timer();
            ConfigChangeNotificationTask configChangeNotificationTask = singleInstance;
            logger.info((Object)"Scheduling config change notification task timer...");
            timer.schedule((TimerTask)configChangeNotificationTask, 2000L, 10000L);
        }
    }

    @Override
    public void run() {
        Integer n = ConfigProperties.getLoglevelFromRegistry();
        ConfigProp configProp = this.configProps.getProperties().get("CVCLOUDAPPS_DEBUGLEVEL");
        Integer n2 = Integer.parseInt(configProp.getPropertyValue());
        if (n2 != n) {
            logger.warn((Object)("Debug level changed FROM: " + n2.toString() + ", TO: " + n.toString()));
            Level level = ConfigProperties.getDebugLevel(n);
            Logger logger = Logger.getLogger((String)"commvault.web");
            logger.setLevel(level);
            this.configProps.getProperties().get("CVCLOUDAPPS_DEBUGLEVEL").setPropertyValue(n.toString());
        }
    }
}

