/*
 * Decompiled with CFR 0.152.
 */
package commvault.web.core;

import commvault.web.core.config.ConfigChangeNotificationTask;
import commvault.web.core.config.ConfigProperties;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.inject.Inject;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.annotation.WebListener;
import org.apache.log4j.Logger;

@WebListener
public class CVContextListener
implements ServletContextListener {
    private static final Logger logger = Logger.getLogger(CVContextListener.class);
    @Inject
    private ConfigProperties config;

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        ServletContext servletContext = servletContextEvent.getServletContext();
        servletContext.removeAttribute("config.properties");
    }

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        ServletContext servletContext = servletContextEvent.getServletContext();
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("config.properties");
        Properties properties = new Properties();
        try {
            if (inputStream != null) {
                properties.load(inputStream);
            }
        }
        catch (IOException iOException) {
            logger.error((Object)"Unable to load property file config.properites:", (Throwable)iOException);
        }
        servletContext.setAttribute("config.properties", (Object)properties);
        this.config.loadProperites(properties);
        ConfigChangeNotificationTask.initiateTask(this.config);
        logger.trace((Object)"TRACE message");
        logger.debug((Object)"DEBUG message");
    }
}

