/*
 * Decompiled with CFR 0.152.
 */
package commvault.web.common;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import commvault.cte.common.xml.XMLDecoder;
import commvault.web.core.config.ConfigProperties;
import commvault.web.core.filter.RequestContext;
import commvault.web.core.msg.App.GenericResp;
import commvault.web.core.msg.CheckCredentialResp;
import commvault.web.core.msg.Workflow.ResponseMessageType;
import commvault.web.core.msg.Workflow.StartWorkflow;
import commvault.web.core.msg.Workflow.WebInteractiveResponse;
import commvault.web.core.net.RequestObject;
import commvault.web.core.net.ServerBroker;
import commvault.web.core.net.ServerException;
import commvault.web.core.util.CVCoreUtil;
import commvault.web.core.util.WebServerLogin;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.log4j.Logger;

public class ExecuteWorkflow {
    public static HashMap<String, List<String>> workflowsMap = new HashMap();
    private static final Logger logger = Logger.getLogger(ExecuteWorkflow.class);
    private static final String REGISTER_COMMCELL = "Commcell Registration";
    private static final String REGISTER_COMMCELL_2 = "Commcell Registration**";
    private static final String TEST_EDGE_DRIVE = "EdgeTestDrive";
    private static final String EMP_LETTER_VER = "RequestEmploymentVerificationLetter";
    private static final String VPOD = "VPOD - Request Quote";
    private static final String PSIRT = "PSIRT Reporting";
    private static final String Commcell_Maintenance_Status = "CommcellMaintenanceStatus";
    private static HashMap<String, String> errorMsg = new HashMap();
    private static List<String> specialWorkflow = new ArrayList<String>();
    @Inject
    private static WebServerLogin loginService;
    @Inject
    private static ServerBroker serverBroker;
    @Inject
    private ConfigProperties configProps;
    private WebInteractiveResponse startActivityResp;
    private GenericResp genResp;
    private String workFlowName;
    private List<String> invalidInputs;
    private String inputXML;

    public static void setWorkflowsMap(String string, String string2, String ... stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string2);
        for (String string3 : stringArray) {
            arrayList.add(string3);
        }
        workflowsMap.put(string, arrayList);
    }

    public static void populateWorkflowMap() {
        if (workflowsMap.isEmpty()) {
            ExecuteWorkflow.setWorkflowsMap(REGISTER_COMMCELL, "<RegistrationInfoXMLData class=\"java.lang.String\">%%RegistrationInfoXMLData%%</RegistrationInfoXMLData>\t<RegistrationInfoIPAddress class=\"java.lang.String\">%%RegistrationInfoIPAddress%%</RegistrationInfoIPAddress>", "RegistrationInfoXMLData", "RegistrationInfoIPAddress");
            ExecuteWorkflow.setWorkflowsMap(TEST_EDGE_DRIVE, "<F_NAME class=\"java.lang.String\">%%F_NAME%%</F_NAME><L_NAME class=\"java.lang.String\">%%L_NAME%%</L_NAME><COMPANY class=\"java.lang.String\">%%COMPANY%%</COMPANY><PHONE class=\"java.lang.String\">%%PHONE%%</PHONE><TITLE class=\"workflow.types.EncryptedString\">%%TITLE%%</TITLE><EMAIL_ADDR class=\"java.lang.String\">%%EMAIL_ADDR%%</EMAIL_ADDR><CITY class=\"java.lang.String\">%%CITY%%</CITY><STATE class=\"java.lang.String\">%%STATE%%</STATE><ZIP class=\"java.lang.String\">%%ZIP%%</ZIP><COUNTRY class=\"java.lang.String\">%%COUNTRY%%</COUNTRY><SOURCECODE class=\"java.lang.String\">%%SOURCECODE%%</SOURCECODE><SOURCE_TYPE class=\"java.lang.String\">%%SOURCE_TYPE%%</SOURCE_TYPE><REDIRURL class=\"java.lang.String\">%%REDIRURL%%</REDIRURL>", "*F_NAME", "*L_NAME", "*COMPANY", "*PHONE", "*TITLE", "*EMAIL_ADDR", "CITY", "STATE", "ZIP", "COUNTRY", "SOURCECODE", "SOURCE_TYPE", "REDIRURL");
            ExecuteWorkflow.setWorkflowsMap(EMP_LETTER_VER, "<UserName class=\"java.lang.String\">%%UserName%%</UserName><Gender class=\"java.lang.String\">%%Gender%%</Gender><Salary class=\"java.lang.float\">%%Salary%%</Salary><Currency class=\"java.lang.String\">%%Currency%%</Currency>", "UserName", "Salary", "Gender", "Currency");
            ExecuteWorkflow.setWorkflowsMap(PSIRT, "<Name class=\"java.lang.String\">%%Name%%</Name><Email class=\"java.lang.String\">%%Email%%</Email><Phone class=\"java.lang.String\">%%Phone%%</Phone><Company class=\"java.lang.String\">%%Company%%</Company><CommvaultRelease class=\"java.lang.String\">%%CommvaultRelease%%</CommvaultRelease><ServicePack class=\"java.lang.String\">%%ServicePack%%</ServicePack><VulnerabilityType class=\"java.lang.String\">%%VulnerabilityType%%</VulnerabilityType><VulnerabilityName class=\"java.lang.String\">%%VulnerabilityName%%</VulnerabilityName><VulnerabilityDescription class=\"java.lang.String\">%%VulnerabilityDescription%%</VulnerabilityDescription><Steps class=\"java.lang.String\">%%Steps%%</Steps><VulnerabilityExistsInDefault class=\"java.lang.Boolean\">%%VulnerabilityExistsInDefault%%</VulnerabilityExistsInDefault><RequestPublicRecognition class=\"java.lang.Boolean\">%%RequestPublicRecognition%%</RequestPublicRecognition><showMessage class=\"java.lang.Boolean\">false</showMessage><ExternalPublicDisclosurePlanned class=\"java.lang.Boolean\">%%ExternalPublicDisclosurePlanned%%</ExternalPublicDisclosurePlanned><publicDiscDate class=\"java.util.Date\">%%disclosureDate%%</publicDiscDate>", "*Name", "*Email", "*Phone", "*Company", "CommvaultRelease", "*ServicePack", "*VulnerabilityType", "*VulnerabilityName", "*VulnerabilityDescription", "*Steps", "VulnerabilityExistsInDefault", "RequestPublicRecognition", "ExternalPublicDisclosurePlanned", "disclosureDate", "*captcha");
            ExecuteWorkflow.setWorkflowsMap(VPOD, "<firstName class=\"java.lang.String\">%%firstName%%</firstName><lastName class=\"java.lang.String\">%%lastName%%</lastName><email class=\"java.lang.String\">%%email%%</email><GUID class=\"java.lang.String\">%%GUID%%</GUID><socketBased class=\"java.lang.String\">%%socketBased%%</socketBased><addOnPackIntellisnap class=\"java.lang.String\">%%addOnPackIntellisnap%%</addOnPackIntellisnap><addOnPackVMProv class=\"java.lang.String\">%%addOnPackVMProv%%</addOnPackVMProv><addOnPackVMArch class=\"java.lang.String\">%%addOnPackVMArch%%</addOnPackVMArch><numberSocketsOrVMs class=\"java.lang.String\">%%numberSocketsOrVMs%%</numberSocketsOrVMs><ipAddress class=\"java.lang.String\">%%ipAddress%%</ipAddress><company class=\"java.lang.String\">%%company%%</company><phone class=\"java.lang.String\">%%phone%%</phone><state class=\"java.lang.String\">%%state%%</state><zip class=\"java.lang.String\">%%zip%%</zip><country class=\"java.lang.String\">%%country%%</country><sourcecode class=\"java.lang.String\">%%sourcecode%%</sourcecode><source_type class=\"java.lang.String\">%%source_type%%</source_type><redirurl class=\"java.lang.String\">%%redirurl%%</redirurl><elqCustomerGUID class=\"java.lang.String\">%%elqCustomerGUID%%</elqCustomerGUID>", "firstName", "lastName", "email", "GUID", "socketBased", "addOnPackIntellisnap", "addOnPackVMProv", "addOnPackVMArch", "numberSocketsOrVMs", "ipAddress", "company", "phone", "state", "zip", "country", "sourcecode", "source_type", "redirurl", "elqCustomerGUID");
            ExecuteWorkflow.setWorkflowsMap(REGISTER_COMMCELL_2, "<RegistrationInfoXMLData class=\"java.lang.String\"><Rpt_CSSXMLDATAROOT commcellID=\"%%commcellID%%\"><EVGui_RegistrationInformation ccguid=\"%%seNum%%%%regCode%%\" ccinstalltime=\"0\" commcellName=\"%%commcellID%%\" companyName=\"\" description=\"webform\" emailAddress=\"%%emailAddress%%\" isRegistered=\"%%isRegistered%%\" majorbrandid=\"1\" minibrandid=\"1\" password=\"%%PassBase64%%\" phoneNumber=\"\"><customerAddress address1=\"\" address2=\"\" city=\"\" country=\"\" state=\"\" zip=\"\" /><customerName firstName=\"%%firstName%%\" lastName=\"%%lastName%%\" /></EVGui_RegistrationInformation></Rpt_CSSXMLDATAROOT></RegistrationInfoXMLData>\t<RegistrationInfoIPAddress class=\"java.lang.String\">%%ipAddr%%</RegistrationInfoIPAddress>", "commcellID", "seNum", "regCode", "emailAddress", "isRegistered", "PassBase64", "firstName", "lastName", "ipAddr");
            ExecuteWorkflow.setWorkflowsMap(Commcell_Maintenance_Status, "<commCellID class=\"java.lang.String\">%%commCellID%%</commCellID>", "commCellID");
        }
    }

    public ExecuteWorkflow(String string, String string2) {
        this.workFlowName = string;
        this.inputXML = string2;
    }

    public ExecuteWorkflow(String string) {
        this.workFlowName = string;
    }

    public JsonObject execute(JsonObject jsonObject, boolean bl) {
        JsonObject jsonObject2;
        block18: {
            jsonObject2 = null;
            this.replaceInputsInXML(jsonObject, bl);
            if (this.invalidInputs != null && this.invalidInputs.size() > 0) {
                return this.listInvalidInputsInLog();
            }
            if (this.inputXML != null && !this.inputXML.isEmpty()) {
                logger.trace((Object)("Executing workflow:" + this.workFlowName + ", INPUT: " + this.inputXML));
                if (loginService == null) {
                    loginService = CVCoreUtil.lookup(WebServerLogin.class);
                }
                ExecuteWorkflow.loginToWebserver(false);
                try {
                    String string;
                    block17: {
                        Object object;
                        if (this.configProps == null) {
                            this.configProps = CVCoreUtil.lookup(ConfigProperties.class);
                        }
                        String string2 = this.configProps.getWebServerURL();
                        String string3 = this.workFlowName.replaceAll("\\*\\*$", "");
                        if (specialWorkflow.contains(string3)) {
                            string2 = string2 + "workflow/{workflowId}/Action/Execute?";
                            string2 = string2.replaceAll("\\{workflowId\\}", string3);
                            object = "<Workflow_StartWorkflow><options><inputs>{inputs}</inputs></options></Workflow_StartWorkflow>".replaceAll("\\{inputs\\}", this.inputXML);
                        } else {
                            string2 = string2 + "WorkflowRequest";
                            object = new StartWorkflow();
                            ((StartWorkflow)object).setOptions("<inputs>" + this.inputXML + "</inputs>");
                            ((StartWorkflow)object).getWorkflow().setWorkflowName(string3);
                        }
                        RequestObject requestObject = new RequestObject(string2, object);
                        if (serverBroker == null) {
                            serverBroker = CVCoreUtil.lookup(ServerBroker.class);
                        }
                        string = null;
                        try {
                            string = serverBroker.getStringResponse(requestObject);
                        }
                        catch (ServerException serverException) {
                            if (serverException.getHttpStatusCode() != 401) break block17;
                            ExecuteWorkflow.loginToWebserver(true);
                            string = serverBroker.getStringResponse(requestObject);
                        }
                    }
                    if (string != null && !string.isEmpty()) {
                        if (RequestContext.getRequest().getHeader("Accept").equalsIgnoreCase("application/xml")) {
                            jsonObject2 = new JsonObject();
                            jsonObject2.addProperty("xml", string);
                            break block18;
                        }
                        try {
                            this.startActivityResp = (WebInteractiveResponse)XMLDecoder.decode((String)string, (String)"commvault.web.core.msg.");
                        }
                        catch (ClassCastException classCastException) {
                            this.genResp = (GenericResp)XMLDecoder.decode((String)string, (String)"commvault.web.core.msg.");
                        }
                        if (this.startActivityResp != null || this.genResp != null) {
                            jsonObject2 = this.getInteractionResponse();
                        }
                        break block18;
                    }
                    logger.error((Object)("Unable to execute workflow, reponse:" + string));
                }
                catch (Exception exception) {
                    logger.error((Object)"Exception while executing workflow", (Throwable)exception);
                }
            } else {
                logger.error((Object)"Input xml is null, so not running the workflow.");
            }
        }
        return jsonObject2;
    }

    private JsonObject listInvalidInputsInLog() {
        JsonObject jsonObject = new JsonObject();
        JsonArray jsonArray = new JsonArray();
        for (int i = 0; i < this.invalidInputs.size(); ++i) {
            jsonArray.add(ExecuteWorkflow.getAllInvalidMessage().get(this.invalidInputs.get(i).toUpperCase()));
        }
        jsonObject.addProperty("success", Boolean.valueOf(false));
        jsonObject.add("errorMsg", (JsonElement)jsonArray);
        return jsonObject;
    }

    public static void loginToWebserver(boolean bl) {
        if (RequestContext.getRequest() != null && RequestContext.getRequest().getSession() != null) {
            CheckCredentialResp checkCredentialResp;
            if (loginService == null) {
                loginService = CVCoreUtil.lookup(WebServerLogin.class);
            }
            if ((checkCredentialResp = loginService.login(bl)).getToken() == null || checkCredentialResp.getToken().isEmpty()) {
                throw new RuntimeException("Unable to execute workflow, as not able to login to webserver.");
            }
        }
    }

    public JsonObject getInteractionResponse() {
        JsonObject jsonObject = null;
        if (this.startActivityResp != null) {
            try {
                jsonObject = new JsonObject();
                JsonElement jsonElement = null;
                Object object = XMLDecoder.decode((String)this.startActivityResp.getMessage(), (String)"commvault.web.core.msg.");
                jsonElement = this.startActivityResp.getMessageType().getEnumValue() == ResponseMessageType.GENERIC_RESP.getEnumValue() ? CVCoreUtil.parseJson(CVCoreUtil.getJsonForObject(object)) : CVCoreUtil.parseJson(CVCoreUtil.getJsonForObject(object));
                jsonObject.addProperty("respType", (Number)this.startActivityResp.getMessageType().getEnumValue());
                jsonObject.add("response", jsonElement);
            }
            catch (Exception exception) {
                logger.error((Object)("Error in parsing next activity of interactive workflow request " + exception.getMessage()), (Throwable)exception);
            }
        } else if (this.genResp != null) {
            jsonObject = new JsonObject();
            jsonObject.addProperty("respType", (Number)0);
            jsonObject.add("response", CVCoreUtil.parseJson(CVCoreUtil.getJsonForObject(this.genResp)));
        }
        return jsonObject;
    }

    public boolean doesExists() {
        return workflowsMap.get(this.workFlowName) != null;
    }

    private void replaceInputsInXML(JsonObject jsonObject, boolean bl) {
        if (jsonObject != null) {
            List<String> list = workflowsMap.get(this.workFlowName);
            this.inputXML = list == null || list.isEmpty() ? null : list.get(0);
            for (int i = 1; i < list.size(); ++i) {
                JsonElement jsonElement;
                String string;
                String string2 = list.get(i);
                boolean bl2 = false;
                if (string2.startsWith("*")) {
                    bl2 = true;
                    string2 = string2.substring(1);
                }
                String string3 = string = (jsonElement = jsonObject.get(string2)) == null ? "" : jsonElement.getAsString();
                if (bl) {
                    try {
                        string = string.isEmpty() ? string : URLDecoder.decode(string, "utf-8");
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        logger.error((Object)"Exception while url decode for workflow inputs, setting the input value to null.", (Throwable)unsupportedEncodingException);
                        string = null;
                    }
                }
                if (bl2 && string != null && string.trim().isEmpty()) {
                    logger.error((Object)("Required inputparameter [" + string2 + "] has empty value, can not proceed with workflow."));
                    this.addInvalidInputs(string2);
                } else if (bl2 && string2.equalsIgnoreCase("captcha")) {
                    if (((Integer)RequestContext.getRequest().getSession().getAttribute("captcha")).intValue() != jsonObject.get("captcha").getAsInt()) {
                        this.addInvalidInputs("captcha");
                        logger.error((Object)"Invalid captcha");
                    }
                    RequestContext.getRequest().getSession().setAttribute("captcha", (Object)"");
                }
                this.inputXML = this.inputXML.replace("%%" + string2 + "%%", StringEscapeUtils.escapeXml11((String)(string == null ? "" : string)));
            }
        }
    }

    private void addInvalidInputs(String string) {
        if (this.invalidInputs == null) {
            this.invalidInputs = new ArrayList<String>();
        }
        this.invalidInputs.add(string);
    }

    public static HashMap<String, String> getAllInvalidMessage() {
        if (errorMsg.isEmpty()) {
            errorMsg.put("COMPANY", "Company name is missing.");
            errorMsg.put("F_NAME", "First name is missing.");
            errorMsg.put("L_NAME", "Last name is missing.");
            errorMsg.put("PHONE", "Phone number is missing.");
            errorMsg.put("TITLE", "Title is missing.");
            errorMsg.put("EMAIL_ADDR", "Email address is missing.");
            errorMsg.put("EMAIL", "Email address is missing.");
            errorMsg.put("NAME", "Name is missing.");
            errorMsg.put("SERVICEPACK", "Service Pack is missing.");
            errorMsg.put("VULNERABILITYTYPE", "Vulnerability type is missing.");
            errorMsg.put("VULNERABILITYNAME", "Vulnerability name is missing.");
            errorMsg.put("STEPS", "Steps to reproduce the issue is missing.");
            errorMsg.put("VULNERABILITYDESCRIPTION", "Vulnerability description is missing.");
            errorMsg.put("EXTERNALPUBLICDISCLOSUREPLANNED", "Disclosure Date is missing.");
            errorMsg.put("CAPTCHA", "Invalid captcha.");
        }
        return errorMsg;
    }

    static {
        ExecuteWorkflow.populateWorkflowMap();
        specialWorkflow.add(REGISTER_COMMCELL);
    }
}

