/*
 * Decompiled with CFR 0.152.
 */
package org.ghost4j.document;

import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfCopy;
import com.lowagie.text.pdf.PdfImportedPage;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.ghost4j.document.AbstractDocument;
import org.ghost4j.document.Document;
import org.ghost4j.document.DocumentException;

public class PDFDocument
extends AbstractDocument {
    private static final long serialVersionUID = 6331191005700202153L;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void load(InputStream inputStream) throws IOException {
        ByteArrayInputStream bais;
        block6: {
            super.load(inputStream);
            bais = null;
            PdfReader reader = null;
            try {
                try {
                    bais = new ByteArrayInputStream(this.content);
                    reader = new PdfReader((InputStream)bais);
                }
                catch (Exception e) {
                    throw new IOException("PDF document is not valid");
                }
                Object var6_4 = null;
                if (reader == null) break block6;
            }
            catch (Throwable throwable) {
                Object var6_5 = null;
                if (reader != null) {
                    reader.close();
                }
                IOUtils.closeQuietly((InputStream)bais);
                throw throwable;
            }
            reader.close();
        }
        IOUtils.closeQuietly((InputStream)bais);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getPageCount() throws DocumentException {
        ByteArrayInputStream bais;
        int pageCount;
        block7: {
            pageCount = 0;
            if (this.content == null) {
                return pageCount;
            }
            bais = null;
            PdfReader reader = null;
            try {
                try {
                    bais = new ByteArrayInputStream(this.content);
                    reader = new PdfReader((InputStream)bais);
                    pageCount = reader.getNumberOfPages();
                }
                catch (Exception e) {
                    throw new DocumentException(e);
                }
                Object var6_4 = null;
                if (reader == null) break block7;
            }
            catch (Throwable throwable) {
                Object var6_5 = null;
                if (reader != null) {
                    reader.close();
                }
                IOUtils.closeQuietly((InputStream)bais);
                throw throwable;
            }
            reader.close();
        }
        IOUtils.closeQuietly((InputStream)bais);
        return pageCount;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Document extract(int begin, int end) throws DocumentException {
        this.assertValidPageRange(begin, end);
        PDFDocument result = new PDFDocument();
        ByteArrayInputStream bais = null;
        ByteArrayOutputStream baos = null;
        if (this.content == null) return result;
        com.lowagie.text.Document document = new com.lowagie.text.Document();
        try {
            try {
                bais = new ByteArrayInputStream(this.content);
                baos = new ByteArrayOutputStream();
                PdfReader inputPDF = new PdfReader((InputStream)bais);
                PdfWriter writer = PdfWriter.getInstance((com.lowagie.text.Document)document, (OutputStream)baos);
                document.open();
                PdfContentByte cb = writer.getDirectContent();
                while (begin <= end) {
                    document.newPage();
                    PdfImportedPage page = writer.getImportedPage(inputPDF, begin);
                    cb.addTemplate((PdfTemplate)page, 0.0f, 0.0f);
                    ++begin;
                }
                document.close();
                result.load(new ByteArrayInputStream(baos.toByteArray()));
            }
            catch (Exception e) {
                throw new DocumentException(e);
            }
            Object var12_12 = null;
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            if (document.isOpen()) {
                document.close();
            }
            IOUtils.closeQuietly((InputStream)bais);
            IOUtils.closeQuietly((OutputStream)baos);
            throw throwable;
        }
        if (document.isOpen()) {
            document.close();
        }
        IOUtils.closeQuietly((InputStream)bais);
        IOUtils.closeQuietly((OutputStream)baos);
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void append(Document document) throws DocumentException {
        super.append(document);
        ByteArrayOutputStream baos = null;
        com.lowagie.text.Document mergedDocument = new com.lowagie.text.Document();
        try {
            try {
                baos = new ByteArrayOutputStream();
                PdfCopy copy = new PdfCopy(mergedDocument, (OutputStream)baos);
                mergedDocument.open();
                PdfReader reader = new PdfReader(this.content);
                int pageCount = reader.getNumberOfPages();
                int i = 0;
                while (i < pageCount) {
                    copy.addPage(copy.getImportedPage(reader, ++i));
                }
                reader = new PdfReader(document.getContent());
                pageCount = reader.getNumberOfPages();
                i = 0;
                while (i < pageCount) {
                    copy.addPage(copy.getImportedPage(reader, ++i));
                }
                mergedDocument.close();
                this.content = baos.toByteArray();
            }
            catch (Exception e) {
                throw new DocumentException(e);
            }
            Object var9_9 = null;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            if (mergedDocument.isOpen()) {
                mergedDocument.close();
            }
            IOUtils.closeQuietly((OutputStream)baos);
            throw throwable;
        }
        if (mergedDocument.isOpen()) {
            mergedDocument.close();
        }
        IOUtils.closeQuietly((OutputStream)baos);
    }

    public String getType() {
        return "PDF";
    }
}

