/*
 * Decompiled with CFR 0.152.
 */
package org.ghost4j.document;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.ghost4j.document.Document;
import org.ghost4j.document.DocumentException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDocument
implements Document,
Serializable {
    private static final long serialVersionUID = -7160779330993730486L;
    public static final int READ_BUFFER_SIZE = 1024;
    protected byte[] content;

    @Override
    public void load(File file) throws FileNotFoundException, IOException {
        FileInputStream fis = new FileInputStream(file);
        this.load(fis);
        IOUtils.closeQuietly((InputStream)fis);
    }

    @Override
    public void load(InputStream inputStream) throws IOException {
        byte[] buffer = new byte[1024];
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int readCount = 0;
        while ((readCount = inputStream.read(buffer)) > 0) {
            baos.write(buffer, 0, readCount);
        }
        this.content = baos.toByteArray();
        IOUtils.closeQuietly((OutputStream)baos);
    }

    @Override
    public void write(File file) throws IOException {
        FileOutputStream fos = new FileOutputStream(file);
        this.write(fos);
        IOUtils.closeQuietly((OutputStream)fos);
    }

    @Override
    public void write(OutputStream outputStream) throws IOException {
        outputStream.write(this.content);
    }

    @Override
    public int getSize() {
        if (this.content == null) {
            return 0;
        }
        return this.content.length;
    }

    @Override
    public byte[] getContent() {
        return this.content;
    }

    protected void assertValidPageIndex(int index) throws DocumentException {
        if (this.content == null || index > this.getPageCount()) {
            throw new DocumentException("Invalid page index: " + index);
        }
    }

    protected void assertValidPageRange(int begin, int end) throws DocumentException {
        this.assertValidPageIndex(begin);
        this.assertValidPageIndex(end);
        if (begin > end) {
            throw new DocumentException("Invalid page range: " + begin + " - " + end);
        }
    }

    @Override
    public void append(Document document) throws DocumentException {
        if (document == null || !this.getType().equals(document.getType())) {
            throw new DocumentException("Cannot append document of different types");
        }
    }

    @Override
    public List<Document> explode() throws DocumentException {
        ArrayList<Document> result = new ArrayList<Document>();
        int pageCount = this.getPageCount();
        for (int i = 0; i < pageCount; ++i) {
            result.add(this.extract(i + 1, i + 1));
        }
        return result;
    }
}

