/*
 * Decompiled with CFR 0.152.
 */
package org.ghost4j.converter;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.ghost4j.Ghostscript;
import org.ghost4j.GhostscriptException;
import org.ghost4j.converter.AbstractRemoteConverter;
import org.ghost4j.converter.ConverterException;
import org.ghost4j.document.Document;
import org.ghost4j.document.DocumentException;
import org.ghost4j.document.PSDocument;
import org.ghost4j.document.PaperSize;
import org.ghost4j.util.DiskStore;

public class PDFConverter
extends AbstractRemoteConverter {
    public static final int OPTION_AUTOROTATEPAGES_NONE = 0;
    public static final int OPTION_AUTOROTATEPAGES_ALL = 1;
    public static final int OPTION_AUTOROTATEPAGES_PAGEBYPAGE = 2;
    public static final int OPTION_AUTOROTATEPAGES_OFF = 3;
    public static final int OPTION_PROCESSCOLORMODEL_RGB = 0;
    public static final int OPTION_PROCESSCOLORMODEL_GRAY = 1;
    public static final int OPTION_PROCESSCOLORMODEL_CMYK = 2;
    public static final int OPTION_PDFSETTINGS_DEFAULT = 0;
    public static final int OPTION_PDFSETTINGS_SCREEN = 1;
    public static final int OPTION_PDFSETTINGS_EBOOK = 2;
    public static final int OPTION_PDFSETTINGS_PRINTER = 3;
    public static final int OPTION_PDFSETTINGS_PREPRESS = 4;
    private int autoRotatePages = 3;
    private int processColorModel;
    private int PDFSettings;
    private String compatibilityLevel = "1.4";
    private boolean PDFX = false;
    private PaperSize paperSize = PaperSize.LETTER;

    public PDFConverter() {
        this.supportedDocumentClasses = new Class[1];
        this.supportedDocumentClasses[0] = PSDocument.class;
    }

    public static void main(String[] args) throws ConverterException {
        PDFConverter.startRemoteConverter(new PDFConverter());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(Document document, OutputStream outputStream) throws IOException, ConverterException, DocumentException {
        if (outputStream == null) {
            return;
        }
        this.assertDocumentSupported(document);
        Ghostscript gs = Ghostscript.getInstance();
        DiskStore diskStore = DiskStore.getInstance();
        String diskStoreKey = diskStore.generateUniqueKey();
        int argCount = 15;
        if (this.autoRotatePages != 3) {
            ++argCount;
        }
        String[] gsArgs = new String[argCount];
        gsArgs[0] = "-ps2pdf";
        gsArgs[1] = "-dNOPAUSE";
        gsArgs[2] = "-dBATCH";
        gsArgs[3] = "-dSAFER";
        int paramPosition = 3;
        switch (this.autoRotatePages) {
            case 0: {
                gsArgs[++paramPosition] = "-dAutoRotatePages=/None";
                break;
            }
            case 1: {
                gsArgs[++paramPosition] = "-dAutoRotatePages=/All";
                break;
            }
            case 2: {
                gsArgs[++paramPosition] = "-dAutoRotatePages=/PageByPage";
                break;
            }
        }
        ++paramPosition;
        switch (this.processColorModel) {
            case 2: {
                gsArgs[paramPosition] = "-dProcessColorModel=/DeviceCMYK";
                break;
            }
            case 1: {
                gsArgs[paramPosition] = "-dProcessColorModel=/DeviceGray";
                break;
            }
            default: {
                gsArgs[paramPosition] = "-dProcessColorModel=/DeviceRGB";
            }
        }
        ++paramPosition;
        switch (this.PDFSettings) {
            case 2: {
                gsArgs[paramPosition] = "-dPDFSETTINGS=/ebook";
                break;
            }
            case 1: {
                gsArgs[paramPosition] = "-dPDFSETTINGS=/screen";
                break;
            }
            case 3: {
                gsArgs[paramPosition] = "-dPDFSETTINGS=/printer";
                break;
            }
            case 4: {
                gsArgs[paramPosition] = "-dPDFSETTINGS=/prepress";
                break;
            }
            default: {
                gsArgs[paramPosition] = "-dPDFSETTINGS=/default";
            }
        }
        gsArgs[++paramPosition] = "-dCompatibilityLevel=" + this.compatibilityLevel;
        gsArgs[++paramPosition] = "-dPDFX=" + this.PDFX;
        gsArgs[++paramPosition] = "-dDEVICEWIDTHPOINTS=" + this.paperSize.getWidth();
        gsArgs[++paramPosition] = "-dDEVICEHEIGHTPOINTS=" + this.paperSize.getHeight();
        gsArgs[++paramPosition] = "-sDEVICE=pdfwrite";
        gsArgs[++paramPosition] = "-sOutputFile=" + diskStore.addFile(diskStoreKey).getAbsolutePath();
        gsArgs[++paramPosition] = "-q";
        gsArgs[++paramPosition] = "-f";
        gsArgs[++paramPosition] = "-";
        ByteArrayInputStream is = new ByteArrayInputStream(document.getContent());
        try {
            try {
                Ghostscript ghostscript = gs;
                synchronized (ghostscript) {
                    gs.setStdIn(is);
                    gs.initialize(gsArgs);
                }
                File outputFile = diskStore.getFile(diskStoreKey);
                if (outputFile == null) {
                    throw new ConverterException("Cannot retrieve file with key " + diskStoreKey + " from disk store");
                }
                FileInputStream fis = new FileInputStream(outputFile);
                byte[] content = new byte[(int)outputFile.length()];
                fis.read(content);
                fis.close();
                outputStream.write(content);
            }
            catch (GhostscriptException e) {
                throw new ConverterException(e);
            }
            Object var14_14 = null;
        }
        catch (Throwable throwable) {
            Object var14_15 = null;
            IOUtils.closeQuietly((InputStream)is);
            try {
                Ghostscript.deleteInstance();
            }
            catch (GhostscriptException e) {
                throw new ConverterException(e);
            }
            diskStore.removeFile(diskStoreKey);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)is);
        try {}
        catch (GhostscriptException e) {
            throw new ConverterException(e);
        }
        Ghostscript.deleteInstance();
        diskStore.removeFile(diskStoreKey);
    }

    public int getAutoRotatePages() {
        return this.autoRotatePages;
    }

    public void setAutoRotatePages(int autoRotatePages) {
        this.autoRotatePages = autoRotatePages;
    }

    public int getProcessColorModel() {
        return this.processColorModel;
    }

    public void setProcessColorModel(int processColorModel) {
        this.processColorModel = processColorModel;
    }

    public String getCompatibilityLevel() {
        return this.compatibilityLevel;
    }

    public void setCompatibilityLevel(String compatibilityLevel) {
        this.compatibilityLevel = compatibilityLevel;
    }

    public int getPDFSettings() {
        return this.PDFSettings;
    }

    public void setPDFSettings(int PDFSettings) {
        this.PDFSettings = PDFSettings;
    }

    public boolean isPDFX() {
        return this.PDFX;
    }

    public void setPDFX(boolean PDFX) {
        this.PDFX = PDFX;
    }

    public PaperSize getPaperSize() {
        return this.paperSize;
    }

    public void setPaperSize(PaperSize paperSize) {
        this.paperSize = paperSize;
    }

    public void setPaperSize(String paperSizeName) {
        PaperSize found = PaperSize.getStandardPaperSize(paperSizeName);
        if (found != null) {
            this.setPaperSize(found);
        }
    }
}

