/*
 * Decompiled with CFR 0.152.
 */
package org.ghost4j.analyzer;

import gnu.cajo.invoke.Remote;
import gnu.cajo.utils.ItemServer;
import java.io.IOException;
import java.util.List;
import org.ghost4j.AbstractRemoteComponent;
import org.ghost4j.analyzer.AnalysisItem;
import org.ghost4j.analyzer.AnalyzerException;
import org.ghost4j.analyzer.RemoteAnalyzer;
import org.ghost4j.document.Document;
import org.ghost4j.document.DocumentException;
import org.ghost4j.util.JavaFork;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRemoteAnalyzer
extends AbstractRemoteComponent
implements RemoteAnalyzer {
    protected abstract List<AnalysisItem> run(Document var1) throws IOException, AnalyzerException, DocumentException;

    protected static void startRemoteAnalyzer(RemoteAnalyzer remoteAnalyzer) throws AnalyzerException {
        try {
            if (System.getenv("cajo.port") == null) {
                throw new AnalyzerException("No Cajo port defined for remote analyzer");
            }
            int cajoPort = Integer.parseInt(System.getenv("cajo.port"));
            RemoteAnalyzer analyzerCopy = (RemoteAnalyzer)remoteAnalyzer.getClass().newInstance();
            analyzerCopy.setMaxProcessCount(0);
            Remote.config(null, cajoPort, null, 0);
            ItemServer.bind(analyzerCopy, RemoteAnalyzer.class.getCanonicalName());
        }
        catch (Exception e) {
            throw new AnalyzerException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<AnalysisItem> analyze(Document document) throws IOException, AnalyzerException, DocumentException {
        if (this.maxProcessCount == 0) {
            return this.run(document);
        }
        this.waitForFreeProcess();
        ++this.processCount;
        if (!this.isStandAloneModeSupported()) {
            throw new AnalyzerException("Standalone mode is not supported by this analyzer: no 'main' method found");
        }
        JavaFork fork = this.buildJavaFork();
        int documentMbSize = document.getSize() / 1024 / 1024 + 1;
        int xmxValue = 64 + documentMbSize;
        fork.setXmx(xmxValue + "m");
        int cajoPort = 0;
        try {
            try {
                cajoPort = this.startRemoteServer(fork);
                Object remote = this.getRemoteComponent(cajoPort, RemoteAnalyzer.class);
                Remote.invoke(remote, "copySettings", this.extractSettings());
                List list = (List)Remote.invoke(remote, "run", document);
                Object var9_10 = null;
                --this.processCount;
                fork.stop();
                return list;
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new AnalyzerException(e);
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            --this.processCount;
            fork.stop();
            throw throwable;
        }
    }
}

