/*
 * Decompiled with CFR 0.152.
 */
package gnu.cajo.utils.extra;

import gnu.cajo.invoke.Remote;
import gnu.cajo.utils.extra.Scheduler;
import java.io.Serializable;
import java.util.LinkedList;

public final class Timer
implements Serializable {
    private final Scheduler sched;
    private final int index;
    private boolean running;
    private LinkedList tasks;

    public Timer(Scheduler sched) {
        this.sched = sched;
        this.index = sched.load(this);
    }

    public synchronized void load(Object task, long interval, int count) {
        if (this.tasks == null) {
            this.tasks = new LinkedList();
        }
        this.tasks.add(new TimedTask(task, interval, count));
        if (!this.running) {
            this.running = true;
            this.sched.wake(this.index);
        }
    }

    public synchronized void remove(Object task) {
        for (int i = 0; i < this.tasks.size(); ++i) {
            TimedTask tt = (TimedTask)this.tasks.get(i);
            if (!tt.task.equals(task)) continue;
            tt.drop();
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void slice() {
        TimedTask tt = null;
        Timer timer = this;
        synchronized (timer) {
            long time = System.currentTimeMillis();
            for (int i = 0; i < this.tasks.size(); ++i) {
                TimedTask task = (TimedTask)this.tasks.get(i);
                if (time < task.time) continue;
                if (task.count != 0 && --task.count == 0) {
                    task.drop();
                } else {
                    task.time += task.interval;
                }
                tt = task;
                break;
            }
        }
        if (tt != null) {
            try {
                Remote.invoke(tt.task, "slice", null);
            }
            catch (Exception x) {
                Timer timer2 = this;
                synchronized (timer2) {
                    tt.drop();
                }
            }
        }
    }

    private final class TimedTask
    implements Serializable {
        private final Object task;
        private final long interval;
        private int count;
        private long time;

        private TimedTask(Object task, long interval, int count) {
            this.task = task;
            this.interval = interval;
            this.count = count;
            this.time = System.currentTimeMillis() + this.interval;
        }

        private void drop() {
            Timer.this.tasks.remove(Timer.this.tasks.indexOf(this));
            if (Timer.this.tasks.isEmpty()) {
                Timer.this.tasks = null;
                if (Timer.this.running) {
                    Timer.this.running = false;
                    Timer.this.sched.stop(Timer.this.index);
                }
            }
        }
    }
}

