/*
 * Decompiled with CFR 0.152.
 */
package gnu.cajo.utils;

import gnu.cajo.invoke.Remote;
import gnu.cajo.utils.Multicast;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.rmi.MarshalledObject;
import java.rmi.RMISecurityManager;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;

public class ItemServer {
    private static Registry registry;
    private static HashMap registries;

    public ItemServer() {
    }

    public ItemServer(String host, int port, String codebase) {
        codebase = "http://" + host + ':' + port + '/' + codebase;
        if (System.getProperty("java.rmi.server.codebase") != null) {
            codebase = codebase + ' ' + System.getProperty("java.rmi.server.codebase");
        }
        System.setProperty("java.rmi.server.codebase", codebase);
    }

    public static void acceptProxies() throws SecurityException {
        System.setProperty("java.rmi.server.useCodebaseOnly", "false");
        System.setSecurityManager(new RMISecurityManager());
    }

    public static Remote bind(Object item, String name) throws IOException {
        return ItemServer.bind(item, name, null, null, null, 0);
    }

    public static Remote bind(String name, String item, String file) throws ClassNotFoundException, InstantiationException, IllegalAccessException, RemoteException {
        Class c = new JarClassLoader(file).loadClass(item);
        try {
            return ItemServer.bind(c.newInstance(), name, null, null, null, 0);
        }
        catch (IOException x) {
            return null;
        }
    }

    public static Remote bind(Object item, String name, Object proxy) throws RemoteException, IOException {
        return ItemServer.bind(item, name, proxy, null, null, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Remote bind(Object item, String name, Object proxy, RMIServerSocketFactory ssf, RMIClientSocketFactory csf, int port) throws RemoteException, IOException {
        Remote handle;
        Remote remote = handle = item instanceof Remote ? (Remote)item : new Remote(item);
        if (proxy != null) {
            try {
                Remote.invoke(proxy, "setItem", handle);
            }
            catch (Exception x) {
                // empty catch block
            }
            if (!(proxy instanceof MarshalledObject)) {
                proxy = new MarshalledObject<Object>(proxy);
            }
            try {
                Remote.invoke(item, "setProxy", proxy);
            }
            catch (Exception x) {
                // empty catch block
            }
        }
        try {
            Remote.invoke(item, "startThread", null);
        }
        catch (Exception x) {
            // empty catch block
        }
        Class<ItemServer> clazz = ItemServer.class;
        synchronized (ItemServer.class) {
            if (csf == null || ssf == null) {
                if (registry == null) {
                    registry = LocateRegistry.createRegistry(Remote.getDefaultServerPort(), Remote.getDefaultClientSocketFactory(), Remote.getDefaultServerSocketFactory());
                }
                registry.rebind(name, handle);
            } else {
                Registry custom = (Registry)registries.get(new Integer(port));
                if (custom == null) {
                    custom = LocateRegistry.createRegistry(port, csf, ssf);
                    registries.put(new Integer(port), custom);
                }
                custom.rebind(name, handle);
            }
            // ** MonitorExit[var7_9] (shouldn't be in output)
            return handle;
        }
    }

    public static void main(String[] args) throws Exception {
        String url = args.length > 0 ? args[0] : null;
        String clientHost = args.length > 1 ? args[1] : null;
        int clientPort = args.length > 2 ? Integer.parseInt(args[2]) : 0;
        String localHost = args.length > 3 ? args[3] : null;
        int localPort = args.length > 4 ? Integer.parseInt(args[4]) : 0;
        Remote.config(localHost, localPort, clientHost, clientPort);
        Remote main = new Remote(Remote.getItem(url));
        Object proxy = args.length > 5 ? Remote.getItem(args[5]) : null;
        new Multicast().announce(ItemServer.bind(main, "main", proxy), 16);
        ItemServer.acceptProxies();
        System.out.println("Server started: " + DateFormat.getDateTimeInstance(0, 0).format(new Date()));
        System.out.print("Serving item ");
        System.out.print(args[0]);
        System.out.println(" bound under the name main");
        System.out.print("internally operating on\t");
        System.out.print(Remote.getDefaultServerHost());
        System.out.print(" port ");
        System.out.println(Remote.getDefaultServerPort());
        System.out.print("externally operating on\t");
        System.out.print(Remote.getDefaultClientHost());
        System.out.print(" port ");
        System.out.println(Remote.getDefaultClientPort());
    }

    static {
        if (System.getProperty("java.security.policy") == null) {
            System.setProperty("java.security.policy", "server.policy");
        }
        System.setProperty("java.rmi.server.useCodebaseOnly", "true");
    }

    private static final class JarClassLoader
    extends ClassLoader {
        final String path;

        JarClassLoader(String jarFile) {
            this.path = "jar:file:" + jarFile + "!/";
        }

        public Class loadClass(String name) throws ClassNotFoundException {
            try {
                return super.findSystemClass(name);
            }
            catch (ClassNotFoundException x) {
                try {
                    String url = this.path + name.replace('.', '/') + ".class";
                    InputStream is = new URL(url).openConnection().getInputStream();
                    byte[] bytes = new byte[is.available()];
                    is.read(bytes);
                    is.close();
                    Class<?> result = this.defineClass(name, bytes, 0, bytes.length);
                    this.resolveClass(result);
                    return result;
                }
                catch (IOException y) {
                    return null;
                }
            }
        }
    }
}

