/*
 * Decompiled with CFR 0.152.
 */
package gnu.cajo.invoke;

import gnu.cajo.invoke.Invoke;
import gnu.cajo.invoke.RemoteInvoke;
import gnu.cajo.utils.ItemServer;
import gnu.cajo.utils.extra.TransparentItemProxy;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.Authenticator;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.rmi.MarshalledObject;
import java.rmi.Naming;
import java.rmi.NoSuchObjectException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.RMISocketFactory;
import java.rmi.server.RemoteServer;
import java.rmi.server.ServerNotActiveException;
import java.rmi.server.UnicastRemoteObject;
import java.rmi.server.Unreferenced;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public final class Remote
extends UnicastRemoteObject
implements RemoteInvoke,
Unreferenced {
    private static String defaultServerHost;
    private static String defaultClientHost;
    private static int defaultServerPort;
    private static int defaultClientPort;
    private static RCSF defaultRCSF;
    private static RSSF defaultRSSF;
    private static final HashMap cache;
    private static final Vector items;
    private static final Class[] NULL;
    private static final Class[] OBJECT;
    private static final Object[] NOARGS;
    private boolean unexportOnUnreference;
    public final Object item;

    protected void finalize() throws Throwable {
        super.finalize();
        this.unexport(true);
    }

    public static RMIServerSocketFactory getDefaultServerSocketFactory() {
        return defaultRSSF;
    }

    public static RMIClientSocketFactory getDefaultClientSocketFactory() {
        return defaultRCSF;
    }

    public static String getDefaultServerHost() {
        return defaultRSSF != null ? defaultRSSF.host : "Unassigned";
    }

    public static int getDefaultServerPort() {
        return defaultRSSF.port;
    }

    public static String getDefaultClientHost() {
        return defaultRCSF != null ? defaultRCSF.host : "Unassigned";
    }

    public static int getDefaultClientPort() {
        return defaultRCSF.port;
    }

    public static void config(String serverHost, int serverPort, String clientHost, int clientPort) {
        defaultRCSF = new RCSF(clientHost, clientPort);
        defaultRSSF = new RSSF(serverHost, serverPort);
        defaultRSSF.rcsf = Remote.defaultRCSF;
        defaultServerHost = serverHost;
        defaultClientHost = clientHost;
        if (clientHost != null) {
            try {
                System.setProperty("java.rmi.server.hostname", clientHost);
            }
            catch (SecurityException x) {
                // empty catch block
            }
        }
    }

    public static void config(int serverPort, String clientHost, int clientPort, String proxyHost, int proxyPort, final String username, final String password) {
        Remote.config(null, serverPort, clientHost, clientPort);
        try {
            if (proxyHost != null) {
                System.setProperty("proxySet", "true");
                System.setProperty("http.proxyHost", proxyHost);
                System.setProperty("http.proxyPort", Integer.toString(proxyPort));
                if (username != null) {
                    Authenticator.setDefault(new Authenticator(){

                        protected PasswordAuthentication getPasswordAuthentication() {
                            return new PasswordAuthentication(username, password.toCharArray());
                        }
                    });
                }
            }
        }
        catch (SecurityException x) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdown() {
        Vector vector = items;
        synchronized (vector) {
            for (int i = items.size() - 1; i >= 0; --i) {
                try {
                    Remote.unexportObject((Remote)items.elementAt(i), true);
                    continue;
                }
                catch (NoSuchObjectException noSuchObjectException) {
                    // empty catch block
                }
            }
            items.clear();
            HashMap hashMap = cache;
            synchronized (hashMap) {
                cache.clear();
            }
        }
    }

    public static Object zedmob(InputStream is) throws ClassNotFoundException, IOException {
        GZIPInputStream gis = new GZIPInputStream(is);
        ObjectInputStream ois = new ObjectInputStream(gis);
        MarshalledObject mob = (MarshalledObject)ois.readObject();
        ois.close();
        return mob.get();
    }

    public static void zedmob(OutputStream os, Object ref) throws IOException {
        GZIPOutputStream zos = new GZIPOutputStream(os);
        ObjectOutputStream oos = new ObjectOutputStream(zos);
        oos.writeObject(new MarshalledObject<Object>(ref));
        oos.flush();
        zos.flush();
        oos.close();
    }

    public static Object getItem(String url) throws RemoteException, NotBoundException, IOException, ClassNotFoundException, InstantiationException, IllegalAccessException, MalformedURLException {
        Object item = null;
        if (url == null) {
            url = "///main";
        } else if (url.startsWith("//") && url.endsWith("/")) {
            url = url + "main";
        }
        if (url.startsWith("//")) {
            item = Naming.lookup(url);
        } else if (url.startsWith("/")) {
            InputStream ris = Remote.class.getResourceAsStream(url);
            if (ris == null) {
                ris = new FileInputStream('.' + url);
            }
            item = Remote.zedmob(ris);
            ris.close();
        } else if (url.indexOf(58) == -1) {
            item = Class.forName(url).newInstance();
        } else {
            InputStream uis = new URL(url).openStream();
            item = Remote.zedmob(uis);
            uis.close();
        }
        return item;
    }

    public static Class autobox(Class arg) {
        return arg.isPrimitive() ? (arg == Boolean.TYPE ? Boolean.class : (arg == Byte.TYPE ? Byte.class : (arg == Character.TYPE ? Character.class : (arg == Short.TYPE ? Short.class : (arg == Integer.TYPE ? Integer.class : (arg == Long.TYPE ? Long.class : (arg == Float.TYPE ? Float.class : Double.class))))))) : arg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Method findBestMethod(Object item, String method, Class[] args) {
        Method best;
        int i;
        HashMap arguments;
        HashMap methods;
        if (args == null) {
            args = NULL;
        }
        if ((methods = (HashMap)cache.get(item.getClass())) != null && (arguments = (HashMap)methods.get(method)) != null) {
            Object[] argumentSet = arguments.keySet().toArray();
            for (i = 0; i < argumentSet.length; ++i) {
                if (!Arrays.equals(args, (Class[])argumentSet[i])) continue;
                return (Method)arguments.get(argumentSet[i]);
            }
        }
        ArrayList<Method> matchList = new ArrayList<Method>();
        if (((Object[])args).length > 0) {
            Method[] ms = item.getClass().getMethods();
            block6: for (i = 0; i < ms.length; ++i) {
                if (!ms[i].getName().equals(method) || ms[i].getParameterTypes().length != args.length) continue;
                for (int j = 0; j < args.length; ++j) {
                    if (args[j] != null && !Remote.autobox(ms[i].getParameterTypes()[j]).isAssignableFrom(args[j])) continue block6;
                }
                matchList.add(ms[i]);
            }
            if (matchList.size() == 0) {
                return null;
            }
        } else {
            try {
                matchList.add(item.getClass().getMethod(method, null));
            }
            catch (NoSuchMethodException x) {
                return null;
            }
        }
        Method method2 = best = matchList.size() == 1 ? (Method)matchList.get(0) : null;
        if (best == null) {
            int goodness = -1;
            for (i = 0; i < matchList.size(); ++i) {
                int closeness = 0;
                Method m = (Method)matchList.get(i);
                for (int j = 0; j < args.length; ++j) {
                    if (args[j] == null || !args[j].isAssignableFrom(Remote.autobox(m.getParameterTypes()[j]))) continue;
                    ++closeness;
                }
                if (closeness <= goodness) continue;
                best = m;
                if (closeness == args.length) break;
                goodness = closeness;
            }
        }
        HashMap hashMap = cache;
        synchronized (hashMap) {
            HashMap<Class[], Method> arguments2;
            methods = (HashMap)cache.get(item.getClass());
            if (methods == null) {
                methods = new HashMap();
                cache.put(item.getClass(), methods);
            }
            if ((arguments2 = (HashMap<Class[], Method>)methods.get(method)) == null) {
                arguments2 = new HashMap<Class[], Method>();
                methods.put(method, arguments2);
            }
            if (arguments2.get(args) == null) {
                arguments2.put(args, best);
            }
        }
        return best;
    }

    public static Object invoke(Object item, String method, Object args) throws Exception {
        Method m;
        Class[] c_args;
        Object[] o_args;
        Object[] objectArray;
        if (args instanceof Object[]) {
            objectArray = (Object[])args;
        } else if (args != null) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = args;
        } else {
            objectArray = o_args = NOARGS;
        }
        if (item instanceof RemoteInvoke) {
            if (o_args.length == 0 && method.equals("hashCode")) {
                return new Integer(item.hashCode());
            }
            if (o_args.length == 1 && method.equals("equals")) {
                return item.equals(o_args[0]) ? Boolean.TRUE : Boolean.FALSE;
            }
            for (int i = 0; i < o_args.length; ++i) {
                if (o_args[i] == null || o_args[i] instanceof Serializable) continue;
                HashSet interfaces = new HashSet();
                for (Class<?> c = o_args[i].getClass(); c != null; c = c.getSuperclass()) {
                    interfaces.addAll(Arrays.asList(c.getInterfaces()));
                }
                o_args[i] = TransparentItemProxy.getItem(o_args[i], interfaces.toArray(new Class[0]));
            }
        }
        if (item instanceof Invoke) {
            return ((Invoke)item).invoke(method, args);
        }
        Class[] classArray = c_args = o_args != NOARGS ? new Class[o_args.length] : NULL;
        if (c_args != NULL) {
            for (int i = 0; i < c_args.length; ++i) {
                c_args[i] = o_args[i] == null ? null : o_args[i].getClass();
            }
        }
        if ((m = Remote.findBestMethod(item, method, c_args)) == null && args != null) {
            c_args = new Class[]{args.getClass()};
            m = Remote.findBestMethod(item, method, c_args);
            o_args = new Object[]{args};
        }
        if (m == null) {
            c_args = new Class[]{args.getClass()};
            m = Remote.findBestMethod(item, method, OBJECT);
            o_args = new Object[]{args};
        }
        if (m != null) {
            try {
                Object result = m.invoke(item, (Object[])(o_args != NOARGS ? o_args : null));
                if (result != null && !(result instanceof Serializable)) {
                    try {
                        RemoteServer.getClientHost();
                        HashSet interfaces = new HashSet();
                        for (Class<?> c = result.getClass(); c != null; c = c.getSuperclass()) {
                            interfaces.addAll(Arrays.asList(c.getInterfaces()));
                        }
                        return TransparentItemProxy.getItem(result, interfaces.toArray(new Class[0]));
                    }
                    catch (ServerNotActiveException x) {
                        // empty catch block
                    }
                }
                return result;
            }
            catch (InvocationTargetException x) {
                Throwable t = x.getTargetException();
                throw t instanceof Exception ? (Exception)t : new Exception(t);
            }
        }
        StringBuffer sb = new StringBuffer(item.getClass().getName());
        sb.append('.').append(method).append('(');
        if (c_args.length > 0) {
            for (int i = 0; i < c_args.length; ++i) {
                sb.append(c_args[i] != null ? c_args[i].getName() : "null");
                if (i + 1 >= o_args.length) continue;
                sb.append(", ");
            }
        }
        throw new NoSuchMethodException(sb.append(')').toString());
    }

    public Remote(Object item) throws RemoteException {
        this(item, defaultRSSF.port, defaultRSSF, defaultRCSF);
    }

    public Remote(Object item, String host, int port) throws RemoteException {
        this(item, port, new RSSF(host, port), new RCSF(host, port));
    }

    public Remote(Object item, int port, RMIServerSocketFactory rssf, RMIClientSocketFactory rcsf) throws RemoteException {
        super(port, rcsf, rssf);
        this.item = item;
        items.add(this);
    }

    public boolean unexport(boolean force) throws NoSuchObjectException {
        if (UnicastRemoteObject.unexportObject(this, force)) {
            items.remove(this);
            return true;
        }
        return false;
    }

    public static boolean unexportObject(java.rmi.Remote obj, boolean force) throws NoSuchObjectException {
        return obj instanceof Remote ? ((Remote)obj).unexport(force) : UnicastRemoteObject.unexportObject(obj, force);
    }

    public Object invoke(String method, Object args) throws Exception {
        return Remote.invoke(this.item, method, args);
    }

    public Object send(String url) throws Exception {
        if (url == null) {
            url = "///main";
        } else if (url.startsWith("//") && url.endsWith("/")) {
            url = url + "main";
        }
        return Remote.invoke(Remote.getItem(url), "send", this);
    }

    public void zedmob(OutputStream os) throws IOException {
        Remote.zedmob(os, this);
    }

    public void unreferenced() {
        if (this.unexportOnUnreference) {
            try {
                this.unexport(true);
            }
            catch (NoSuchObjectException x) {
                // empty catch block
            }
        }
        if (this.item instanceof Unreferenced) {
            try {
                Remote.invoke(this.item, "unreferenced", null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public Remote clientScope() {
        this.unexportOnUnreference = true;
        return this;
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            args = new String[]{"///main"};
        }
        String clientHost = args.length > 1 ? args[1] : null;
        int clientPort = args.length > 2 ? Integer.parseInt(args[2]) : 0;
        String localHost = args.length > 3 ? args[3] : null;
        int localPort = args.length > 4 ? Integer.parseInt(args[4]) : 0;
        Remote.config(localHost, localPort, clientHost, clientPort);
        try {
            System.setProperty("java.rmi.server.disableHttp", "true");
        }
        catch (SecurityException x) {
            // empty catch block
        }
        Object proxy = Remote.getItem(args[0]);
        if (args.length > 5) {
            Remote.invoke(proxy, "setItem", Remote.getItem(args[5]));
        }
        ItemServer.bind(proxy, "main");
    }

    static {
        cache = new HashMap();
        items = new Vector();
        NULL = new Class[0];
        OBJECT = new Class[]{Object.class};
        NOARGS = new Object[0];
        String defaulthost = "127.0.0.1";
        try {
            defaulthost = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException x) {
            // empty catch block
        }
        Remote.config(defaulthost, 0, defaulthost, 0);
        try {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                public void run() {
                    Remote.shutdown();
                }
            });
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    private static final class RCSF
    implements RMIClientSocketFactory,
    Serializable {
        private static final long serialVersionUID = 101058626L;
        private int port;
        private String host;

        private RCSF() {
        }

        private RCSF(String host, int port) {
            this.host = host;
            this.port = port;
        }

        public Socket createSocket(String host, int port) throws IOException {
            Socket s = RMISocketFactory.getDefaultSocketFactory().createSocket(this.host, this.port);
            return s;
        }

        public boolean equals(Object o) {
            return o instanceof RCSF && ((RCSF)o).port == this.port;
        }

        public int hashCode() {
            return this.getClass().hashCode() ^ this.port;
        }
    }

    private static final class RSSF
    implements RMIServerSocketFactory {
        private int port;
        private String host;
        private RCSF rcsf;

        private RSSF(String host, int port) {
            this.host = host;
            this.port = port;
        }

        public ServerSocket createServerSocket(int port) throws IOException {
            ServerSocket ss;
            ServerSocket serverSocket = ss = this.host == null ? RMISocketFactory.getDefaultSocketFactory().createServerSocket(this.port) : new ServerSocket(this.port, 50, InetAddress.getByName(this.host));
            if (this.host == null) {
                this.host = ss.getInetAddress().getHostAddress();
                System.setProperty("java.rmi.server.hostname", this.host);
            }
            if (this.port == 0) {
                this.port = ss.getLocalPort();
            }
            if (this.rcsf != null) {
                if (this.rcsf.host == null) {
                    this.rcsf.host = InetAddress.getLocalHost().getHostAddress();
                }
                if (this.rcsf.port == 0) {
                    this.rcsf.port = this.port;
                }
                defaultServerHost = this.host;
                defaultServerPort = this.port;
                defaultClientHost = this.rcsf.host;
                defaultClientPort = this.rcsf.port;
                this.rcsf = null;
            }
            return ss;
        }

        public boolean equals(Object o) {
            return o instanceof RSSF && ((RSSF)o).port == this.port;
        }

        public int hashCode() {
            return this.getClass().hashCode() ^ this.port;
        }
    }
}

