/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.serviceruntime;

import com.microsoft.windowsazure.serviceruntime.AcquireCurrentState;
import com.microsoft.windowsazure.serviceruntime.AcquireLeaseInfo;
import com.microsoft.windowsazure.serviceruntime.CurrentState;
import com.microsoft.windowsazure.serviceruntime.CurrentStateInfo;
import com.microsoft.windowsazure.serviceruntime.CurrentStateSerializer;
import com.microsoft.windowsazure.serviceruntime.CurrentStatusEnum;
import com.microsoft.windowsazure.serviceruntime.GoalStateInfo;
import com.microsoft.windowsazure.serviceruntime.ObjectFactory;
import com.microsoft.windowsazure.serviceruntime.ReleaseCurrentState;
import com.microsoft.windowsazure.serviceruntime.StatusLeaseInfo;
import java.io.OutputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;

class XmlCurrentStateSerializer
implements CurrentStateSerializer {
    @Override
    public void serialize(CurrentState state, OutputStream stream) {
        try {
            JAXBContext context = JAXBContext.newInstance((String)GoalStateInfo.class.getPackage().getName());
            Marshaller marshaller = context.createMarshaller();
            ObjectFactory factory = new ObjectFactory();
            CurrentStateInfo info = factory.createCurrentStateInfo();
            StatusLeaseInfo leaseInfo = factory.createStatusLeaseInfo();
            leaseInfo.setClientId(state.getClientId());
            if (state instanceof AcquireCurrentState) {
                AcquireCurrentState acquireState = (AcquireCurrentState)state;
                AcquireLeaseInfo acquire = factory.createAcquireLeaseInfo();
                acquire.setExpiration(acquireState.getExpiration());
                acquire.setIncarnation(acquireState.getIncarnation());
                switch (acquireState.getStatus()) {
                    case BUSY: {
                        acquire.setStatus(CurrentStatusEnum.BUSY);
                        break;
                    }
                    case RECYCLE: {
                        acquire.setStatus(CurrentStatusEnum.RECYCLE);
                        break;
                    }
                    case STARTED: {
                        acquire.setStatus(CurrentStatusEnum.STARTED);
                        break;
                    }
                    case STOPPED: {
                        acquire.setStatus(CurrentStatusEnum.STOPPED);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
                leaseInfo.setAcquire(acquire);
            } else if (state instanceof ReleaseCurrentState) {
                leaseInfo.setRelease(factory.createStatusLeaseInfoRelease());
            }
            info.setStatusLease(leaseInfo);
            marshaller.marshal(factory.createCurrentState(info), stream);
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }
}

