/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.serviceruntime;

import com.microsoft.windowsazure.serviceruntime.ChunkedGoalStateDeserializer;
import com.microsoft.windowsazure.serviceruntime.CurrentStateSerializer;
import com.microsoft.windowsazure.serviceruntime.FileInputChannel;
import com.microsoft.windowsazure.serviceruntime.FileOutputChannel;
import com.microsoft.windowsazure.serviceruntime.GoalStateDeserializer;
import com.microsoft.windowsazure.serviceruntime.InputChannel;
import com.microsoft.windowsazure.serviceruntime.OutputChannel;
import com.microsoft.windowsazure.serviceruntime.Protocol1RuntimeCurrentStateClient;
import com.microsoft.windowsazure.serviceruntime.Protocol1RuntimeGoalStateClient;
import com.microsoft.windowsazure.serviceruntime.RoleEnvironmentDataDeserializer;
import com.microsoft.windowsazure.serviceruntime.RuntimeVersionManager;
import com.microsoft.windowsazure.serviceruntime.RuntimeVersionProtocolClient;
import com.microsoft.windowsazure.serviceruntime.XmlCurrentStateSerializer;
import com.microsoft.windowsazure.serviceruntime.XmlRoleEnvironmentDataDeserializer;

public final class RuntimeKernel {
    private static RuntimeKernel theKernel;
    private final CurrentStateSerializer currentStateSerializer = new XmlCurrentStateSerializer();
    private final GoalStateDeserializer goalStateDeserializer = new ChunkedGoalStateDeserializer();
    private final InputChannel inputChannel = new FileInputChannel();
    private final OutputChannel outputChannel = new FileOutputChannel();
    private final Protocol1RuntimeCurrentStateClient protocol1RuntimeCurrentStateClient = new Protocol1RuntimeCurrentStateClient(this.currentStateSerializer, this.outputChannel);
    private final RoleEnvironmentDataDeserializer roleEnvironmentDataDeserializer = new XmlRoleEnvironmentDataDeserializer();
    private final Protocol1RuntimeGoalStateClient protocol1RuntimeGoalStateClient = new Protocol1RuntimeGoalStateClient(this.protocol1RuntimeCurrentStateClient, this.goalStateDeserializer, this.roleEnvironmentDataDeserializer, this.inputChannel);
    private final RuntimeVersionProtocolClient runtimeVersionProtocolClient = new RuntimeVersionProtocolClient(this.inputChannel);
    private final RuntimeVersionManager runtimeVersionManager = new RuntimeVersionManager(this.runtimeVersionProtocolClient);

    private RuntimeKernel() {
    }

    public static RuntimeKernel getKernel() {
        if (theKernel == null) {
            theKernel = new RuntimeKernel();
        }
        return theKernel;
    }

    public CurrentStateSerializer getCurrentStateSerializer() {
        return this.currentStateSerializer;
    }

    public GoalStateDeserializer getGoalStateDeserializer() {
        return this.goalStateDeserializer;
    }

    public InputChannel getInputChannel() {
        return this.inputChannel;
    }

    public OutputChannel getOutputChannel() {
        return this.outputChannel;
    }

    public Protocol1RuntimeCurrentStateClient getProtocol1RuntimeCurrentStateClient() {
        return this.protocol1RuntimeCurrentStateClient;
    }

    public RoleEnvironmentDataDeserializer getRoleEnvironmentDataDeserializer() {
        return this.roleEnvironmentDataDeserializer;
    }

    public Protocol1RuntimeGoalStateClient getProtocol1RuntimeGoalStateClient() {
        return this.protocol1RuntimeGoalStateClient;
    }

    public RuntimeVersionProtocolClient getRuntimeVersionProtocolClient() {
        return this.runtimeVersionProtocolClient;
    }

    public RuntimeVersionManager getRuntimeVersionManager() {
        return this.runtimeVersionManager;
    }
}

