/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.serviceruntime;

import com.microsoft.windowsazure.serviceruntime.GoalState;
import com.microsoft.windowsazure.serviceruntime.GoalStateDeserializer;
import com.microsoft.windowsazure.serviceruntime.XmlGoalStateDeserializer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;

class ChunkedGoalStateDeserializer
implements GoalStateDeserializer {
    private final XmlGoalStateDeserializer deserializer = new XmlGoalStateDeserializer();
    private BufferedReader reader;

    @Override
    public void initialize(InputStream inputStream) {
        try {
            this.reader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    @Override
    public GoalState deserialize() {
        try {
            String lengthString = this.reader.readLine();
            if (lengthString == null) {
                return null;
            }
            int length = Integer.parseInt(lengthString.toString(), 16);
            char[] chunkData = new char[length];
            this.reader.read(chunkData, 0, length);
            GoalState goalState = this.deserializer.deserialize(new String(chunkData));
            this.reader.readLine();
            return goalState;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

