/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.grpc;

import com.google.api.core.BetaApi;
import com.google.api.gax.retrying.RetrySettings;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import io.grpc.Status;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public abstract class UnaryCallSettings {
    private final ImmutableSet<Status.Code> retryableCodes;
    private final RetrySettings retrySettings;

    public final Set<Status.Code> getRetryableCodes() {
        return this.retryableCodes;
    }

    public final RetrySettings getRetrySettings() {
        return this.retrySettings;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public abstract Builder toBuilder();

    protected UnaryCallSettings(Set<Status.Code> retryableCodes, RetrySettings retrySettings) {
        this.retryableCodes = ImmutableSet.copyOf(retryableCodes);
        this.retrySettings = retrySettings;
    }

    public static class Builder {
        private Set<Status.Code> retryableCodes;
        private RetrySettings.Builder retrySettingsBuilder;

        protected Builder() {
            this.retryableCodes = Sets.newHashSet();
            this.retrySettingsBuilder = RetrySettings.newBuilder();
        }

        protected Builder(UnaryCallSettings unaryCallSettings) {
            this.setRetryableCodes((Set<Status.Code>)unaryCallSettings.retryableCodes);
            this.setRetrySettingsBuilder(unaryCallSettings.getRetrySettings().toBuilder());
        }

        public Builder setRetryableCodes(Set<Status.Code> retryableCodes) {
            this.retryableCodes = Sets.newHashSet(retryableCodes);
            return this;
        }

        public Builder setRetryableCodes(Status.Code ... codes) {
            this.setRetryableCodes(Sets.newHashSet((Object[])codes));
            return this;
        }

        public Builder setRetrySettingsBuilder(RetrySettings.Builder retrySettingsBuilder) {
            this.retrySettingsBuilder = (RetrySettings.Builder)Preconditions.checkNotNull((Object)retrySettingsBuilder);
            return this;
        }

        public Builder setSimpleTimeoutNoRetries(Duration timeout) {
            this.setRetryableCodes(new Status.Code[0]);
            this.setRetrySettingsBuilder(RetrySettings.newBuilder().setTotalTimeout(timeout).setInitialRetryDelay(Duration.ZERO).setRetryDelayMultiplier(1.0).setMaxRetryDelay(Duration.ZERO).setInitialRpcTimeout(timeout).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(timeout));
            return this;
        }

        public Set<Status.Code> getRetryableCodes() {
            return this.retryableCodes;
        }

        public RetrySettings.Builder getRetrySettingsBuilder() {
            return this.retrySettingsBuilder;
        }

        public UnaryCallSettings build() {
            throw new UnsupportedOperationException("Cannot build an instance of abstract class UnaryCallSettings.");
        }
    }
}

