/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.media.models;

import com.microsoft.windowsazure.services.media.entityoperations.DefaultDeleteOperation;
import com.microsoft.windowsazure.services.media.entityoperations.DefaultGetOperation;
import com.microsoft.windowsazure.services.media.entityoperations.DefaultListOperation;
import com.microsoft.windowsazure.services.media.entityoperations.EntityCreateOperation;
import com.microsoft.windowsazure.services.media.entityoperations.EntityDeleteOperation;
import com.microsoft.windowsazure.services.media.entityoperations.EntityGetOperation;
import com.microsoft.windowsazure.services.media.entityoperations.EntityLinkOperation;
import com.microsoft.windowsazure.services.media.entityoperations.EntityOperationBase;
import com.microsoft.windowsazure.services.media.entityoperations.EntityOperationSingleResultBase;
import com.microsoft.windowsazure.services.media.entityoperations.EntityProxyData;
import com.microsoft.windowsazure.services.media.entityoperations.EntityUnlinkOperation;
import com.microsoft.windowsazure.services.media.entityoperations.EntityUpdateOperation;
import com.microsoft.windowsazure.services.media.implementation.content.AssetType;
import com.microsoft.windowsazure.services.media.models.AssetInfo;
import com.microsoft.windowsazure.services.media.models.AssetOption;
import com.microsoft.windowsazure.services.media.models.AssetState;
import com.microsoft.windowsazure.services.media.models.LinkInfo;
import com.microsoft.windowsazure.services.media.models.ListResult;
import com.sun.jersey.api.client.GenericType;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.security.InvalidParameterException;

public final class Asset {
    private static final String ENTITY_SET = "Assets";

    private Asset() {
    }

    public static Creator create() {
        return new Creator();
    }

    public static EntityGetOperation<AssetInfo> get(String assetId) {
        return new DefaultGetOperation<AssetInfo>(ENTITY_SET, assetId, AssetInfo.class);
    }

    public static EntityGetOperation<AssetInfo> get(LinkInfo<AssetInfo> link) {
        return new DefaultGetOperation<AssetInfo>(link.getHref(), AssetInfo.class);
    }

    public static DefaultListOperation<AssetInfo> list() {
        return new DefaultListOperation<AssetInfo>(ENTITY_SET, new GenericType<ListResult<AssetInfo>>(){});
    }

    public static DefaultListOperation<AssetInfo> list(LinkInfo<AssetInfo> link) {
        return new DefaultListOperation<AssetInfo>(link.getHref(), new GenericType<ListResult<AssetInfo>>(){});
    }

    public static Updater update(String assetId) {
        return new Updater(assetId);
    }

    public static EntityDeleteOperation delete(String assetId) {
        return new DefaultDeleteOperation(ENTITY_SET, assetId);
    }

    public static EntityLinkOperation linkContentKey(String assetId, String contentKeyId) {
        String escapedContentKeyId = null;
        try {
            escapedContentKeyId = URLEncoder.encode(contentKeyId, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new InvalidParameterException("contentKeyId");
        }
        URI contentKeyUri = URI.create(String.format("ContentKeys('%s')", escapedContentKeyId));
        return new EntityLinkOperation(ENTITY_SET, assetId, "ContentKeys", contentKeyUri);
    }

    public static EntityUnlinkOperation unlinkContentKey(String assetId, String contentKeyId) {
        return new EntityUnlinkOperation(ENTITY_SET, assetId, "ContentKeys", contentKeyId);
    }

    public static EntityLinkOperation linkDeliveryPolicy(String assetId, String deliveryPolicyId) {
        String escapedContentKeyId = null;
        try {
            escapedContentKeyId = URLEncoder.encode(deliveryPolicyId, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new InvalidParameterException("deliveryPolicyId");
        }
        URI contentKeyUri = URI.create(String.format("AssetDeliveryPolicies('%s')", escapedContentKeyId));
        return new EntityLinkOperation(ENTITY_SET, assetId, "DeliveryPolicies", contentKeyUri);
    }

    public static EntityUnlinkOperation unlinkDeliveryPolicy(String assetId, String adpId) {
        return new EntityUnlinkOperation(ENTITY_SET, assetId, "DeliveryPolicies", adpId);
    }

    public static class Updater
    extends EntityOperationBase
    implements EntityUpdateOperation {
        private String name;
        private String alternateId;

        protected Updater(String assetId) {
            super(new EntityOperationBase.EntityIdUriBuilder(Asset.ENTITY_SET, assetId));
        }

        @Override
        public void setProxyData(EntityProxyData proxyData) {
        }

        @Override
        public Object getRequestContents() {
            AssetType assetType = new AssetType();
            assetType.setName(this.name);
            assetType.setAlternateId(this.alternateId);
            return assetType;
        }

        public Updater setName(String name) {
            this.name = name;
            return this;
        }

        public Updater setAlternateId(String alternateId) {
            this.alternateId = alternateId;
            return this;
        }
    }

    public static class Creator
    extends EntityOperationSingleResultBase<AssetInfo>
    implements EntityCreateOperation<AssetInfo> {
        private String name;
        private String alternateId;
        private String storageAccountName;
        private AssetOption options;
        private AssetState state;

        public Creator() {
            super(Asset.ENTITY_SET, AssetInfo.class);
        }

        @Override
        public Object getRequestContents() {
            AssetType assetType = new AssetType();
            assetType.setName(this.name);
            assetType.setAlternateId(this.alternateId);
            assetType.setStorageAccountName(this.storageAccountName);
            if (this.options != null) {
                assetType.setOptions(this.options.getCode());
            }
            if (this.state != null) {
                assetType.setState(this.state.getCode());
            }
            return assetType;
        }

        public Creator setName(String name) {
            this.name = name;
            return this;
        }

        public Creator setAlternateId(String alternateId) {
            this.alternateId = alternateId;
            return this;
        }

        public Creator setOptions(AssetOption options) {
            this.options = options;
            return this;
        }

        public Creator setState(AssetState state) {
            this.state = state;
            return this;
        }

        public Creator setStorageAccountName(String storageAccountName) {
            this.storageAccountName = storageAccountName;
            return this;
        }
    }
}

