/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.media.implementation;

import com.microsoft.windowsazure.core.utils.InputStreamDataSource;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.services.media.entityoperations.EntityBatchOperation;
import com.microsoft.windowsazure.services.media.implementation.ODataAtomMarshaller;
import com.microsoft.windowsazure.services.media.implementation.ODataAtomUnmarshaller;
import com.microsoft.windowsazure.services.media.implementation.SetBoundaryMultipartDataSource;
import com.microsoft.windowsazure.services.media.implementation.StatusLine;
import com.microsoft.windowsazure.services.media.implementation.atom.EntryType;
import com.microsoft.windowsazure.services.media.models.Job;
import com.microsoft.windowsazure.services.media.models.JobInfo;
import com.microsoft.windowsazure.services.media.models.Task;
import com.microsoft.windowsazure.services.media.models.TaskInfo;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.core.header.InBoundHeaders;
import com.sun.jersey.core.util.ReaderWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.UUID;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.Header;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimePart;
import javax.mail.internet.MimePartDataSource;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.UriBuilder;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.ParserConfigurationException;

public class MediaBatchOperations {
    private static final int BUFFER_SIZE = 1024;
    private static final int HTTP_ERROR = 400;
    private final List<EntityBatchOperation> entityBatchOperations;
    private final URI serviceURI;
    private final ODataAtomMarshaller oDataAtomMarshaller;
    private final ODataAtomUnmarshaller oDataAtomUnmarshaller;
    private final String batchId;

    public MediaBatchOperations(URI serviceURI) throws JAXBException, ParserConfigurationException {
        if (serviceURI == null) {
            throw new IllegalArgumentException("The service URI cannot be null.");
        }
        this.serviceURI = serviceURI;
        this.oDataAtomMarshaller = new ODataAtomMarshaller();
        this.oDataAtomUnmarshaller = new ODataAtomUnmarshaller();
        this.entityBatchOperations = new ArrayList<EntityBatchOperation>();
        this.batchId = String.format("batch_%s", UUID.randomUUID().toString());
    }

    public MimeMultipart getMimeMultipart() throws MessagingException, IOException, JAXBException {
        List<DataSource> bodyPartContents = this.createRequestBody();
        return this.toMimeMultipart(bodyPartContents);
    }

    private List<DataSource> createRequestBody() throws JAXBException {
        ArrayList<DataSource> bodyPartContents = new ArrayList<DataSource>();
        int contentId = 1;
        URI jobURI = UriBuilder.fromUri((URI)this.serviceURI).path("Jobs").build(new Object[0]);
        int jobContentId = this.addJobPart(bodyPartContents, jobURI, contentId);
        URI taskURI = UriBuilder.fromUri((URI)this.serviceURI).path(String.format("$%d", jobContentId)).path("Tasks").build(new Object[0]);
        this.addTaskPart(bodyPartContents, taskURI, ++contentId);
        return bodyPartContents;
    }

    private int addJobPart(List<DataSource> bodyPartContents, URI jobURI, int contentId) throws JAXBException {
        int jobContentId = contentId;
        this.validateJobOperation();
        for (EntityBatchOperation entityBatchOperation : this.entityBatchOperations) {
            DataSource bodyPartContent = null;
            if (!(entityBatchOperation instanceof Job.CreateBatchOperation)) continue;
            Job.CreateBatchOperation jobCreateBatchOperation = (Job.CreateBatchOperation)entityBatchOperation;
            jobContentId = contentId;
            bodyPartContent = this.createBatchCreateEntityPart(jobCreateBatchOperation.getVerb(), "Jobs", jobCreateBatchOperation.getEntryType(), jobURI, contentId);
            ++contentId;
            if (bodyPartContent == null) continue;
            bodyPartContents.add(bodyPartContent);
            break;
        }
        return jobContentId;
    }

    private void validateJobOperation() {
        int jobCount = 0;
        for (EntityBatchOperation entityBatchOperation : this.entityBatchOperations) {
            if (!(entityBatchOperation instanceof Job.CreateBatchOperation)) continue;
            ++jobCount;
        }
        if (jobCount != 1) {
            throw new IllegalArgumentException(String.format("The Job operation is invalid, expect 1 but get %s job(s). ", jobCount));
        }
    }

    private void addTaskPart(List<DataSource> bodyPartContents, URI taskURI, int contentId) throws JAXBException {
        for (EntityBatchOperation entityBatchOperation : this.entityBatchOperations) {
            DataSource bodyPartContent = null;
            if (entityBatchOperation instanceof Task.CreateBatchOperation) {
                Task.CreateBatchOperation createTaskOperation = (Task.CreateBatchOperation)entityBatchOperation;
                bodyPartContent = this.createBatchCreateEntityPart(createTaskOperation.getVerb(), "Tasks", createTaskOperation.getEntryType(), taskURI, contentId);
                ++contentId;
            }
            if (bodyPartContent == null) continue;
            bodyPartContents.add(bodyPartContent);
        }
    }

    private MimeMultipart toMimeMultipart(List<DataSource> bodyPartContents) throws MessagingException, IOException {
        String changeSetId = String.format("changeset_%s", UUID.randomUUID().toString());
        MimeMultipart changeSets = this.createChangeSets(bodyPartContents, changeSetId);
        MimeBodyPart mimeBodyPart = this.createMimeBodyPart(changeSets, changeSetId);
        MimeMultipart mimeMultipart = new MimeMultipart((DataSource)new SetBoundaryMultipartDataSource(this.batchId));
        mimeMultipart.addBodyPart((BodyPart)mimeBodyPart);
        return mimeMultipart;
    }

    private MimeBodyPart createMimeBodyPart(MimeMultipart changeSets, String changeSetId) throws MessagingException {
        MimeBodyPart mimeBodyPart = new MimeBodyPart();
        mimeBodyPart.setContent((Multipart)changeSets);
        String contentType = String.format("multipart/mixed; boundary=%s", changeSetId);
        mimeBodyPart.setHeader("Content-Type", contentType);
        return mimeBodyPart;
    }

    private MimeMultipart createChangeSets(List<DataSource> bodyPartContents, String changeSetId) throws MessagingException {
        MimeMultipart changeSets = new MimeMultipart((DataSource)new SetBoundaryMultipartDataSource(changeSetId));
        for (DataSource bodyPart : bodyPartContents) {
            MimeBodyPart mimeBodyPart = new MimeBodyPart();
            mimeBodyPart.setDataHandler(new DataHandler(bodyPart));
            mimeBodyPart.setHeader("Content-Type", bodyPart.getContentType());
            mimeBodyPart.setHeader("Content-Transfer-Encoding", "binary");
            changeSets.addBodyPart((BodyPart)mimeBodyPart);
        }
        return changeSets;
    }

    private DataSource createBatchCreateEntityPart(String verb, String entityName, EntryType entryType, URI uri, int contentId) throws JAXBException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        this.oDataAtomMarshaller.marshalEntryType(entryType, stream);
        byte[] bytes = stream.toByteArray();
        InternetHeaders headers = new InternetHeaders();
        headers.addHeader("Content-ID", Integer.toString(contentId));
        headers.addHeader("Content-Type", "application/atom+xml;type=entry");
        headers.addHeader("Content-Length", Integer.toString(bytes.length));
        headers.addHeader("DataServiceVersion", "3.0;NetFx");
        headers.addHeader("MaxDataServiceVersion", "3.0;NetFx");
        ByteArrayOutputStream httpRequest = new ByteArrayOutputStream();
        this.addHttpMethod(httpRequest, verb, uri);
        this.appendHeaders(httpRequest, headers);
        this.appendEntity(httpRequest, new ByteArrayInputStream(bytes));
        InputStreamDataSource bodyPartContent = new InputStreamDataSource((InputStream)new ByteArrayInputStream(httpRequest.toByteArray()), "application/http");
        return bodyPartContent;
    }

    public void parseBatchResult(ClientResponse response) throws IOException, ServiceException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        InputStream inputStream = response.getEntityInputStream();
        ReaderWriter.writeTo((InputStream)inputStream, (OutputStream)byteArrayOutputStream);
        response.setEntityInputStream((InputStream)new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
        List<DataSource> parts = this.parseParts(response.getEntityInputStream(), (String)response.getHeaders().getFirst((Object)"Content-Type"));
        if (parts.size() == 0 || parts.size() > this.entityBatchOperations.size()) {
            throw new UniformInterfaceException(String.format("Batch response from server does not contain the correct amount of parts (expecting %d, received %d instead)", parts.size(), this.entityBatchOperations.size()), response);
        }
        for (int i = 0; i < parts.size(); ++i) {
            DataSource ds = parts.get(i);
            EntityBatchOperation entityBatchOperation = this.entityBatchOperations.get(i);
            StatusLine status = StatusLine.create(ds);
            InternetHeaders headers = this.parseHeaders(ds);
            InputStream content = this.parseEntity(ds);
            if (status.getStatus() >= 400) {
                InBoundHeaders inBoundHeaders = new InBoundHeaders();
                Enumeration e = headers.getAllHeaders();
                while (e.hasMoreElements()) {
                    Header header = (Header)e.nextElement();
                    inBoundHeaders.putSingle(header.getName(), (Object)header.getValue());
                }
                ClientResponse clientResponse = new ClientResponse(status.getStatus(), inBoundHeaders, content, null);
                UniformInterfaceException uniformInterfaceException = new UniformInterfaceException(clientResponse);
                throw uniformInterfaceException;
            }
            if (entityBatchOperation instanceof Job.CreateBatchOperation) {
                try {
                    JobInfo jobInfo = this.oDataAtomUnmarshaller.unmarshalEntry(content, JobInfo.class);
                    Job.CreateBatchOperation jobCreateBatchOperation = (Job.CreateBatchOperation)entityBatchOperation;
                    jobCreateBatchOperation.setJobInfo(jobInfo);
                    continue;
                }
                catch (JAXBException e) {
                    throw new ServiceException((Throwable)e);
                }
            }
            if (!(entityBatchOperation instanceof Task.CreateBatchOperation)) continue;
            try {
                this.oDataAtomUnmarshaller.unmarshalEntry(content, TaskInfo.class);
                continue;
            }
            catch (JAXBException e) {
                throw new ServiceException((Throwable)e);
            }
        }
    }

    private InternetHeaders parseHeaders(DataSource ds) {
        try {
            return new InternetHeaders(ds.getInputStream());
        }
        catch (MessagingException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private InputStream parseEntity(DataSource ds) {
        try {
            return ds.getInputStream();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private List<DataSource> parseParts(InputStream entityInputStream, String contentType) {
        try {
            return this.parsePartsCore(entityInputStream, contentType);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (MessagingException e) {
            throw new RuntimeException(e);
        }
    }

    private List<DataSource> parsePartsCore(InputStream entityInputStream, String contentType) throws MessagingException, IOException {
        InputStreamDataSource dataSource = new InputStreamDataSource(entityInputStream, contentType);
        MimeMultipart batch = new MimeMultipart((DataSource)dataSource);
        MimeBodyPart batchBody = (MimeBodyPart)batch.getBodyPart(0);
        MimeMultipart changeSets = new MimeMultipart((DataSource)new MimePartDataSource((MimePart)batchBody));
        ArrayList<DataSource> result = new ArrayList<DataSource>();
        for (int i = 0; i < changeSets.getCount(); ++i) {
            BodyPart part = changeSets.getBodyPart(i);
            result.add((DataSource)new InputStreamDataSource(part.getInputStream(), part.getContentType()));
        }
        return result;
    }

    public void addOperation(EntityBatchOperation entityBatchOperation) {
        this.entityBatchOperations.add(entityBatchOperation);
    }

    private void addHttpMethod(ByteArrayOutputStream outputStream, String verb, URI uri) {
        try {
            String method = String.format("%s %s HTTP/1.1\r\n", verb, uri);
            outputStream.write(method.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void appendHeaders(OutputStream outputStream, InternetHeaders internetHeaders) {
        try {
            Enumeration headers = internetHeaders.getAllHeaders();
            while (headers.hasMoreElements()) {
                Header header = (Header)headers.nextElement();
                String headerLine = String.format("%s: %s\r\n", header.getName(), header.getValue());
                outputStream.write(headerLine.getBytes("UTF-8"));
            }
            outputStream.write("\r\n".getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void appendEntity(OutputStream outputStream, ByteArrayInputStream byteArrayInputStream) {
        try {
            int bytesRead;
            byte[] buffer = new byte[1024];
            while ((bytesRead = byteArrayInputStream.read(buffer)) > 0) {
                outputStream.write(buffer, 0, bytesRead);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public List<EntityBatchOperation> getOperations() {
        return this.entityBatchOperations;
    }

    public String getBatchId() {
        return this.batchId;
    }

    public MediaType getContentType() {
        Hashtable<String, String> parameters = new Hashtable<String, String>();
        parameters.put("boundary", this.batchId);
        MediaType contentType = new MediaType("multipart", "mixed", parameters);
        return contentType;
    }
}

