/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.citation;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.apache.sis.util.iso.Types;
import org.opengis.metadata.citation.Series;
import org.opengis.util.InternationalString;

@XmlType(name="CI_Series_Type", propOrder={"name", "issueIdentification", "page"})
@XmlRootElement(name="CI_Series")
public class DefaultSeries
extends ISOMetadata
implements Series {
    private static final long serialVersionUID = 7061644572814855051L;
    private InternationalString name;
    private String issueIdentification;
    private String page;

    public DefaultSeries() {
    }

    public DefaultSeries(CharSequence charSequence) {
        this.name = Types.toInternationalString(charSequence);
    }

    public DefaultSeries(Series series) {
        super(series);
        if (series != null) {
            this.name = series.getName();
            this.issueIdentification = series.getIssueIdentification();
            this.page = series.getPage();
        }
    }

    public static DefaultSeries castOrCopy(Series series) {
        if (series == null || series instanceof DefaultSeries) {
            return (DefaultSeries)series;
        }
        return new DefaultSeries(series);
    }

    @XmlElement(name="name")
    public InternationalString getName() {
        return this.name;
    }

    public void setName(InternationalString internationalString) {
        this.checkWritePermission();
        this.name = internationalString;
    }

    @XmlElement(name="issueIdentification")
    public String getIssueIdentification() {
        return this.issueIdentification;
    }

    public void setIssueIdentification(String string) {
        this.checkWritePermission();
        this.issueIdentification = string;
    }

    @XmlElement(name="page")
    public String getPage() {
        return this.page;
    }

    public void setPage(String string) {
        this.checkWritePermission();
        this.page = string;
    }
}

