/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.citation;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.metadata.Dependencies;
import org.apache.sis.internal.metadata.LegacyPropertyAdapter;
import org.apache.sis.metadata.iso.citation.AbstractParty;
import org.apache.sis.metadata.iso.citation.DefaultIndividual;
import org.apache.sis.metadata.iso.citation.DefaultOrganisation;
import org.apache.sis.metadata.iso.citation.DefaultResponsibility;
import org.apache.sis.util.iso.Types;
import org.opengis.metadata.citation.Contact;
import org.opengis.metadata.citation.ResponsibleParty;
import org.opengis.metadata.citation.Role;
import org.opengis.util.InternationalString;

@XmlType(name="CI_ResponsibleParty_Type", propOrder={"individualName", "organisationName", "positionName", "contactInfo", "role"})
@XmlRootElement(name="CI_ResponsibleParty")
public class DefaultResponsibleParty
extends DefaultResponsibility
implements ResponsibleParty {
    private static final long serialVersionUID = -1022635486627088812L;

    public DefaultResponsibleParty() {
    }

    public DefaultResponsibleParty(Role role) {
        super(role, null, null);
    }

    public DefaultResponsibleParty(DefaultResponsibility defaultResponsibility) {
        super(defaultResponsibility);
    }

    public DefaultResponsibleParty(ResponsibleParty responsibleParty) {
        super(responsibleParty);
        if (responsibleParty != null && !(responsibleParty instanceof DefaultResponsibility)) {
            this.setIndividualName(responsibleParty.getIndividualName());
            this.setOrganisationName(responsibleParty.getOrganisationName());
        }
    }

    public static DefaultResponsibleParty castOrCopy(ResponsibleParty responsibleParty) {
        if (responsibleParty == null || responsibleParty instanceof DefaultResponsibleParty) {
            return (DefaultResponsibleParty)responsibleParty;
        }
        return new DefaultResponsibleParty(responsibleParty);
    }

    private InternationalString getIndividual(boolean bl) {
        InternationalString internationalString;
        block1: {
            Collection<AbstractParty> collection = this.getParties();
            internationalString = DefaultResponsibleParty.getName(collection, DefaultIndividual.class, bl);
            if (internationalString != null || collection == null) break block1;
            for (AbstractParty abstractParty : collection) {
                if (abstractParty instanceof DefaultOrganisation && (internationalString = DefaultResponsibleParty.getName(((DefaultOrganisation)abstractParty).getIndividual(), DefaultIndividual.class, bl)) != null) break;
            }
        }
        return internationalString;
    }

    private static InternationalString getName(Collection<? extends AbstractParty> collection, Class<? extends AbstractParty> clazz, boolean bl) {
        InternationalString internationalString = null;
        if (collection != null) {
            for (AbstractParty abstractParty : collection) {
                if (!clazz.isInstance(abstractParty)) continue;
                if (internationalString != null) {
                    LegacyPropertyAdapter.warnIgnoredExtraneous(clazz, DefaultResponsibleParty.class, bl ? "getPositionName" : (clazz == DefaultIndividual.class ? "getIndividualName" : "getOrganisationName"));
                    break;
                }
                internationalString = bl ? ((DefaultIndividual)abstractParty).getPositionName() : abstractParty.getName();
            }
        }
        return internationalString;
    }

    private boolean setName(Class<? extends AbstractParty> clazz, boolean bl, InternationalString internationalString) {
        this.checkWritePermission();
        Iterator<AbstractParty> iterator = this.getParties().iterator();
        while (iterator.hasNext()) {
            AbstractParty abstractParty = iterator.next();
            if (!clazz.isInstance(abstractParty)) continue;
            if (bl) {
                ((DefaultIndividual)abstractParty).setPositionName(internationalString);
            } else {
                abstractParty.setName(internationalString);
            }
            if (abstractParty.isEmpty()) {
                iterator.remove();
            }
            return true;
        }
        return internationalString == null;
    }

    @Deprecated
    @XmlElement(name="individualName")
    @Dependencies(value={"getParties"})
    public String getIndividualName() {
        InternationalString internationalString = this.getIndividual(false);
        return internationalString != null ? internationalString.toString() : null;
    }

    @Deprecated
    public void setIndividualName(String string) {
        if (!this.setName(DefaultIndividual.class, false, Types.toInternationalString(string))) {
            this.getParties().add(new DefaultIndividual(string, null, null));
        }
    }

    @Deprecated
    @XmlElement(name="organisationName")
    @Dependencies(value={"getParties"})
    public InternationalString getOrganisationName() {
        return DefaultResponsibleParty.getName(this.getParties(), DefaultOrganisation.class, false);
    }

    @Deprecated
    public void setOrganisationName(InternationalString internationalString) {
        if (!this.setName(DefaultOrganisation.class, false, Types.toInternationalString((CharSequence)internationalString))) {
            this.getParties().add(new DefaultOrganisation((CharSequence)internationalString, null, null, null));
        }
    }

    @Deprecated
    @XmlElement(name="positionName")
    @Dependencies(value={"getParties"})
    public InternationalString getPositionName() {
        return this.getIndividual(true);
    }

    @Deprecated
    public void setPositionName(InternationalString internationalString) {
        if (!this.setName(DefaultIndividual.class, true, internationalString)) {
            this.getParties().add(new DefaultIndividual(null, (CharSequence)internationalString, null));
        }
    }

    @Deprecated
    @XmlElement(name="contactInfo")
    @Dependencies(value={"getParties"})
    public Contact getContactInfo() {
        Collection<AbstractParty> collection = this.getParties();
        if (collection != null) {
            for (AbstractParty abstractParty : collection) {
                Collection<Contact> collection2 = abstractParty.getContactInfo();
                if (collection2 == null) continue;
                for (Contact contact : collection2) {
                    if (contact == null) continue;
                    return contact;
                }
            }
        }
        return null;
    }

    @Deprecated
    public void setContactInfo(Contact contact) {
        this.checkWritePermission();
        Iterator<AbstractParty> iterator = this.getParties().iterator();
        if (iterator.hasNext()) {
            AbstractParty abstractParty = iterator.next();
            abstractParty.setContactInfo(contact != null ? Collections.singleton(contact) : null);
            if (abstractParty.isEmpty()) {
                iterator.remove();
            }
            return;
        }
        if (contact != null) {
            this.getParties().add(new DefaultIndividual(null, null, contact));
        }
    }

    @Override
    @XmlElement(name="role", required=true)
    public Role getRole() {
        return super.getRole();
    }

    @Override
    public void setRole(Role role) {
        super.setRole(role);
    }
}

