/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.acquisition;

import java.util.Collection;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.jaxb.NonMarshalledAuthority;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.acquisition.Event;
import org.opengis.metadata.acquisition.Instrument;
import org.opengis.metadata.acquisition.Objective;
import org.opengis.metadata.acquisition.ObjectiveType;
import org.opengis.metadata.acquisition.PlatformPass;
import org.opengis.metadata.extent.Extent;
import org.opengis.util.InternationalString;

@XmlType(name="MI_Objective_Type", propOrder={"identifiers", "priority", "types", "functions", "extents", "objectiveOccurences", "pass", "sensingInstruments"})
@XmlRootElement(name="MI_Objective")
public class DefaultObjective
extends ISOMetadata
implements Objective {
    private static final long serialVersionUID = 8273806197892815938L;
    private InternationalString priority;
    private Collection<ObjectiveType> types;
    private Collection<InternationalString> functions;
    private Collection<Extent> extents;
    private Collection<Event> objectiveOccurences;
    private Collection<PlatformPass> pass;
    private Collection<Instrument> sensingInstruments;

    public DefaultObjective() {
    }

    public DefaultObjective(Objective objective) {
        super(objective);
        if (objective != null) {
            this.identifiers = this.copyCollection(objective.getIdentifiers(), Identifier.class);
            this.priority = objective.getPriority();
            this.types = this.copyCollection(objective.getTypes(), ObjectiveType.class);
            this.functions = this.copyCollection(objective.getFunctions(), InternationalString.class);
            this.extents = this.copyCollection(objective.getExtents(), Extent.class);
            this.objectiveOccurences = this.copyCollection(objective.getObjectiveOccurences(), Event.class);
            this.pass = this.copyCollection(objective.getPass(), PlatformPass.class);
            this.sensingInstruments = this.copyCollection(objective.getSensingInstruments(), Instrument.class);
        }
    }

    public static DefaultObjective castOrCopy(Objective objective) {
        if (objective == null || objective instanceof DefaultObjective) {
            return (DefaultObjective)objective;
        }
        return new DefaultObjective(objective);
    }

    @Override
    @XmlElement(name="identifier", required=true)
    public Collection<Identifier> getIdentifiers() {
        return NonMarshalledAuthority.filterOnMarshalling(super.getIdentifiers());
    }

    public void setIdentifiers(Collection<? extends Identifier> collection) {
        collection = NonMarshalledAuthority.setMarshallables(this.identifiers, collection);
        this.identifiers = this.writeCollection(collection, this.identifiers, Identifier.class);
    }

    @XmlElement(name="priority")
    public InternationalString getPriority() {
        return this.priority;
    }

    public void setPriority(InternationalString internationalString) {
        this.checkWritePermission();
        this.priority = internationalString;
    }

    @XmlElement(name="type")
    public Collection<ObjectiveType> getTypes() {
        this.types = this.nonNullCollection(this.types, ObjectiveType.class);
        return this.types;
    }

    public void setTypes(Collection<? extends ObjectiveType> collection) {
        this.types = this.writeCollection(collection, this.types, ObjectiveType.class);
    }

    @XmlElement(name="function")
    public Collection<InternationalString> getFunctions() {
        this.functions = this.nonNullCollection(this.functions, InternationalString.class);
        return this.functions;
    }

    public void setFunctions(Collection<? extends InternationalString> collection) {
        this.functions = this.writeCollection(collection, this.functions, InternationalString.class);
    }

    @XmlElement(name="extent")
    public Collection<Extent> getExtents() {
        this.extents = this.nonNullCollection(this.extents, Extent.class);
        return this.extents;
    }

    public void setExtents(Collection<? extends Extent> collection) {
        this.extents = this.writeCollection(collection, this.extents, Extent.class);
    }

    @XmlElement(name="objectiveOccurence", required=true)
    public Collection<Event> getObjectiveOccurences() {
        this.objectiveOccurences = this.nonNullCollection(this.objectiveOccurences, Event.class);
        return this.objectiveOccurences;
    }

    public void setObjectiveOccurences(Collection<? extends Event> collection) {
        this.objectiveOccurences = this.writeCollection(collection, this.objectiveOccurences, Event.class);
    }

    @XmlElement(name="pass")
    public Collection<PlatformPass> getPass() {
        this.pass = this.nonNullCollection(this.pass, PlatformPass.class);
        return this.pass;
    }

    public void setPass(Collection<? extends PlatformPass> collection) {
        this.pass = this.writeCollection(collection, this.pass, PlatformPass.class);
    }

    @XmlElement(name="sensingInstrument")
    public Collection<Instrument> getSensingInstruments() {
        this.sensingInstruments = this.nonNullCollection(this.sensingInstruments, Instrument.class);
        return this.sensingInstruments;
    }

    public void setSensingInstruments(Collection<? extends Instrument> collection) {
        this.sensingInstruments = this.writeCollection(collection, this.sensingInstruments, Instrument.class);
    }
}

