/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.acquisition;

import java.util.Collection;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.jaxb.NonMarshalledAuthority;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.acquisition.Instrument;
import org.opengis.metadata.acquisition.Platform;
import org.opengis.metadata.citation.Citation;
import org.opengis.util.InternationalString;

@XmlType(name="MI_Instrument_Type", propOrder={"citations", "identifier", "type", "description", "mountedOn"})
@XmlRootElement(name="MI_Instrument")
public class DefaultInstrument
extends ISOMetadata
implements Instrument {
    private static final long serialVersionUID = -7439143424271079960L;
    private Collection<Citation> citations;
    private InternationalString type;
    private InternationalString description;
    private Platform mountedOn;

    public DefaultInstrument() {
    }

    public DefaultInstrument(Instrument instrument) {
        super(instrument);
        if (instrument != null) {
            this.citations = this.copyCollection(instrument.getCitations(), Citation.class);
            this.identifiers = this.singleton(instrument.getIdentifier(), Identifier.class);
            this.type = instrument.getType();
            this.description = instrument.getDescription();
            this.mountedOn = instrument.getMountedOn();
        }
    }

    public static DefaultInstrument castOrCopy(Instrument instrument) {
        if (instrument == null || instrument instanceof DefaultInstrument) {
            return (DefaultInstrument)instrument;
        }
        return new DefaultInstrument(instrument);
    }

    @XmlElement(name="citation")
    public Collection<Citation> getCitations() {
        this.citations = this.nonNullCollection(this.citations, Citation.class);
        return this.citations;
    }

    public void setCitations(Collection<? extends Citation> collection) {
        this.citations = this.writeCollection(collection, this.citations, Citation.class);
    }

    @XmlElement(name="identifier", required=true)
    public Identifier getIdentifier() {
        return NonMarshalledAuthority.getMarshallable(this.identifiers);
    }

    public void setIdentifier(Identifier identifier) {
        this.checkWritePermission();
        this.identifiers = this.nonNullCollection(this.identifiers, Identifier.class);
        NonMarshalledAuthority.setMarshallable(this.identifiers, identifier);
    }

    @XmlElement(name="type", required=true)
    public InternationalString getType() {
        return this.type;
    }

    public void setType(InternationalString internationalString) {
        this.checkWritePermission();
        this.type = internationalString;
    }

    @XmlElement(name="description")
    public InternationalString getDescription() {
        return this.description;
    }

    public void setDescription(InternationalString internationalString) {
        this.checkWritePermission();
        this.description = internationalString;
    }

    @XmlElement(name="mountedOn")
    public Platform getMountedOn() {
        return this.mountedOn;
    }

    public void setMountedOn(Platform platform) {
        this.checkWritePermission();
        this.mountedOn = platform;
    }
}

