/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.metadata;

import java.util.HashMap;
import java.util.Map;
import org.apache.sis.internal.metadata.ReferencingServices;
import org.apache.sis.internal.metadata.VerticalDatumTypes;
import org.apache.sis.metadata.iso.extent.Extents;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.opengis.metadata.extent.Extent;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CRSFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeodeticCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.CSFactory;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.datum.VerticalDatum;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.referencing.operation.Projection;
import org.opengis.util.FactoryException;

public class EllipsoidalHeightCombiner {
    protected static final int CRS = 1;
    protected static final int CS = 2;
    protected static final int OPERATION = 4;
    protected CRSFactory crsFactory;
    protected CSFactory csFactory;
    protected CoordinateOperationFactory opFactory;

    protected EllipsoidalHeightCombiner() {
    }

    public EllipsoidalHeightCombiner(CRSFactory cRSFactory, CSFactory cSFactory, CoordinateOperationFactory coordinateOperationFactory) {
        this.crsFactory = cRSFactory;
        this.csFactory = cSFactory;
        this.opFactory = coordinateOperationFactory;
    }

    protected void initialize(int n) {
    }

    public final CoordinateReferenceSystem createCompoundCRS(Map<String, ?> map, CoordinateReferenceSystem ... coordinateReferenceSystemArray) throws FactoryException {
        for (int i = 0; i < coordinateReferenceSystemArray.length; ++i) {
            Map<String, ?> map2;
            VerticalDatum verticalDatum;
            CoordinateReferenceSystem coordinateReferenceSystem = coordinateReferenceSystemArray[i];
            if (!(coordinateReferenceSystem instanceof VerticalCRS) || (verticalDatum = ((VerticalCRS)coordinateReferenceSystem).getDatum()) == null || verticalDatum.getVerticalDatumType() != VerticalDatumTypes.ELLIPSOIDAL) continue;
            int n = 0;
            CoordinateSystem coordinateSystem = null;
            CoordinateReferenceSystem coordinateReferenceSystem2 = null;
            if (i == 0 || (coordinateSystem = EllipsoidalHeightCombiner.getCsIfHorizontal2D(coordinateReferenceSystem2 = coordinateReferenceSystemArray[i - 1])) == null) {
                if (i + 1 >= coordinateReferenceSystemArray.length || (coordinateSystem = EllipsoidalHeightCombiner.getCsIfHorizontal2D(coordinateReferenceSystem2 = coordinateReferenceSystemArray[i + 1])) == null) continue;
                n = 1;
            }
            CoordinateSystemAxis[] coordinateSystemAxisArray = new CoordinateSystemAxis[3];
            coordinateSystemAxisArray[n++] = coordinateSystem.getAxis(0);
            coordinateSystemAxisArray[n++] = coordinateSystem.getAxis(1);
            coordinateSystemAxisArray[n %= 3] = coordinateReferenceSystem.getCoordinateSystem().getAxis(0);
            ReferencingServices referencingServices = ReferencingServices.getInstance();
            Map<String, ?> map3 = referencingServices.getProperties((IdentifiedObject)coordinateSystem, false);
            Map<String, ?> map4 = map2 = coordinateReferenceSystemArray.length == 2 ? map : referencingServices.getProperties((IdentifiedObject)coordinateReferenceSystem2, false);
            if (coordinateReferenceSystem2 instanceof GeodeticCRS) {
                this.initialize(3);
                coordinateSystem = this.csFactory.createEllipsoidalCS(map3, coordinateSystemAxisArray[0], coordinateSystemAxisArray[1], coordinateSystemAxisArray[2]);
                coordinateReferenceSystem2 = this.crsFactory.createGeographicCRS(map2, ((GeodeticCRS)coordinateReferenceSystem2).getDatum(), (EllipsoidalCS)coordinateSystem);
            } else {
                this.initialize(7);
                ProjectedCRS projectedCRS = (ProjectedCRS)coordinateReferenceSystem2;
                GeographicCRS geographicCRS = projectedCRS.getBaseCRS();
                if (geographicCRS.getCoordinateSystem().getDimension() == 2) {
                    geographicCRS = (GeographicCRS)this.createCompoundCRS(referencingServices.getProperties((IdentifiedObject)geographicCRS, false), new CoordinateReferenceSystem[]{geographicCRS, coordinateReferenceSystem});
                }
                Projection projection = projectedCRS.getConversionFromBase();
                projection = this.opFactory.createDefiningConversion(referencingServices.getProperties((IdentifiedObject)projection, true), projection.getMethod(), projection.getParameterValues());
                coordinateSystem = this.csFactory.createCartesianCS(map3, coordinateSystemAxisArray[0], coordinateSystemAxisArray[1], coordinateSystemAxisArray[2]);
                coordinateReferenceSystem2 = this.crsFactory.createProjectedCRS(map2, geographicCRS, (Conversion)projection, (CartesianCS)coordinateSystem);
            }
            coordinateReferenceSystemArray = ArraysExt.remove(coordinateReferenceSystemArray, i, 1);
            if (n != 0) {
                --i;
            }
            coordinateReferenceSystemArray[i] = coordinateReferenceSystem2;
        }
        switch (coordinateReferenceSystemArray.length) {
            case 0: {
                return null;
            }
            case 1: {
                return coordinateReferenceSystemArray[0];
            }
        }
        this.initialize(1);
        return this.crsFactory.createCompoundCRS(map, coordinateReferenceSystemArray);
    }

    private static CoordinateSystem getCsIfHorizontal2D(CoordinateReferenceSystem coordinateReferenceSystem) {
        CoordinateSystem coordinateSystem;
        boolean bl = coordinateReferenceSystem instanceof ProjectedCRS;
        if ((bl || coordinateReferenceSystem instanceof GeodeticCRS) && (coordinateSystem = coordinateReferenceSystem.getCoordinateSystem()).getDimension() == 2 && (bl || coordinateSystem instanceof EllipsoidalCS)) {
            return coordinateSystem;
        }
        return null;
    }

    public static Map<String, Object> properties(CoordinateReferenceSystem ... coordinateReferenceSystemArray) {
        StringBuilder stringBuilder = new StringBuilder(40);
        Extent extent = null;
        for (int i = 0; i < coordinateReferenceSystemArray.length; ++i) {
            CoordinateReferenceSystem coordinateReferenceSystem = coordinateReferenceSystemArray[i];
            ArgumentChecks.ensureNonNullElement("components", i, coordinateReferenceSystem);
            if (i != 0) {
                stringBuilder.append(" + ");
            }
            stringBuilder.append(coordinateReferenceSystem.getName().getCode());
            extent = Extents.intersection(extent, coordinateReferenceSystem.getDomainOfValidity());
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>(2);
        hashMap.put("name", stringBuilder.toString());
        hashMap.put("domainOfValidity", extent);
        return hashMap;
    }
}

