/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.internal.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import java.util.function.Supplier;
import org.apache.uima.internal.util.Misc;
import org.apache.uima.jcas.cas.TOP;
import org.apache.uima.util.impl.Constants;

public class OrderedFsSet_array2
implements NavigableSet<TOP> {
    private static final boolean TRACE = false;
    private static final boolean MEASURE = false;
    private static final int DEFAULT_MIN_SIZE = 8;
    private static final int MAX_DOUBLE_SIZE = 0x400000;
    private static final int MIN_SIZE = 8;
    TOP[] a = new TOP[8];
    int a_nextFreeslot = 0;
    int a_firstUsedslot = 0;
    private final ArrayList<TOP> batch = new ArrayList();
    public final Comparator<TOP> comparatorWithID;
    public final Comparator<TOP> comparatorWithoutID;
    private int size = 0;
    private int maxSize = 0;
    private TOP highest = null;
    private int nullBlockStart = -1;
    private int nullBlockEnd = -1;
    private boolean doingBatchAdds = false;
    private int modificationCount = 0;
    private int lastRemovedPos = -1;
    private StringBuilder tr = null;
    private static int addToEndCount = 0;
    private static int addNotToEndCount = 0;
    private static int[] batchCountHistogram;
    private static int batchAddCount;
    private static int batchAddTotal;
    private static int[] moveSizeHistogram;
    private static int[] movePctHistogram;
    private static int[] fillHistogram;
    private static int[] iterPctEmptySkip;

    public OrderedFsSet_array2(Comparator<TOP> comparatorWithID, Comparator<TOP> comparatorWithoutID) {
        this.comparatorWithID = comparatorWithID;
        this.comparatorWithoutID = comparatorWithoutID;
    }

    public OrderedFsSet_array2(OrderedFsSet_array2 set) {
        set.processBatch();
        this.a = Arrays.copyOf(set.a, set.a.length);
        this.a_nextFreeslot = set.a_nextFreeslot;
        this.a_firstUsedslot = set.a_firstUsedslot;
        this.comparatorWithID = set.comparatorWithID;
        this.comparatorWithoutID = set.comparatorWithoutID;
        this.size = set.size;
        this.maxSize = set.maxSize;
        this.highest = set.highest;
        this.nullBlockStart = set.nullBlockStart;
        this.nullBlockEnd = set.nullBlockEnd;
        this.modificationCount = set.modificationCount;
        this.lastRemovedPos = set.lastRemovedPos;
    }

    public OrderedFsSet_array2(OrderedFsSet_array2 set, boolean isReadOnly) {
        if (!isReadOnly) {
            Misc.internalError();
        }
        set.processBatch();
        this.size = set.size;
        this.a = this.size == 0 ? Constants.EMPTY_TOP_ARRAY : Arrays.copyOf(set.a, set.a.length);
        this.a_nextFreeslot = set.a_nextFreeslot;
        this.a_firstUsedslot = set.a_firstUsedslot;
        this.comparatorWithID = set.comparatorWithID;
        this.comparatorWithoutID = set.comparatorWithoutID;
        this.maxSize = set.maxSize;
        this.highest = set.highest;
        this.nullBlockStart = set.nullBlockStart;
        this.nullBlockEnd = set.nullBlockEnd;
        this.modificationCount = set.modificationCount;
        this.lastRemovedPos = set.lastRemovedPos;
    }

    @Override
    public Comparator<? super TOP> comparator() {
        return this.comparatorWithID;
    }

    @Override
    public TOP first() {
        this.processBatch();
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        for (int i = this.a_firstUsedslot; i < this.a_nextFreeslot; ++i) {
            TOP item = this.a[i];
            if (null == item) continue;
            if (i > this.a_firstUsedslot) {
                this.a_firstUsedslot = i;
            }
            return item;
        }
        Misc.internalError();
        return null;
    }

    @Override
    public TOP last() {
        this.processBatch();
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        for (int i = this.a_nextFreeslot - 1; i >= this.a_firstUsedslot; --i) {
            TOP item = this.a[i];
            if (item == null) continue;
            if (i < this.a_nextFreeslot - 1) {
                this.a_nextFreeslot = i + 1;
            }
            return item;
        }
        Misc.internalError();
        return null;
    }

    @Override
    public int size() {
        this.processBatch();
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0 && this.batch.size() == 0;
    }

    @Override
    public boolean contains(Object o) {
        if (o == null) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty()) {
            return false;
        }
        TOP fs = (TOP)o;
        this.processBatch();
        return this.find(fs) >= 0;
    }

    @Override
    public Object[] toArray() {
        Object[] r = new Object[this.size()];
        int i = 0;
        for (TOP item : this.a) {
            if (item == null) continue;
            r[i++] = item;
        }
        assert (r.length == i);
        return r;
    }

    @Override
    public <T> T[] toArray(T[] a1) {
        if (a1.length < this.size()) {
            a1 = (Object[])Array.newInstance(this.a.getClass(), this.size());
        }
        int i = 0;
        for (TOP item : this.a) {
            if (item == null) continue;
            a1[i++] = item;
        }
        if (i < a1.length) {
            a1[i] = null;
        }
        return a1;
    }

    @Override
    public boolean add(TOP fs) {
        if (fs == null) {
            throw new IllegalArgumentException("Null cannot be added to this set.");
        }
        if (this.highest == null) {
            this.addNewHighest(fs);
            return true;
        }
        int c = this.comparatorWithID.compare(fs, this.highest);
        if (c > 0) {
            this.addNewHighest(fs);
            return true;
        }
        if (c == 0) {
            return false;
        }
        this.batch.add(fs);
        return true;
    }

    private void addNewHighest(TOP fs) {
        this.highest = fs;
        this.ensureCapacity(1);
        this.a[this.a_nextFreeslot++] = fs;
        this.incrSize();
    }

    private void incrSize() {
        ++this.size;
        this.maxSize = Math.max(this.maxSize, this.size);
        ++this.modificationCount;
    }

    private void ensureCapacity(int incr) {
        int szNeeded = this.a_nextFreeslot + incr;
        if (szNeeded <= this.a.length) {
            return;
        }
        int sz = this.a.length;
        while ((sz = sz < 0x400000 ? sz << 1 : sz + 0x400000) < szNeeded) {
        }
        TOP[] aa = new TOP[sz];
        System.arraycopy(this.a, 0, aa, 0, this.a_nextFreeslot);
        this.a = aa;
    }

    private boolean shrinkCapacity() {
        int nextSmallerSize = this.getNextSmallerSize(2);
        if (nextSmallerSize == 8) {
            return false;
        }
        if (this.maxSize < nextSmallerSize) {
            this.a = new TOP[this.getNextSmallerSize(1)];
            this.maxSize = 0;
            return true;
        }
        this.maxSize = 0;
        return false;
    }

    private int getNextSmallerSize(int n) {
        int sz = this.a.length;
        if (sz <= 8) {
            return 8;
        }
        for (int i = 0; i < n; ++i) {
            sz = sz > 0x400000 ? sz - 0x400000 : sz >> 1;
        }
        return sz;
    }

    public void processBatch() {
        if (this.batch.size() != 0) {
            this.doProcessBatch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doProcessBatch() {
        ArrayList<TOP> arrayList = this.batch;
        synchronized (arrayList) {
            int batchSize = this.batch.size();
            if (batchSize == 0) {
                return;
            }
            if (this.doingBatchAdds) {
                return;
            }
            try {
                this.doingBatchAdds = true;
                int nbrNewSlots = 1;
                if (batchSize > 1) {
                    Collections.sort(this.batch, this.comparatorWithID);
                    TOP prev = this.batch.get(batchSize - 1);
                    boolean useEq = this.comparatorWithID != this.comparatorWithoutID;
                    for (int i = batchSize - 2; i >= 0; --i) {
                        TOP item = this.batch.get(i);
                        if (useEq ? item == prev : this.comparatorWithID.compare(item, prev) == 0) {
                            this.batch.set(i + 1, null);
                            if (i + 1 != batchSize - 1) continue;
                            --batchSize;
                            continue;
                        }
                        prev = item;
                        ++nbrNewSlots;
                    }
                }
                int i_batch = batchSize - 1;
                int insertPosOfAddedSpace = 0;
                TOP itemToAdd = this.batch.get(i_batch);
                while (itemToAdd == null || (insertPosOfAddedSpace = this.find(itemToAdd)) >= 0) {
                    --nbrNewSlots;
                    if (--i_batch < 0) {
                        this.batch.clear();
                        return;
                    }
                    itemToAdd = this.batch.get(i_batch);
                }
                insertPosOfAddedSpace = -insertPosOfAddedSpace - 1;
                int indexOfNewItem = this.insertSpace(insertPosOfAddedSpace, nbrNewSlots) - 1;
                assert (nbrNewSlots == this.nullBlockEnd - this.nullBlockStart);
                int nbrNewSlotsRemaining = nbrNewSlots;
                if (indexOfNewItem >= this.nullBlockStart) {
                    --nbrNewSlotsRemaining;
                }
                this.insertItem(indexOfNewItem, itemToAdd);
                if (indexOfNewItem + 1 == this.a_nextFreeslot) {
                    this.highest = itemToAdd;
                }
                for (int bPos = i_batch - 1; bPos >= 0; --bPos) {
                    int pos;
                    itemToAdd = this.batch.get(bPos);
                    if (null == itemToAdd || (pos = this.findRemaining(itemToAdd)) >= 0) continue;
                    pos = -pos - 1;
                    assert (this.a[pos] != null);
                    indexOfNewItem = pos - 1;
                    if (this.nullBlockStart == 0) {
                        this.insertItem(indexOfNewItem--, itemToAdd);
                        --nbrNewSlotsRemaining;
                        --bPos;
                        while (bPos >= 0) {
                            itemToAdd = this.batch.get(bPos);
                            if (itemToAdd != null) {
                                this.insertItem(indexOfNewItem--, itemToAdd);
                                --nbrNewSlotsRemaining;
                            }
                            --bPos;
                        }
                        break;
                    }
                    if (indexOfNewItem == -1 || null != this.a[indexOfNewItem]) {
                        indexOfNewItem = this.shiftFreespaceDown(pos, nbrNewSlotsRemaining) - 1;
                        assert (nbrNewSlotsRemaining == this.nullBlockEnd - this.nullBlockStart);
                        --nbrNewSlotsRemaining;
                    } else if (indexOfNewItem < this.nullBlockEnd && indexOfNewItem >= this.nullBlockStart) {
                        --nbrNewSlotsRemaining;
                    }
                    this.insertItem(indexOfNewItem, itemToAdd);
                }
                if (nbrNewSlotsRemaining > 0 && this.nullBlockEnd != this.a_firstUsedslot) {
                    assert (nbrNewSlotsRemaining == this.nullBlockEnd - this.nullBlockStart);
                    int nullBlockEnd_end = this.a_nextFreeslot - this.nullBlockEnd;
                    int nullBlockStart_start = this.nullBlockStart - this.a_firstUsedslot;
                    assert (nullBlockEnd_end > 0);
                    assert (nullBlockStart_start > 0);
                    if (nullBlockStart_start <= nullBlockEnd_end) {
                        this.shiftFreespaceDown(this.a_firstUsedslot, nbrNewSlotsRemaining);
                    } else {
                        this.shiftFreespaceUp(this.a_nextFreeslot, nbrNewSlotsRemaining);
                        this.a_nextFreeslot -= nbrNewSlotsRemaining;
                    }
                }
                this.nullBlockEnd = -1;
                this.nullBlockStart = -1;
                this.batch.clear();
            }
            finally {
                this.doingBatchAdds = false;
            }
        }
    }

    private void insertItem(int indexToUpdate, TOP itemToAdd) {
        assert (indexToUpdate >= 0);
        assert (null == this.a[indexToUpdate]);
        this.a[indexToUpdate] = itemToAdd;
        if (indexToUpdate == this.lastRemovedPos) {
            this.lastRemovedPos = -1;
        }
        this.incrSize();
        if (indexToUpdate < this.a_firstUsedslot) {
            this.a_firstUsedslot = indexToUpdate;
        }
        if (this.nullBlockEnd == indexToUpdate + 1) {
            --this.nullBlockEnd;
            if (this.nullBlockStart == this.nullBlockEnd) {
                this.nullBlockEnd = -1;
                this.nullBlockStart = -1;
            }
        }
        if (this.nullBlockStart == indexToUpdate) {
            this.nullBlockEnd = -1;
            this.nullBlockStart = -1;
        }
    }

    private int insertSpace(int positionToInsert, int origNbrNewSlots) {
        int nbrNewSlotsNeeded;
        int i;
        int nullsBelowInsertMin = i = positionToInsert;
        for (nbrNewSlotsNeeded = origNbrNewSlots; i > 0 && this.a[i - 1] == null && nbrNewSlotsNeeded > 0; --nbrNewSlotsNeeded) {
            nullsBelowInsertMin = --i;
            if (i != this.lastRemovedPos) continue;
            this.lastRemovedPos = -1;
        }
        int r = positionToInsert;
        if (nbrNewSlotsNeeded != 0) {
            boolean useLastRemoved;
            int distanceFromLastRemoved = this.lastRemovedPos == -1 || nbrNewSlotsNeeded != 1 ? Integer.MAX_VALUE : positionToInsert - this.lastRemovedPos;
            int distanceFromEnd = this.a_nextFreeslot - positionToInsert;
            int distanceFromFront = this.a_firstUsedslot < nbrNewSlotsNeeded ? Integer.MAX_VALUE : positionToInsert - this.a_firstUsedslot;
            boolean useFront = distanceFromFront < distanceFromEnd;
            boolean bl = useLastRemoved = Math.abs(distanceFromLastRemoved) < (useFront ? distanceFromFront : distanceFromEnd);
            if (!useLastRemoved && !useFront && this.a.length < this.a_nextFreeslot + nbrNewSlotsNeeded) {
                boolean bl2 = useFront = nbrNewSlotsNeeded <= this.a_firstUsedslot;
            }
            if (useLastRemoved) {
                this.nullBlockStart = this.lastRemovedPos;
                this.nullBlockEnd = this.lastRemovedPos + 1;
                if (distanceFromLastRemoved > 0) {
                    assert (distanceFromLastRemoved != 1);
                    this.shiftFreespaceUp(nullsBelowInsertMin, nbrNewSlotsNeeded);
                } else {
                    r = this.shiftFreespaceDown(positionToInsert, nbrNewSlotsNeeded);
                }
                this.lastRemovedPos = -1;
            } else if (useFront) {
                this.nullBlockStart = this.a_firstUsedslot - nbrNewSlotsNeeded;
                this.nullBlockEnd = this.a_firstUsedslot;
                if (this.a_firstUsedslot != positionToInsert) {
                    this.shiftFreespaceUp(positionToInsert, nbrNewSlotsNeeded);
                }
            } else {
                this.ensureCapacity(nbrNewSlotsNeeded);
                this.nullBlockStart = this.a_nextFreeslot;
                this.nullBlockEnd = this.nullBlockStart + nbrNewSlotsNeeded;
                r = this.shiftFreespaceDown(positionToInsert, nbrNewSlotsNeeded);
                this.a_nextFreeslot += nbrNewSlotsNeeded;
            }
        }
        this.nullBlockEnd = r;
        this.nullBlockStart = r - origNbrNewSlots;
        return r;
    }

    private int shiftFreespaceDown(int insertPoint, int nbrNewSlots) {
        int i;
        assert (insertPoint >= 0);
        assert (nbrNewSlots >= 0);
        int lengthToMove = this.nullBlockStart - insertPoint;
        try {
            if (this.lastRemovedPos >= insertPoint && this.lastRemovedPos < insertPoint + lengthToMove) {
                this.lastRemovedPos += nbrNewSlots;
            }
            System.arraycopy(this.a, insertPoint, this.a, insertPoint + nbrNewSlots, lengthToMove);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            System.err.println("Internal error: OrderedFsSet_sorted got array out of bounds in shiftFreeSpaceDown " + e.toString());
            System.err.format("  array size: %,d insertPoint: %,d nbrNewSlots: %,d lengthToMove: %d%n", this.a.length, insertPoint, nbrNewSlots, lengthToMove);
            throw e;
        }
        int lengthToClear = Math.min(nbrNewSlots, lengthToMove);
        Arrays.fill(this.a, insertPoint, insertPoint + lengthToClear, null);
        this.nullBlockStart = insertPoint;
        this.nullBlockEnd = this.nullBlockStart + nbrNewSlots;
        for (i = insertPoint - 1; i >= 0 && this.a[i] == null; --i) {
        }
        this.nullBlockStart = i + 1;
        if (insertPoint == this.a_firstUsedslot) {
            this.a_firstUsedslot = insertPoint + nbrNewSlots;
        }
        return insertPoint + nbrNewSlots;
    }

    private int shiftFreespaceUp(int newInsertPoint, int nbrNewSlots) {
        boolean need2setFirstUsedslot = this.nullBlockEnd == this.a_firstUsedslot;
        int lengthToMove = newInsertPoint - this.nullBlockEnd;
        if (this.lastRemovedPos >= this.nullBlockEnd && this.lastRemovedPos < this.nullBlockEnd + lengthToMove) {
            this.lastRemovedPos -= nbrNewSlots;
        }
        System.arraycopy(this.a, this.nullBlockEnd, this.a, this.nullBlockStart, lengthToMove);
        int lengthToClear = Math.min(nbrNewSlots, lengthToMove);
        Arrays.fill(this.a, newInsertPoint - lengthToClear, newInsertPoint, null);
        this.nullBlockStart = newInsertPoint - nbrNewSlots;
        this.nullBlockEnd = newInsertPoint;
        if (need2setFirstUsedslot) {
            this.a_firstUsedslot = 0;
        }
        return newInsertPoint;
    }

    private int find(TOP fs) {
        if (this.size == 0) {
            return -1;
        }
        return this.binarySearch(fs);
    }

    private int findRemaining(TOP fs) {
        int pos = OrderedFsSet_array2.binarySearch(fs, this.a_firstUsedslot, this.nullBlockStart, this.a, this.nullBlockStart, this.nullBlockEnd, this.comparatorWithID);
        return pos < 0 && -pos - 1 == this.nullBlockStart ? -this.nullBlockEnd - 1 : pos;
    }

    private int binarySearch(TOP fs) {
        return OrderedFsSet_array2.binarySearch(fs, this.a_firstUsedslot, this.a_nextFreeslot, this.a, this.nullBlockStart, this.nullBlockEnd, this.comparatorWithID);
    }

    public static int binarySearch(TOP fs, int start, int end, TOP[] _a, int _nullBlockStart, int _nullBlockEnd, Comparator<TOP> _comparatorWithID) {
        int pos;
        int c;
        if (start < 0 || end - start <= 0) {
            return start < 0 ? -1 : -start - 1;
        }
        int lower = start;
        int upper = end;
        do {
            int mid = lower + upper >>> 1;
            TOP item = _a[mid];
            int delta = 0;
            int midup = mid;
            int middwn = mid;
            pos = mid;
            while (null == item) {
                boolean belowLower;
                boolean belowUpper;
                if (_nullBlockStart != -1 && middwn >= _nullBlockStart && midup < _nullBlockEnd) {
                    midup = _nullBlockEnd;
                    middwn = _nullBlockStart - 1;
                } else {
                    ++delta;
                }
                pos = midup + delta;
                boolean bl = belowUpper = pos < upper;
                if (belowUpper && null != (item = _a[pos])) break;
                pos = middwn - delta;
                boolean bl2 = belowLower = pos < lower;
                if (!belowLower && null != (item = _a[pos])) break;
                if (belowUpper || !belowLower) continue;
                return -upper - 1;
            }
            if ((c = _comparatorWithID.compare(fs, item)) != 0) continue;
            return pos;
        } while (!(c < 0 ? (upper = pos) == lower : (lower = pos + 1) == upper));
        return -upper - 1;
    }

    @Override
    public boolean remove(Object o) {
        if (o == null) {
            throw new IllegalArgumentException("Null cannot be the argument to remove");
        }
        this.processBatch();
        TOP fs = (TOP)o;
        int pos = this.find(fs);
        if (pos < 0) {
            return false;
        }
        assert (this.a[pos] != null);
        this.a[pos] = null;
        --this.size;
        ++this.modificationCount;
        if (this.size == 0) {
            this.clearResets();
        } else {
            if (pos == this.a_firstUsedslot) {
                do {
                    ++this.a_firstUsedslot;
                } while (this.a[this.a_firstUsedslot] == null);
            } else if (pos == this.a_nextFreeslot - 1) {
                do {
                    --this.a_nextFreeslot;
                } while (this.a[this.a_nextFreeslot - 1] == null);
                this.highest = this.a[this.a_nextFreeslot - 1];
            }
            if (this.size < this.a_nextFreeslot - this.a_firstUsedslot >> 1 && this.size > 8) {
                this.compressOutRemoves();
            } else {
                this.lastRemovedPos = pos > this.a_firstUsedslot && pos < this.a_nextFreeslot - 1 ? pos : -1;
            }
            int spaceToSave = this.a_firstUsedslot + (this.a.length >> 2) - this.a_nextFreeslot;
            if (spaceToSave > 32) {
                int spaceAtEnd = (this.a.length >> 1) - this.a_nextFreeslot;
                int totalSpaceToSave = spaceAtEnd + this.a_firstUsedslot;
                int spaceToHaveAtFront = totalSpaceToSave >> 1;
                int spaceToReclaimAtFront = Math.max(0, this.a_firstUsedslot - spaceToHaveAtFront);
                this.a = Arrays.copyOfRange(this.a, spaceToReclaimAtFront, spaceToReclaimAtFront + (this.a.length >> 1));
                this.a_firstUsedslot -= spaceToReclaimAtFront;
                this.a_nextFreeslot -= spaceToReclaimAtFront;
                if (this.lastRemovedPos != -1) {
                    assert (this.lastRemovedPos > spaceToReclaimAtFront);
                    this.lastRemovedPos -= spaceToReclaimAtFront;
                }
            }
        }
        return true;
    }

    private void compressOutRemoves() {
        int j = this.a_firstUsedslot + 1;
        int i = this.a_firstUsedslot + 1;
        while (i < this.a_nextFreeslot) {
            while (this.a[i] == null) {
                ++i;
            }
            if (i > j) {
                this.a[j] = this.a[i];
            }
            ++i;
            ++j;
        }
        Arrays.fill(this.a, j, this.a_nextFreeslot, null);
        this.a_nextFreeslot = j;
        this.lastRemovedPos = -1;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends TOP> c) {
        boolean changed = false;
        for (TOP tOP : c) {
            changed |= this.add(tOP);
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        if (this.isEmpty()) {
            return;
        }
        if (!this.shrinkCapacity()) {
            Arrays.fill(this.a, this.a_firstUsedslot, this.a_nextFreeslot, null);
        }
        this.clearResets();
    }

    private void clearResets() {
        this.a_firstUsedslot = 0;
        this.a_nextFreeslot = 0;
        this.batch.clear();
        this.size = 0;
        this.maxSize = 0;
        this.nullBlockStart = -1;
        this.nullBlockEnd = -1;
        this.doingBatchAdds = false;
        this.highest = null;
        ++this.modificationCount;
        this.lastRemovedPos = -1;
    }

    @Override
    public TOP lower(TOP fs) {
        int pos = this.lowerPos(fs);
        return pos < 0 ? null : this.a[pos];
    }

    public int lowerPos(TOP fs) {
        this.processBatch();
        int pos = this.find(fs);
        int n = pos = pos < 0 ? -pos - 2 : pos - 1;
        while (pos >= this.a_firstUsedslot) {
            if (this.a[pos] != null) {
                return pos;
            }
            --pos;
        }
        return -1;
    }

    @Override
    public TOP floor(TOP fs) {
        int pos = this.floorPos(fs);
        return pos < 0 ? null : this.a[pos];
    }

    public int floorPos(TOP fs) {
        this.processBatch();
        int pos = this.find(fs);
        if (pos < 0) {
            pos = -pos - 2;
        }
        while (pos >= this.a_firstUsedslot) {
            if (this.a[pos] != null) {
                return pos;
            }
            --pos;
        }
        return -1;
    }

    @Override
    public TOP ceiling(TOP fs) {
        int pos = this.ceilingPos(fs);
        return pos < this.a_nextFreeslot ? this.a[pos] : null;
    }

    public int ceilingPos(TOP fs) {
        this.processBatch();
        int pos = this.find(fs);
        if (pos < 0) {
        } else {
            return pos;
        }
        for (pos = -pos - 1; pos < this.a_nextFreeslot; ++pos) {
            if (this.a[pos] == null) continue;
            return pos;
        }
        return pos;
    }

    @Override
    public TOP higher(TOP fs) {
        int pos = this.higherPos(fs);
        return pos < this.a_nextFreeslot ? this.a[pos] : null;
    }

    public int higherPos(TOP fs) {
        this.processBatch();
        int pos = this.find(fs);
        int n = pos = pos < 0 ? -pos - 1 : pos + 1;
        while (pos < this.a_nextFreeslot) {
            if (this.a[pos] != null) {
                return pos;
            }
            ++pos;
        }
        return pos;
    }

    @Override
    public TOP pollFirst() {
        throw new UnsupportedOperationException();
    }

    @Override
    public TOP pollLast() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<TOP> iterator() {
        this.processBatch();
        if (this.a_nextFreeslot == 0) {
            return Collections.emptyIterator();
        }
        return new Iterator<TOP>(){
            private int pos;
            {
                this.pos = OrderedFsSet_array2.this.a_firstUsedslot;
                this.incrToSkipOverNulls();
            }

            @Override
            public boolean hasNext() {
                OrderedFsSet_array2.this.processBatch();
                return this.pos < OrderedFsSet_array2.this.a_nextFreeslot;
            }

            @Override
            public TOP next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                TOP r = OrderedFsSet_array2.this.a[this.pos++];
                this.incrToSkipOverNulls();
                return r;
            }

            private void incrToSkipOverNulls() {
                while (this.pos < OrderedFsSet_array2.this.a_nextFreeslot && OrderedFsSet_array2.this.a[this.pos] == null) {
                    ++this.pos;
                }
            }
        };
    }

    @Override
    public NavigableSet<TOP> descendingSet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<TOP> descendingIterator() {
        this.processBatch();
        return new Iterator<TOP>(){
            private int pos;
            {
                this.pos = OrderedFsSet_array2.this.a_nextFreeslot - 1;
                if (this.pos >= 0) {
                    this.decrToNext();
                }
            }

            @Override
            public boolean hasNext() {
                return this.pos >= OrderedFsSet_array2.this.a_firstUsedslot;
            }

            @Override
            public TOP next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                TOP r = OrderedFsSet_array2.this.a[this.pos--];
                this.decrToNext();
                return r;
            }

            private void decrToNext() {
                while (this.pos >= OrderedFsSet_array2.this.a_firstUsedslot && OrderedFsSet_array2.this.a[this.pos] == null) {
                    --this.pos;
                }
            }
        };
    }

    @Override
    public NavigableSet<TOP> subSet(TOP fromElement, boolean fromInclusive, TOP toElement, boolean toInclusive) {
        return new SubSet(() -> this, fromElement, fromInclusive, toElement, toInclusive, false, null);
    }

    @Override
    public NavigableSet<TOP> headSet(TOP toElement, boolean inclusive) {
        if (this.isEmpty()) {
            return this;
        }
        return this.subSet(this.first(), true, toElement, inclusive);
    }

    @Override
    public NavigableSet<TOP> tailSet(TOP fromElement, boolean inclusive) {
        if (this.isEmpty()) {
            return this;
        }
        return this.subSet(fromElement, inclusive, this.last(), true);
    }

    @Override
    public SortedSet<TOP> subSet(TOP fromElement, TOP toElement) {
        return this.subSet(fromElement, true, toElement, false);
    }

    @Override
    public SortedSet<TOP> headSet(TOP toElement) {
        return this.headSet(toElement, false);
    }

    @Override
    public SortedSet<TOP> tailSet(TOP fromElement) {
        return this.tailSet(fromElement, true);
    }

    public int getModificationCount() {
        return this.modificationCount;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("OrderedFsSet_array [a=");
        if (this.a != null) {
            boolean firstTime = true;
            for (TOP i : this.a) {
                if (firstTime) {
                    firstTime = false;
                } else {
                    b.append(",\n");
                }
                if (i != null) {
                    b.append(i.toShortString());
                    continue;
                }
                b.append("null");
            }
        } else {
            b.append("null");
        }
        b.append(", a_nextFreeslot=").append(this.a_nextFreeslot).append(", a_firstUsedslot=").append(this.a_firstUsedslot).append(", batch=").append(this.batch).append(", origComparator=").append(this.comparatorWithID).append(", size=").append(this.size).append(", maxSize=").append(this.maxSize).append(", highest=").append(this.highest).append(", nullBlockStart=").append(this.nullBlockStart).append(", nullBlockEnd=").append(this.nullBlockEnd).append("]");
        return b.toString();
    }

    private static /* synthetic */ void lambda$static$1() {
        int v;
        int i;
        System.out.println("Histogram measures of Ordered Set add / remove operations");
        System.out.format(" - Add to end: %,d,  batch add count: %,d  batch add tot: %,d%n", addToEndCount, batchAddCount, batchAddTotal);
        for (i = 0; i < batchCountHistogram.length; ++i) {
            v = batchCountHistogram[i];
            if (v == 0) continue;
            System.out.format(" batch size: %,d, count: %,d%n", 1 << i, v);
        }
        for (i = 0; i < moveSizeHistogram.length; ++i) {
            v = moveSizeHistogram[i];
            if (v == 0) continue;
            System.out.format(" move size: %,d, count: %,d%n", i == 0 ? 0 : 1 << i - 1, v);
        }
        for (i = 0; i < movePctHistogram.length; ++i) {
            v = movePctHistogram[i];
            if (v == 0) continue;
            System.out.format(" move Pct: %,d - %,d, count: %,d%n", i * 10, (i + 1) * 10, v);
        }
        for (i = 0; i < fillHistogram.length; ++i) {
            v = fillHistogram[i];
            if (v == 0) continue;
            System.out.format(" fill size: %,d, count: %,d%n", i == 0 ? 0 : 1 << i - 1, v);
        }
        for (i = 0; i < iterPctEmptySkip.length; ++i) {
            v = iterPctEmptySkip[i];
            if (v == 0) continue;
            System.out.format(" iterator percent empty needing skip: %,d - %,d, count: %,d%n", i * 10, (i + 1) * 10, v);
        }
    }

    static {
        batchAddCount = 0;
        batchAddTotal = 0;
    }

    public static class SubSet
    implements NavigableSet<TOP> {
        final Supplier<OrderedFsSet_array2> theSet;
        private final TOP fromElement;
        private final TOP toElement;
        private final boolean fromInclusive;
        private final boolean toInclusive;
        private final int firstPosInRange;
        private final int lastPosInRange;
        private final TOP firstElementInRange;
        private final TOP lastElementInRange;
        private int sizeSubSet = -1;

        private OrderedFsSet_array2 theSet() {
            return this.theSet.get();
        }

        SubSet(Supplier<OrderedFsSet_array2> theSet, TOP fromElement, boolean fromInclusive, TOP toElement, boolean toInclusive) {
            this(theSet, fromElement, fromInclusive, toElement, toInclusive, true, theSet.get().comparatorWithID);
        }

        SubSet(Supplier<OrderedFsSet_array2> theSet, TOP fromElement, boolean fromInclusive, TOP toElement, boolean toInclusive, boolean doTest, Comparator<TOP> comparator) {
            this.theSet = theSet;
            this.fromElement = fromElement;
            this.toElement = toElement;
            this.fromInclusive = fromInclusive;
            this.toInclusive = toInclusive;
            if (doTest && comparator.compare(fromElement, toElement) > 0) {
                throw new IllegalArgumentException();
            }
            OrderedFsSet_array2 s = this.theSet();
            this.theSet().processBatch();
            this.firstPosInRange = fromInclusive ? s.ceilingPos(fromElement) : s.higherPos(fromElement);
            int n = this.lastPosInRange = toInclusive ? s.floorPos(toElement) : s.lowerPos(toElement);
            if (this.lastPosInRange < this.firstPosInRange) {
                this.firstElementInRange = null;
                this.lastElementInRange = null;
            } else {
                this.firstElementInRange = s.a[this.firstPosInRange];
                this.lastElementInRange = s.a[this.lastPosInRange];
            }
        }

        @Override
        public Comparator<? super TOP> comparator() {
            return this.theSet().comparatorWithID;
        }

        @Override
        public TOP first() {
            return this.firstElementInRange;
        }

        @Override
        public TOP last() {
            return this.lastElementInRange;
        }

        @Override
        public int size() {
            if (this.firstElementInRange == null) {
                return 0;
            }
            if (this.sizeSubSet == -1) {
                Iterator<TOP> it = this.iterator();
                int i = 0;
                while (it.hasNext()) {
                    it.next();
                    ++i;
                }
                this.sizeSubSet = i;
            }
            return this.sizeSubSet;
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }

        @Override
        public boolean contains(Object o) {
            TOP fs = (TOP)o;
            if (!this.isInRange(fs)) {
                return false;
            }
            return this.theSet().contains(o);
        }

        @Override
        public Object[] toArray() {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T> T[] toArray(T[] a1) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean add(TOP e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends TOP> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public TOP lower(TOP fs) {
            if (this.lastElementInRange == null || this.isLeFirst(fs)) {
                return null;
            }
            if (this.isGtLast(fs)) {
                return this.lastElementInRange;
            }
            return this.theSet().lower(fs);
        }

        @Override
        public TOP floor(TOP fs) {
            if (this.lastElementInRange == null || this.isLtFirst(fs)) {
                return null;
            }
            if (this.isGeLast(fs)) {
                return this.lastElementInRange;
            }
            return this.theSet().floor(fs);
        }

        @Override
        public TOP ceiling(TOP fs) {
            if (this.firstElementInRange == null || this.isGtLast(fs)) {
                return null;
            }
            if (this.isLeFirst(fs)) {
                return this.firstElementInRange;
            }
            return this.theSet().ceiling(fs);
        }

        @Override
        public TOP higher(TOP fs) {
            if (this.firstElementInRange == null || this.isGeLast(fs)) {
                return null;
            }
            if (this.isLtFirst(fs)) {
                return this.firstElementInRange;
            }
            return this.theSet().higher(fs);
        }

        @Override
        public TOP pollFirst() {
            throw new UnsupportedOperationException();
        }

        @Override
        public TOP pollLast() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<TOP> iterator() {
            if (this.firstElementInRange == null) {
                return Collections.emptyIterator();
            }
            return new Iterator<TOP>(){
                private int pos;
                {
                    this.pos = firstPosInRange;
                }

                @Override
                public boolean hasNext() {
                    return this.pos <= lastPosInRange;
                }

                @Override
                public TOP next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    TOP r = ((SubSet)this).theSet().a[this.pos++];
                    this.incrToSkipOverNulls();
                    return r;
                }

                private void incrToSkipOverNulls() {
                    while (this.pos <= lastPosInRange && ((SubSet)this).theSet().a[this.pos] == null) {
                        ++this.pos;
                    }
                }
            };
        }

        @Override
        public NavigableSet<TOP> descendingSet() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<TOP> descendingIterator() {
            if (this.firstElementInRange == null) {
                return Collections.emptyIterator();
            }
            return new Iterator<TOP>(){
                private int pos;
                {
                    this.pos = lastPosInRange;
                }

                @Override
                public boolean hasNext() {
                    return this.pos >= firstPosInRange;
                }

                @Override
                public TOP next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    TOP r = ((SubSet)this).theSet().a[this.pos--];
                    this.decrToNext();
                    return r;
                }

                private void decrToNext() {
                    while (this.pos >= firstPosInRange && ((SubSet)this).theSet().a[this.pos] == null) {
                        --this.pos;
                    }
                }
            };
        }

        @Override
        public NavigableSet<TOP> subSet(TOP fromElement1, boolean fromInclusive1, TOP toElement1, boolean toInclusive1) {
            if (!this.isInRange(fromElement1) || !this.isInRange(toElement1)) {
                throw new IllegalArgumentException();
            }
            return this.theSet().subSet(fromElement1, fromInclusive1, toElement1, toInclusive1);
        }

        @Override
        public NavigableSet<TOP> headSet(TOP toElement1, boolean inclusive) {
            return this.subSet(this.fromElement, this.fromInclusive, toElement1, inclusive);
        }

        @Override
        public NavigableSet<TOP> tailSet(TOP fromElement1, boolean inclusive) {
            return this.subSet(fromElement1, inclusive, this.toElement, this.toInclusive);
        }

        @Override
        public SortedSet<TOP> subSet(TOP fromElement1, TOP toElement1) {
            return this.subSet(fromElement1, true, toElement1, false);
        }

        @Override
        public SortedSet<TOP> headSet(TOP toElement1) {
            return this.headSet(toElement1, true);
        }

        @Override
        public SortedSet<TOP> tailSet(TOP fromElement1) {
            return this.tailSet(fromElement1, false);
        }

        private boolean isGtLast(TOP fs) {
            return this.theSet().comparatorWithID.compare(fs, this.lastElementInRange) > 0;
        }

        private boolean isGeLast(TOP fs) {
            return this.theSet().comparatorWithID.compare(fs, this.lastElementInRange) >= 0;
        }

        private boolean isLtFirst(TOP fs) {
            return this.theSet().comparatorWithID.compare(fs, this.firstElementInRange) < 0;
        }

        private boolean isLeFirst(TOP fs) {
            return this.theSet().comparatorWithID.compare(fs, this.firstElementInRange) <= 0;
        }

        private boolean isInRange(TOP fs) {
            return this.isInRangeLower(fs) && this.isInRangeHigher(fs);
        }

        private boolean isInRangeLower(TOP fs) {
            if (this.firstElementInRange == null) {
                return false;
            }
            int r = this.theSet().comparatorWithID.compare(fs, this.firstElementInRange);
            return this.fromInclusive ? r >= 0 : r > 0;
        }

        private boolean isInRangeHigher(TOP fs) {
            if (this.lastElementInRange == null) {
                return false;
            }
            int r = this.theSet().comparatorWithID.compare(fs, this.lastElementInRange);
            return this.toInclusive ? r <= 0 : r < 0;
        }
    }
}

