/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.factory;

import java.io.PrintWriter;
import java.lang.ref.PhantomReference;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Deque;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.measure.Unit;
import org.apache.sis.internal.jdk8.JDK8;
import org.apache.sis.internal.simple.SimpleCitation;
import org.apache.sis.internal.system.DelayedExecutor;
import org.apache.sis.internal.system.DelayedRunnable;
import org.apache.sis.internal.system.ReferenceQueueConsumer;
import org.apache.sis.internal.system.Shutdown;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.referencing.factory.AuthorityFactoryProxy;
import org.apache.sis.referencing.factory.CacheRecord;
import org.apache.sis.referencing.factory.GeodeticAuthorityFactory;
import org.apache.sis.referencing.factory.IdentifiedObjectFinder;
import org.apache.sis.referencing.factory.UnavailableFactoryException;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Classes;
import org.apache.sis.util.Disposable;
import org.apache.sis.util.collection.Cache;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.logging.PerformanceLevel;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Messages;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.extent.Extent;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.DerivedCRS;
import org.opengis.referencing.crs.EngineeringCRS;
import org.opengis.referencing.crs.GeocentricCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ImageCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.CylindricalCS;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.cs.PolarCS;
import org.opengis.referencing.cs.SphericalCS;
import org.opengis.referencing.cs.TimeCS;
import org.opengis.referencing.cs.VerticalCS;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.EngineeringDatum;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.ImageDatum;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.referencing.datum.TemporalDatum;
import org.opengis.referencing.datum.VerticalDatum;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.util.FactoryException;
import org.opengis.util.InternationalString;

public abstract class ConcurrentAuthorityFactory<DAO extends GeodeticAuthorityFactory>
extends GeodeticAuthorityFactory
implements AutoCloseable {
    private static final long DURATION_FOR_LOGGING = 10000000L;
    private static final Citation UNAVAILABLE = new SimpleCitation("unavailable");
    private volatile transient Citation authority;
    private final Map<Class<?>, Boolean> inherited = new IdentityHashMap();
    private final Cache<Key, Object> cache;
    private final Map<IdentifiedObject, FindEntry> findPool = new WeakHashMap<IdentifiedObject, FindEntry>();
    private final ThreadLocal<DataAccessRef<DAO>> currentDAO = new ThreadLocal();
    private final Deque<DataAccessRef<DAO>> availableDAOs = new LinkedList<DataAccessRef<DAO>>();
    private int remainingDAOs;
    private boolean isCleanScheduled;
    private long timeout = 60000000000L;
    static final long TIMEOUT_RESOLUTION = 200000000L;

    protected ConcurrentAuthorityFactory(Class<DAO> clazz) {
        this(clazz, 100, 8);
    }

    protected ConcurrentAuthorityFactory(Class<DAO> clazz, int n, int n2) {
        ArgumentChecks.ensureNonNull("dataAccessClass", clazz);
        ArgumentChecks.ensurePositive("maxStrongReferences", n);
        ArgumentChecks.ensureStrictlyPositive("maxConcurrentQueries", n2);
        for (Method method : clazz.getMethods()) {
            Class<?>[] classArray;
            if (method.getDeclaringClass() != GeodeticAuthorityFactory.class || !method.getName().startsWith("create") || (classArray = method.getParameterTypes()).length != 1 || classArray[0] != String.class) continue;
            this.inherited.put(method.getReturnType(), Boolean.TRUE);
        }
        this.remainingDAOs = n2;
        this.cache = new Cache(20, n, false);
        this.cache.setKeyCollisionAllowed(true);
        Shutdown.register(new ShutdownHook(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final int countAvailableDataAccess() {
        Deque<DataAccessRef<DAO>> deque = this.availableDAOs;
        synchronized (deque) {
            return this.availableDAOs.size();
        }
    }

    protected abstract DAO newDataAccess() throws UnavailableFactoryException, FactoryException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DAO getDataAccess() throws FactoryException {
        DataAccessRef<Object> dataAccessRef = this.currentDAO.get();
        if (dataAccessRef == null) {
            Deque<DataAccessRef<DAO>> deque = this.availableDAOs;
            synchronized (deque) {
                while (this.remainingDAOs == 0) {
                    try {
                        this.availableDAOs.wait(200000000L);
                    }
                    catch (InterruptedException interruptedException) {
                        throw new FactoryException(interruptedException.getLocalizedMessage(), (Throwable)interruptedException);
                    }
                }
                dataAccessRef = this.availableDAOs.pollLast();
                --this.remainingDAOs;
            }
            try {
                if (dataAccessRef == null) {
                    deque = this.newDataAccess();
                    if (deque == null) {
                        UnavailableFactoryException unavailableFactoryException = new UnavailableFactoryException(Errors.format((short)38, GeodeticAuthorityFactory.class));
                        unavailableFactoryException.setUnavailableFactory(this);
                        throw unavailableFactoryException;
                    }
                    dataAccessRef = new DataAccessRef<Deque<DataAccessRef<DAO>>>(deque);
                }
                assert (dataAccessRef.depth == 0) : dataAccessRef;
                dataAccessRef.timestamp = System.nanoTime();
            }
            catch (Throwable throwable) {
                Deque<DataAccessRef<DAO>> deque2 = this.availableDAOs;
                synchronized (deque2) {
                    ++this.remainingDAOs;
                }
                throw throwable;
            }
            this.currentDAO.set(dataAccessRef);
        }
        ++dataAccessRef.depth;
        return dataAccessRef.factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void release(String string, Class<?> clazz, String string2) {
        DataAccessRef<DAO> dataAccessRef = this.currentDAO.get();
        if (--dataAccessRef.depth == 0) {
            this.currentDAO.remove();
            long l = dataAccessRef.timestamp;
            Object object = this.availableDAOs;
            synchronized (object) {
                ++this.remainingDAOs;
                this.recycle(dataAccessRef);
                this.availableDAOs.notify();
                l = dataAccessRef.timestamp - l;
            }
            if (l >= 10000000L && clazz != null) {
                if (string == null) {
                    string = "create".concat(clazz.getSimpleName());
                }
                object = PerformanceLevel.forDuration(l, TimeUnit.NANOSECONDS);
                Double d = (double)l / 1.0E9;
                Messages messages = Messages.getResources(null);
                LogRecord logRecord = string2 != null ? messages.getLogRecord((Level)object, (short)7, clazz, string2, d) : messages.getLogRecord((Level)object, (short)8, clazz, d);
                logRecord.setLoggerName("org.apache.sis.referencing.factory");
                Logging.log(this.getClass(), string, logRecord);
            }
        }
        assert (dataAccessRef.depth >= 0) : dataAccessRef;
    }

    private void recycle(DataAccessRef<DAO> dataAccessRef) {
        dataAccessRef.timestamp = System.nanoTime();
        this.availableDAOs.addLast(dataAccessRef);
        if (!this.isCleanScheduled) {
            this.isCleanScheduled = true;
            DelayedExecutor.schedule(new CloseTask(dataAccessRef.timestamp + this.timeout));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean isCleanScheduled() {
        Deque<DataAccessRef<DAO>> deque = this.availableDAOs;
        synchronized (deque) {
            return this.isCleanScheduled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void confirmClose(List<DAO> list) {
        assert (!Thread.holdsLock(this.availableDAOs));
        Iterator<DAO> iterator = list.iterator();
        while (iterator.hasNext()) {
            GeodeticAuthorityFactory geodeticAuthorityFactory;
            block8: {
                geodeticAuthorityFactory = (GeodeticAuthorityFactory)iterator.next();
                try {
                    if (this.canClose(geodeticAuthorityFactory)) {
                    }
                    break block8;
                }
                catch (Exception exception) {
                    ConcurrentAuthorityFactory.unexpectedException("canClose", exception);
                }
                continue;
            }
            iterator.remove();
            Deque<DataAccessRef<DAO>> deque = this.availableDAOs;
            synchronized (deque) {
                this.recycle(new DataAccessRef<GeodeticAuthorityFactory>(geodeticAuthorityFactory));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void closeExpired() {
        boolean bl;
        Iterator<Object> iterator;
        ArrayList arrayList;
        Object object = this.availableDAOs;
        synchronized (object) {
            arrayList = new ArrayList(this.availableDAOs.size());
            iterator = this.availableDAOs.iterator();
            long l = System.nanoTime();
            while (iterator.hasNext()) {
                DataAccessRef<DAO> dataAccessRef = iterator.next();
                long l2 = dataAccessRef.timestamp + this.timeout;
                if (l2 - l > 200000000L) {
                    DelayedExecutor.schedule(new CloseTask(l2));
                    break;
                }
                arrayList.add(dataAccessRef.factory);
                iterator.remove();
            }
            this.isCleanScheduled = !(bl = this.availableDAOs.isEmpty());
        }
        this.confirmClose(arrayList);
        try {
            ConcurrentAuthorityFactory.close(arrayList);
        }
        catch (Exception exception) {
            ConcurrentAuthorityFactory.unexpectedException("closeExpired", exception);
        }
        if (bl) {
            object = this.findPool;
            synchronized (object) {
                iterator = this.findPool.values().iterator();
                while (iterator.hasNext()) {
                    if (!((FindEntry)iterator.next()).cleanup()) continue;
                    iterator.remove();
                }
            }
        }
    }

    static void unexpectedException(String string, Exception exception) {
        Logging.unexpectedException(Logging.getLogger("org.apache.sis.referencing.factory"), ConcurrentAuthorityFactory.class, string, exception);
    }

    protected boolean canClose(DAO DAO) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTimeout(TimeUnit timeUnit) {
        Deque<DataAccessRef<DAO>> deque = this.availableDAOs;
        synchronized (deque) {
            return timeUnit.convert(this.timeout, TimeUnit.NANOSECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTimeout(long l, TimeUnit timeUnit) {
        ArgumentChecks.ensureStrictlyPositive("delay", l);
        l = timeUnit.toNanos(l);
        Deque<DataAccessRef<DAO>> deque = this.availableDAOs;
        synchronized (deque) {
            this.timeout = l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Citation getAuthority() {
        Citation citation = this.authority;
        if (citation == null || citation == UNAVAILABLE) {
            try {
                DAO DAO = this.getDataAccess();
                try {
                    this.authority = citation = ((GeodeticAuthorityFactory)DAO).getAuthority();
                }
                finally {
                    this.release("getAuthority", Citation.class, null);
                }
            }
            catch (FactoryException factoryException) {
                this.authority = UNAVAILABLE;
                LogRecord logRecord = new LogRecord(citation == null ? Level.WARNING : Level.FINE, factoryException.getLocalizedMessage());
                if (!(factoryException instanceof UnavailableFactoryException)) {
                    logRecord.setThrown(factoryException);
                }
                logRecord.setLoggerName("org.apache.sis.referencing.factory");
                Logging.log(ConcurrentAuthorityFactory.class, "getAuthority", logRecord);
                citation = null;
            }
        }
        return citation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getAuthorityCodes(Class<? extends IdentifiedObject> clazz) throws FactoryException {
        DAO DAO = this.getDataAccess();
        try {
            Set set = DAO.getAuthorityCodes(clazz);
            return set;
        }
        finally {
            this.release("getAuthorityCodes", Set.class, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InternationalString getDescriptionText(String string) throws NoSuchAuthorityCodeException, FactoryException {
        DAO DAO = this.getDataAccess();
        try {
            InternationalString internationalString = ((GeodeticAuthorityFactory)DAO).getDescriptionText(string);
            return internationalString;
        }
        finally {
            this.release("getDescriptionText", InternationalString.class, string);
        }
    }

    private boolean isDefault(Class<?> clazz) {
        return this.inherited.containsKey(clazz);
    }

    protected String normalizeCode(String string) throws FactoryException {
        return this.trimNamespace(string);
    }

    @Override
    public IdentifiedObject createObject(String string) throws FactoryException {
        return this.create(AuthorityFactoryProxy.OBJECT, string);
    }

    @Override
    public CoordinateReferenceSystem createCoordinateReferenceSystem(String string) throws FactoryException {
        if (this.isDefault(CoordinateReferenceSystem.class)) {
            return super.createCoordinateReferenceSystem(string);
        }
        return this.create(AuthorityFactoryProxy.CRS, string);
    }

    @Override
    public GeographicCRS createGeographicCRS(String string) throws FactoryException {
        if (this.isDefault(GeographicCRS.class)) {
            return super.createGeographicCRS(string);
        }
        return this.create(AuthorityFactoryProxy.GEOGRAPHIC_CRS, string);
    }

    @Override
    public GeocentricCRS createGeocentricCRS(String string) throws FactoryException {
        if (this.isDefault(GeocentricCRS.class)) {
            return super.createGeocentricCRS(string);
        }
        return this.create(AuthorityFactoryProxy.GEOCENTRIC_CRS, string);
    }

    @Override
    public ProjectedCRS createProjectedCRS(String string) throws FactoryException {
        if (this.isDefault(ProjectedCRS.class)) {
            return super.createProjectedCRS(string);
        }
        return this.create(AuthorityFactoryProxy.PROJECTED_CRS, string);
    }

    @Override
    public VerticalCRS createVerticalCRS(String string) throws FactoryException {
        if (this.isDefault(VerticalCRS.class)) {
            return super.createVerticalCRS(string);
        }
        return this.create(AuthorityFactoryProxy.VERTICAL_CRS, string);
    }

    @Override
    public TemporalCRS createTemporalCRS(String string) throws FactoryException {
        if (this.isDefault(TemporalCRS.class)) {
            return super.createTemporalCRS(string);
        }
        return this.create(AuthorityFactoryProxy.TEMPORAL_CRS, string);
    }

    @Override
    public CompoundCRS createCompoundCRS(String string) throws FactoryException {
        if (this.isDefault(CompoundCRS.class)) {
            return super.createCompoundCRS(string);
        }
        return this.create(AuthorityFactoryProxy.COMPOUND_CRS, string);
    }

    @Override
    public DerivedCRS createDerivedCRS(String string) throws FactoryException {
        if (this.isDefault(DerivedCRS.class)) {
            return super.createDerivedCRS(string);
        }
        return this.create(AuthorityFactoryProxy.DERIVED_CRS, string);
    }

    @Override
    public EngineeringCRS createEngineeringCRS(String string) throws FactoryException {
        if (this.isDefault(EngineeringCRS.class)) {
            return super.createEngineeringCRS(string);
        }
        return this.create(AuthorityFactoryProxy.ENGINEERING_CRS, string);
    }

    @Override
    public ImageCRS createImageCRS(String string) throws FactoryException {
        if (this.isDefault(ImageCRS.class)) {
            return super.createImageCRS(string);
        }
        return this.create(AuthorityFactoryProxy.IMAGE_CRS, string);
    }

    @Override
    public Datum createDatum(String string) throws FactoryException {
        if (this.isDefault(Datum.class)) {
            return super.createDatum(string);
        }
        return this.create(AuthorityFactoryProxy.DATUM, string);
    }

    @Override
    public GeodeticDatum createGeodeticDatum(String string) throws FactoryException {
        if (this.isDefault(GeodeticDatum.class)) {
            return super.createGeodeticDatum(string);
        }
        return this.create(AuthorityFactoryProxy.GEODETIC_DATUM, string);
    }

    @Override
    public VerticalDatum createVerticalDatum(String string) throws FactoryException {
        if (this.isDefault(VerticalDatum.class)) {
            return super.createVerticalDatum(string);
        }
        return this.create(AuthorityFactoryProxy.VERTICAL_DATUM, string);
    }

    @Override
    public TemporalDatum createTemporalDatum(String string) throws FactoryException {
        if (this.isDefault(TemporalDatum.class)) {
            return super.createTemporalDatum(string);
        }
        return this.create(AuthorityFactoryProxy.TEMPORAL_DATUM, string);
    }

    @Override
    public EngineeringDatum createEngineeringDatum(String string) throws FactoryException {
        if (this.isDefault(EngineeringDatum.class)) {
            return super.createEngineeringDatum(string);
        }
        return this.create(AuthorityFactoryProxy.ENGINEERING_DATUM, string);
    }

    @Override
    public ImageDatum createImageDatum(String string) throws FactoryException {
        if (this.isDefault(ImageDatum.class)) {
            return super.createImageDatum(string);
        }
        return this.create(AuthorityFactoryProxy.IMAGE_DATUM, string);
    }

    @Override
    public Ellipsoid createEllipsoid(String string) throws FactoryException {
        if (this.isDefault(Ellipsoid.class)) {
            return super.createEllipsoid(string);
        }
        return this.create(AuthorityFactoryProxy.ELLIPSOID, string);
    }

    @Override
    public PrimeMeridian createPrimeMeridian(String string) throws FactoryException {
        if (this.isDefault(PrimeMeridian.class)) {
            return super.createPrimeMeridian(string);
        }
        return this.create(AuthorityFactoryProxy.PRIME_MERIDIAN, string);
    }

    @Override
    public Extent createExtent(String string) throws FactoryException {
        if (this.isDefault(Extent.class)) {
            return super.createExtent(string);
        }
        return this.create(AuthorityFactoryProxy.EXTENT, string);
    }

    @Override
    public CoordinateSystem createCoordinateSystem(String string) throws FactoryException {
        if (this.isDefault(CoordinateSystem.class)) {
            return super.createCoordinateSystem(string);
        }
        return this.create(AuthorityFactoryProxy.COORDINATE_SYSTEM, string);
    }

    @Override
    public EllipsoidalCS createEllipsoidalCS(String string) throws FactoryException {
        if (this.isDefault(EllipsoidalCS.class)) {
            return super.createEllipsoidalCS(string);
        }
        return this.create(AuthorityFactoryProxy.ELLIPSOIDAL_CS, string);
    }

    @Override
    public VerticalCS createVerticalCS(String string) throws FactoryException {
        if (this.isDefault(VerticalCS.class)) {
            return super.createVerticalCS(string);
        }
        return this.create(AuthorityFactoryProxy.VERTICAL_CS, string);
    }

    @Override
    public TimeCS createTimeCS(String string) throws FactoryException {
        if (this.isDefault(TimeCS.class)) {
            return super.createTimeCS(string);
        }
        return this.create(AuthorityFactoryProxy.TIME_CS, string);
    }

    @Override
    public CartesianCS createCartesianCS(String string) throws FactoryException {
        if (this.isDefault(CartesianCS.class)) {
            return super.createCartesianCS(string);
        }
        return this.create(AuthorityFactoryProxy.CARTESIAN_CS, string);
    }

    @Override
    public SphericalCS createSphericalCS(String string) throws FactoryException {
        if (this.isDefault(SphericalCS.class)) {
            return super.createSphericalCS(string);
        }
        return this.create(AuthorityFactoryProxy.SPHERICAL_CS, string);
    }

    @Override
    public CylindricalCS createCylindricalCS(String string) throws FactoryException {
        if (this.isDefault(CylindricalCS.class)) {
            return super.createCylindricalCS(string);
        }
        return this.create(AuthorityFactoryProxy.CYLINDRICAL_CS, string);
    }

    @Override
    public PolarCS createPolarCS(String string) throws FactoryException {
        if (this.isDefault(PolarCS.class)) {
            return super.createPolarCS(string);
        }
        return this.create(AuthorityFactoryProxy.POLAR_CS, string);
    }

    @Override
    public CoordinateSystemAxis createCoordinateSystemAxis(String string) throws FactoryException {
        if (this.isDefault(CoordinateSystemAxis.class)) {
            return super.createCoordinateSystemAxis(string);
        }
        return this.create(AuthorityFactoryProxy.AXIS, string);
    }

    @Override
    public Unit<?> createUnit(String string) throws FactoryException {
        if (this.isDefault(Unit.class)) {
            return super.createUnit(string);
        }
        return this.create(AuthorityFactoryProxy.UNIT, string);
    }

    @Override
    public ParameterDescriptor<?> createParameterDescriptor(String string) throws FactoryException {
        if (this.isDefault(ParameterDescriptor.class)) {
            return super.createParameterDescriptor(string);
        }
        return this.create(AuthorityFactoryProxy.PARAMETER, string);
    }

    @Override
    public OperationMethod createOperationMethod(String string) throws FactoryException {
        if (this.isDefault(OperationMethod.class)) {
            return super.createOperationMethod(string);
        }
        return this.create(AuthorityFactoryProxy.METHOD, string);
    }

    @Override
    public CoordinateOperation createCoordinateOperation(String string) throws FactoryException {
        if (this.isDefault(CoordinateOperation.class)) {
            return super.createCoordinateOperation(string);
        }
        return this.create(AuthorityFactoryProxy.OPERATION, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T create(AuthorityFactoryProxy<T> authorityFactoryProxy, String string) throws FactoryException {
        Object object;
        Class clazz;
        block8: {
            ArgumentChecks.ensureNonNull("code", string);
            clazz = authorityFactoryProxy.type;
            Key key = new Key(clazz, this.normalizeCode(string));
            object = this.cache.peek(key);
            if (!clazz.isInstance(object)) {
                Cache.Handler<Object> handler = this.cache.lock(key);
                try {
                    T t;
                    object = handler.peek();
                    if (clazz.isInstance(object)) break block8;
                    DAO DAO = this.getDataAccess();
                    try {
                        t = authorityFactoryProxy.create((GeodeticAuthorityFactory)DAO, key.code);
                    }
                    finally {
                        this.release(null, clazz, string);
                    }
                    if (this.isCacheable(string, t)) {
                        object = t;
                    }
                    T t2 = t;
                    return t2;
                }
                finally {
                    handler.putAndUnlock(object);
                }
            }
        }
        return clazz.cast(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<CoordinateOperation> createFromCoordinateReferenceSystemCodes(String string, String string2) throws FactoryException {
        Set<CoordinateOperation> set;
        block7: {
            ArgumentChecks.ensureNonNull("sourceCRS", string);
            ArgumentChecks.ensureNonNull("targetCRS", string2);
            Key key = new Key(this.normalizeCode(string), this.normalizeCode(string2));
            set = this.cache.peek(key);
            if (!(set instanceof Set)) {
                Cache.Handler<Object> handler = this.cache.lock(key);
                try {
                    set = handler.peek();
                    if (set instanceof Set) break block7;
                    DAO DAO = this.getDataAccess();
                    try {
                        set = ((GeodeticAuthorityFactory)DAO).createFromCoordinateReferenceSystemCodes(string, string2);
                    }
                    finally {
                        this.release("createFromCoordinateReferenceSystemCodes", CoordinateOperation.class, null);
                    }
                }
                finally {
                    handler.putAndUnlock(set);
                }
            }
        }
        return set;
    }

    @Override
    public IdentifiedObjectFinder newIdentifiedObjectFinder() throws FactoryException {
        return new Finder(this);
    }

    protected boolean isCacheable(String string, Object object) {
        return true;
    }

    public void printCacheContent(PrintWriter printWriter) {
        CacheRecord.printCacheContent(this.cache, printWriter);
    }

    static <DAO extends GeodeticAuthorityFactory> List<DAO> clear(Deque<DataAccessRef<DAO>> deque) {
        DataAccessRef<DAO> dataAccessRef;
        assert (Thread.holdsLock(deque));
        ArrayList arrayList = new ArrayList(deque.size());
        while ((dataAccessRef = deque.pollFirst()) != null) {
            arrayList.add(dataAccessRef.factory);
        }
        return arrayList;
    }

    static <DAO extends GeodeticAuthorityFactory> void close(List<DAO> list) throws Exception {
        Exception exception = null;
        int n = list.size();
        while (--n >= 0) {
            GeodeticAuthorityFactory geodeticAuthorityFactory = (GeodeticAuthorityFactory)list.get(n);
            if (!(geodeticAuthorityFactory instanceof AutoCloseable)) continue;
            try {
                ((AutoCloseable)((Object)geodeticAuthorityFactory)).close();
            }
            catch (Exception exception2) {
                if (exception == null) {
                    exception = exception2;
                    continue;
                }
                exception.addSuppressed(exception2);
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws FactoryException {
        try {
            List<DAO> list;
            Deque<DataAccessRef<DAO>> deque = this.availableDAOs;
            synchronized (deque) {
                list = ConcurrentAuthorityFactory.clear(this.availableDAOs);
            }
            this.confirmClose(list);
            ConcurrentAuthorityFactory.close(list);
        }
        catch (Exception exception) {
            if (exception instanceof FactoryException) {
                throw (FactoryException)((Object)exception);
            }
            throw new FactoryException((Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        String string = super.toString();
        DataAccessRef<DAO> dataAccessRef = this.currentDAO.get();
        if (dataAccessRef == null) {
            Deque<DataAccessRef<DAO>> deque = this.availableDAOs;
            synchronized (deque) {
                dataAccessRef = this.availableDAOs.peekLast();
            }
            if (dataAccessRef == null) {
                return string;
            }
        }
        return string + System.lineSeparator() + dataAccessRef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    final void toString(StringBuilder stringBuilder) {
        stringBuilder.append(", cache=").append(this.cache.size()).append(", DAO=");
        Deque<DataAccessRef<DAO>> deque = this.availableDAOs;
        synchronized (deque) {
            stringBuilder.append(this.availableDAOs.size());
            if (this.remainingDAOs <= 0) {
                stringBuilder.append(" (limit reached)");
            }
        }
    }

    private static final class ShutdownHook<DAO extends GeodeticAuthorityFactory>
    extends PhantomReference<ConcurrentAuthorityFactory<DAO>>
    implements Disposable,
    Callable<Object> {
        private final Deque<DataAccessRef<DAO>> availableDAOs;

        ShutdownHook(ConcurrentAuthorityFactory<DAO> concurrentAuthorityFactory) {
            super(concurrentAuthorityFactory, ReferenceQueueConsumer.QUEUE);
            this.availableDAOs = ((ConcurrentAuthorityFactory)concurrentAuthorityFactory).availableDAOs;
        }

        @Override
        public void dispose() {
            Shutdown.unregister(this);
            try {
                this.call();
            }
            catch (Exception exception) {
                ConcurrentAuthorityFactory.unexpectedException("finalize", exception);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object call() throws Exception {
            List<DAO> list;
            Deque<DataAccessRef<DAO>> deque = this.availableDAOs;
            synchronized (deque) {
                list = ConcurrentAuthorityFactory.clear(this.availableDAOs);
            }
            ConcurrentAuthorityFactory.close(list);
            return null;
        }
    }

    private static final class FindEntry {
        private Set<IdentifiedObject> strict;
        private Set<IdentifiedObject> lenient;
        private boolean explicitStrict;
        private boolean explicitLenient;

        private FindEntry() {
        }

        Set<IdentifiedObject> get(boolean bl) {
            return bl ? this.lenient : this.strict;
        }

        Set<IdentifiedObject> set(boolean bl, Set<IdentifiedObject> set, boolean bl2) {
            if (bl) {
                if (this.lenient != null) {
                    set = this.lenient;
                } else {
                    this.lenient = set;
                }
                this.explicitLenient |= bl2;
            } else {
                if (this.strict != null) {
                    set = this.strict;
                } else {
                    this.strict = set;
                }
                this.explicitStrict |= bl2;
            }
            return set;
        }

        boolean cleanup() {
            if (!this.explicitStrict) {
                this.strict = null;
            }
            if (!this.explicitLenient) {
                this.lenient = null;
            }
            return this.strict == null && this.lenient == null;
        }
    }

    private static final class Finder
    extends IdentifiedObjectFinder {
        private transient IdentifiedObjectFinder finder;
        private transient int acquireCount;
        private transient IdentifiedObject searching;

        Finder(ConcurrentAuthorityFactory<?> concurrentAuthorityFactory) {
            super(concurrentAuthorityFactory);
        }

        private void acquire() throws FactoryException {
            assert (Thread.holdsLock(this));
            assert (this.acquireCount == 0 == (this.finder == null)) : this.acquireCount;
            if (this.acquireCount == 0) {
                GeodeticAuthorityFactory geodeticAuthorityFactory = ((ConcurrentAuthorityFactory)this.factory).getDataAccess();
                this.acquireCount = 1;
                this.finder = geodeticAuthorityFactory.newIdentifiedObjectFinder();
                this.finder.setWrapper(this);
            } else {
                ++this.acquireCount;
            }
        }

        private void release() {
            assert (Thread.holdsLock(this));
            if (this.acquireCount == 0) {
                return;
            }
            if (--this.acquireCount == 0) {
                this.finder = null;
                ((ConcurrentAuthorityFactory)this.factory).release(null, null, null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected synchronized Set<String> getCodeCandidates(IdentifiedObject identifiedObject) throws FactoryException {
            try {
                this.acquire();
                Set<String> set = this.finder.getCodeCandidates(identifiedObject);
                return set;
            }
            finally {
                this.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        final Set<IdentifiedObject> getFromCache(IdentifiedObject identifiedObject) {
            Map map;
            Map map2 = map = ((ConcurrentAuthorityFactory)this.factory).findPool;
            synchronized (map2) {
                FindEntry findEntry = (FindEntry)map.get(identifiedObject);
                if (findEntry != null) {
                    return findEntry.get((this.finder != null ? this.finder : this).isIgnoringAxes());
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        final Set<IdentifiedObject> cache(IdentifiedObject identifiedObject, Set<IdentifiedObject> set) {
            Map map = ((ConcurrentAuthorityFactory)this.factory).findPool;
            set = CollectionsExt.unmodifiableOrCopy(set);
            FindEntry findEntry = new FindEntry();
            Map map2 = map;
            synchronized (map2) {
                FindEntry findEntry2 = JDK8.putIfAbsent(map, identifiedObject, findEntry);
                if (findEntry2 != null) {
                    findEntry = findEntry2;
                }
                set = findEntry.set(this.finder.isIgnoringAxes(), set, identifiedObject == this.searching);
            }
            return set;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set<IdentifiedObject> find(IdentifiedObject identifiedObject) throws FactoryException {
            Set<IdentifiedObject> set = this.getFromCache(identifiedObject);
            if (set == null) {
                Finder finder = this;
                synchronized (finder) {
                    try {
                        this.acquire();
                        this.searching = identifiedObject;
                        set = this.finder.find(identifiedObject);
                    }
                    finally {
                        this.searching = null;
                        this.release();
                    }
                }
            }
            return set;
        }
    }

    private static final class Key {
        final Object type;
        final String code;

        Key(Object object, String string) {
            this.type = object;
            this.code = string;
        }

        public int hashCode() {
            return this.type.hashCode() ^ this.code.hashCode();
        }

        public boolean equals(Object object) {
            if (object instanceof Key) {
                Key key = (Key)object;
                return this.type.equals(key.type) && this.code.equals(key.code);
            }
            return false;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.type instanceof Class) {
                stringBuilder.append("Code[\u201c").append(this.code);
                if (stringBuilder.length() > 15) {
                    stringBuilder.setLength(15);
                    stringBuilder.append('\u2026');
                }
                stringBuilder.append("\u201d : ").append(((Class)this.type).getSimpleName());
            } else {
                stringBuilder.append("CodePair[\u201c").append(this.type).append("\u201d \u2192 \u201c").append(this.code).append('\u201d');
            }
            return stringBuilder.append(']').toString();
        }
    }

    private final class CloseTask
    extends DelayedRunnable {
        CloseTask(long l) {
            super(l);
        }

        @Override
        public void run() {
            ConcurrentAuthorityFactory.this.closeExpired();
        }
    }

    private static final class DataAccessRef<DAO extends GeodeticAuthorityFactory> {
        final DAO factory;
        int depth;
        long timestamp;

        DataAccessRef(DAO DAO) {
            this.factory = DAO;
        }

        public String toString() {
            Number number;
            String string;
            if (this.depth != 0) {
                string = "%s in use at depth %d";
                number = this.depth;
            } else {
                string = "%s made available %d seconds ago";
                number = Math.round((double)(System.nanoTime() - this.timestamp) / 1.0E9);
            }
            return String.format(string, Classes.getShortClassName(this.factory), number);
        }
    }
}

