/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing;

import javax.measure.Quantity;
import javax.measure.Unit;
import org.apache.sis.internal.referencing.ReferencingUtilities;
import org.apache.sis.io.wkt.ElementKind;
import org.apache.sis.io.wkt.FormattableObject;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.measure.Units;
import org.apache.sis.parameter.DefaultParameterValue;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.crs.AbstractCRS;
import org.apache.sis.referencing.cs.AbstractCS;
import org.apache.sis.referencing.cs.DefaultCoordinateSystemAxis;
import org.apache.sis.referencing.datum.AbstractDatum;
import org.apache.sis.referencing.datum.DefaultEllipsoid;
import org.apache.sis.referencing.datum.DefaultGeodeticDatum;
import org.apache.sis.referencing.datum.DefaultPrimeMeridian;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Static;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.PrimeMeridian;

public final class WKTUtilities
extends Static {
    private WKTUtilities() {
    }

    public static FormattableObject toFormattable(CoordinateReferenceSystem coordinateReferenceSystem) {
        if (coordinateReferenceSystem instanceof FormattableObject) {
            return (FormattableObject)coordinateReferenceSystem;
        }
        return AbstractCRS.castOrCopy(coordinateReferenceSystem);
    }

    public static FormattableObject toFormattable(CoordinateSystem coordinateSystem) {
        if (coordinateSystem instanceof FormattableObject) {
            return (FormattableObject)coordinateSystem;
        }
        return AbstractCS.castOrCopy(coordinateSystem);
    }

    public static FormattableObject toFormattable(CoordinateSystemAxis coordinateSystemAxis) {
        if (coordinateSystemAxis instanceof FormattableObject) {
            return (FormattableObject)coordinateSystemAxis;
        }
        return DefaultCoordinateSystemAxis.castOrCopy(coordinateSystemAxis);
    }

    public static FormattableObject toFormattable(Datum datum) {
        if (datum instanceof FormattableObject) {
            return (FormattableObject)datum;
        }
        return AbstractDatum.castOrCopy(datum);
    }

    public static FormattableObject toFormattable(GeodeticDatum geodeticDatum) {
        if (geodeticDatum instanceof FormattableObject) {
            return (FormattableObject)geodeticDatum;
        }
        return DefaultGeodeticDatum.castOrCopy(geodeticDatum);
    }

    public static FormattableObject toFormattable(Ellipsoid ellipsoid) {
        if (ellipsoid instanceof FormattableObject) {
            return (FormattableObject)ellipsoid;
        }
        return DefaultEllipsoid.castOrCopy(ellipsoid);
    }

    public static FormattableObject toFormattable(PrimeMeridian primeMeridian) {
        if (primeMeridian instanceof FormattableObject) {
            return (FormattableObject)primeMeridian;
        }
        return DefaultPrimeMeridian.castOrCopy(primeMeridian);
    }

    public static <Q extends Quantity<Q>> Unit<Q> toFormattable(Unit<Q> object) {
        if (Units.isAngular(object) && !object.getConverterTo(Units.RADIAN).isLinear()) {
            object = Units.DEGREE;
        }
        return object;
    }

    public static void appendName(IdentifiedObject identifiedObject, Formatter formatter, ElementKind elementKind) {
        String string = IdentifiedObjects.getName(identifiedObject, formatter.getNameAuthority());
        if (string == null && (string = IdentifiedObjects.getName(identifiedObject, null)) == null) {
            string = Vocabulary.getResources(formatter.getLocale()).getString((short)108);
        }
        formatter.append(string, elementKind != null ? elementKind : ElementKind.NAME);
    }

    public static void appendParamMT(ParameterValueGroup parameterValueGroup, Formatter formatter) {
        if (parameterValueGroup != null) {
            WKTUtilities.appendName((IdentifiedObject)parameterValueGroup.getDescriptor(), formatter, ElementKind.PARAMETER);
            WKTUtilities.append((GeneralParameterValue)parameterValueGroup, formatter);
        }
    }

    public static void append(GeneralParameterValue object, Formatter formatter) {
        if (object instanceof ParameterValueGroup) {
            boolean bl = true;
            for (GeneralParameterValue generalParameterValue : ((ParameterValueGroup)object).values()) {
                if (bl) {
                    formatter.newLine();
                    bl = false;
                }
                WKTUtilities.append(generalParameterValue, formatter);
            }
        }
        if (object instanceof ParameterValue) {
            if (!(object instanceof FormattableObject)) {
                object = new DefaultParameterValue((ParameterValue)object);
            }
            formatter.append((FormattableObject)object);
            formatter.newLine();
        }
    }

    public static boolean isEPSG(GeneralParameterDescriptor generalParameterDescriptor, boolean bl) {
        String string;
        ReferenceIdentifier referenceIdentifier;
        if (generalParameterDescriptor != null && (referenceIdentifier = generalParameterDescriptor.getName()) != null && (string = referenceIdentifier.getCodeSpace()) != null) {
            return "EPSG".equalsIgnoreCase(string);
        }
        return bl;
    }

    public static String toType(Class<?> clazz, Class<?> clazz2) {
        int n;
        StringBuilder stringBuilder;
        if (clazz2 != clazz && (stringBuilder = ReferencingUtilities.toPropertyName(clazz, clazz2)) != null && CharSequences.regionMatches(stringBuilder, n = stringBuilder.length() - 2, "CS")) {
            stringBuilder.setLength(n);
            if ("time".contentEquals(stringBuilder)) {
                return "temporal";
            }
            if (CharSequences.regionMatches(stringBuilder, 0, "cartesian")) {
                stringBuilder.setCharAt(0, 'C');
            }
            return stringBuilder.toString();
        }
        return null;
    }
}

