/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.netcdf.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.feature.AbstractIdentifiedType;
import org.apache.sis.feature.DefaultAttributeType;
import org.apache.sis.feature.DefaultFeatureType;
import org.apache.sis.internal.feature.MovingFeature;
import org.apache.sis.internal.jdk8.Consumer;
import org.apache.sis.internal.jdk8.JDK8;
import org.apache.sis.internal.jdk8.Spliterator;
import org.apache.sis.internal.jdk8.Stream;
import org.apache.sis.internal.jdk8.StreamSupport;
import org.apache.sis.internal.netcdf.DataType;
import org.apache.sis.internal.netcdf.DiscreteSampling;
import org.apache.sis.internal.netcdf.impl.ChannelDecoder;
import org.apache.sis.internal.netcdf.impl.Dimension;
import org.apache.sis.internal.netcdf.impl.VariableInfo;
import org.apache.sis.math.Vector;
import org.apache.sis.setup.GeometryLibrary;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.util.collection.BackingStoreException;
import org.apache.sis.util.logging.WarningListeners;

final class FeaturesInfo
extends DiscreteSampling {
    private final Vector counts;
    private final VariableInfo identifiers;
    private final VariableInfo time;
    private final VariableInfo[] coordinates;
    private final VariableInfo[] properties;
    private final DefaultFeatureType type;

    private FeaturesInfo(Vector vector, VariableInfo variableInfo, VariableInfo variableInfo2, Collection<VariableInfo> collection, Collection<VariableInfo> collection2, GeometryLibrary geometryLibrary, WarningListeners<DataStore> warningListeners) {
        super(geometryLibrary, warningListeners);
        this.counts = vector;
        this.identifiers = variableInfo;
        this.coordinates = collection.toArray(new VariableInfo[collection.size()]);
        this.properties = collection2.toArray(new VariableInfo[collection2.size()]);
        this.time = variableInfo2;
        HashMap<String, String> hashMap = new HashMap<String, String>(4);
        AbstractIdentifiedType[] abstractIdentifiedTypeArray = new AbstractIdentifiedType[this.properties.length + 2];
        DefaultAttributeType[] defaultAttributeTypeArray = null;
        for (int i = 0; i < abstractIdentifiedTypeArray.length; ++i) {
            Class clazz;
            VariableInfo variableInfo3;
            int n = 1;
            int n2 = 1;
            switch (i) {
                case 0: {
                    variableInfo3 = variableInfo;
                    clazz = Integer.class;
                    break;
                }
                case 1: {
                    variableInfo3 = null;
                    clazz = this.factory.polylineClass;
                    defaultAttributeTypeArray = new DefaultAttributeType[]{MovingFeature.TIME};
                    break;
                }
                default: {
                    variableInfo3 = this.properties[i - 2];
                    clazz = variableInfo3.meaning(0) != null ? String.class : Number.class;
                    n = 0;
                    n2 = Integer.MAX_VALUE;
                }
            }
            hashMap.put("name", variableInfo3 != null ? variableInfo3.getName() : "trajectory");
            abstractIdentifiedTypeArray[i] = new DefaultAttributeType<Object>(hashMap, clazz, n, n2, null, defaultAttributeTypeArray);
        }
        hashMap.put("name", "Feature");
        this.type = new DefaultFeatureType(hashMap, false, null, abstractIdentifiedTypeArray);
    }

    private static boolean isSupportedRole(Object object) {
        return object instanceof String && ((String)object).equalsIgnoreCase("trajectory_id");
    }

    static FeaturesInfo[] create(ChannelDecoder channelDecoder) throws IOException, DataStoreException {
        ArrayList<FeaturesInfo> arrayList = new ArrayList<FeaturesInfo>(3);
        block4: for (VariableInfo variableInfo : channelDecoder.variables) {
            Object object;
            if (variableInfo.dimensions.length != 1 || !variableInfo.getDataType().isInteger || !((object = variableInfo.getAttributeValue("sample_dimension")) instanceof String)) continue;
            Dimension dimension = variableInfo.dimensions[0];
            Dimension dimension2 = channelDecoder.findDimension((String)object);
            if (dimension2 == null) {
                channelDecoder.listeners.warning(channelDecoder.resources().getString((short)1, channelDecoder.getFilename(), variableInfo.getName(), object), null);
                continue;
            }
            VariableInfo variableInfo2 = channelDecoder.findVariable(dimension.name);
            if (variableInfo2 == null || !FeaturesInfo.isSupportedRole(variableInfo2.getAttributeValue("cf_role"))) {
                VariableInfo variableInfo3 = null;
                for (VariableInfo variableInfo4 : channelDecoder.variables) {
                    if (variableInfo4.dimensions.length == 0 || variableInfo4.dimensions[0] != dimension || !FeaturesInfo.isSupportedRole(variableInfo4.getAttributeValue("cf_role"))) continue;
                    if (variableInfo3 != null) {
                        variableInfo3 = null;
                        break;
                    }
                    variableInfo3 = variableInfo4;
                }
                if (variableInfo3 != null) {
                    variableInfo2 = variableInfo3;
                }
                if (variableInfo2 == null) {
                    channelDecoder.listeners.warning(channelDecoder.resources().getString((short)3, channelDecoder.getFilename(), dimension.name), null);
                    continue;
                }
            }
            for (int i = 0; i < variableInfo2.dimensions.length; ++i) {
                boolean bl;
                switch (i) {
                    case 0: {
                        bl = variableInfo2.dimensions[0] == dimension;
                        break;
                    }
                    case 1: {
                        bl = variableInfo2.getDataType() == DataType.CHAR;
                        break;
                    }
                    default: {
                        bl = false;
                    }
                }
                if (bl) continue;
                channelDecoder.listeners.warning(channelDecoder.resources().getString((short)2, channelDecoder.getFilename(), variableInfo2.getName(), dimension.getName(), variableInfo2.dimensions[i].name), null);
                continue block4;
            }
            LinkedHashMap<String, VariableInfo> linkedHashMap = new LinkedHashMap<String, VariableInfo>();
            ArrayList arrayList2 = new ArrayList();
            for (VariableInfo variableInfo5 : channelDecoder.variables) {
                if (variableInfo5.dimensions.length != 1 || variableInfo5.dimensions[0] != dimension2) continue;
                Object object2 = variableInfo5.getAttributeValue("axis");
                if (object2 == null) {
                    arrayList2.add(variableInfo5);
                    continue;
                }
                if (linkedHashMap.put(object2.toString(), variableInfo5) != null) continue block4;
            }
            VariableInfo variableInfo6 = (VariableInfo)linkedHashMap.remove("T");
            if (variableInfo6 == null) continue;
            arrayList.add(new FeaturesInfo(variableInfo.read(), variableInfo2, variableInfo6, linkedHashMap.values(), arrayList2, channelDecoder.geomlib, (WarningListeners<DataStore>)channelDecoder.listeners));
        }
        return arrayList.toArray(new FeaturesInfo[arrayList.size()]);
    }

    @Override
    public DefaultFeatureType getType() {
        return this.type;
    }

    public Stream<AbstractFeature> features(boolean bl) {
        return StreamSupport.stream((Spliterator)new Iter(), (boolean)false);
    }

    private final class Iter
    implements Spliterator<AbstractFeature> {
        private int index;
        private int position;

        Iter() {
        }

        public void forEachRemaining(Consumer<? super AbstractFeature> consumer) {
            while (this.tryAdvance(consumer)) {
            }
        }

        public boolean tryAdvance(Consumer<? super AbstractFeature> consumer) {
            int n;
            Object object;
            Vector vector;
            int n2 = FeaturesInfo.this.counts.intValue(this.index);
            int[] nArray = new int[]{this.position};
            int[] nArray2 = new int[]{this.position + n2};
            int[] nArray3 = new int[]{1};
            Vector[] vectorArray = new Vector[FeaturesInfo.this.coordinates.length];
            Object[] objectArray = new Object[FeaturesInfo.this.properties.length];
            try {
                int n3;
                vector = FeaturesInfo.this.identifiers.read();
                Vector vector2 = FeaturesInfo.this.time.read(nArray, nArray2, nArray3);
                for (n3 = 0; n3 < FeaturesInfo.this.coordinates.length; ++n3) {
                    vectorArray[n3] = FeaturesInfo.this.coordinates[n3].read(nArray, nArray2, nArray3);
                }
                for (n3 = 0; n3 < FeaturesInfo.this.properties.length; ++n3) {
                    VariableInfo variableInfo = FeaturesInfo.this.properties[n3];
                    object = variableInfo.read(nArray, nArray2, nArray3);
                    if (variableInfo.isEnumeration()) {
                        String[] stringArray = new String[object.size()];
                        for (int i = 0; i < stringArray.length; ++i) {
                            String string = variableInfo.meaning(object.intValue(i));
                            stringArray[i] = string != null ? string : "";
                        }
                        objectArray[n3] = Arrays.asList(stringArray);
                        continue;
                    }
                    objectArray[n3] = object;
                }
            }
            catch (IOException | DataStoreException exception) {
                throw new BackingStoreException(FeaturesInfo.this.canNotReadFile(), (Throwable)exception);
            }
            AbstractFeature abstractFeature = FeaturesInfo.this.type.newInstance();
            abstractFeature.setPropertyValue(FeaturesInfo.this.identifiers.getName(), vector.intValue(this.index));
            for (n = 0; n < FeaturesInfo.this.properties.length; ++n) {
                abstractFeature.setPropertyValue(FeaturesInfo.this.properties[n].getName(), objectArray[n]);
            }
            n = FeaturesInfo.this.coordinates.length;
            object = new double[n2 * n];
            for (int i = 0; i < ((Vector)object).length; ++i) {
                object[i] = (Vector)vectorArray[i % n].doubleValue(i / n);
            }
            abstractFeature.setPropertyValue("trajectory", FeaturesInfo.this.factory.createPolyline(n, Vector.create((Object)object, (boolean)false)));
            consumer.accept((Object)abstractFeature);
            this.position = JDK8.addExact((int)this.position, (int)n2);
            return ++this.index < FeaturesInfo.this.counts.size();
        }

        public Spliterator<AbstractFeature> trySplit() {
            return null;
        }

        public long estimateSize() {
            return FeaturesInfo.this.counts.size();
        }

        public int characteristics() {
            return 1360;
        }
    }
}

