/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.impl;

import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NoHttpResponseException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.mime.FormBodyPart;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.InputStreamBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.BinaryResponseParser;
import org.apache.solr.client.solrj.impl.HttpClientUtil;
import org.apache.solr.client.solrj.request.RequestWriter;
import org.apache.solr.client.solrj.request.UpdateRequest;
import org.apache.solr.client.solrj.response.UpdateResponse;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.util.ContentStream;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SolrjNamedThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpSolrServer
extends SolrServer {
    private static final String UTF_8 = StandardCharsets.UTF_8.name();
    private static final String DEFAULT_PATH = "/select";
    private static final long serialVersionUID = -946812319974801896L;
    public static final String AGENT = "Solr[" + HttpSolrServer.class.getName() + "] 1.0";
    private static Logger log = LoggerFactory.getLogger(HttpSolrServer.class);
    protected volatile String baseUrl;
    protected ModifiableSolrParams invariantParams;
    protected volatile ResponseParser parser;
    protected volatile RequestWriter requestWriter = new RequestWriter();
    private final HttpClient httpClient;
    private volatile boolean followRedirects = false;
    private volatile int maxRetries = 0;
    private volatile boolean useMultiPartPost;
    private final boolean internalClient;
    private volatile Set<String> queryParams = Collections.emptySet();

    public HttpSolrServer(String baseURL) {
        this(baseURL, null, new BinaryResponseParser());
    }

    public HttpSolrServer(String baseURL, HttpClient client) {
        this(baseURL, client, new BinaryResponseParser());
    }

    public HttpSolrServer(String baseURL, HttpClient client, ResponseParser parser) {
        this.baseUrl = baseURL;
        if (this.baseUrl.endsWith("/")) {
            this.baseUrl = this.baseUrl.substring(0, this.baseUrl.length() - 1);
        }
        if (this.baseUrl.indexOf(63) >= 0) {
            throw new RuntimeException("Invalid base url for solrj.  The base URL must not contain parameters: " + this.baseUrl);
        }
        if (client != null) {
            this.httpClient = client;
            this.internalClient = false;
        } else {
            this.internalClient = true;
            ModifiableSolrParams params = new ModifiableSolrParams();
            params.set("maxConnections", 128);
            params.set("maxConnectionsPerHost", 32);
            params.set("followRedirects", this.followRedirects);
            this.httpClient = HttpClientUtil.createClient(params);
        }
        this.parser = parser;
    }

    public Set<String> getQueryParams() {
        return this.queryParams;
    }

    public void setQueryParams(Set<String> queryParams) {
        this.queryParams = queryParams;
    }

    @Override
    public NamedList<Object> request(SolrRequest request) throws SolrServerException, IOException {
        ResponseParser responseParser = request.getResponseParser();
        if (responseParser == null) {
            responseParser = this.parser;
        }
        return this.request(request, responseParser);
    }

    public NamedList<Object> request(SolrRequest request, ResponseParser processor) throws SolrServerException, IOException {
        return this.executeMethod(this.createMethod(request), processor);
    }

    public HttpUriRequestResponse httpUriRequest(SolrRequest request) throws SolrServerException, IOException {
        ResponseParser responseParser = request.getResponseParser();
        if (responseParser == null) {
            responseParser = this.parser;
        }
        return this.httpUriRequest(request, responseParser);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpUriRequestResponse httpUriRequest(SolrRequest request, final ResponseParser processor) throws SolrServerException, IOException {
        HttpUriRequestResponse mrr = new HttpUriRequestResponse();
        final HttpRequestBase method = this.createMethod(request);
        ExecutorService pool = Executors.newFixedThreadPool(1, new SolrjNamedThreadFactory("httpUriRequest"));
        try {
            mrr.future = pool.submit(new Callable<NamedList<Object>>(){

                @Override
                public NamedList<Object> call() throws Exception {
                    return HttpSolrServer.this.executeMethod(method, processor);
                }
            });
        }
        finally {
            pool.shutdown();
        }
        assert (method != null);
        mrr.httpUriRequest = method;
        return mrr;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected HttpRequestBase createMethod(SolrRequest request) throws IOException, SolrServerException {
        method = null;
        is = null;
        params = request.getParams();
        streams = this.requestWriter.getContentStreams(request);
        path = this.requestWriter.getPath(request);
        if (path == null || !path.startsWith("/")) {
            path = "/select";
        }
        if ((parser = request.getResponseParser()) == null) {
            parser = this.parser;
        }
        wparams = new ModifiableSolrParams(params);
        if (parser != null) {
            wparams.set("wt", new String[]{parser.getWriterType()});
            wparams.set("version", new String[]{parser.getVersion()});
        }
        if (this.invariantParams != null) {
            wparams.add(this.invariantParams);
        }
        tries = this.maxRetries + 1;
        try {
            block4: while (tries-- > 0) {
                try {
                    if (SolrRequest.METHOD.GET == request.getMethod()) {
                        if (streams != null) {
                            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "GET can't send streams!");
                        }
                        method = new HttpGet(this.baseUrl + path + ClientUtils.toQueryString(wparams, false));
                        continue;
                    }
                    if (SolrRequest.METHOD.POST != request.getMethod()) throw new SolrServerException("Unsupported method: " + (Object)request.getMethod());
                    url = this.baseUrl + path;
                    hasNullStreamName = false;
                    if (streams != null) {
                        for (ContentStream cs : streams) {
                            if (cs.getName() != null) continue;
                            hasNullStreamName = true;
                            break;
                        }
                    }
                    isMultipart = (this.useMultiPartPost != false || streams != null && streams.size() > 1) && hasNullStreamName == false;
                    queryParams = new ModifiableSolrParams();
                    for (String param : this.queryParams) {
                        value = wparams.getParams(param);
                        if (value == null) continue;
                        for (String var20_32 : value) {
                            queryParams.add(param, new String[]{var20_32});
                        }
                        wparams.remove(param);
                    }
                    postParams = new LinkedList<BasicNameValuePair>();
                    if (streams == null || isMultipart) {
                        post = new HttpPost(url + ClientUtils.toQueryString(queryParams, false));
                        post.setHeader("Content-Charset", "UTF-8");
                        if (!isMultipart) {
                            post.addHeader("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
                        }
                    } else {
                        pstr = ClientUtils.toQueryString(wparams, false);
                        post = new HttpPost(url + pstr);
                        contentStream = new ContentStream[1];
                        var18_25 = streams.iterator();
                        if (var18_25.hasNext()) {
                            contentStream[0] = content = var18_25.next();
                        }
                        if (contentStream[0] instanceof RequestWriter.LazyContentStream) {
                            post.setEntity((HttpEntity)new InputStreamEntity(contentStream[0].getStream(), -1L){

                                public Header getContentType() {
                                    return new BasicHeader("Content-Type", contentStream[0].getContentType());
                                }

                                public boolean isRepeatable() {
                                    return false;
                                }
                            });
                        } else {
                            post.setEntity((HttpEntity)new InputStreamEntity(contentStream[0].getStream(), -1L){

                                public Header getContentType() {
                                    return new BasicHeader("Content-Type", contentStream[0].getContentType());
                                }

                                public boolean isRepeatable() {
                                    return false;
                                }
                            });
                        }
                        method = post;
                        continue;
                    }
                    parts = new LinkedList<FormBodyPart>();
                    iter = wparams.getParameterNamesIterator();
                    while (true) {
                        if (iter.hasNext()) {
                            p = iter.next();
                            vals = wparams.getParams(p);
                            if (vals == null) continue;
                        } else {
                            if (isMultipart && streams != null) {
                                for (ContentStream content : streams) {
                                    var20_34 = content.getContentType();
                                    if (var20_34 == null) {
                                        var20_35 = "application/octet-stream";
                                    }
                                    if ((name = content.getName()) == null) {
                                        name = "";
                                    }
                                    parts.add(new FormBodyPart(name, (ContentBody)new InputStreamBody(content.getStream(), (String)var20_36, content.getName())));
                                }
                            }
                            if (parts.size() > 0) {
                                entity = new MultipartEntity(HttpMultipartMode.STRICT);
                                for (FormBodyPart var20_37 : parts) {
                                    entity.addPart(var20_37);
                                }
                                post.setEntity((HttpEntity)entity);
                            } else {
                                post.setEntity((HttpEntity)new UrlEncodedFormEntity(postParams, StandardCharsets.UTF_8));
                            }
                            method = post;
                            continue block4;
                        }
                        var20_33 = vals;
                        var21_38 = var20_33.length;
                        var22_40 = 0;
                        while (true) {
                            if (var22_40 >= var21_38) ** break;
                            v = var20_33[var22_40];
                            if (isMultipart) {
                                parts.add(new FormBodyPart(p, (ContentBody)new StringBody(v, StandardCharsets.UTF_8)));
                            } else {
                                postParams.add(new BasicNameValuePair(p, v));
                            }
                            ++var22_40;
                        }
                        break;
                    }
                }
                catch (NoHttpResponseException r) {
                    method = null;
                    if (is != null) {
                        is.close();
                    }
                    if (tries < 1) throw r;
                }
            }
            return method;
        }
        catch (IOException ex) {
            throw new SolrServerException("error reading streams", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected NamedList<Object> executeMethod(HttpRequestBase method, ResponseParser processor) throws SolrServerException {
        method.getParams().setParameter("http.protocol.handle-redirects", (Object)this.followRedirects);
        method.addHeader("User-Agent", AGENT);
        InputStream respBody = null;
        boolean shouldClose = true;
        boolean success = false;
        try {
            String mimeType;
            String procMimeType;
            HttpResponse response = this.httpClient.execute((HttpUriRequest)method);
            int httpStatus = response.getStatusLine().getStatusCode();
            respBody = response.getEntity().getContent();
            Header ctHeader = response.getLastHeader("content-type");
            String contentType = ctHeader != null ? ctHeader.getValue() : "";
            switch (httpStatus) {
                case 200: 
                case 400: 
                case 409: {
                    break;
                }
                case 301: 
                case 302: {
                    if (this.followRedirects) break;
                    throw new SolrServerException("Server at " + this.getBaseURL() + " sent back a redirect (" + httpStatus + ").");
                }
                default: {
                    if (processor != null) break;
                    throw new RemoteSolrException(httpStatus, "Server at " + this.getBaseURL() + " returned non ok status:" + httpStatus + ", message:" + response.getStatusLine().getReasonPhrase(), null);
                }
            }
            if (processor == null) {
                NamedList<Object> rsp = new NamedList<Object>();
                rsp.add("stream", respBody);
                shouldClose = false;
                success = true;
                NamedList<Object> namedList = rsp;
                return namedList;
            }
            String procCt = processor.getContentType();
            if (procCt != null && !(procMimeType = ContentType.parse((String)procCt).getMimeType().trim().toLowerCase(Locale.ROOT)).equals(mimeType = ContentType.parse((String)contentType).getMimeType().trim().toLowerCase(Locale.ROOT))) {
                String msg = "Expected mime type " + procMimeType + " but got " + mimeType + ".";
                Header encodingHeader = response.getEntity().getContentEncoding();
                String encoding = encodingHeader != null ? encodingHeader.getValue() : "UTF-8";
                try {
                    msg = msg + " " + IOUtils.toString((InputStream)respBody, (String)encoding);
                }
                catch (IOException e) {
                    throw new RemoteSolrException(httpStatus, "Could not parse response with encoding " + encoding, (Throwable)e);
                }
                RemoteSolrException e = new RemoteSolrException(httpStatus, msg, null);
                throw e;
            }
            NamedList<Object> rsp = null;
            String charset = EntityUtils.getContentCharSet((HttpEntity)response.getEntity());
            try {
                rsp = processor.processResponse(respBody, charset);
            }
            catch (Exception e) {
                throw new RemoteSolrException(httpStatus, e.getMessage(), (Throwable)e);
            }
            if (httpStatus != 200) {
                String reason = null;
                try {
                    NamedList err = (NamedList)rsp.get("error");
                    if (err != null && (reason = (String)err.get("msg")) == null) {
                        reason = (String)err.get("trace");
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
                if (reason != null) throw new RemoteSolrException(httpStatus, reason, null);
                StringBuilder msg = new StringBuilder();
                msg.append(response.getStatusLine().getReasonPhrase());
                msg.append("\n\n");
                msg.append("request: " + method.getURI());
                reason = URLDecoder.decode(msg.toString(), UTF_8);
                throw new RemoteSolrException(httpStatus, reason, null);
            }
            success = true;
            NamedList<Object> namedList = rsp;
            return namedList;
        }
        catch (ConnectException e) {
            throw new SolrServerException("Server refused connection at: " + this.getBaseURL(), e);
        }
        catch (SocketTimeoutException e) {
            throw new SolrServerException("Timeout occured while waiting response from server at: " + this.getBaseURL(), e);
        }
        catch (IOException e) {
            throw new SolrServerException("IOException occured when talking to server at: " + this.getBaseURL(), e);
        }
        finally {
            if (respBody != null && shouldClose) {
                try {
                    respBody.close();
                }
                catch (IOException e) {
                    log.error("", (Throwable)e);
                }
                finally {
                    if (!success) {
                        method.abort();
                    }
                }
            }
        }
    }

    public ModifiableSolrParams getInvariantParams() {
        return this.invariantParams;
    }

    public String getBaseURL() {
        return this.baseUrl;
    }

    public void setBaseURL(String baseURL) {
        this.baseUrl = baseURL;
    }

    public ResponseParser getParser() {
        return this.parser;
    }

    public void setParser(ResponseParser processor) {
        this.parser = processor;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public void setConnectionTimeout(int timeout) {
        HttpClientUtil.setConnectionTimeout(this.httpClient, timeout);
    }

    public void setSoTimeout(int timeout) {
        HttpClientUtil.setSoTimeout(this.httpClient, timeout);
    }

    public void setFollowRedirects(boolean followRedirects) {
        this.followRedirects = followRedirects;
        HttpClientUtil.setFollowRedirects(this.httpClient, followRedirects);
    }

    public void setAllowCompression(boolean allowCompression) {
        if (!(this.httpClient instanceof DefaultHttpClient)) {
            throw new UnsupportedOperationException("HttpClient instance was not of type DefaultHttpClient");
        }
        HttpClientUtil.setAllowCompression((DefaultHttpClient)this.httpClient, allowCompression);
    }

    public void setMaxRetries(int maxRetries) {
        if (maxRetries > 1) {
            log.warn("HttpSolrServer: maximum Retries " + maxRetries + " > 1. Maximum recommended retries is 1.");
        }
        this.maxRetries = maxRetries;
    }

    public void setRequestWriter(RequestWriter requestWriter) {
        this.requestWriter = requestWriter;
    }

    public UpdateResponse add(Iterator<SolrInputDocument> docIterator) throws SolrServerException, IOException {
        UpdateRequest req = new UpdateRequest();
        req.setDocIterator(docIterator);
        return req.process(this);
    }

    public UpdateResponse addBeans(final Iterator<?> beanIterator) throws SolrServerException, IOException {
        UpdateRequest req = new UpdateRequest();
        req.setDocIterator(new Iterator<SolrInputDocument>(){

            @Override
            public boolean hasNext() {
                return beanIterator.hasNext();
            }

            @Override
            public SolrInputDocument next() {
                Object o = beanIterator.next();
                if (o == null) {
                    return null;
                }
                return HttpSolrServer.this.getBinder().toSolrInputDocument(o);
            }

            @Override
            public void remove() {
                beanIterator.remove();
            }
        });
        return req.process(this);
    }

    @Override
    public void shutdown() {
        if (this.httpClient != null && this.internalClient) {
            this.httpClient.getConnectionManager().shutdown();
        }
    }

    public void setDefaultMaxConnectionsPerHost(int max) {
        if (!this.internalClient) {
            throw new UnsupportedOperationException("Client was created outside of HttpSolrServer");
        }
        HttpClientUtil.setMaxConnectionsPerHost(this.httpClient, max);
    }

    public void setMaxTotalConnections(int max) {
        if (!this.internalClient) {
            throw new UnsupportedOperationException("Client was created outside of HttpSolrServer");
        }
        HttpClientUtil.setMaxConnections(this.httpClient, max);
    }

    public boolean isUseMultiPartPost() {
        return this.useMultiPartPost;
    }

    public void setUseMultiPartPost(boolean useMultiPartPost) {
        this.useMultiPartPost = useMultiPartPost;
    }

    public static class RemoteSolrException
    extends SolrException {
        public RemoteSolrException(int code, String msg, Throwable th) {
            super(code, msg, th);
        }
    }

    public static class HttpUriRequestResponse {
        public HttpUriRequest httpUriRequest;
        public Future<NamedList<Object>> future;
    }
}

