/*
 * Decompiled with CFR 0.152.
 */
package com.commvault.perfutil;

import java.util.logging.Level;

public enum LoggerLevel {
    DISABLED(0, Level.OFF),
    ERROR(1, Level.SEVERE),
    WARNING(2, Level.WARNING),
    INFO(3, Level.INFO),
    DETAILS(4, Level.CONFIG),
    DEBUG(5, Level.FINE),
    XML(6, Level.FINER),
    TRACE(7, Level.FINEST);

    private int flag;
    private Level level;

    private LoggerLevel(int flag, Level level) {
        this.flag = flag;
        this.level = level;
    }

    public int toInt() {
        return this.flag;
    }

    public Level getLevel() {
        return this.level;
    }

    public static LoggerLevel fromInt(int status) {
        if (status < 0) {
            return DISABLED;
        }
        if (status > 7) {
            return TRACE;
        }
        for (LoggerLevel s : LoggerLevel.values()) {
            if (s.toInt() != status) continue;
            return s;
        }
        return INFO;
    }

    public static LoggerLevel fromLevel(Level level) {
        for (LoggerLevel s : LoggerLevel.values()) {
            if (!s.getLevel().equals(level)) continue;
            return s;
        }
        return null;
    }
}

