/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.identification;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.sis.internal.jaxb.Context;
import org.apache.sis.internal.jaxb.gco.GO_Distance;
import org.apache.sis.internal.metadata.MetadataUtilities;
import org.apache.sis.measure.ValueRange;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.apache.sis.util.resources.Messages;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.metadata.identification.RepresentativeFraction;
import org.opengis.metadata.identification.Resolution;
import org.opengis.util.InternationalString;

@XmlType(name="MD_Resolution_Type")
@XmlRootElement(name="MD_Resolution")
public class DefaultResolution
extends ISOMetadata
implements Resolution {
    private static final long serialVersionUID = 4333582736458380544L;
    private static final byte SCALE = 1;
    private static final byte DISTANCE = 2;
    private static final byte VERTICAL = 3;
    private static final byte ANGULAR = 4;
    private static final byte TEXT = 5;
    private static final String[] NAMES = new String[]{"equivalentScale", "distance", "vertical", "angularDistance", "levelOfDetail"};
    private static final String[] SETTERS = new String[]{"setEquivalentScale", "setDistance", "setVertical", "setAngularDistance", "setLevelOfDetail"};
    private byte property;
    private Object value;

    public DefaultResolution() {
    }

    public DefaultResolution(RepresentativeFraction representativeFraction) {
        if (representativeFraction != null) {
            this.value = representativeFraction;
            this.property = 1;
        }
    }

    public DefaultResolution(Resolution resolution) {
        super(resolution);
        if (resolution != null) {
            for (int n = 1; n <= 5; n = (int)((byte)(n + 1))) {
                Object object = null;
                switch (n) {
                    case 1: {
                        object = resolution.getEquivalentScale();
                        break;
                    }
                    case 2: {
                        object = resolution.getDistance();
                        break;
                    }
                    case 3: {
                        if (!(object instanceof DefaultResolution)) break;
                        object = ((DefaultResolution)resolution).getVertical();
                        break;
                    }
                    case 4: {
                        if (!(object instanceof DefaultResolution)) break;
                        object = ((DefaultResolution)resolution).getAngularDistance();
                        break;
                    }
                    case 5: {
                        if (!(object instanceof DefaultResolution)) break;
                        object = ((DefaultResolution)resolution).getLevelOfDetail();
                        break;
                    }
                    default: {
                        throw new AssertionError(n);
                    }
                }
                if (object == null) continue;
                this.property = (byte)n;
                this.value = object;
                break;
            }
        }
    }

    public static DefaultResolution castOrCopy(Resolution resolution) {
        if (resolution == null || resolution instanceof DefaultResolution) {
            return (DefaultResolution)resolution;
        }
        return new DefaultResolution(resolution);
    }

    private void setProperty(byte by, Object object) {
        this.checkWritePermission();
        if (this.value != null && this.property != by) {
            if (object == null) {
                return;
            }
            Context.warningOccured(Context.current(), DefaultResolution.class, SETTERS[by - 1], Messages.class, (short)19, NAMES[this.property - 1], NAMES[by - 1]);
        }
        this.value = object;
        this.property = by;
    }

    @XmlElement(name="equivalentScale")
    public RepresentativeFraction getEquivalentScale() {
        return this.property == 1 ? (RepresentativeFraction)this.value : null;
    }

    public void setEquivalentScale(RepresentativeFraction representativeFraction) {
        this.setProperty((byte)1, representativeFraction);
    }

    @XmlElement(name="distance")
    @XmlJavaTypeAdapter(value=GO_Distance.class)
    @ValueRange(minimum=0.0, isMinIncluded=false)
    public Double getDistance() {
        return this.property == 2 ? (Double)this.value : null;
    }

    public void setDistance(Double d) {
        if (MetadataUtilities.ensurePositive(DefaultResolution.class, "distance", true, d)) {
            this.setProperty((byte)2, d);
        }
    }

    @UML(identifier="vertical", obligation=Obligation.CONDITIONAL, specification=Specification.ISO_19115)
    @ValueRange(minimum=0.0, isMinIncluded=false)
    public Double getVertical() {
        return this.property == 3 ? (Double)this.value : null;
    }

    public void setVertical(Double d) {
        if (MetadataUtilities.ensurePositive(DefaultResolution.class, "vertical", true, d)) {
            this.setProperty((byte)3, d);
        }
    }

    @UML(identifier="angularDistance", obligation=Obligation.CONDITIONAL, specification=Specification.ISO_19115)
    @ValueRange(minimum=0.0, isMinIncluded=false)
    public Double getAngularDistance() {
        return this.property == 4 ? (Double)this.value : null;
    }

    public void setAngularDistance(Double d) {
        if (MetadataUtilities.ensurePositive(DefaultResolution.class, "angular", true, d)) {
            this.setProperty((byte)4, d);
        }
    }

    @UML(identifier="levelOfDetail", obligation=Obligation.CONDITIONAL, specification=Specification.ISO_19115)
    public InternationalString getLevelOfDetail() {
        return this.property == 5 ? (InternationalString)this.value : null;
    }

    public void setLevelOfDetail(InternationalString internationalString) {
        this.setProperty((byte)5, internationalString);
    }
}

