/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.extent;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.sis.internal.jaxb.gco.GO_Real;
import org.apache.sis.internal.metadata.ReferencingServices;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.xml.NilReason;
import org.opengis.geometry.Envelope;
import org.opengis.metadata.extent.VerticalExtent;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.operation.MathTransform1D;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

@XmlType(name="EX_VerticalExtent_Type", propOrder={"minimumValue", "maximumValue", "verticalCRS"})
@XmlRootElement(name="EX_VerticalExtent")
public class DefaultVerticalExtent
extends ISOMetadata
implements VerticalExtent {
    private static final long serialVersionUID = -1963873471175296153L;
    private Double minimumValue;
    private Double maximumValue;
    private VerticalCRS verticalCRS;

    public DefaultVerticalExtent() {
    }

    public DefaultVerticalExtent(double d, double d2, VerticalCRS verticalCRS) {
        if (!Double.isNaN(d)) {
            this.minimumValue = d;
        }
        if (!Double.isNaN(d2)) {
            this.maximumValue = d2;
        }
        this.verticalCRS = verticalCRS;
    }

    public DefaultVerticalExtent(VerticalExtent verticalExtent) {
        super(verticalExtent);
        if (verticalExtent != null) {
            this.minimumValue = verticalExtent.getMinimumValue();
            this.maximumValue = verticalExtent.getMaximumValue();
            this.verticalCRS = verticalExtent.getVerticalCRS();
        }
    }

    public static DefaultVerticalExtent castOrCopy(VerticalExtent verticalExtent) {
        if (verticalExtent == null || verticalExtent instanceof DefaultVerticalExtent) {
            return (DefaultVerticalExtent)verticalExtent;
        }
        return new DefaultVerticalExtent(verticalExtent);
    }

    @XmlElement(name="minimumValue", required=true)
    @XmlJavaTypeAdapter(value=GO_Real.class)
    public Double getMinimumValue() {
        return this.minimumValue;
    }

    public void setMinimumValue(Double d) {
        this.checkWritePermission();
        this.minimumValue = d;
    }

    @XmlElement(name="maximumValue", required=true)
    @XmlJavaTypeAdapter(value=GO_Real.class)
    public Double getMaximumValue() {
        return this.maximumValue;
    }

    public void setMaximumValue(Double d) {
        this.checkWritePermission();
        this.maximumValue = d;
    }

    @XmlElement(name="verticalCRS", required=true)
    public VerticalCRS getVerticalCRS() {
        return this.verticalCRS;
    }

    public void setVerticalCRS(VerticalCRS verticalCRS) {
        this.checkWritePermission();
        this.verticalCRS = verticalCRS;
    }

    public void setBounds(Envelope envelope) throws TransformException {
        this.checkWritePermission();
        ReferencingServices.getInstance().setBounds(envelope, this);
    }

    public void intersect(VerticalExtent verticalExtent) throws IllegalArgumentException {
        block10: {
            this.checkWritePermission();
            ArgumentChecks.ensureNonNull("other", verticalExtent);
            Double d = verticalExtent.getMinimumValue();
            Double d2 = verticalExtent.getMaximumValue();
            try {
                MathTransform1D mathTransform1D;
                block11: {
                    block12: {
                        Double d3;
                        mathTransform1D = this.getConversionFrom(verticalExtent.getVerticalCRS());
                        if (DefaultVerticalExtent.isReversing(mathTransform1D, d, d2)) {
                            Double d4 = d;
                            d = d2;
                            d2 = d4;
                        }
                        if (d == null) break block11;
                        if (this.minimumValue == null || d.isNaN()) break block12;
                        d = DefaultVerticalExtent.convert(mathTransform1D, d);
                        if (!(d3 > this.minimumValue)) break block11;
                    }
                    this.minimumValue = d;
                }
                if (d2 == null) break block10;
                if (this.maximumValue != null && !d2.isNaN()) {
                    Double d5;
                    d2 = DefaultVerticalExtent.convert(mathTransform1D, d2);
                    if (!(d5 < this.maximumValue)) break block10;
                }
                this.maximumValue = d2;
            }
            catch (ClassCastException | UnsupportedOperationException | TransformException | FactoryException throwable) {
                throw new IllegalArgumentException(Errors.format((short)63, "verticalCRS"), throwable);
            }
        }
        if (this.minimumValue != null && this.maximumValue != null && this.minimumValue > this.maximumValue) {
            this.minimumValue = this.maximumValue = NilReason.MISSING.createNilObject(Double.class);
        }
    }

    private MathTransform1D getConversionFrom(VerticalCRS verticalCRS) throws FactoryException {
        MathTransform1D mathTransform1D;
        if (!Utilities.equalsIgnoreMetadata(this.verticalCRS, verticalCRS) && this.verticalCRS != null && verticalCRS != null && !(mathTransform1D = (MathTransform1D)ReferencingServices.getInstance().getCoordinateOperationFactory(null, null, null, null).createOperation((CoordinateReferenceSystem)verticalCRS, (CoordinateReferenceSystem)this.verticalCRS).getMathTransform()).isIdentity()) {
            return mathTransform1D;
        }
        return null;
    }

    private static boolean isReversing(MathTransform1D mathTransform1D, Double d, Double d2) throws TransformException {
        if (mathTransform1D == null) {
            return false;
        }
        if (d == null || d.isNaN()) {
            d = d2;
        } else if (d2 != null && !d2.isNaN()) {
            d = (d + d2) / 2.0;
        }
        return MathFunctions.isNegative(mathTransform1D.derivative(d != null ? d : Double.NaN));
    }

    private static Double convert(MathTransform1D mathTransform1D, Double d) throws TransformException {
        return mathTransform1D != null ? mathTransform1D.transform(d.doubleValue()) : d.doubleValue();
    }
}

