/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.resource.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.uima.resource.RelativePathResolver;
import org.apache.uima.util.impl.Constants;

public class RelativePathResolver_impl
implements RelativePathResolver {
    private String mDataPath;
    private URL[] mBaseUrls;
    private ClassLoader mClassLoader;

    public RelativePathResolver_impl() {
        this(null);
        this.mClassLoader = this.getClass().getClassLoader();
    }

    public RelativePathResolver_impl(ClassLoader aClassLoader) {
        String dataPath = null;
        try {
            dataPath = System.getProperty("uima.datapath");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (dataPath == null) {
            try {
                dataPath = System.getProperty("user.dir");
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        if (dataPath == null) {
            dataPath = "";
        }
        try {
            this.setDataPath(dataPath);
        }
        catch (MalformedURLException e) {
            this.mDataPath = "";
            this.mBaseUrls = Constants.EMPTY_URL_ARRAY;
        }
        this.mClassLoader = aClassLoader;
    }

    @Override
    public String getDataPath() {
        return this.mDataPath;
    }

    @Override
    public void setDataPath(String aPath) throws MalformedURLException {
        ArrayList<URL> urls = new ArrayList<URL>();
        String pathSepChar = System.getProperty("path.separator");
        StringTokenizer tokenizer = new StringTokenizer(aPath, pathSepChar);
        while (tokenizer.hasMoreTokens()) {
            String tok = tokenizer.nextToken();
            URL url = new File(tok).toURL();
            urls.add(url);
        }
        this.mBaseUrls = new URL[urls.size()];
        urls.toArray(this.mBaseUrls);
        this.mDataPath = aPath;
    }

    @Override
    public URL resolveRelativePath(URL aRelativeUrl) {
        ClassLoader tccl;
        URL[] baseUrls = this.getBaseUrls();
        for (int i = 0; i < baseUrls.length; ++i) {
            try {
                URL absUrl = new URL(baseUrls[i], aRelativeUrl.toString());
                if (!this.fileExistsAtUrl(absUrl)) continue;
                return absUrl;
            }
            catch (MalformedURLException absUrl) {
                // empty catch block
            }
        }
        if (aRelativeUrl.getPath().startsWith("/") && this.fileExistsAtUrl(aRelativeUrl)) {
            return aRelativeUrl;
        }
        String f = aRelativeUrl.getFile();
        URL absURL = this.mClassLoader != null ? this.mClassLoader.getResource(f) : ((tccl = Thread.currentThread().getContextClassLoader()) != null ? tccl.getResource(f) : ClassLoader.getSystemClassLoader().getResource(f));
        return absURL;
    }

    @Override
    public void setPathResolverClassLoader(ClassLoader aClassLoader) {
        this.mClassLoader = aClassLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean fileExistsAtUrl(URL aUrl) {
        InputStream testStream = null;
        try {
            testStream = aUrl.openStream();
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (testStream != null) {
                try {
                    testStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected URL[] getBaseUrls() {
        return this.mBaseUrls;
    }
}

