/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.jcas.cas;

import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandle;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.apache.uima.UimaSerializableFSs;
import org.apache.uima.cas.impl.CASImpl;
import org.apache.uima.cas.impl.FeatureStructureImplC;
import org.apache.uima.cas.impl.TypeImpl;
import org.apache.uima.cas.impl.TypeSystemImpl;
import org.apache.uima.internal.util.Int2ObjHashMap;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.JCasRegistry;
import org.apache.uima.jcas.cas.FSArray;
import org.apache.uima.jcas.cas.IntegerArray;
import org.apache.uima.jcas.cas.TOP;
import org.apache.uima.util.IntEntry;
import org.apache.uima.util.impl.Constants;

public class Int2FS<T extends TOP>
extends TOP
implements UimaSerializableFSs,
Cloneable {
    public static final String _TypeName = "org.apache.uima.jcas.cas.Int2FS";
    public static final int typeIndexID;
    public static final int type;
    private boolean isPendingInit = false;
    private boolean isSaveNeeded = false;
    private final Int2ObjHashMap<TOP, T> int2FS;
    public static final String _FeatName_fsArray = "fsArray";
    private static final CallSite _FC_fsArray;
    private static final MethodHandle _FH_fsArray;
    public static final String _FeatName_intArray = "intArray";
    private static final CallSite _FC_intArray;
    private static final MethodHandle _FH_intArray;

    @Override
    public int getTypeIndexID() {
        return typeIndexID;
    }

    protected Int2FS() {
        this.int2FS = null;
    }

    public Int2FS(TypeImpl type, CASImpl casImpl) {
        super(type, casImpl);
        this.int2FS = new Int2ObjHashMap(TOP.class);
        if (CASImpl.traceFSs) {
            this._casView.traceFSCreate(this);
        }
    }

    public Int2FS(JCas jcas) {
        super(jcas);
        this.int2FS = new Int2ObjHashMap(TOP.class);
        if (CASImpl.traceFSs) {
            this._casView.traceFSCreate(this);
        }
    }

    public Int2FS(JCas jcas, int length) {
        super(jcas);
        this._casView.validateArraySize(length);
        this.int2FS = new Int2ObjHashMap(TOP.class, length);
        if (CASImpl.traceFSs) {
            this._casView.traceFSCreate(this);
        }
    }

    private FSArray<T> getFsArray() {
        return (FSArray)this._getFeatureValueNc(Int2FS.wrapGetIntCatchException(_FH_fsArray));
    }

    private void setFsArray(FSArray<T> v) {
        this._setFeatureValueNcWj(Int2FS.wrapGetIntCatchException(_FH_fsArray), v);
    }

    private IntegerArray getIntArray() {
        return (IntegerArray)this._getFeatureValueNc(Int2FS.wrapGetIntCatchException(_FH_intArray));
    }

    private void setIntArray(IntegerArray v) {
        this._setFeatureValueNcWj(Int2FS.wrapGetIntCatchException(_FH_intArray), v);
    }

    @Override
    public void _init_from_cas_data() {
        this.isPendingInit = true;
    }

    private void maybeLazyInit() {
        if (this.isPendingInit) {
            this.lazyInit();
        }
    }

    private void lazyInit() {
        this.isPendingInit = false;
        this.int2FS.clear();
        FSArray<T> a = this.getFsArray();
        IntegerArray ii = this.getIntArray();
        int size = ii.size();
        for (int i = 0; i < size; ++i) {
            this.int2FS.put(ii.get(i), (TOP)a.get(i));
        }
    }

    @Override
    public void _save_to_cas_data() {
        if (this.isSaveNeeded) {
            this.isSaveNeeded = false;
            FSArray fsa = this.getFsArray();
            IntegerArray ia = this.getIntArray();
            int newSize = this.int2FS.size();
            if (fsa == null || fsa.size() != newSize) {
                fsa = new FSArray(this._casView.getJCasImpl(), newSize);
                this.setFsArray(fsa);
                ia = new IntegerArray(this._casView.getJCasImpl(), newSize);
                this.setIntArray(ia);
            }
            Iterator<IntEntry<T>> it = this.int2FS.iterator();
            int[] i = new int[1];
            FSArray fsa_final = fsa;
            IntegerArray ia_final = ia;
            it.forEachRemaining(e -> {
                ia_final.set(i[0], e.getKey());
                fsa_final.set_without_PEAR_conversion(i[0], (TOP)e.getValue());
                i[0] = i[0] + 1;
            });
        }
    }

    @Override
    public FeatureStructureImplC _superClone() {
        return this.clone();
    }

    private TOP[] gta() {
        FSArray<T> fsa = this.getFsArray();
        return null == fsa ? Constants.EMPTY_TOP_ARRAY : fsa._getTheArray();
    }

    public Collection<T> values() {
        if (this.isSaveNeeded) {
            return Arrays.asList(this.int2FS.valuesArray());
        }
        return Arrays.asList((Object[])this.gta().clone());
    }

    @Override
    public String toString() {
        int maxLen = 10;
        return "int2FS [isPendingInit=" + this.isPendingInit + ", isSaveNeeded=" + this.isSaveNeeded + ", int2FS=" + (this.int2FS != null ? this.toString(this.int2FS, 10) : null) + "]";
    }

    private String toString(Int2ObjHashMap<TOP, T> collection, int maxLen) {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        Iterator<IntEntry<T>> iterator = collection.iterator();
        for (int i = 0; iterator.hasNext() && i < maxLen; ++i) {
            if (i > 0) {
                builder.append(", ");
            }
            builder.append(iterator.next());
        }
        builder.append("]");
        return builder.toString();
    }

    public int size() {
        return this.isSaveNeeded ? this.int2FS.size() : this.gta().length;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean containsKey(Object key) {
        this.maybeLazyInit();
        return this.int2FS.containsKey((Integer)key);
    }

    public boolean containsValue(Object value) {
        if (!(value instanceof TOP)) {
            return false;
        }
        return this.values().contains(value);
    }

    public T get(int key) {
        this.maybeLazyInit();
        return (T)((TOP)this.int2FS.get(key));
    }

    public T put(int key, T value) {
        this.maybeLazyInit();
        this.isSaveNeeded = true;
        return (T)this.int2FS.put(key, (TOP)value);
    }

    public T remove(int key) {
        this.maybeLazyInit();
        this.isSaveNeeded = true;
        return (T)((TOP)this.int2FS.remove(key));
    }

    public void clear() {
        if (this.size() == 0) {
            return;
        }
        this.maybeLazyInit();
        this.isSaveNeeded = true;
        this.int2FS.clear();
    }

    public Iterator<IntEntry<T>> iterator() {
        this.maybeLazyInit();
        return this.int2FS.iterator();
    }

    static {
        type = typeIndexID = JCasRegistry.register(Int2FS.class);
        _FC_fsArray = TypeSystemImpl.createCallSite(Int2FS.class, _FeatName_fsArray);
        _FH_fsArray = _FC_fsArray.dynamicInvoker();
        _FC_intArray = TypeSystemImpl.createCallSite(Int2FS.class, _FeatName_intArray);
        _FH_intArray = _FC_intArray.dynamicInvoker();
    }
}

