/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.function.Predicate;
import org.apache.uima.cas.FSComparators;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.admin.LinearTypeOrder;
import org.apache.uima.cas.impl.FSIndexRepositoryImpl;
import org.apache.uima.cas.impl.LowLevelIndex;
import org.apache.uima.cas.impl.LowLevelIterator;
import org.apache.uima.cas.impl.TypeImpl;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.internal.util.Misc;
import org.apache.uima.jcas.cas.TOP;
import org.apache.uima.jcas.impl.JCasImpl;
import org.apache.uima.jcas.tcas.Annotation;

public class Subiterator<T extends AnnotationFS>
implements LowLevelIterator<T> {
    private static final boolean IS_GOING_FORWARDS = true;
    private static final boolean IS_GOING_BACKWARDS = false;
    private ArrayList<Annotation> list = null;
    private int pos = 0;
    private final LowLevelIterator<Annotation> it;
    private final Annotation boundingAnnot;
    private final Annotation coveringStartPos;
    private final Annotation coveringEndPos;
    private final boolean isUnambiguous;
    private final boolean isStrict;
    private final boolean isBounded;
    private final boolean isUseTypePriority;
    private final boolean isSkipSameBeginEndType;
    private final BoundsUse boundsUse;
    private boolean isEmpty;
    private int prevEnd = 0;
    private boolean isListForm = false;
    private int startId;
    private final int boundBegin;
    private final int boundEnd;
    private final TypeImpl boundType;
    private final LinearTypeOrder lto;
    private final Comparator<TOP> comparatorMaybeNoTypeWithoutId;
    private final Comparator<TOP> annotationComparator_withId;
    private final JCasImpl jcas;

    Subiterator(FSIterator<T> it, AnnotationFS boundingAnnot, boolean ambiguous, boolean strict, BoundsUse boundsUse, boolean isUseTypePriority, boolean isSkipSameBeginEndType) {
        this.it = (LowLevelIterator)it;
        this.boundingAnnot = (Annotation)boundingAnnot;
        this.isBounded = boundsUse != null && boundsUse != BoundsUse.notBounded;
        this.boundsUse = boundsUse == null ? BoundsUse.notBounded : boundsUse;
        boolean bl = this.isUnambiguous = !ambiguous;
        if (strict && BoundsUse.coveredBy != boundsUse && BoundsUse.sameBeginEnd != boundsUse) {
            throw new IllegalArgumentException("Strict requires BoundsUse.coveredBy or BoundsUse.sameBeginEnd");
        }
        this.isStrict = strict;
        this.isSkipSameBeginEndType = isSkipSameBeginEndType;
        if (this.isBounded && (null == boundingAnnot || !(boundingAnnot instanceof Annotation))) {
            Misc.internalError(new IllegalArgumentException("Bounded Subiterators require a bounding annotation"));
        }
        this.boundBegin = this.isBounded ? boundingAnnot.getBegin() : -1;
        this.boundEnd = this.isBounded ? boundingAnnot.getEnd() : -1;
        this.boundType = this.isBounded ? (TypeImpl)boundingAnnot.getType() : null;
        FSIndexRepositoryImpl ir = this.it.ll_getIndex().getCasImpl().indexRepository;
        if (boundsUse == BoundsUse.covering && isUseTypePriority) {
            throw new IllegalArgumentException("Cannot specify isUseTypePriority with BoundsUse.covering");
        }
        this.isUseTypePriority = isUseTypePriority;
        this.lto = isUseTypePriority ? ir.getDefaultTypeOrder() : null;
        this.comparatorMaybeNoTypeWithoutId = ir.getAnnotationFsComparator(FSComparators.WITHOUT_ID, isUseTypePriority ? FSComparators.WITH_TYPE_ORDER : FSComparators.WITHOUT_TYPE_ORDER);
        this.annotationComparator_withId = ir.getAnnotationFsComparatorWithId();
        this.jcas = (JCasImpl)this.ll_getIndex().getCasImpl().getJCas();
        if (boundsUse == BoundsUse.covering) {
            int span = ((LowLevelIterator)it).ll_maxAnnotSpan();
            int begin = this.boundEnd - span;
            if (begin > this.boundBegin) {
                this.makeInvalid();
                this.coveringEndPos = null;
                this.coveringStartPos = null;
                this.isEmpty = true;
                this.startId = 0;
                return;
            }
            if (begin < 0) {
                begin = 0;
            }
            this.coveringStartPos = new Annotation(this.jcas, begin, Integer.MAX_VALUE);
            this.coveringEndPos = new Annotation(this.jcas, this.boundBegin + 1, this.boundBegin + 1);
        } else {
            this.coveringEndPos = null;
            this.coveringStartPos = null;
        }
        this.moveToStartSetEmptyAndId();
    }

    private void moveToStartSetEmptyAndId() {
        this.moveToStart();
        this.isEmpty = !this.isValid();
        this.startId = this.isValid() ? this.getNvc()._id() : 0;
    }

    Subiterator(FSIterator<Annotation> it, Annotation boundingAnnot, boolean ambiguous, boolean strict, BoundsUse boundsUse, boolean isUseTypePriority, boolean isSkipSameBeginEndType, int startId, boolean isEmpty, Annotation coveringStartPos, Annotation coveringEndPos) {
        this.it = (LowLevelIterator)it;
        this.boundingAnnot = boundingAnnot;
        this.isBounded = boundsUse != null && boundsUse != BoundsUse.notBounded;
        this.boundsUse = boundsUse == null ? BoundsUse.notBounded : boundsUse;
        boolean bl = this.isUnambiguous = !ambiguous;
        if (strict && BoundsUse.coveredBy != boundsUse && BoundsUse.sameBeginEnd != boundsUse) {
            throw new IllegalArgumentException("Strict requires BoundsUse.coveredBy or BoundsUse.sameBeginEnd");
        }
        this.isStrict = strict;
        this.isSkipSameBeginEndType = isSkipSameBeginEndType;
        this.boundBegin = this.isBounded ? boundingAnnot.getBegin() : -1;
        this.boundEnd = this.isBounded ? boundingAnnot.getEnd() : -1;
        this.boundType = this.isBounded ? (TypeImpl)boundingAnnot.getType() : null;
        FSIndexRepositoryImpl ir = this.it.ll_getIndex().getCasImpl().indexRepository;
        this.isUseTypePriority = isUseTypePriority;
        this.lto = isUseTypePriority ? ir.getDefaultTypeOrder() : null;
        this.comparatorMaybeNoTypeWithoutId = ir.getAnnotationFsComparator(FSComparators.WITHOUT_ID, isUseTypePriority ? FSComparators.WITH_TYPE_ORDER : FSComparators.WITHOUT_TYPE_ORDER);
        this.annotationComparator_withId = ir.getAnnotationFsComparatorWithId();
        this.jcas = (JCasImpl)this.ll_getIndex().getCasImpl().getJCas();
        this.coveringStartPos = coveringStartPos;
        this.coveringEndPos = coveringEndPos;
        this.startId = startId;
        this.isEmpty = isEmpty;
        if (isEmpty) {
            this.makeInvalid();
        }
    }

    private void convertToListForm() {
        this.moveToStart();
        this.list = new ArrayList();
        while (this.isValid()) {
            this.list.add((Annotation)this.it.getNvc());
            this.moveToNext();
        }
        this.pos = 0;
        this.isListForm = true;
    }

    private void moveToStart() {
        switch (this.boundsUse) {
            case notBounded: {
                this.it.moveToFirstNoReinit();
                break;
            }
            case sameBeginEnd: {
                this.it.moveToNoReinit(this.boundingAnnot);
                if (!this.it.isValid()) break;
                this.skipOverBoundingAnnot(true);
                break;
            }
            case coveredBy: {
                this.it.moveToNoReinit(this.boundingAnnot);
                if (!this.it.isValid()) break;
                this.adjustForStrictOrCoveringAndBoundSkipNvc(true);
                break;
            }
            case covering: {
                this.it.moveToNoReinit(this.coveringStartPos);
                if (!this.it.isValid()) break;
                this.adjustForCoveringAndBoundSkip(true);
            }
        }
        if (!this.isBoundOk()) {
            return;
        }
        this.maybeSetPrevEnd();
    }

    @Override
    public boolean isValid() {
        if (this.isListForm) {
            return this.pos >= 0 && this.pos < this.list.size();
        }
        return this.it.isValid();
    }

    @Override
    public T getNvc() {
        if (this.isListForm) {
            return (T)this.list.get(this.pos);
        }
        return (T)((AnnotationFS)this.it.getNvc());
    }

    @Override
    public void moveToNextNvc() {
        if (this.isListForm) {
            ++this.pos;
            return;
        }
        this.it.moveToNextNvc();
        if (this.isUnambiguous) {
            this.movePastPrevAnnotation();
        }
        this.adjustForStrictOrCoveringAndBoundSkip(true);
        if (this.it.isValid() && !this.isBoundOkNvc()) {
            return;
        }
        this.maybeSetPrevEnd();
    }

    @Override
    public void moveToPreviousNvc() {
        if (this.isListForm) {
            --this.pos;
            return;
        }
        if (this.isUnambiguous) {
            Annotation currentAnnotation = (Annotation)this.it.getNvc();
            this.convertToListForm();
            this.pos = Collections.binarySearch(this.list, currentAnnotation, this.annotationComparator_withId);
            --this.pos;
            return;
        }
        this.maybeMoveToPrevBounded();
        this.adjustForStrictOrCoveringAndBoundSkip(false);
    }

    @Override
    public void moveToFirstNoReinit() {
        if (this.isEmpty) {
            return;
        }
        if (this.isListForm) {
            this.pos = 0;
        } else {
            this.moveToStart();
        }
    }

    private void resetList() {
        if (this.isListForm) {
            this.isListForm = false;
            if (this.list != null) {
                this.list.clear();
            }
        }
    }

    @Override
    public void moveToLastNoReinit() {
        if (this.isEmpty) {
            return;
        }
        if (this.isUnambiguous && !this.isListForm) {
            this.convertToListForm();
        }
        if (this.isListForm) {
            this.pos = this.list.size() - 1;
        } else {
            assert (this.isBounded);
            switch (this.boundsUse) {
                case notBounded: {
                    Misc.internalError();
                    break;
                }
                case coveredBy: {
                    this.moveToJustPastBoundsAndBackup(this.boundEnd + 1, this.boundEnd + 1, a -> a.getBegin() > this.boundEnd);
                    break;
                }
                case covering: {
                    this.moveToJustPastBoundsAndBackup(this.boundBegin + 1, this.boundBegin + 1, a -> a.getBegin() > this.boundBegin);
                    break;
                }
                case sameBeginEnd: {
                    this.moveToJustPastBoundsAndBackup(this.boundBegin, this.boundEnd + 1, a -> a.getEnd() != this.boundEnd);
                }
            }
        }
    }

    private void moveToJustPastBoundsAndBackup(int begin, int end, Predicate<Annotation> goBackwards) {
        this.it.moveToNoReinit(new Annotation(this.jcas, begin, end));
        if (this.it.isValid()) {
            Annotation a = (Annotation)this.it.getNvc();
            while (goBackwards.test(a)) {
                if (a._id == this.startId) {
                    assert (a.getBegin() <= this.boundEnd);
                } else {
                    this.it.moveToPreviousNvc();
                    this.adjustForStrictOrCoveringAndBoundSkip(false);
                    if (this.it.isValid()) {
                        a = (Annotation)this.it.getNvc();
                        continue;
                    }
                }
                break;
            }
        } else {
            this.it.moveToLastNoReinit();
            this.adjustForStrictOrCoveringAndBoundSkip(false);
        }
    }

    static Comparator<AnnotationFS> getAnnotationBeginEndComparator(final int boundingBegin, final int boundingEnd) {
        return new Comparator<AnnotationFS>(){

            @Override
            public int compare(AnnotationFS o1, AnnotationFS o2) {
                AnnotationFS a = o1 == null ? o2 : o1;
                boolean isReverse = o1 == null;
                int b = a.getBegin();
                if (b < boundingBegin) {
                    return isReverse ? 1 : -1;
                }
                if (b > boundingBegin) {
                    return isReverse ? -1 : 1;
                }
                int e = a.getEnd();
                if (e < boundingEnd) {
                    return isReverse ? -1 : 1;
                }
                if (e > boundingEnd) {
                    return isReverse ? 1 : -1;
                }
                return 0;
            }
        };
    }

    @Override
    public void moveToNoReinit(FeatureStructure fs) {
        if (!(fs instanceof Annotation)) {
            throw new IllegalArgumentException("Argument must be a subtype of Annotation");
        }
        if (this.isEmpty) {
            return;
        }
        Annotation fsa = (Annotation)fs;
        if (this.isUnambiguous && !this.isListForm) {
            this.convertToListForm();
        }
        if (this.isListForm) {
            this.pos = Collections.binarySearch(this.list, fsa, this.comparatorMaybeNoTypeWithoutId);
            int begin = fsa.getBegin();
            int end = fsa.getEnd();
            Type type = fsa.getType();
            if (this.pos >= 0) {
                this.moveToPrevious();
            } else {
                this.pos = -this.pos - 1;
                if (!this.isValid()) {
                    return;
                }
            }
            while (this.isValid() && 0 == this.comparatorMaybeNoTypeWithoutId.compare((Annotation)this.getNvc(), fsa)) {
                this.moveToPreviousNvc();
            }
            if (this.isValid()) {
                this.moveToNextNvc();
            } else {
                this.moveToFirstNoReinit();
            }
            return;
        }
        this.it.moveToNoReinit(fs);
        if (!this.it.isValid()) {
            this.makeInvalid();
            return;
        }
        if ((this.boundsUse == BoundsUse.coveredBy || this.boundsUse == BoundsUse.sameBeginEnd) && ((Annotation)this.it.getNvc()).getBegin() < this.boundBegin) {
            this.moveToFirstNoReinit();
        } else if (this.isAboveBound()) {
            this.makeInvalid();
            return;
        }
        this.adjustForStrictOrCoveringAndBoundSkip(true);
    }

    private boolean isBoundOk() {
        if (!this.it.isValid()) {
            return false;
        }
        return this.isBoundOkNvc();
    }

    private boolean isBoundOkNvc() {
        boolean ok;
        if (!this.it.isValid()) {
            return false;
        }
        if (this.boundsUse == BoundsUse.notBounded) {
            return true;
        }
        Annotation a = (Annotation)this.it.getNvc();
        int begin = a.getBegin();
        int end = a.getEnd();
        switch (this.boundsUse) {
            case covering: {
                if (begin == this.boundBegin && end == this.boundEnd) {
                    ok = this.lto == null || this.lto.lessThan(a._getTypeImpl(), this.boundType);
                    break;
                }
                ok = begin <= this.boundBegin && end >= this.boundEnd;
                break;
            }
            case coveredBy: {
                if (begin == this.boundBegin && end == this.boundEnd) {
                    ok = this.lto == null || this.lto.lessThan(this.boundType, a._getTypeImpl());
                    break;
                }
                ok = begin >= this.boundBegin && begin <= this.boundEnd;
                break;
            }
            default: {
                ok = begin == this.boundBegin && end == this.boundEnd ? this.lto == null || this.boundType == a._getTypeImpl() : false;
            }
        }
        if (!ok) {
            this.makeInvalid();
        }
        return ok;
    }

    private boolean isAboveBound() {
        Annotation a = (Annotation)this.it.getNvc();
        switch (this.boundsUse) {
            case notBounded: {
                return false;
            }
            case covering: {
                return a.getBegin() > this.boundBegin;
            }
            case coveredBy: {
                return a.getBegin() > this.boundEnd;
            }
        }
        return a.getBegin() != this.boundBegin || a.getEnd() < this.boundEnd;
    }

    private void adjustForStrictOrCoveringAndBoundSkip(boolean forward_or_backward) {
        if (!this.isValid()) {
            return;
        }
        this.adjustForStrictOrCoveringAndBoundSkipNvc(forward_or_backward);
    }

    private void adjustForStrictOrCoveringAndBoundSkipNvc(boolean forward_or_backward) {
        if (this.boundsUse == BoundsUse.covering) {
            this.adjustForCoveringAndBoundSkip(forward_or_backward);
            return;
        }
        this.adjustForStrict(forward_or_backward);
        if (this.skipOverBoundingAnnot(forward_or_backward)) {
            this.adjustForStrict(forward_or_backward);
        }
    }

    private void adjustForCoveringAndBoundSkip(boolean forward_or_backwards) {
        this.adjustForCovering(forward_or_backwards);
        if (this.skipOverBoundingAnnot(forward_or_backwards)) {
            this.adjustForCovering(forward_or_backwards);
        }
    }

    private boolean skipOverBoundingAnnot(boolean forward) {
        boolean moved = false;
        if (this.isBounded && this.it.isValid()) {
            while (this.equalToBounds((Annotation)this.it.getNvc())) {
                moved = true;
                if (forward) {
                    this.it.moveToNextNvc();
                } else {
                    this.maybeMoveToPrevBounded();
                }
                if (!this.it.isValid()) break;
                if (this.isBoundOkNvc()) continue;
                return true;
            }
        }
        return moved;
    }

    private boolean equalToBounds(Annotation fs) {
        if (fs._id == this.boundingAnnot._id) {
            return true;
        }
        if (this.isSkipSameBeginEndType) {
            return this.isBeginEndTypeEqual(fs, this.boundBegin, this.boundEnd, this.boundType);
        }
        return false;
    }

    private void maybeSetPrevEnd() {
        if (this.isUnambiguous && this.it.isValid()) {
            this.prevEnd = ((Annotation)this.it.getNvc()).getEnd();
        }
    }

    private void adjustForStrict(boolean forward) {
        if (!this.isValid()) {
            return;
        }
        if (this.isStrict) {
            Annotation item = (Annotation)this.it.getNvc();
            while (item.getEnd() > this.boundEnd) {
                if (forward) {
                    this.it.moveToNextNvc();
                    if (!this.isValid()) {
                        return;
                    }
                    item = (Annotation)this.it.getNvc();
                    if (item.getBegin() <= this.boundEnd) continue;
                    this.makeInvalid();
                    return;
                }
                this.maybeMoveToPrevBounded();
                if (!this.isValid()) {
                    return;
                }
                item = (Annotation)this.it.getNvc();
            }
        }
    }

    private void adjustForCovering(boolean forward) {
        if (!this.it.isValid()) {
            return;
        }
        if (((Annotation)this.it.getNvc()).getBegin() > this.boundBegin) {
            this.makeInvalid();
            return;
        }
        while (this.it.isValid() && ((Annotation)this.it.getNvc()).getEnd() < this.boundEnd) {
            if (forward) {
                this.it.moveToNextNvc();
                if (!this.it.isValid() || ((Annotation)this.it.getNvc()).getBegin() <= this.boundBegin) continue;
                this.makeInvalid();
                return;
            }
            this.maybeMoveToPrevBounded();
        }
    }

    private void maybeMoveToPrevBounded() {
        if (((Annotation)this.it.getNvc())._id == this.startId) {
            this.it.moveToFirstNoReinit();
        }
        this.it.moveToPreviousNvc();
    }

    private boolean isBeginEndTypeEqual(Annotation fs, int begin, int end, Type type) {
        if (fs.getBegin() != begin || fs.getEnd() != end) {
            return false;
        }
        return fs.getType() == type;
    }

    private void movePastPrevAnnotation() {
        if (this.isUnambiguous) {
            while (this.it.isValid() && ((Annotation)this.it.get()).getBegin() < this.prevEnd) {
                this.it.moveToNext();
            }
        }
    }

    @Override
    public FSIterator<T> copy() {
        Subiterator<T> copy = new Subiterator<T>(this.it.copy(), this.boundingAnnot, !this.isUnambiguous, this.isStrict, this.boundsUse, this.isUseTypePriority, this.isSkipSameBeginEndType, this.startId, this.isEmpty, this.coveringStartPos, this.coveringEndPos);
        copy.list = this.list;
        copy.pos = this.pos;
        copy.isListForm = this.isListForm;
        return copy;
    }

    @Override
    public int ll_indexSizeMaybeNotCurrent() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int ll_maxAnnotSpan() {
        if (this.isEmpty) {
            return 0;
        }
        return this.it.ll_maxAnnotSpan();
    }

    @Override
    public LowLevelIndex<T> ll_getIndex() {
        return this.it.ll_getIndex();
    }

    private void makeInvalid() {
        this.it.moveToFirstNoReinit();
        this.it.moveToPrevious();
    }

    @Override
    public boolean isIndexesHaveBeenUpdated() {
        return this.it.isIndexesHaveBeenUpdated();
    }

    @Override
    public boolean maybeReinitIterator() {
        if (this.it.maybeReinitIterator()) {
            this.resetList();
            this.moveToStartSetEmptyAndId();
            return true;
        }
        return false;
    }

    @Override
    public Comparator<TOP> getComparator() {
        return null;
    }

    public static enum BoundsUse {
        coveredBy,
        covering,
        sameBeginEnd,
        notBounded;

    }
}

