/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import java.util.Comparator;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.impl.LowLevelIndex;
import org.apache.uima.cas.impl.LowLevelIterator;
import org.apache.uima.jcas.cas.TOP;

class FsIterator_limited<T extends FeatureStructure>
implements LowLevelIterator<T> {
    private final LowLevelIterator<T> iterator;
    private final int limit;
    private int count = 0;

    FsIterator_limited(FSIterator<T> iterator, int limit) {
        this.iterator = (LowLevelIterator)iterator;
        this.limit = limit;
    }

    private void maybeMakeInvalid() {
        if (this.count == this.limit) {
            this.iterator.moveToFirstNoReinit();
            this.iterator.moveToPrevious();
        }
    }

    @Override
    public T getNvc() {
        this.maybeMakeInvalid();
        Object r = this.iterator.get();
        ++this.count;
        return r;
    }

    @Override
    public void moveToNextNvc() {
        this.maybeMakeInvalid();
        this.iterator.moveToNext();
    }

    @Override
    public void moveToPreviousNvc() {
        this.maybeMakeInvalid();
        this.iterator.moveToPrevious();
    }

    @Override
    public void moveToFirstNoReinit() {
        this.iterator.moveToFirstNoReinit();
        this.maybeMakeInvalid();
    }

    @Override
    public void moveToLastNoReinit() {
        this.iterator.moveToLastNoReinit();
        this.maybeMakeInvalid();
    }

    @Override
    public void moveToNoReinit(FeatureStructure fs) {
        this.iterator.moveToNoReinit(fs);
        this.maybeMakeInvalid();
    }

    @Override
    public FSIterator<T> copy() {
        return new FsIterator_limited(this.iterator.copy(), this.limit);
    }

    @Override
    public boolean isValid() {
        this.maybeMakeInvalid();
        return this.iterator.isValid();
    }

    @Override
    public int ll_indexSizeMaybeNotCurrent() {
        return this.iterator.ll_indexSizeMaybeNotCurrent();
    }

    @Override
    public int ll_maxAnnotSpan() {
        return this.iterator.ll_maxAnnotSpan();
    }

    @Override
    public LowLevelIndex<T> ll_getIndex() {
        return this.iterator.ll_getIndex();
    }

    @Override
    public boolean isIndexesHaveBeenUpdated() {
        return this.iterator.isIndexesHaveBeenUpdated();
    }

    @Override
    public boolean maybeReinitIterator() {
        return this.iterator.maybeReinitIterator();
    }

    @Override
    public Comparator<TOP> getComparator() {
        return this.iterator.getComparator();
    }

    @Override
    public int size() {
        return Math.min(this.limit, this.iterator.size());
    }
}

