/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.util;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.S3Object;
import com.commvault.perfutil.PerfCounter;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Properties;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.mime.FormBodyPart;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.InputStreamBody;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.util.Base64;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class CommvaultCommon {
    public static AWSCredentials credentials = null;
    public static HttpClient g_client = new DefaultHttpClient((ClientConnectionManager)new PoolingClientConnectionManager());
    private static String bucketName = "";
    public static final String AttachmentStartTag = "<!--Attachment_Start_9cffdc74-5341-44ac-8c4c-55b3eb34c027-->";
    public static final String AttachmentEndTag = "<!--Attachment_End_9cffdc74-5341-44ac-8c4c-55b3eb34c027-->";
    public static final String CSSStartTag = "<!--CSS_Start_9a8d5123-e0d7-4d25-aae0-03c1e3925030-->";
    public static final String CSSEndTag = "<!--CSS_End_9a8d5123-e0d7-4d25-aae0-03c1e3925030-->";
    public static final String CurrentURL = "link_c8261c4467b94ad5acb1a2e0b0681d57_";
    public static final String EmailTag = "5686fec4-f67e-4fe0-839b-5a6ab5295f4d-";
    public static final String TitleStartTag = "<!--5686fec4-f67e-4fe0-839b-5a6ab5295f4d-Title_Sart_b98ba523-d16e-4b74-b50d-502a40101179-->";
    public static final String TitleEndTag = "<!--5686fec4-f67e-4fe0-839b-5a6ab5295f4d-Title_End_b98ba523-d16e-4b74-b50d-502a40101179-->";
    public static final String SentStartTag = "<!--5686fec4-f67e-4fe0-839b-5a6ab5295f4d-Sent_Sart_4894e6c0-9606-48c9-a0c9-2a485e019685-->";
    public static final String SentEndTag = "<!--5686fec4-f67e-4fe0-839b-5a6ab5295f4d-Sent_End_4894e6c0-9606-48c9-a0c9-2a485e019685-->";
    public static final String FromStartTag = "<!--5686fec4-f67e-4fe0-839b-5a6ab5295f4d-From_Sart_5a902233-d303-4788-b26b-122c800d420c-->";
    public static final String FromEndTag = "<!--5686fec4-f67e-4fe0-839b-5a6ab5295f4d-From_End_5a902233-d303-4788-b26b-122c800d420c-->";
    public static final String ToStartTag = "<!--5686fec4-f67e-4fe0-839b-5a6ab5295f4d-To_Sart_16e96c5c-8396-4505-b16e-c46c2d9e5d20-->";
    public static final String ToEndTag = "<!--5686fec4-f67e-4fe0-839b-5a6ab5295f4d-To_End_16e96c5c-8396-4505-b16e-c46c2d9e5d20-->";
    public static final String CcStartTag = "<!--5686fec4-f67e-4fe0-839b-5a6ab5295f4d-Cc_Sart_cd7caaa8-7cbd-4f66-88b5-aa10175538b6-->";
    public static final String CcEndTag = "<!--5686fec4-f67e-4fe0-839b-5a6ab5295f4d-Cc_End_cd7caaa8-7cbd-4f66-88b5-aa10175538b6-->";
    public static final String BccStartTag = "<!--5686fec4-f67e-4fe0-839b-5a6ab5295f4d-Bcc_Start_944c1322-30c2-4e80-93b4-b59e7082db04-->";
    public static final String BccEndTag = "<!--5686fec4-f67e-4fe0-839b-5a6ab5295f4d-Bcc_End_944c1322-30c2-4e80-93b4-b59e7082db04-->";
    public static final String FromAddrStartTag = "--5686fec4-f67e-4fe0-839b-5a6ab5295f4d-From_Address_Sart_530865d8-e750-427f-9a26-a33d0216c06b--";
    public static final String FromAddrEndTag = "--5686fec4-f67e-4fe0-839b-5a6ab5295f4d-From_Address_End_530865d8-e750-427f-9a26-a33d0216c06b--";
    public static final String ToAddrStartTag = "--5686fec4-f67e-4fe0-839b-5a6ab5295f4d-To_Address_Sart_1e7e48c4-c316-4026-be6b-f7ce061e1794--";
    public static final String ToAddrEndTag = "--5686fec4-f67e-4fe0-839b-5a6ab5295f4d-To_Address_End_1e7e48c4-c316-4026-be6b-f7ce061e1794--";
    public static final String CcAddrStartTag = "--5686fec4-f67e-4fe0-839b-5a6ab5295f4d-Cc_Address_Sart_7a9923d3-fd43-417c-9e3b-b280f989ed4a--";
    public static final String CcAddrEndTag = "--5686fec4-f67e-4fe0-839b-5a6ab5295f4d-Cc_Address_End_7a9923d3-fd43-417c-9e3b-b280f989ed4a--";
    public static final String BccAddrStartTag = "--5686fec4-f67e-4fe0-839b-5a6ab5295f4d-Bcc_Address_Start_7034714e-b192-4359-92ca-3ec95caf1e49--";
    public static final String BccAddrEndTag = "--5686fec4-f67e-4fe0-839b-5a6ab5295f4d-Bcc_Address_End_7034714e-b192-4359-92ca-3ec95caf1e49--";
    public static final String AttachmentsStartTag = "<!--5686fec4-f67e-4fe0-839b-5a6ab5295f4d-Attachments_Start_69b61b6e-14f0-4285-80e0-367b2c90163f-->";
    public static final String AttachmentsEndTag = "<!--5686fec4-f67e-4fe0-839b-5a6ab5295f4d-Attachments_End_69b61b6e-14f0-4285-80e0-367b2c90163f-->";
    public static final String BodyStartTag = "<!--5686fec4-f67e-4fe0-839b-5a6ab5295f4d-Body_Start_444dcf6d-4e31-4862-8c07-36923325c423-->";
    public static final String BodyEndTag = "<!--5686fec4-f67e-4fe0-839b-5a6ab5295f4d-Body_End_444dcf6d-4e31-4862-8c07-36923325c423-->";
    public static final String EmeilHomeTag = "<!--5686fec4-f67e-4fe0-839b-5a6ab5295f4d-EmailHome_b5b6b98d-0420-4c41-b72f-7bf35dacd95b-->";
    public static final String EmailHeadStartTag = "<!--5686fec4-f67e-4fe0-839b-5a6ab5295f4d-Email_Headt_Start_2afb7efe-f83f-4ae9-a38b-048d0a84782f-->";
    public static final String EmailHeadEndTag = "<!--5686fec4-f67e-4fe0-839b-5a6ab5295f4d-Email_Headt_End_2afb7efe-f83f-4ae9-a38b-048d0a84782f-->";
    public static final String EmailHeadTableStartTag = "<!--5686fec4-f67e-4fe0-839b-5a6ab5295f4d-Email_Headt_Table_Start_ef6380b8-a50d-4364-a3ea-7dc1b91a5d1d-->";
    public static final String EmailHeadTableEndTag = "<!--5686fec4-f67e-4fe0-839b-5a6ab5295f4d-Email_Headt_Table_End_ef6380b8-a50d-4364-a3ea-7dc1b91a5d1d-->";
    public static final String EmailLengthStartTag = "--5686fec4-f67e-4fe0-839b-5a6ab5295f4d-Email_Length_Sart_92de45ea-abd8-4b3f-a706-de8bddfe7ebc--";
    public static final String EmailLengthEndTag = "--5686fec4-f67e-4fe0-839b-5a6ab5295f4d-Email_Length_End_92de45ea-abd8-4b3f-a706-de8bddfe7ebc--";
    public static final String EmailConversationTopicStartTag = "--5686fec4-f67e-4fe0-839b-5a6ab5295f4d-Email_ConversationTopic_Sart_2e0daeba-6403-4522-bd66-0d35ebf6e875--";
    public static final String EmailConversationTopicEndTag = "--5686fec4-f67e-4fe0-839b-5a6ab5295f4d-Email_ConversationTopic_End_92de45ea-2e0daeba-6403-4522-bd66-0d35ebf6e875--";
    public static final String EmailConversationIndexStartTag = "--5686fec4-f67e-4fe0-839b-5a6ab5295f4d-Email_ConversationIndex_Sart_8fa160ef-a9c2-4e03-81a3-b31f676ce65a--";
    public static final String EmailConversationIndexEndTag = "--5686fec4-f67e-4fe0-839b-5a6ab5295f4d-Email_ConversationIndex_End_92de45ea-8fa160ef-a9c2-4e03-81a3-b31f676ce65a--";
    public static final String DicomSummaryStartTag = "<!--Dicom_Summary_Start_e833112e-aa0c-470a-9f53-455e0146f4f7-->";
    public static final String DicomSummaryEndTag = "<!--Dicom_Summary_End_e833112e-aa0c-470a-9f53-455e0146f4f7-->";
    public static final String ZIPPED_BINARY_FILE_TAG = "eb901d5cyae5dy4c1fybffaye34a399acbce";
    protected static final String HEXES = "0123456789ABCDEF";
    public static final String ExternalFileTag = "9c85564114716202";
    public static final String REMOTEFileTag = "7ud55cs12471921d";
    public static final String EXTERNAL_IMG_START_TAG = "0b1112fc-ff10-4dd3-a8d7-d493786bb2a3_";
    public static final String REMOTE_IMG_START_TAG = "92d14d5a-0aa5-4422-b92d-4ab1bcb88047_";
    public static final String EXTERNAL_IMG_END_TAG = "_eea8f429-652b-4aa4-87c8-606c0ce593f6";
    public static final String EXT_META_CORE = "extmeta";
    public static final String EXT_STORE_CORE = "extstore";
    public static final String MAIN_CORE = "collection1";
    public static final int EXT_META_CORE_COUNT = 8;
    public static final String extstoresolr;
    public static final String solrDataDir;
    public static final String extCloudstore;
    public static final File fakeFile;

    public static void setCredentials(AWSCredentials credentials) {
        CommvaultCommon.credentials = credentials;
    }

    public static File zipFile(String filePath) throws IOException {
        int len;
        File f = new File(filePath);
        BufferedInputStream fi = new BufferedInputStream(new FileInputStream(f));
        byte[] buf = new byte[1024];
        File fResult = File.createTempFile("StellentZippedContent_a168a1a3y095cy4ccfy83bey8720eed60032_", ".tmp");
        ZipOutputStream zo = new ZipOutputStream(new FileOutputStream(fResult));
        zo.putNextEntry(new ZipEntry("preview or search.txt"));
        while ((len = fi.read(buf)) > 0) {
            zo.write(buf, 0, len);
        }
        zo.closeEntry();
        zo.close();
        fi.close();
        return fResult;
    }

    public static void loadBinaryFileToHandler(String filePath, ContentHandler handler) throws IOException, SAXException {
        File f = new File(filePath);
        handler.characters(ZIPPED_BINARY_FILE_TAG.toCharArray(), 0, ZIPPED_BINARY_FILE_TAG.length());
        byte[] buf = new byte[1024];
        int len = (int)(f.length() * 2L);
        for (int i = 0; i < 4; ++i) {
            int offset = (3 - i) * 8;
            byte b = (byte)(len >>> offset & 0xFF);
            char[] ca = new char[]{HEXES.charAt((b & 0xF0) >> 4), HEXES.charAt(b & 0xF)};
            handler.characters(ca, 0, 2);
        }
        BufferedInputStream fi = new BufferedInputStream(new FileInputStream(f));
        while ((len = fi.read(buf)) > 0) {
            for (int i = 0; i < len; ++i) {
                char[] ca = new char[]{HEXES.charAt((buf[i] & 0xF0) >> 4), HEXES.charAt(buf[i] & 0xF)};
                handler.characters(ca, 0, 2);
            }
        }
        fi.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File zippedBinaryToTextFile(String val) throws IOException {
        File fResult = File.createTempFile("UnzippedContent_acf2bc0fy8181y4e56ya20dy2c44865590c4_", ".tmp");
        try (BufferedWriter os = null;){
            os = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(fResult), "UTF-8"));
            int strlen = val.length();
            for (int i = 0; i < strlen; ++i) {
                if (i + ZIPPED_BINARY_FILE_TAG.length() < strlen && val.charAt(i + 0) == ZIPPED_BINARY_FILE_TAG.charAt(0) && val.charAt(i + 1) == ZIPPED_BINARY_FILE_TAG.charAt(1) && val.charAt(i + 2) == ZIPPED_BINARY_FILE_TAG.charAt(2) && val.charAt(i + 3) == ZIPPED_BINARY_FILE_TAG.charAt(3) && val.substring(i, i + ZIPPED_BINARY_FILE_TAG.length()).equalsIgnoreCase(ZIPPED_BINARY_FILE_TAG)) {
                    int zipDataLen;
                    block22: {
                        if ((i += ZIPPED_BINARY_FILE_TAG.length()) + 8 >= strlen) {
                            throw new SolrException(SolrException.ErrorCode.UNKNOWN, "invalue zipped format field");
                        }
                        zipDataLen = Integer.parseInt(val.substring(i, i + 8), 16);
                        if (zipDataLen % 2 != 0) {
                            throw new SolrException(SolrException.ErrorCode.UNKNOWN, "invalue zipped format field");
                        }
                        if ((i += 8) + zipDataLen - 1 > strlen) {
                            throw new SolrException(SolrException.ErrorCode.UNKNOWN, "invalue zipped format field");
                        }
                        File fDoc = File.createTempFile("ZippedDoc_d057d3d1y8958y4247yb666y0c34c7ad4cc9_", ".tmp");
                        FilterOutputStream fo = null;
                        ZipInputStream zis = null;
                        try {
                            fo = new BufferedOutputStream(new FileOutputStream(fDoc));
                            for (int j = i; j < i + zipDataLen; j += 2) {
                                ((BufferedOutputStream)fo).write((byte)Integer.parseInt(val.substring(j, j + 2), 16));
                            }
                            fo.close();
                            fo = null;
                            zis = new ZipInputStream(new FileInputStream(fDoc));
                            if (zis.getNextEntry() == null) break block22;
                            File f = File.createTempFile("UnzippedContent_cbef3a6fy4130y4a27yb384y5f89f9d1601e_", ".tmp");
                            FilterOutputStream fos = null;
                            BufferedReader tr = null;
                            try {
                                fos = new BufferedOutputStream(new FileOutputStream(f));
                                int len = 0;
                                byte[] buf = new byte[1024];
                                while ((len = zis.read(buf)) != -1) {
                                    ((BufferedOutputStream)fos).write(buf, 0, len);
                                }
                                fos.close();
                                tr = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f), "UTF-8"));
                                char[] cbuf = new char[1024];
                                while ((len = tr.read(cbuf)) != -1) {
                                    os.write(cbuf, 0, len);
                                }
                            }
                            finally {
                                if (fos != null) {
                                    fos.close();
                                }
                                if (tr != null) {
                                    tr.close();
                                }
                                f.delete();
                            }
                        }
                        finally {
                            if (fo != null) {
                                fo.close();
                            }
                            if (zis != null) {
                                zis.close();
                            }
                            fDoc.delete();
                        }
                    }
                    i += zipDataLen - 1;
                    continue;
                }
                os.write(val.charAt(i));
            }
        }
        return fResult;
    }

    public static MessageDigest getMessageDigest() throws IOException {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-512");
            return md;
        }
        catch (Exception e) {
            throw new IOException(e.toString());
        }
    }

    public static void SHA512HashUpdate(MessageDigest md, byte[] bytes, int len) throws IOException {
        try {
            md.update(bytes, 0, len);
            return;
        }
        catch (Exception e) {
            throw new IOException(e.toString());
        }
    }

    public static String SHA512HashStr(byte[] bytes, int len) throws IOException {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-512");
            CommvaultCommon.SHA512HashUpdate(md, bytes, len);
            byte[] mdbytes = md.digest();
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < mdbytes.length; ++i) {
                sb.append(Integer.toString((mdbytes[i] & 0xFF) + 256, 16).substring(1));
            }
            return sb.toString();
        }
        catch (Exception e) {
            throw new IOException(e.toString());
        }
    }

    public static String SHA512MDToStr(MessageDigest md) {
        byte[] mdbytes = md.digest();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < mdbytes.length; ++i) {
            sb.append(Integer.toString((mdbytes[i] & 0xFF) + 256, 16).substring(1));
        }
        return sb.toString();
    }

    public static long BKDRHash(long hash, byte[] bytes, int len) {
        long seed = 131L;
        for (int i = 0; i < len; ++i) {
            hash = hash * seed + (long)bytes[i];
        }
        return hash & Integer.MAX_VALUE;
    }

    public static String processExternalImgs(String contentid, String externalImgs) throws IOException {
        if (externalImgs == null) {
            return null;
        }
        if (extstoresolr != null) {
            return null;
        }
        TreeSet<String> trackingSet = new TreeSet<String>();
        String result = "";
        String[] imgs = externalImgs.trim().split(" ");
        for (int i = 0; i < imgs.length; ++i) {
            if (trackingSet.contains(imgs[i])) continue;
            trackingSet.add(imgs[i]);
            String folderPath = solrDataDir + File.separator + "externalfields" + File.separator + "img" + File.separator + Long.parseLong(imgs[i].split("_")[1]) % 10000L + File.separator + imgs[i];
            File f = new File(folderPath + File.separator + contentid);
            if (!f.exists()) {
                f.createNewFile();
            } else {
                f = new File(folderPath + File.separator + contentid + "_1");
                f.createNewFile();
            }
            result = result + imgs[i] + " ";
        }
        return result.trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getExtMetaNodeInfo(String cvturboguid, String shards) throws IOException {
        String beingtag = "<str name=\"cv_node_s\">";
        String endtag = "</str>";
        String content = "";
        String url = System.getProperty("solr.host.httpschema") + "://127.0.0.1:" + System.getProperty("solr.port") + System.getProperty("solr.host.appname") + "/" + EXT_META_CORE + "/select?q=cvturboguid:" + cvturboguid + "&rows=1&fl=cv_node_s&shards=" + shards;
        HttpGet method = new HttpGet(url);
        try {
            HttpResponse response = g_client.execute((HttpUriRequest)method);
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new IOException("cannot access " + url + " with exceptione \r\n " + EntityUtils.toString((HttpEntity)response.getEntity()));
            }
            content = EntityUtils.toString((HttpEntity)response.getEntity());
        }
        finally {
            method.releaseConnection();
        }
        int begin = 0;
        int end = 0;
        begin = content.indexOf(beingtag);
        if (begin < 0 || (end = content.indexOf(endtag, begin + beingtag.length())) < 0) {
            throw new IOException("did not find document which cvturboguid = " + cvturboguid + " on multi nodes " + shards);
        }
        content = content.substring(begin + beingtag.length(), end);
        return content;
    }

    public static void extractFolder(String zipFile) throws ZipException, IOException {
        int BUFFER = 2048;
        File file = new File(zipFile);
        ZipFile zip = new ZipFile(file);
        String newPath = zipFile.substring(0, zipFile.length() - 4);
        new File(newPath).mkdir();
        Enumeration<? extends ZipEntry> zipFileEntries = zip.entries();
        while (zipFileEntries.hasMoreElements()) {
            ZipEntry entry = zipFileEntries.nextElement();
            String currentEntry = entry.getName();
            File destFile = new File(newPath, currentEntry);
            File destinationParent = destFile.getParentFile();
            destinationParent.mkdirs();
            if (!entry.isDirectory()) {
                int currentByte;
                BufferedInputStream is = new BufferedInputStream(zip.getInputStream(entry));
                byte[] data = new byte[BUFFER];
                FileOutputStream fos = new FileOutputStream(destFile);
                BufferedOutputStream dest = new BufferedOutputStream(fos, BUFFER);
                while ((currentByte = is.read(data, 0, BUFFER)) != -1) {
                    dest.write(data, 0, currentByte);
                }
                dest.flush();
                dest.close();
                is.close();
            }
            if (!currentEntry.endsWith(".zip")) continue;
            CommvaultCommon.extractFolder(destFile.getAbsolutePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void metaCoreSanityTest(int id, String node) throws IOException {
        String url = System.getProperty("solr.host.httpschema") + "://" + node + System.getProperty("solr.host.appname") + "/" + EXT_META_CORE + id + "/admin/ping";
        HttpGet method = new HttpGet(url);
        try {
            HttpResponse response = g_client.execute((HttpUriRequest)method);
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new IOException("cannot access " + url + " with exceptione \r\n " + EntityUtils.toString((HttpEntity)response.getEntity()));
            }
        }
        finally {
            method.releaseConnection();
        }
    }

    public static String getPreviewEngineUrl(String cvexchid, String sharedPreviewURL) throws IOException {
        int endTag = (sharedPreviewURL = sharedPreviewURL.substring(sharedPreviewURL.indexOf("&shards=") + "&shards=".length())).indexOf("&");
        if (endTag != -1) {
            sharedPreviewURL = sharedPreviewURL.substring(0, endTag);
        }
        String[] nodes = sharedPreviewURL.split(",");
        int code = 0;
        for (int i = 0; i < cvexchid.length(); ++i) {
            code += cvexchid.charAt(i);
        }
        CommvaultCommon.recordPreviewCores(sharedPreviewURL);
        return nodes[code % nodes.length];
    }

    public static void recordPreviewCores(String shards) throws IOException {
        String curshards = System.getProperty("solr.previewshards");
        if (shards.equalsIgnoreCase(curshards)) {
            return;
        }
        FileOutputStream fo = new FileOutputStream(System.getProperty("solr.data.dir") + File.separator + "previewengine.properties");
        Properties prop = new Properties();
        prop.setProperty("solr.previewshards", shards);
        System.setProperty("solr.previewshards", shards);
        prop.store(fo, null);
        fo.close();
    }

    public static void recordMetaCore(String[] nodes, String shards) throws IOException {
        Properties prop = new Properties();
        if (nodes == null) {
            FileInputStream fio = new FileInputStream(System.getProperty("solr.data.dir") + File.separator + "extmetacore.properties");
            prop.load(fio);
            fio.close();
            Enumeration<?> e = prop.propertyNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String value = prop.getProperty(key);
                if (!key.startsWith("solr.extmeta")) continue;
                CommvaultCommon.metaCoreSanityTest(Integer.parseInt(key.substring("solr.extmeta".length())), value);
                System.setProperty(key, value);
            }
        } else {
            if (shards == null) {
                throw new IOException("do not get shards parameter");
            }
            if (nodes.length != 8) {
                throw new IOException("nodes.length(" + nodes.length + ") != EXT_META_CORE_COUNT(" + 8 + ")");
            }
            for (int i = 0; i < nodes.length; ++i) {
                CommvaultCommon.metaCoreSanityTest(i, nodes[i]);
                prop.setProperty("solr.extmeta" + i, nodes[i]);
                System.setProperty("solr.extmeta" + i, nodes[i]);
            }
            prop.setProperty("shards", shards);
            FileOutputStream fo = new FileOutputStream(System.getProperty("solr.data.dir") + File.separator + "extmetacore.properties");
            prop.store(fo, null);
            fo.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addLocalMetaCore(String[] nodes, int id, String sourceNode, String shards) throws IOException {
        String content;
        HttpResponse response;
        HttpGet method;
        if (sourceNode != null) {
            method = new HttpGet(System.getProperty("solr.host.httpschema") + "://" + sourceNode + System.getProperty("solr.host.appname") + "/admin/cores?action=UNLOAD&core=" + EXT_META_CORE + id);
            try {
                response = g_client.execute((HttpUriRequest)method);
                content = EntityUtils.toString((HttpEntity)response.getEntity());
                if (response.getStatusLine().getStatusCode() != 200) {
                    throw new IOException(content);
                }
            }
            finally {
                method.releaseConnection();
            }
            byte[] buffer = new byte[1024];
            int bytesRead = 0;
            BufferedInputStream inStream = null;
            BufferedOutputStream outStrem = null;
            method = new HttpGet(System.getProperty("solr.host.httpschema") + "://" + sourceNode + System.getProperty("solr.host.appname") + "/admin/removecore.jsp?metacoreprop=true");
            try {
                response = g_client.execute((HttpUriRequest)method);
                if (response.getStatusLine().getStatusCode() != 200) {
                    throw new IOException(EntityUtils.toString((HttpEntity)response.getEntity()));
                }
                ByteArrayOutputStream bao = new ByteArrayOutputStream();
                inStream = new BufferedInputStream(response.getEntity().getContent());
                outStrem = new BufferedOutputStream(bao);
                while ((bytesRead = inStream.read(buffer)) != -1) {
                    outStrem.write(buffer, 0, bytesRead);
                }
                inStream.close();
                outStrem.close();
                ByteArrayInputStream bai = new ByteArrayInputStream(bao.toByteArray());
                Properties prop = new Properties();
                prop.load(bai);
                Enumeration<?> enu = prop.propertyNames();
                while (enu.hasMoreElements()) {
                    String key = (String)enu.nextElement();
                    String value = prop.getProperty(key);
                    System.setProperty(key, value);
                }
                bai.close();
                bao.close();
            }
            finally {
                method.releaseConnection();
            }
            method = new HttpGet(System.getProperty("solr.host.httpschema") + "://" + sourceNode + System.getProperty("solr.host.appname") + "/admin/removecore.jsp?core=ExtMetaIndex" + id);
            try {
                response = g_client.execute((HttpUriRequest)method);
                if (response.getStatusLine().getStatusCode() != 200) {
                    throw new IOException(EntityUtils.toString((HttpEntity)response.getEntity()));
                }
                String zipFilePath = System.getProperty("solr.data.dir") + File.separator + "ExtMetaIndex" + id + ".zip";
                inStream = new BufferedInputStream(response.getEntity().getContent());
                outStrem = new BufferedOutputStream(new FileOutputStream(new File(zipFilePath)));
                while ((bytesRead = inStream.read(buffer)) != -1) {
                    outStrem.write(buffer, 0, bytesRead);
                }
                inStream.close();
                outStrem.close();
                CommvaultCommon.extractFolder(zipFilePath);
            }
            finally {
                method.releaseConnection();
            }
        }
        method = new HttpGet(System.getProperty("solr.host.httpschema") + "://127.0.0.1:" + System.getProperty("solr.port") + System.getProperty("solr.host.appname") + "/admin/cores?action=CREATE&name=" + EXT_META_CORE + id + "&instanceDir=.&dataDir=" + URLEncoder.encode("${solr.data.dir:}/ExtMetaIndex", "ISO-8859-1") + id);
        try {
            response = g_client.execute((HttpUriRequest)method);
            content = EntityUtils.toString((HttpEntity)response.getEntity());
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new IOException(content);
            }
        }
        finally {
            method.releaseConnection();
        }
        for (int i = 0; i < nodes.length; ++i) {
            method = new HttpGet(System.getProperty("solr.host.httpschema") + "://" + nodes[i] + "/push?SUBMITCODE=META_CORE_POSITION&shards=" + shards + "&" + id + "=" + URLEncoder.encode(InetAddress.getLocalHost().getHostName() + ":" + System.getProperty("solr.port"), "ISO-8859-1"));
            try {
                response = g_client.execute((HttpUriRequest)method);
                String content2 = EntityUtils.toString((HttpEntity)response.getEntity());
                if (response.getStatusLine().getStatusCode() == 200) continue;
                throw new IOException(content2);
            }
            finally {
                method.releaseConnection();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addMetaCore(String id, String sourceNode, String shards, String stopforward) throws IOException {
        block17: {
            int i;
            int coreid = Integer.parseInt(id);
            if (coreid < 0 || coreid > 7) {
                throw new IOException("ext meta core id:" + id + " not in range [0, 7]");
            }
            if (shards == null) {
                throw new IOException("For create ext meta core request, shards parameters cannot be null");
            }
            Object[] nodes = shards.split(",");
            for (int i2 = 0; i2 < nodes.length; ++i2) {
                nodes[i2] = ((String)nodes[i2]).toLowerCase();
            }
            Arrays.sort(nodes);
            Object targetNode = nodes[coreid % nodes.length];
            for (i = 0; sourceNode == null && i < nodes.length; ++i) {
                try {
                    CommvaultCommon.metaCoreSanityTest(coreid, (String)nodes[i]);
                    sourceNode = nodes[i];
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (sourceNode != null) {
                for (i = 0; i < nodes.length; ++i) {
                    HttpGet method = new HttpGet(System.getProperty("solr.host.httpschema") + "://" + (String)nodes[i] + "/push?SUBMITCODE=META_CORE_POSITION&shards=" + shards + "&" + id + "=" + URLEncoder.encode((String)sourceNode, "ISO-8859-1"));
                    try {
                        HttpResponse response = g_client.execute((HttpUriRequest)method);
                        String content = EntityUtils.toString((HttpEntity)response.getEntity());
                        if (response.getStatusLine().getStatusCode() == 200) continue;
                        throw new IOException(content);
                    }
                    finally {
                        method.releaseConnection();
                    }
                }
                return;
            }
            String remoteIP = InetAddress.getByName(((String)targetNode).split(":")[0]).getHostAddress();
            if (stopforward == null && !remoteIP.equalsIgnoreCase("127.0.0.1") && !InetAddress.getLocalHost().getHostAddress().equalsIgnoreCase(remoteIP)) {
                String url = System.getProperty("solr.host.httpschema") + "://" + (String)targetNode + "/push?SUBMITCODE=CREATE_META_CORE&id=" + coreid + "&shards=" + shards;
                url = url + "&stopforward=true";
                if (sourceNode != null) {
                    url = url + "&source=" + (String)sourceNode;
                }
                HttpGet method = new HttpGet(url);
                try {
                    HttpResponse response = g_client.execute((HttpUriRequest)method);
                    String content = EntityUtils.toString((HttpEntity)response.getEntity());
                    if (response.getStatusLine().getStatusCode() != 200) {
                        throw new IOException(content);
                    }
                    break block17;
                }
                finally {
                    method.releaseConnection();
                }
            }
            CommvaultCommon.addLocalMetaCore((String[])nodes, coreid, (String)sourceNode, shards);
        }
    }

    public static TreeSet<String> getShardNodes() throws IOException {
        TreeSet<String> nodes = new TreeSet<String>();
        Properties prop = new Properties();
        FileInputStream fi = new FileInputStream(System.getProperty("solr.data.dir") + File.separator + "extmetacore.properties");
        prop.load(fi);
        fi.close();
        String str = prop.getProperty("shards");
        String[] arr = str.split(",");
        for (int i = 0; i < arr.length; ++i) {
            nodes.add(arr[i]);
        }
        return nodes;
    }

    public static String getExtMetaCoreByCoreId(int coreID) throws IOException {
        String node = System.getProperty("solr.extmeta" + coreID);
        if (node == null) {
            CommvaultCommon.recordMetaCore(null, null);
            node = System.getProperty("solr.extmeta" + coreID);
        }
        if (node == null) {
            throw new IOException("cannot get #" + coreID + " meta core");
        }
        return node;
    }

    public static String getExtMetaCoreUrlByCoreId(int coreID) throws IOException {
        return CommvaultCommon.getExtMetaCoreByCoreId(coreID) + System.getProperty("solr.host.appname") + "/" + EXT_META_CORE + coreID;
    }

    public static String getExtMetaCoreUrlByClid(int clid) throws IOException {
        return CommvaultCommon.getExtMetaCoreUrlByCoreId(clid % 8);
    }

    public static boolean isValidCvturboguid(String cvturboguid) {
        int i = cvturboguid.length() - 1;
        while (i > -1) {
            char c;
            if ((c = cvturboguid.charAt(i--)) >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c == '_' || c >= 'a' && c <= 'z') continue;
            return false;
        }
        return true;
    }

    public static String dumpApifAndAfofToSolr(String cvturboguid, String afid, String afof, String ccn, String jid, String clid, String apid, String lnks, String url) throws IOException {
        if (!CommvaultCommon.isValidCvturboguid(cvturboguid)) {
            throw new IOException("for document afid:" + afid + ", afof:" + afof + ", jid:" + jid + " get invalid cvturboguid " + cvturboguid);
        }
        String host = CommvaultCommon.getExtMetaCoreUrlByClid(Integer.parseInt(afid));
        String extcontentid = cvturboguid + "_" + afid + "_" + ccn;
        g_client.getParams().setParameter("http.useragent", (Object)"Test Client");
        StringBuffer strbuf = new StringBuffer();
        strbuf.append("<add>");
        strbuf.append("<doc>");
        strbuf.append("<field name=\"contentid\">" + extcontentid + "</field>");
        strbuf.append("<field name=\"afid\">" + afid + "</field>");
        strbuf.append("<field name=\"jid\">" + jid + "</field>");
        strbuf.append("<field name=\"clid\">" + clid + "</field>");
        strbuf.append("<field name=\"ccn\">" + ccn + "</field>");
        strbuf.append("<field name=\"afof\">" + afof + "</field>");
        strbuf.append("<field name=\"apid\">" + apid + "</field>");
        strbuf.append("<field name=\"cvturboguid\">" + cvturboguid + "</field>");
        if (lnks != null) {
            strbuf.append("<field name=\"lnks\"><![CDATA[" + URLEncoder.encode(lnks, "ISO-8859-1") + "]]></field>");
        }
        if (url != null) {
            strbuf.append("<field name=\"url\"><![CDATA[" + URLEncoder.encode(url, "ISO-8859-1") + "]]></field>");
        }
        strbuf.append("</doc>");
        strbuf.append("</add>");
        HttpPost method = new HttpPost(System.getProperty("solr.host.httpschema") + "://" + host + "/update");
        method.setHeader("Content-Type", "application/x-www-form-urlencoded");
        ArrayList<BasicNameValuePair> nameValuePairs = new ArrayList<BasicNameValuePair>(1);
        nameValuePairs.add(new BasicNameValuePair("stream.body", strbuf.toString()));
        method.setEntity((HttpEntity)new UrlEncodedFormEntity(nameValuePairs));
        int i = 0;
        while (++i < 10) {
            try {
                HttpResponse response = g_client.execute((HttpUriRequest)method);
                String content = EntityUtils.toString((HttpEntity)response.getEntity());
                if (response.getStatusLine().getStatusCode() != 200) {
                    throw new IOException("Request to " + method.getURI() + " get exceptione " + content);
                }
                break;
            }
            catch (SocketException e1) {
                try {
                    Thread.sleep(10L);
                }
                catch (Exception e11) {}
            }
        }
        if (i == 10) {
            throw new IOException("Fail to submit reqeust " + method.getURI() + " with parameter " + strbuf.toString() + " ");
        }
        return extcontentid;
    }

    public static String dumpApifAndAfofToSolr(SolrInputDocument solrDoc) throws IOException {
        if (solrDoc.get("cvturboguid") == null || solrDoc.get("afid") == null || solrDoc.get("afof") == null || solrDoc.get("ccn") == null || solrDoc.get("clid") == null || solrDoc.get("jid") == null || solrDoc.get("apid") == null) {
            return null;
        }
        String lnks = null;
        if (solrDoc.get("lnks") != null) {
            lnks = (String)solrDoc.get("lnks").getFirstValue();
        }
        String url = null;
        if (solrDoc.get("url") != null) {
            url = (String)solrDoc.get("url").getFirstValue();
        }
        return CommvaultCommon.dumpApifAndAfofToSolr((String)solrDoc.get("cvturboguid").getFirstValue(), (String)solrDoc.get("afid").getFirstValue(), (String)solrDoc.get("afof").getFirstValue(), (String)solrDoc.get("ccn").getFirstValue(), (String)solrDoc.get("jid").getFirstValue(), (String)solrDoc.get("clid").getFirstValue(), (String)solrDoc.get("apid").getFirstValue(), lnks, url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpDataToSolr(String hash, byte[] data, File f, String solrUrl) throws IOException {
        try {
            if (extstoresolr == null) {
                throw new IOException("did not find extstoresolr env");
            }
            if (data != null && f != null) {
                throw new IOException("data and input file should not both not null");
            }
            if (data != null) {
                f = File.createTempFile("TempData", "tmp");
                BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(f));
                bos.write(data);
                bos.close();
            }
            boolean localReq = extstoresolr.equalsIgnoreCase(solrUrl);
            String url = solrUrl + "/update/" + EXT_STORE_CORE + "?contentid=" + hash;
            if (localReq) {
                url = url + "&getpath=" + URLEncoder.encode(f.getAbsolutePath(), "UTF-8");
            }
            HttpPost post = new HttpPost(url);
            if (localReq) {
                MultipartEntity entity = new MultipartEntity(HttpMultipartMode.STRICT);
                entity.addPart(new FormBodyPart("fakebody", (ContentBody)new InputStreamBody((InputStream)new ByteArrayInputStream(new byte[5]), "fakestream")));
                post.setEntity((HttpEntity)entity);
            } else {
                ByteArrayInputStream instream = new ByteArrayInputStream(FileUtils.readFileToByteArray((File)f));
                InputStreamEntity entity = new InputStreamEntity((InputStream)instream, -1L);
                entity.setContentType("Content-Type: application/x-www-form-urlencoded");
                post.setEntity((HttpEntity)entity);
            }
            try {
                HttpResponse response = g_client.execute((HttpUriRequest)post);
                String content = EntityUtils.toString((HttpEntity)response.getEntity());
                if (response.getStatusLine().getStatusCode() != 200) {
                    throw new IOException("Request to " + post.getURI() + " get exceptione " + content);
                }
            }
            finally {
                post.releaseConnection();
            }
        }
        finally {
            f.delete();
        }
    }

    public static String dumpImgToDisk(byte[] imgbyte) throws IOException {
        File f;
        String hash = "";
        hash = CommvaultCommon.SHA512HashStr(imgbyte, imgbyte.length);
        String folderPath = solrDataDir + File.separator + "externalfields" + File.separator + "img" + File.separator + File.separator + imgbyte.length + "_" + hash;
        File folder = new File(folderPath);
        if (!folder.exists()) {
            folder.mkdirs();
        }
        if (!(f = new File(folderPath + File.separator + "img")).exists()) {
            BufferedOutputStream bof = new BufferedOutputStream(new FileOutputStream(f));
            bof.write(imgbyte);
            bof.close();
        }
        return "" + imgbyte.length + "_" + hash;
    }

    public static String dumpImageToExternal(byte[] imgbyte, String solrUrl) throws IOException {
        String hash = CommvaultCommon.SHA512HashStr(imgbyte, imgbyte.length);
        if (extCloudstore != null) {
            CommvaultCommon.dumpDataToCloud(null, hash, imgbyte);
        } else if (extstoresolr != null) {
            if (!extstoresolr.equalsIgnoreCase(solrUrl)) {
                solrUrl = extstoresolr.replaceFirst("127.0.0.1:" + System.getProperty("solr.port") + System.getProperty("solr.host.appname"), solrUrl);
            }
            CommvaultCommon.dumpDataToSolr(hash, imgbyte, null, solrUrl);
        } else {
            return CommvaultCommon.dumpImgToDisk(imgbyte);
        }
        return hash;
    }

    public static String dumpImageToExternal(byte[] imgbyte) throws IOException {
        return CommvaultCommon.dumpImageToExternal(imgbyte, extstoresolr);
    }

    public static void dumpFileToDisk(File fZip, String hash, String fieldName, String contentid) throws IOException {
        File f;
        String folderName = solrDataDir + File.separator + "externalfields" + File.separator + fieldName + File.separator + hash + File.separator + "_" + hash;
        File folder = new File(folderName);
        if (!folder.exists()) {
            folder.mkdirs();
        }
        if ((f = new File(folderName + File.separator + fieldName)).exists()) {
            fZip.delete();
        } else {
            fZip.renameTo(f);
        }
        f = new File(folderName + File.separator + contentid);
        if (!f.exists()) {
            f.createNewFile();
        } else {
            f = new File(folderName + File.separator + contentid + "_1");
            f.createNewFile();
        }
    }

    public static void dumpFileToSolr(File fZip, String hash, String fieldName, String contentid, String solrUrl) throws IOException {
        if (extstoresolr == null) {
            throw new IOException("did not find extstoresolr env");
        }
        CommvaultCommon.dumpDataToSolr(hash + "_" + fieldName, null, fZip, solrUrl);
    }

    public static void dumpFileToExternal(File fZip, String hash, String fieldName, String contentid, String remoteSolr) throws IOException {
        if (extstoresolr != null) {
            CommvaultCommon.dumpFileToSolr(fZip, hash, fieldName, contentid, extstoresolr.replaceFirst("127.0.0.1:" + System.getProperty("solr.port") + System.getProperty("solr.host.appname"), remoteSolr));
        } else {
            CommvaultCommon.dumpFileToDisk(fZip, hash, fieldName, contentid);
        }
    }

    private static AWSCredentials getCredentials() {
        return credentials;
    }

    public static void dumpDataToCloud(File f, String hash, byte[] data) throws IOException {
        if (credentials == null) {
            throw new AmazonClientException("Cannot load the credentials from the credential profiles file. Please make sure that your credentials file is at the correct location (~/.aws/credentials), and is in valid format.");
        }
        AmazonS3Client s3 = new AmazonS3Client(credentials);
        s3.setEndpoint(extCloudstore);
        String key = hash;
        if (data != null && f != null) {
            throw new IOException("data and input file should not both not null");
        }
        if (data != null) {
            f = File.createTempFile("TempData", "tmp");
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(f));
            bos.write(data);
            bos.close();
        }
        try {
            long start = System.currentTimeMillis();
            s3.putObject(new PutObjectRequest(bucketName, key, f));
            long end = System.currentTimeMillis();
            PerfCounter.addCounter("uploadToCloud", end - start);
        }
        catch (AmazonServiceException ase) {
            throw new IOException("Caught an AmazonServiceExceptionError Message:    " + ase.getMessage() + "AWS Error Code:   " + ase.getErrorCode() + "Error Type:       " + ase.getErrorType() + "Request ID:       " + ase.getRequestId());
        }
        catch (AmazonClientException ace) {
            throw new IOException("Caught an AmazonServiceExceptionError Message:    " + ace.getMessage());
        }
    }

    public static void dumpFileToExternal(File fZip, String hash, String fieldName, String contentid) throws IOException {
        if (extCloudstore != null) {
            CommvaultCommon.dumpDataToCloud(fZip, hash, null);
        } else if (extstoresolr != null) {
            CommvaultCommon.dumpFileToSolr(fZip, hash, fieldName, contentid, extstoresolr);
        } else {
            CommvaultCommon.dumpFileToDisk(fZip, hash, fieldName, contentid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String _TEMPloadMainAfofAndAfidField(String fieldName, String val, String shards) throws IOException {
        if (!fieldName.equalsIgnoreCase("afof") && !fieldName.equalsIgnoreCase("afid")) {
            return "";
        }
        boolean isAfid = fieldName.equalsIgnoreCase("afid");
        String beingtag = "<";
        beingtag = beingtag + (isAfid ? "int" : "str");
        beingtag = beingtag + " name=\"";
        beingtag = beingtag + (isAfid ? "afid" : "afof");
        beingtag = beingtag + "\">";
        String endtag = "</";
        endtag = endtag + (isAfid ? "int" : "str");
        endtag = endtag + ">";
        String url = System.getProperty("solr.host.httpschema") + "://127.0.0.1:" + System.getProperty("solr.port") + System.getProperty("solr.host.appname") + "/" + "/select?q=" + (isAfid ? "afid" : "afof") + ":" + val + "&rows=1&yliu=true&sort=afid%20desc&fl=" + (isAfid ? "afid" : "afof");
        if (shards != null) {
            url = url + "&shards=" + shards;
        }
        String content = "";
        HttpGet method = new HttpGet(url);
        try {
            HttpResponse response = g_client.execute((HttpUriRequest)method);
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new IOException("cannot access " + url + " with exceptione \r\n " + EntityUtils.toString((HttpEntity)response.getEntity()));
            }
            content = EntityUtils.toString((HttpEntity)response.getEntity());
        }
        finally {
            method.releaseConnection();
        }
        int begin = 0;
        int end = 0;
        begin = content.indexOf(beingtag);
        if (begin < 0 || (end = content.indexOf(endtag, begin + beingtag.length())) < 0) {
            throw new IOException("did not find document afof or afid :" + val + " on local machine" + (shards != null ? " and remote server " + shards : ""));
        }
        content = content.substring(begin + beingtag.length(), end);
        return content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String loadExtMetaField(String fieldName, String pleaseHolder) throws IOException {
        if (!fieldName.equalsIgnoreCase("extafid") && !fieldName.equalsIgnoreCase("extafof")) {
            return "";
        }
        String[] arr = pleaseHolder.split("52208e8d43ab4a64a0e8ffbee23502d3");
        if (arr.length != 2) {
            throw new IOException("invalid place hodler " + pleaseHolder + " for extafid or extafof");
        }
        String cvturboguid = arr[0];
        String clid = arr[1];
        String host = CommvaultCommon.getExtMetaCoreUrlByClid(Integer.parseInt(clid));
        boolean isAfid = fieldName.equalsIgnoreCase("extafid");
        String beingtag = "<";
        beingtag = beingtag + (isAfid ? "int" : "str");
        beingtag = beingtag + " name=\"";
        beingtag = beingtag + (isAfid ? "afid" : "afof");
        beingtag = beingtag + "\">";
        String endtag = "</";
        endtag = endtag + (isAfid ? "int" : "str");
        endtag = endtag + ">";
        String url = System.getProperty("solr.host.httpschema") + "://" + host + "/select?q=contentid:" + cvturboguid + "*&sort=afid%20desc&rows=1&fl=afid,afof";
        String content = "";
        url = url + "&shards=";
        for (int i = 0; i < 8; ++i) {
            url = url + URLEncoder.encode(CommvaultCommon.getExtMetaCoreUrlByClid(i) + ",", "UTF-8");
        }
        HttpGet method = new HttpGet(url);
        try {
            HttpResponse response = g_client.execute((HttpUriRequest)method);
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new IOException("cannot access " + url + " with exceptione \r\n " + EntityUtils.toString((HttpEntity)response.getEntity()));
            }
            content = EntityUtils.toString((HttpEntity)response.getEntity());
        }
        finally {
            method.releaseConnection();
        }
        int begin = 0;
        int end = 0;
        begin = content.indexOf(beingtag);
        if (begin < 0 || (end = content.indexOf(endtag, begin + beingtag.length())) < 0) {
            return "0";
        }
        content = content.substring(begin + beingtag.length(), end);
        return content;
    }

    public static ByteBuffer loadBinField(String name, ByteBuffer buf, boolean loadDiskImg) throws IOException {
        byte[] data = buf.array();
        if (data.length > 1024 || !new String(data).startsWith(ExternalFileTag) && !new String(data).startsWith(REMOTEFileTag)) {
            return buf;
        }
        String hush = new String(data, "ISO-8859-1").substring(ExternalFileTag.length());
        if (new String(data).startsWith(ExternalFileTag)) {
            hush = new String(data, "ISO-8859-1").substring(ExternalFileTag.length());
            if (System.getProperty("solr.previewshards") != null || new File(System.getProperty("solr.data.dir") + File.separator + "previewengine.properties").exists()) {
                if (extCloudstore == null) {
                    return CommvaultCommon.loadBinFieldFromSolr(hush, loadDiskImg, false);
                }
                return CommvaultCommon.loadBinFieldFromCloud(hush, loadDiskImg);
            }
            if (extCloudstore == null) {
                return CommvaultCommon.loadBinFieldFromSolr(hush, loadDiskImg, true);
            }
            return CommvaultCommon.loadBinFieldFromCloud(hush, loadDiskImg);
        }
        if (new String(data).startsWith(REMOTEFileTag)) {
            hush = new String(data, "ISO-8859-1").substring(REMOTEFileTag.length());
            if (extCloudstore == null) {
                return CommvaultCommon.loadBinFieldFromSolr(hush, loadDiskImg, false);
            }
            return CommvaultCommon.loadBinFieldFromCloud(hush, loadDiskImg);
        }
        if (extstoresolr != null) {
            return CommvaultCommon.loadBinFieldFromSolr(hush, loadDiskImg, true);
        }
        return CommvaultCommon.loadBinFieldFromDisk(hush, name, loadDiskImg);
    }

    public static ByteBuffer loadBinFieldFromDisk(String hush, String name, boolean loadDiskImg) throws IOException {
        File f = new File(solrDataDir + File.separator + "externalfields" + File.separator + name + File.separator + Long.parseLong(hush.split("_")[1]) % 10000L + File.separator + hush + File.separator + name);
        ZipInputStream zi = new ZipInputStream(new FileInputStream(f));
        ZipEntry zp = zi.getNextEntry();
        String zeName = zp.getName();
        zi.close();
        if (loadDiskImg && zp.getName().equalsIgnoreCase("PartialObject.bin")) {
            return CommvaultCommon.mergeImageFromDisk(f);
        }
        byte[] data = new byte[(int)f.length()];
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(f));
        bis.read(data);
        bis.close();
        return ByteBuffer.wrap(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getRemoteSolrBinaryField(String hush, boolean isLocalExtStore) throws IOException {
        if (extstoresolr == null) {
            throw new IOException("did not find extstoresolr env");
        }
        String beingtag = "<str name=\"bindoc\">";
        String endtag = "</str>";
        String content = "";
        String url = extstoresolr + "/select?q=contentid:" + hush + "&fl=bindoc";
        if (!isLocalExtStore) {
            String curshards = System.getProperty("solr.previewshards");
            if (curshards == null) {
                Properties prop = new Properties();
                FileInputStream fio = new FileInputStream(System.getProperty("solr.data.dir") + File.separator + "previewengine.properties");
                prop.load(fio);
                fio.close();
                curshards = prop.getProperty("solr.previewshards");
                System.setProperty("solr.previewshards", curshards);
            }
            url = url + "&shards=" + curshards.replaceAll(System.getProperty("solr.host.appname"), System.getProperty("solr.host.appname") + "/extstore");
            url = url + ",127.0.0.1:" + System.getProperty("solr.port") + System.getProperty("solr.host.appname") + "/" + EXT_STORE_CORE;
        }
        HttpGet method = new HttpGet(url);
        try {
            HttpResponse response = g_client.execute((HttpUriRequest)method);
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new IOException("cannot access " + url + " with exceptione \r\n " + EntityUtils.toString((HttpEntity)response.getEntity()));
            }
            content = EntityUtils.toString((HttpEntity)response.getEntity());
        }
        finally {
            method.releaseConnection();
        }
        int begin = 0;
        int end = 0;
        begin = content.indexOf(beingtag);
        if (begin < 0 || (end = content.indexOf(endtag, begin + beingtag.length())) < 0) {
            throw new IOException("did not find document " + hush + " on remote server " + extstoresolr);
        }
        content = content.substring(begin + beingtag.length(), end);
        return content;
    }

    public static ByteBuffer loadBinFieldFromCloud(String hush, boolean loadDiskImg) throws IOException {
        if (credentials == null) {
            throw new AmazonClientException("Cannot load the credentials from the credential profiles file. Please make sure that your credentials file is at the correct location (~/.aws/credentials), and is in valid format.");
        }
        byte[] data = null;
        try {
            AmazonS3Client s3 = new AmazonS3Client(credentials);
            String key = hush.split("_")[0];
            s3.setEndpoint(extCloudstore);
            S3Object object = s3.getObject(new GetObjectRequest(bucketName, key));
            data = new byte[(int)object.getObjectMetadata().getInstanceLength()];
            BufferedInputStream bis = new BufferedInputStream((InputStream)object.getObjectContent());
            bis.read(data);
            bis.close();
        }
        catch (AmazonServiceException ase) {
            throw new IOException("Caught an AmazonServiceExceptionError Message:    " + ase.getMessage() + "AWS Error Code:   " + ase.getErrorCode() + "Error Type:       " + ase.getErrorType() + "Request ID:       " + ase.getRequestId());
        }
        catch (AmazonClientException ace) {
            throw new IOException("Caught an AmazonServiceExceptionError Message:    " + ace.getMessage());
        }
        ZipInputStream zi = new ZipInputStream(new ByteArrayInputStream(data));
        ZipEntry zp = zi.getNextEntry();
        String zeName = zp.getName();
        if (loadDiskImg && zeName.equalsIgnoreCase("PartialObject.bin")) {
            ObjectInputStream objInStream = new ObjectInputStream(zi);
            Object obj = null;
            try {
                obj = objInStream.readObject();
            }
            catch (ClassNotFoundException e) {
                throw new IOException(e);
            }
            finally {
                objInStream.close();
                zi.close();
            }
            return CommvaultCommon.mergeImageFromCloud((String)obj);
        }
        return ByteBuffer.wrap(data);
    }

    public static ByteBuffer loadBinFieldFromSolr(String hush, boolean loadDiskImg, boolean isLocalExtStore) throws IOException {
        byte[] data = Base64.base64ToByteArray(CommvaultCommon.getRemoteSolrBinaryField(hush, isLocalExtStore));
        ZipInputStream zi = new ZipInputStream(new ByteArrayInputStream(data));
        ZipEntry zp = zi.getNextEntry();
        String zeName = zp.getName();
        if (loadDiskImg && zeName.equalsIgnoreCase("PartialObject.bin")) {
            ObjectInputStream objInStream = new ObjectInputStream(zi);
            Object obj = null;
            try {
                obj = objInStream.readObject();
            }
            catch (ClassNotFoundException e) {
                throw new IOException(e);
            }
            finally {
                objInStream.close();
                zi.close();
            }
            return CommvaultCommon.mergeImageFromSolr((String)obj, isLocalExtStore);
        }
        return ByteBuffer.wrap(data);
    }

    public static String getImagefromCloud(String hush) throws IOException {
        String beingtag = "<str name=\"bindoc\">";
        String endtag = "</str>";
        if (credentials == null) {
            throw new AmazonClientException("Cannot load the credentials from the credential profiles file. Please make sure that your credentials file is at the correct location (~/.aws/credentials), and is in valid format.");
        }
        byte[] data = null;
        try {
            AmazonS3Client s3 = new AmazonS3Client(credentials);
            s3.setEndpoint(extCloudstore);
            S3Object object = s3.getObject(new GetObjectRequest(bucketName, hush));
            data = new byte[(int)object.getObjectMetadata().getInstanceLength()];
            BufferedInputStream bis = new BufferedInputStream((InputStream)object.getObjectContent());
            bis.read(data);
            bis.close();
        }
        catch (AmazonServiceException ase) {
            throw new IOException("Caught an AmazonServiceExceptionError Message:    " + ase.getMessage() + "AWS Error Code:   " + ase.getErrorCode() + "Error Type:       " + ase.getErrorType() + "Request ID:       " + ase.getRequestId());
        }
        catch (AmazonClientException ace) {
            throw new IOException("Caught an AmazonServiceExceptionError Message:    " + ace.getMessage());
        }
        String tstr = Base64.byteArrayToBase64(data, 0, data.length);
        return tstr;
    }

    public static ByteBuffer mergeImageFromCloud(String content) throws IOException {
        int begin = 0;
        while ((begin = content.indexOf(EXTERNAL_IMG_START_TAG)) != -1) {
            int end = content.indexOf(EXTERNAL_IMG_END_TAG, begin);
            String temp = content.substring(begin, end + EXTERNAL_IMG_END_TAG.length());
            String hush = temp.replaceFirst(EXTERNAL_IMG_START_TAG, "").replaceFirst(EXTERNAL_IMG_END_TAG, "");
            String tstr = CommvaultCommon.getImagefromCloud(hush);
            content = content.replaceFirst(temp, tstr);
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream ooStream = new ObjectOutputStream(bos);
        ooStream.writeObject(content);
        ooStream.close();
        bos.close();
        byte[] tbuf = bos.toByteArray();
        bos = new ByteArrayOutputStream();
        ZipOutputStream zo = new ZipOutputStream(bos);
        zo.putNextEntry(new ZipEntry("Object.bin"));
        zo.write(tbuf);
        zo.close();
        bos.close();
        tbuf = bos.toByteArray();
        return ByteBuffer.wrap(tbuf);
    }

    public static ByteBuffer mergeImageFromSolr(String content, boolean isLocalExtStore) throws IOException {
        int begin = 0;
        while ((begin = content.indexOf(EXTERNAL_IMG_START_TAG, begin)) != -1) {
            int end = content.indexOf(EXTERNAL_IMG_END_TAG, begin);
            String temp = content.substring(begin, end + EXTERNAL_IMG_END_TAG.length());
            String hush = temp.replaceFirst(EXTERNAL_IMG_START_TAG, "").replaceFirst(EXTERNAL_IMG_END_TAG, "");
            String tstr = CommvaultCommon.getRemoteSolrBinaryField(hush, isLocalExtStore);
            content = content.replaceFirst(Pattern.quote(temp), tstr);
            begin += tstr.length();
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream ooStream = new ObjectOutputStream(bos);
        ooStream.writeObject(content);
        ooStream.close();
        bos.close();
        byte[] tbuf = bos.toByteArray();
        bos = new ByteArrayOutputStream();
        ZipOutputStream zo = new ZipOutputStream(bos);
        zo.putNextEntry(new ZipEntry("Object.bin"));
        zo.write(tbuf);
        zo.close();
        bos.close();
        tbuf = bos.toByteArray();
        return ByteBuffer.wrap(tbuf);
    }

    public static ByteBuffer mergeImageFromDisk(File outsideFile) throws IOException {
        ZipInputStream zi = new ZipInputStream(new BufferedInputStream(new FileInputStream(outsideFile)));
        zi.getNextEntry();
        ObjectInputStream objInStream = new ObjectInputStream(zi);
        Object obj = null;
        try {
            obj = objInStream.readObject();
            zi.close();
        }
        catch (ClassNotFoundException e) {
            zi.close();
            throw new IOException(e);
        }
        objInStream.close();
        String result = (String)obj;
        int begin = 0;
        while ((begin = result.indexOf(EXTERNAL_IMG_START_TAG)) != -1) {
            int end = result.indexOf(EXTERNAL_IMG_END_TAG, begin);
            String temp = result.substring(begin, end + EXTERNAL_IMG_END_TAG.length());
            String hush = temp.replaceFirst(EXTERNAL_IMG_START_TAG, "").replaceFirst(EXTERNAL_IMG_END_TAG, "");
            File f = new File(solrDataDir + File.separator + "externalfields" + File.separator + "img" + File.separator + Long.parseLong(hush.split("_")[1]) % 10000L + File.separator + hush + File.separator + "img");
            byte[] ba = new byte[(int)f.length()];
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(f));
            bis.read(ba);
            bis.close();
            String tstr = Base64.byteArrayToBase64(ba, 0, ba.length);
            result = result.replaceFirst(temp, tstr);
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream ooStream = new ObjectOutputStream(bos);
        ooStream.writeObject(result);
        ooStream.close();
        bos.close();
        byte[] tbuf = bos.toByteArray();
        bos = new ByteArrayOutputStream();
        ZipOutputStream zo = new ZipOutputStream(bos);
        zo.putNextEntry(new ZipEntry("Object.bin"));
        zo.write(tbuf);
        zo.close();
        bos.close();
        tbuf = bos.toByteArray();
        return ByteBuffer.wrap(tbuf);
    }

    public static String getHtmlFromPreviewStr(String previewStr) throws IOException {
        boolean isImg;
        if (previewStr == null) {
            return "no preview";
        }
        int previewLength = 0x100000;
        boolean isEmail = previewStr.indexOf(AttachmentStartTag.substring(1, AttachmentStartTag.length() - 1)) != -1;
        boolean isDicom = previewStr.indexOf(DicomSummaryStartTag.substring(1, DicomSummaryStartTag.length() - 1)) != -1;
        boolean bl = isImg = previewStr.indexOf("src=\"data:image/") != -1;
        if (previewStr.indexOf(ZIPPED_BINARY_FILE_TAG) != -1) {
            File fPreview = CommvaultCommon.zippedBinaryToTextFile(previewStr);
            previewStr = null;
            StringBuilder strbuf = new StringBuilder();
            InputStreamReader fr = new InputStreamReader((InputStream)new FileInputStream(fPreview), "UTF-8");
            char[] cbuf = new char[1024];
            int len = 0;
            int totalLen = 0;
            while ((len = fr.read(cbuf)) != -1) {
                if (!(isEmail || isDicom || isImg)) {
                    String tempStr = new String(cbuf);
                    isEmail = tempStr.indexOf(AttachmentStartTag.substring(1, AttachmentStartTag.length() - 1)) != -1;
                    isDicom = tempStr.indexOf(DicomSummaryStartTag.substring(1, DicomSummaryStartTag.length() - 1)) != -1;
                    isImg = tempStr.indexOf("src=\"data:image/") != -1;
                }
                strbuf.append(cbuf, 0, len);
                if (isEmail || isDicom || isImg || (totalLen += len) <= previewLength) continue;
            }
            fr.close();
            fPreview.delete();
            previewStr = strbuf.toString();
        } else if (!(isEmail || isDicom || isImg || previewStr.length() <= previewLength)) {
            previewStr = previewStr.substring(0, previewLength);
        }
        return previewStr;
    }

    public static String convertEscapedHtml(String strHtml) {
        StringBuilder buffer = new StringBuilder();
        char[] chararr = strHtml.toCharArray();
        int i = 0;
        int deadloop = 0;
        while (i < chararr.length && ++deadloop <= chararr.length) {
            if (chararr[i] == '&' && i + 4 < chararr.length && chararr[i + 1] == 'a' && chararr[i + 2] == 'm' && chararr[i + 3] == 'p' && chararr[i + 4] == ';') {
                chararr[i + 4] = 38;
                i += 4;
                continue;
            }
            if (chararr[i] == '&' && i + 5 < chararr.length && chararr[i + 1] == 'q' && chararr[i + 2] == 'u' && chararr[i + 3] == 'o' && chararr[i + 4] == 't' && chararr[i + 5] == ';') {
                buffer.append('\"');
                i += 6;
                continue;
            }
            if (chararr[i] == '&' && i + 3 < chararr.length && chararr[i + 1] == 'g' && chararr[i + 2] == 't' && chararr[i + 3] == ';') {
                buffer.append('>');
                i += 4;
                continue;
            }
            if (chararr[i] == '&' && i + 3 < chararr.length && chararr[i + 1] == 'l' && chararr[i + 2] == 't' && chararr[i + 3] == ';') {
                buffer.append('<');
                i += 4;
                continue;
            }
            if (chararr[i] == 'b' && i + 5 < chararr.length && chararr[i + 1] == 'o' && chararr[i + 2] == 'd' && chararr[i + 3] == 'y' && chararr[i + 4] == '\\' && chararr[i + 5] == '{') {
                buffer.append("body_\\{");
                i += 6;
                continue;
            }
            if (chararr[i] == '<' && i + 7 < chararr.length && chararr[i + 1] == 't' && chararr[i + 2] == 'i' && chararr[i + 3] == 't' && chararr[i + 4] == 'l' && chararr[i + 5] == 'e' && chararr[i + 6] == '/' && chararr[i + 7] == '>') {
                i += 8;
                continue;
            }
            if (chararr[i] == '&' && i + 4 < chararr.length && chararr[i + 1] == '#' && chararr[i + 2] == '1' && chararr[i + 3] == '3' && chararr[i + 4] == ';') {
                i += 5;
                continue;
            }
            buffer.append(chararr[i++]);
        }
        return buffer.toString();
    }

    public static String writeSummaryhtml(ByteBuffer buf) throws IOException {
        ZipInputStream zi = new ZipInputStream(new ByteArrayInputStream(buf.array()));
        zi.getNextEntry();
        ObjectInputStream objInStream = new ObjectInputStream(zi);
        Object obj = null;
        try {
            obj = objInStream.readObject();
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e);
        }
        objInStream.close();
        zi.close();
        String result = (String)obj;
        return CommvaultCommon.convertEscapedHtml(CommvaultCommon.getHtmlFromPreviewStr(result));
    }

    static {
        bucketName = System.getProperty("aws.bucketname");
        PoolingClientConnectionManager connManager = (PoolingClientConnectionManager)g_client.getConnectionManager();
        connManager.setDefaultMaxPerRoute(64);
        connManager.setMaxTotal(512);
        if (credentials == null) {
            try {
                long start = System.currentTimeMillis();
                credentials = new BasicAWSCredentials(System.getProperty("aws.username"), System.getProperty("aws.password"));
                long end = System.currentTimeMillis();
                PerfCounter.addCounter("LoginAmazon", end - start);
            }
            catch (Exception e) {
                credentials = null;
            }
        }
        extstoresolr = (System.getProperty("solr.host.httpschema") == null ? "http" : System.getProperty("solr.host.httpschema")) + "://127.0.0.1:" + System.getProperty("solr.port") + (System.getProperty("solr.host.appname") == null ? "/solr" : System.getProperty("solr.host.appname")) + "/" + EXT_STORE_CORE + "/";
        solrDataDir = System.getProperty("solr.data.dir");
        extCloudstore = System.getProperty("cloud.src");
        fakeFile = new File(System.getProperty("java.io.tmpdir") + File.separator + "DoNotDelete.txt");
    }
}

