/*
 * Decompiled with CFR 0.152.
 */
package com.commvault.perfutil;

import com.commvault.perfutil.ILogger;
import com.commvault.perfutil.LogConfig;
import com.commvault.perfutil.LoggerFactory;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;

public class PerfCounter {
    private static ILogger logger;
    private static boolean enable;
    private int rem = 0;
    private static Map<String, Integer> remainder;
    private static Map<String, ArrayList<Long>> counts;
    private static Map<String, List<Long>> stats;
    private static long printInterval;
    private static Timer timer;
    private static Object lock;
    static int counter;

    public static long getPrintInterval() {
        return printInterval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void addCounter(String name, Long value) {
        if (enable) {
            if (stats.get(name) == null) {
                ArrayList<Long> lst = new ArrayList<Long>();
                lst.add(value);
                stats.put(name, lst);
                ArrayList<Long> lst1 = new ArrayList<Long>(2);
                lst1.add(0, 0L);
                lst1.add(1, 0L);
                counts.put(name, lst1);
                remainder.put(name, 0);
            } else {
                List<Long> list = stats.get(name);
                synchronized (list) {
                    stats.get(name).add(value);
                }
            }
        }
    }

    public static void init(List<String> counterList) {
        timer = new Timer();
        for (String string : counterList) {
        }
        lock = new Object();
    }

    public static synchronized List<List<Long>> removeCounter(String name) {
        if ("*".equalsIgnoreCase(name)) {
            Set<String> keySet = stats.keySet();
            ArrayList<String> list = new ArrayList<String>(stats.keySet());
            return PerfCounter.removeCounter(list);
        }
        ArrayList<List<Long>> ls = new ArrayList<List<Long>>();
        List<Long> lst = stats.remove(name);
        ls.add(lst);
        return ls;
    }

    public static synchronized List<List<Long>> removeCounter(List<String> names) {
        ArrayList<List<Long>> countsList = new ArrayList<List<Long>>();
        for (String name : names) {
            stats.remove(name);
            countsList.add(counts.remove(name));
        }
        return countsList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void Reset(String name) {
        List<Long> list = stats.get(name);
        synchronized (list) {
            stats.put(name, new ArrayList());
            ArrayList<Long> lst1 = new ArrayList<Long>(2);
            lst1.add(0, 0L);
            lst1.add(1, 0L);
            counts.put(name, lst1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateCounter(String name, long end) {
        List<Long> list = stats.get(name);
        synchronized (list) {
            stats.get(name).add(end);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printStats() {
        List<Long> lst = null;
        for (String name : stats.keySet()) {
            int agg = 0;
            List<Long> list = stats.get(name);
            synchronized (list) {
                lst = stats.get(name);
                stats.put(name, new ArrayList());
            }
            for (int i = 0; i < lst.size(); ++i) {
                agg = (int)((long)agg + lst.get(i));
            }
            ArrayList<Long> countlst = counts.get(name);
            long totalcount = countlst.get(0) + (long)lst.size();
            remainder.put(name, (agg += remainder.get(name).intValue()) % 1000);
            long totalagg = countlst.get(1) + (long)(agg / 1000);
            long avg = (countlst.get(1) * 1000L + (long)agg) / totalcount;
            countlst.add(0, totalcount);
            countlst.add(1, totalagg);
            logger.Error("", "[%s]: Total:[%d sec] Avg:[%d ms] Count:[%d]", name, counts.get(name).get(1), avg, counts.get(name).get(0));
        }
    }

    public static void setprintInterval(long newprintInterval) {
        printInterval = newprintInterval;
    }

    public static void startPrint(String name) {
        Timer timer = new Timer();
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                PerfCounter.printStats();
            }
        }, 50000L, printInterval);
    }

    public static void stopPrint() {
        if (timer != null) {
            timer.cancel();
        }
    }

    static {
        String bolValue;
        File dir;
        String name;
        logger = null;
        enable = true;
        remainder = new HashMap<String, Integer>();
        String loc = System.getProperty("perfCounterLogLocation");
        if (loc == null) {
            loc = "./perfCounterLogs/perfCounterLog";
        }
        if ((name = System.getProperty("AppName")) == null) {
            name = "performanceUtility";
        }
        if (!(dir = new File(loc)).exists()) {
            try {
                dir.mkdir();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        LogConfig config = new LogConfig(loc, name);
        if (logger == null) {
            logger = LoggerFactory.createLogger(config);
        }
        if ((bolValue = System.getProperty("ebablePerfCounterLogging")) != null) {
            try {
                enable = Boolean.parseBoolean(bolValue);
            }
            catch (Exception e) {
                enable = true;
            }
        }
        if (enable) {
            Timer timer = new Timer();
            timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    PerfCounter.printStats();
                }
            }, 10L, 300000L);
        }
        counts = new HashMap<String, ArrayList<Long>>();
        stats = new HashMap<String, List<Long>>();
        printInterval = 300000L;
        lock = null;
        counter = 0;
    }
}

