/*
 * Decompiled with CFR 0.152.
 */
package com.commvault.perfutil;

import com.commvault.perfutil.CVLogFormat;
import com.commvault.perfutil.ILogger;
import com.commvault.perfutil.LogConfig;
import java.io.IOException;
import java.util.Hashtable;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LoggerImpl
implements ILogger {
    private Logger logger;
    private CVLogFormat formatter;
    public static Hashtable<ILogger.LoggerLevel, Level> logLevelMapping = new Hashtable();

    protected LoggerImpl(LogConfig config) {
        this.logger = Logger.getLogger(config.getApplicationName());
        if (this.logger.getHandlers().length == 0) {
            FileHandler fh = null;
            String completeFileLoc = null;
            try {
                completeFileLoc = config.getLogFileLoc() != null && !config.getLogFileLoc().equals("") ? config.getLogFileLoc() + "\\" + config.getApplicationName() : config.getApplicationName();
                if (!completeFileLoc.endsWith(".log")) {
                    completeFileLoc = completeFileLoc + ".log";
                }
                fh = new FileHandler(completeFileLoc, config.getLogFileSizeLimit(), config.getNumberOfLogFiles(), true);
                this.logger.addHandler(fh);
                this.logger.setLevel(logLevelMapping.get((Object)ILogger.LoggerLevel.LOG_INFO));
                this.formatter = new CVLogFormat();
                fh.setFormatter(this.formatter);
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    protected void setLogLevel(Level logLevel) {
        this.logger.setLevel(logLevel);
    }

    @Override
    public void Debug(String function, String umessage, Object ... argList) {
        this.logMessage(function, umessage, 0.0, this.getDefaultLevel(), argList);
    }

    @Override
    public void DebugJob(String function, double jobID, String umessage, Object ... argList) {
        this.logMessage(function, umessage, jobID, this.getDefaultLevel(), argList);
    }

    @Override
    public void DebugJob(ILogger.LoggerLevel debugLevel, String function, double jobID, String umessage, Object ... argList) {
        this.logMessage(function, umessage, jobID, debugLevel, argList);
    }

    @Override
    public void DebugLvl(String function, ILogger.LoggerLevel debugLevel, String umessage, Object ... argList) {
        this.logMessage(function, umessage, 0.0, debugLevel, argList);
    }

    @Override
    public void DebugLvl(String function, ILogger.LoggerLevel debugLevel, double jobId, String umessage, Object ... argList) {
        this.logMessage(function, umessage, jobId, debugLevel, argList);
    }

    @Override
    public void Error(String function, String umessage, Object ... argList) {
        this.logMessage(function, umessage, 0.0, ILogger.LoggerLevel.LOG_ERROR, argList);
    }

    @Override
    public void debug(String umessage, Object ... argList) {
        this.logMessage(null, umessage, 0.0, this.getDefaultLevel(), argList);
    }

    @Override
    public void debugLvl(ILogger.LoggerLevel debugLevel, String umessage, Object ... argList) {
        this.logMessage(null, umessage, 0.0, debugLevel, argList);
    }

    @Override
    public void debugLvl(ILogger.LoggerLevel debugLevel, double jobID, String umessage, Object ... argList) {
        this.logMessage(null, umessage, jobID, debugLevel, argList);
    }

    @Override
    public void error(String umessage, Object ... argList) {
        this.logMessage(null, umessage, 0.0, ILogger.LoggerLevel.LOG_ERROR, argList);
    }

    private void logMessage(String functionName, String umessage, double jobID, ILogger.LoggerLevel debugLevel, Object ... argList) {
        if (functionName == null || functionName.equals("")) {
            functionName = "#####";
        }
        this.logger.log(logLevelMapping.get((Object)debugLevel), String.format("%s  %s::%s", jobID == 0.0 ? "###" : String.valueOf(jobID), functionName, String.format(umessage, argList)));
    }

    private ILogger.LoggerLevel getDefaultLevel() {
        Level defaultLevel = this.logger.getLevel();
        if (defaultLevel == Level.OFF) {
            return ILogger.LoggerLevel.LOG_DISABLE;
        }
        if (defaultLevel == Level.INFO) {
            return ILogger.LoggerLevel.LOG_INFO;
        }
        if (defaultLevel == Level.FINER) {
            return ILogger.LoggerLevel.LOG_DETAILS;
        }
        if (defaultLevel == Level.FINEST) {
            return ILogger.LoggerLevel.LOG_VERBOSE;
        }
        if (defaultLevel == Level.SEVERE) {
            return ILogger.LoggerLevel.LOG_ERROR;
        }
        return ILogger.LoggerLevel.LOG_INFO;
    }

    static {
        logLevelMapping.put(ILogger.LoggerLevel.LOG_DETAILS, Level.FINER);
        logLevelMapping.put(ILogger.LoggerLevel.LOG_DISABLE, Level.OFF);
        logLevelMapping.put(ILogger.LoggerLevel.LOG_ERROR, Level.SEVERE);
        logLevelMapping.put(ILogger.LoggerLevel.LOG_INFO, Level.INFO);
        logLevelMapping.put(ILogger.LoggerLevel.LOG_VERBOSE, Level.FINEST);
    }
}

