<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.vmsJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.vms"></cv:cvMessages>
</script>
<fmt:bundle basename="localization.vms">
	<h1 class="clear-both pageTitle">
		{{headerText}} {{name}}
	</h1>
	<span class=" serverMessage {{serverMessage.type}}">{{serverMessage.message}}</span>
	<span class="vmListSecHeader"></span>
	<div>
		<div class="group filter-options">
			<div class="vm-status-period-span" id="statusPeriodSpan" data-ng-click="changeDateOption('range')">
				<span class="time-range-select-wrapper">
					<label id="statusSelector" class="select-label" for="time-range-select"><cv:msg key="label.timeRange" bundle="vms"/>
						<select class="status-select" id="time-range-select" data-ng-model="timeRangeOption"
							data-ng-options="option as option.label for option in timeRangeOptions" data-ng-change="onTimeRangeChange()">
						</select>
					</label>
				</span>
				<span id="time-range-wrapper" data-ng-if="timeRangeOption == timeRangeOptions[timeRangeOptions.length - 1]">
					<span class=" fromLabel"><cv:msg key="label.from" bundle="vms"/></span>
					<input class="date-box" type="text" data-ng-model="timeRange.fromDate" data-uib-datepicker-popup="yyyy-MM-dd" is-open="datepicker.from" datepicker-options="dateOptions" close-text="Close" />
			      	<span class="input-group-btn ">
			        	<button id="vmList_button_#0309" type="button" class="btn btn-default" data-ng-click="open('from')"><i class="glyphicon glyphicon-calendar"></i></button> 
			      	</span>
			      	<span class=" fromLabel"><cv:msg key="label.to" bundle="vms"/></span>
			      	<input class="date-box" type="text" data-ng-model="timeRange.toDate" data-uib-datepicker-popup="yyyy-MM-dd" is-open="datepicker.to" datepicker-options="dateOptions" close-text="Close" />
			      	<span class=" input-group-btn">
			        	<button id="vmList_button_#6887" type="button" class="btn btn-default" data-ng-click="open('to')"><i class="glyphicon glyphicon-calendar"></i></button> 
      				</span>
		     		<button id="vmList_button_#2251" type="button" class="btn btn-default" data-ng-click="regenerate()"><cv:msg key="Submit" bundle="messages"/></button> 
				</span>
	    </div>
	    <div data-ng-show="vmList.length!=0" class="search-widget-wrapper  search-filter" style="margin-top: 2px">
			<input type="search" class="search-field" placeholder="Search" title="Search" id="search-field"
			data-ng-model="searchText" data-ng-change="searchTextChange()"/><span data-ng-click="searchText='';searchTextChange();"
						class="form-control-clear glyphicon glyphicon-remove form-control-feedback"
						title="<cv:msg key='label.clear' bundle='navJs' />"></span>
		</div>
	    <label id="statusSelector" class="clear-both vm-status-selector select-label"><cv:msg key="label.status" bundle="vms"/>
			<select class="status-select" data-ng-model="currStatus" data-ng-options="status.name for status in statusArr" data-ng-change="statusChanged()"></select></label>
		<label data-ng-show="showCollectionFilter" class="vm-collection-selector select-label"><cv:msg key="header.vmGroup" bundle="vmsJs"/>
			<select class="collection-select" data-ng-model="currCollection" data-ng-options="collection.name for collection in collectionArr" data-ng-change="collectionChanged()"></select></label>
			<%-- &nbsp;<cv:msg key="status.vms"  bundle="vms"/> --%>
	</div>
	<div data-ng-if="vmList.length!=0">
		<div data-ng-if="vmList.length!=0" data-ng-controller="chartCtrl">
			<highchart ng-hide="hideChart" id="chart1" config="chartConfig" class="span9 highchart-wrapper" ></highchart>
	    </div>
	    <br>
		<br>
		<div id="vmsTable" show-empty-msg='<cv:msg key="No_vms_available" bundle="vms"/>' class="grid-style bottom-grid-fix" data-ui-grid="gridOptions" data-ui-grid-pagination data-ui-grid-auto-resize data-cv-ui-grid-resize></div>
		</div>
	</div>
	<div class="horz-center extra-spacing" data-ng-if="vmList.length==0">
		{{noVMsFoundText}}
	</div>
</fmt:bundle>