<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.restore"></cv:cvMessages>
	<cv:cvMessages bundle="localization.restoreJs"></cv:cvMessages>
</script>
<div class="vmFullRestoreRedHatOpenShift">
	<div class="setup-content padding-top-0">
		<div>
			<span class="{{vmFullOpenShift.serverMessageTop.type}} serverMessage">{{vmFullOpenShift.serverMessageTop.message}}</span>
			<div class="global-options">
				<div>
					<div>
						<label for="serverId" class="select-label restorePathLabel">
							<cv:msg key="label.fsServer" bundle="restore"></cv:msg>
							<div class="company-multi-select" data-ng-if="!isOutOfPlaceRestore">
								<p class="no-margin">{{vmFullOpenShift.restoreData.globalOptions.serverDetails.clientName}}</p>
							</div>
							<select id="serverId" name="serverId"
								data-ng-model="vmFullOpenShift.restoreData.globalOptions.serverDetails"
								data-ng-options="server.name for server in vmFullOpenShift.servers" required
								data-ng-change="vmFullOpenShift.destinationServerChanged()"
								data-ng-if="isOutOfPlaceRestore">
							</select>
						</label>
					</div>
					<div>
						<label for="destinationProxy" class="select-label restorePathLabel">
							<cv:msg key="label.proxy" bundle="restore"></cv:msg>
							<select id="destinationProxy" name="destinationProxy"
								data-ng-required="true"
								data-ng-model="vmFullOpenShift.restoreData.globalOptions.proxy"
								data-ng-options="ds as ds.clientName for ds in vmFullOpenShift.restoreData.globalOptions.proxyList track by (ds.clientName|lowercase)">
							</select>
						</label>
					</div>
				</div>
<%-- 				<div data-ng-show="!vmFullOpenShift.isEndUser"
					data-ng-disabled="vmFullOpenShift.restoreData.globalOptions.disableInPlaceRestore">
					<input name="showInPlaceRestore" id="showInPlaceRestore" type="checkbox" data-ng-model="vmFullOpenShift.restoreData.globalOptions.inPlaceRestore"
						data-ng-change="vmFullOpenShift.populateInPlaceOptions()" /> 
					<label for="showInPlaceRestore" class="overwriteLabel">
						<cv:msg	key="label.inPlaceRestore" bundle="restore" />
					</label>
				</div> --%>
				<%-- <div>
					<input name="overwrite"	id="overwrite" type="checkbox" data-ng-model="vmFullOpenShift.restoreData.globalOptions.overwrite"
					data-ng-change="vmFullOpenShift.overwriteOptionChanged()"> 
					<label for="overwrite">
						<cv:msg	key="warning.overwrite" bundle="restore" />
					</label>
				</div> --%>
			</div>
			<div class="local-options">
				<div class="error" data-ng-show="cv.vmFullRestoreForm.getAttempted() && vmFullOpenShift.showSomeVmsInvalidWarning()">
					<cv:msg	key="error.allApplicationOptions" bundle="restore" />
				</div>
				<div>
					<ul class="vm-full-restore-list">
						<li data-ng-if="::vmFullOpenShift.restoreData.multipleVMsSelected">
							<a class="btn font-weight-bold"
							data-ng-click="vmFullOpenShift.displayAllVmOptions()"
							data-ng-class="{'selected-value': vmFullOpenShift.restoreData.isAll()}">
								<cv:msg key="label.allApplications" bundle="restore" />
							</a>
						</li>
						<li data-ng-repeat="vmOptions in vmFullOpenShift.restoreData.vmOptionsList">
							<a class="btn" data-ng-click="vmFullOpenShift.displayVmOptions(vmOptions)"
								title="{{vmOptions.browseData.displayName}}"
								data-ng-class="{'selected-value': vmFullOpenShift.restoreData.vmOptions == vmOptions}">
								{{vmOptions.browseData.displayName}}
							</a>
							<span class="error"data-ng-show="cv.vmFullRestoreForm.getAttempted() && !vmFullOpenShift.isVmOptionValid(vmOptions)">*</span>
						</li>
					</ul>
				</div>
				<form name="vmFullRestoreForm" novalidate data-cv-submit="vmFullOpenShift.restoreVms()" autocomplete="off"
					class='vm-full-restore-form form-horizontal bootstrap-wrapper padding-bottom-0'>
					<div class="{{isOutOfPlaceRestore ? '' : 'in-place-restore'}}">
						<div id="perVmOptions" class="mainFormContent hyperv-restore-form-content">
							<div class="{{vmFullOpenShift.serverMessage.type}}" data-ng-bind="vmFullOpenShift.serverMessage.message"></div>
							<div class="form-group">
								<div data-ng-if="!vmFullOpenShift.restoreData.isAll()">
									<div class="col-xs-12">
										<label for="displayName">
											<cv:msg key="label.applicationDisplayName" bundle="restore" />
											<input type="text" name="displayName" id="displayName"
												data-ng-model="vmFullOpenShift.restoreData.vmOptions.displayName"
												data-ng-disabled="!isOutOfPlaceRestore"
												data-ng-required="!vmFullOpenShift.restoreData.isAll() && !isOutOfPlaceRestore" />
											<span class="help-block"
												data-ng-show="isOutOfPlaceRestore
													&& vmFullRestoreForm.displayName.$error 
													&& cv.vmFullRestoreForm.needsAttention(vmFullRestoreForm.displayName)">
												<cv:msg key="error.displayName" bundle="restore" />
											</span>
										</label>
									</div>
								</div>
								<div class="col-xs-12">
									<div data-ng-if="!vmFullOpenShift.isEndUser && isOutOfPlaceRestore">
										<label for="projects">
											<cv:msg key="label.projects" bundle="restore" />
											<select name="projects" id="projects"
												data-ng-model="vmFullOpenShift.restoreData.vmOptions.project"
												data-ng-options="p as p.displayName for p in vmFullOpenShift.restoreData.globalOptions.projectList track by (p.displayName|lowercase)"
												data-ng-required="!vmFullOpenShift.restoreData.isAll() && isOutOfPlaceRestore"
												data-ng-change="vmFullOpenShift.projectChanged()"/>
											</select>
											<span class="help-block"
												data-ng-show="isOutOfPlaceRestore
													&& vmFullOpenShift.restoreData.globalOptions.projectList.length > 0 
													&& vmFullRestoreForm.projects.$error 
													&& cv.vmFullRestoreForm.needsAttention(vmFullRestoreForm.projects)">
												<cv:msg key="error.project" bundle="restore" />
											</span>
										</label>
									</div>
								</div>
							</div>
						</div>
					</div>
					<div class="button-container">
						<button id="vmFullRestoreRedHatOpenShift_button_#4469" type="button" class="btn btn-default" data-ng-click="vmFullOpenShift.closeModal()"> 
							<cv:msg key="Cancel" bundle="messages" />
						</button>
						<button id="vmFullRestoreRedHatOpenShift_button_#6282" type="submit" class="btn cvBusyOnAjax btn-primary"> 
							<cv:msg key="Submit" bundle="messages" />
						</button>
					</div>
				</form>
			</div>
			<div>
				<label id="vmFullRestoreRedHatOpenShift_label_overwrite" data-ng-click="vmFullOpenShift.restoreData.globalOptions.overwrite  = !vmFullOpenShift.restoreData.globalOptions.overwrite; vmFullOpenShift.overwriteOptionChanged()">
					<toggle-control id="vmFullRestoreRedHatOpenShift_toggle_overwrite" status="vmFullOpenShift.restoreData.globalOptions.overwrite ? 'enabled-activity' : 'disabled-activity'">
					</toggle-control><span><cv:msg	key="warning.overwrite" bundle="restore" /></span>
				</label>
			</div>
			<div>
				<label>
					<div class="global-options remove-border-padding padding-top-10 padding-left-10">
						<cv-alert-me selected="false" text="<cv:msg key='label.notifyUserOnJobCompletion' bundle='messages'/>"></cv-alert-me>
					</div>
				</label>
			</div>
		</div>
	</div>
</div>
