<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<fmt:bundle basename="localization.restore">
		
		<!-- showVM will be true when we get destination servers..If users doesn't have access to servers then we will only allow user to choose Vm name and do retsore -->
		<div class="setup-content" data-ng-show="!showVM">
			<span class="{{serverMessage.type}} serverMessage">{{serverMessage.message}}</span>
			<form name="vmFullRestoreForm" novalidate
				class='vm-full-restore-form' data-cv-submit="restoreVms()"
				autocomplete="off">
				<label for="displayName" class="data-store-label"> <!-- !!! STYLE -->
					<cv:msg key="label.changeVmDisplayName" bundle="restore" /> <input
					type="text" name="displayName"
					data-ng-model="restoreData.vmOptions.displayName"
					data-ng-required="true" />
			    <span class="help-block"
					data-ng-show="vmFullRestoreForm.displayName.$error && cv.vmFullRestoreForm.needsAttention(vmFullRestoreForm.displayName)">
						<cv:msg key="error.displayName" bundle="restore"  />
				</span>
				</label> 
			
			</form>
		</div>
		<div class="setup-content" data-ng-show="showVM">
			<div class="global-options">
					<div data-ng-if="servers">
						<label for="serverId" class="select-label restorePathLabel">
							<cv:msg key="label.fsServer" bundle="restore" />
							<select data-ng-model="restoreData.globalOptions.serverDetails"
							data-ng-options="server.name for server in servers" required
							data-ng-change="destinationServerChanged()">
						</select>
						</label>
						<div style="clear: both;"></div>
					</div>
					<div data-ng-if="showProxy">
						<label for="destinationProxy"
							class="select-label restorePathLabel"> <!-- !!! STYLE -->
							<cv:msg key="label.proxy" bundle="restore"></cv:msg> <select
							id="destinationProxy" name="destinationProxy"
							data-ng-required="true"
							data-ng-model="restoreData.globalOptions.proxy"
							data-ng-options="ds as ds.clientName for ds in restoreData.globalOptions.proxyList track by (ds.clientName|lowercase)">
						</select>
						</label>
					</div>
					<!-- 		<input name="inPlace" id="inPlace" type="checkbox"  data-ng-model="restoreData.globalOptions.inPlace">
				<label for="inPlace" class="overwriteLabel"><cv:msg key="label.inPlace" /></label><!-- !!! Style -->
			</div>
			<div class="local-options">
				<div class="error"
					data-ng-show="cv.vmFullRestoreForm.getAttempted() && showSomeVmsInvalidWarning()">
					<cv:msg key="error.allVmOptions" bundle="restore"/>
				</div>
					<ul class="vm-full-restore-list">
						<li data-ng-show="multipleVmsSelected()"><a class="btn"
							data-ng-click="displayAllVmOptions()"
							data-ng-class="{'selected-value': restoreData.isAll()}"><cv:msg
									key="label.allvms" bundle="restore" /></a></li>
						<li data-ng-repeat="vmOptions in restoreData.vmOptionsList">
							<a class="btn" data-ng-click="displayVmOptions(vmOptions)" title="{{vmOptions.browseData.displayName}}"
							data-ng-class="{'selected-value': restoreData.vmOptions == vmOptions}">{{vmOptions.browseData.displayName}}</a>
							<span class="error"
							data-ng-show="cv.vmFullRestoreForm.getAttempted() && !isVmOptionValid(vmOptions)">*</span>
						</li>
					</ul>
				<form name="vmFullRestoreForm" novalidate
					class='vm-full-restore-form form-horizontal bootstrap-wrapper padding-bottom-0' data-cv-submit="restoreVms()"
					autocomplete="off">
						<div id="perVmOptions" class="mainFormContent hyperv-restore-form-content">
						<div class="{{serverMessage.type}}"
							data-ng-bind="serverMessage.message"></div>
							<div class="form-group">
							<div class="col-xs-12">
							<label data-ng-show="!restoreData.isAll()" for="displayName" class="data-store-label">
							<cv:msg	key="label.changeVmDisplayName" bundle="restore" />
							<input	data-ng-disabled="isRestoreInPlace()" type="text"
								name="displayName"
								data-ng-model="restoreData.vmOptions.displayName"
								data-ng-required="!restoreData.isAll() && !isRestoreInPlace()" />
								<span class="help-block"
								data-ng-show="!isRestoreInPlace() && vmFullRestoreForm.displayName.$error && cv.vmFullRestoreForm.needsAttention(vmFullRestoreForm.displayName)">
									<cv:msg key="error.displayName" bundle="restore" />
							</span>
							</label>
							</div>
							</div>
							<!-- prefix/suffix for vm display names on the all vms tab -->
							<div class="" data-ng-show="restoreData.isAll()">
							<input name="enablePrefixSuffix" id="enablePrefixSuffix" type="checkbox"
								data-ng-model="restoreData.globalOptions.enablePrefixSuffix" data-ng-change="prefixSuffixSelectorChanged()">
								<label for="enablePrefixSuffix" class="label-only restore-options-label"><cv:msg key="label.dispayNamePrefixSuffixTitle" bundle="restore"/></label>
								<label class="label-only restore-options-label">
									<input id="displayNamePrefix" type="radio" name="displayNamePrefixSuffix" value="prefix" data-ng-model="restoreData.prefixSuffixSelector"
										data-ng-disabled="!restoreData.globalOptions.enablePrefixSuffix" data-ng-change="prefixSuffixNameChanged()"/><span class="restore-settings-right-padding"><cv:msg key="label.prefix" bundle="restore"/></span>
									<input id="displayNameSuffix" type="radio" name="displayNamePrefixSuffix" value="suffix" data-ng-model="restoreData.prefixSuffixSelector"
										data-ng-disabled="!restoreData.globalOptions.enablePrefixSuffix" data-ng-change="prefixSuffixNameChanged()"/><span class="restore-settings-right-padding"><cv:msg key="label.suffix" bundle="restore"/></span>
									<input type="text" name="displayNamePrefixSuffix" placeholder="<cv:msg key="placeholder.prefixSuffixDisplayName" bundle="restore"/>" data-ng-model="restoreData.displayNamePrefixSuffix"
										data-ng-disabled="!restoreData.globalOptions.enablePrefixSuffix" data-ng-blur="prefixSuffixNameChanged()"/>
								</label>
							</div>
							<div class="form-group">
							<div class="col-xs-12">
							<div class="input-group">
							<label for="destinationHost" class="destination-vm">
							<cv:msg key="label.oracleVmDestinationServer" bundle="restore" />
							<input type="text" readonly name="destinationHost" id="destinationHost"
								value="{{restoreData.getCurrentHostDisplayName()}}"
								data-ng-required="true && !restoreData.isAll()" />
								<span class="help-block"
								data-ng-show="!restoreData.isAll() && restoreData.vmOptions.destinationHost === null && cv.vmFullRestoreForm.getAttempted()">
									<cv:msg key="error.oracleVmDestinationServer" bundle="restore" />
							</span>
							</label>
							<span class="input-group-btn">
							<button id="vmFullRestoreOracleVM_button_#3176" type="button" 
								data-ng-click="openSelectDestinationHostDialog(restoreData.subClientEntity)"
								class="btn btn-default browse-btn" >
								<cv:msg key="label.browse" bundle="restore" />
							</button>
							</span>
							</div>
							</div>
							</div>
							<div class="form-group">
							<div class="col-xs-12">
							<!-- <label class="label-only restore-options-label"></label> -->
							<label for="data-store"	class="data-store-label">
							<cv:msg key="label.repository" bundle="restore" />
							<select	id="data-store" name="dataStore"
								data-ng-required="true && !restoreData.isAll()"
								data-ng-model="restoreData.vmOptions.dataStore"
								data-ng-disabled="!isDataStoreListAvailable()"
								data-ng-options="ds as getDataStoreDropdownLabel(ds) for ds in restoreData.vmOptions.dataStoreList track by ds.dataStoreName"
								data-ng-change="dataStoreChanged()">
									<option value=''>{{getDataStoreDropdownText()}}</option>
							</select>
							<span class="help-block" data-ng-show="!restoreData.isAll() && vmFullRestoreForm.dataStore.$error && cv.vmFullRestoreForm.needsAttention(vmFullRestoreForm.dataStore) && isDataStoreListAvailable()">
									<cv:msg key="error.repository" bundle="restore" />
							</span>
							</label>
							</div>
							</div>
						</div>
					<div class="button-container">
						<fmt:bundle basename="localization.messages">
							<button id="vmFullRestoreOracleVM_button_#8762" type="button" class="btn btn-default setup-btn--hidden" 
								data-ng-click="cancel()">
								<cv:msg key="Cancel" bundle="messages" />
							</button>
							<button id="vmFullRestoreOracleVM_button_#1304" type="submit"
								class="btn cvBusyOnAjax btn-primary">
								<cv:msg key="Submit" bundle="messages" />
							</button>
						</fmt:bundle>
					</div>
				</form>
			</div>
			<label id="vmFullRestoreOracleVM_label_powerOn" data-ng-if="showVM" data-ng-click="restoreData.globalOptions.powerOn = !restoreData.globalOptions.powerOn" for="powerOn" class="overwriteLabel" >
				<toggle-control id="vmFullRestoreOracleVM_toggle_powerOn" status="restoreData.globalOptions.powerOn ? 'enabled-activity' : 'disabled-activity'">
				</toggle-control><span><cv:msg key="label.powerOn" bundle="restore"/></span>
			</label>
			<label id="vmFullRestoreOracleVM_label_overwrite" data-ng-if="showVM" data-ng-click="restoreData.globalOptions.overwrite = !restoreData.globalOptions.overwrite; overwriteOptionChanged()">
				<toggle-control id="vmFullRestoreOracleVM_toggle_overwrite" status="restoreData.globalOptions.overwrite ? 'enabled-activity' : 'disabled-activity'">
				</toggle-control><span><cv:msg key="warning.overwrite" bundle="restore" /></span>
			</label>
			<label>
				<div class="global-options remove-border-padding padding-top-10 padding-left-10">
					<cv-alert-me selected="false" text="<cv:msg key='label.notifyUserOnJobCompletion' bundle='messages'/>"></cv-alert-me>
				</div>
			</label>
			 <cv-plain-accordion accordion-label="label.additionalOptions" collapsed="additionalOptions" data-ng-show="showVM">
			 		<label id="vmFullRestoreOracleVM_label_diskProv" for="diskProvOption" class="select-label"><cv:msg
							key="label.diskProvisioning" bundle="collectionsJs" /> <select id="vmFullRestoreOracleVM_diskProv"
						name="diskProvOption"
						data-ng-options="diskOption.value as diskOption.name for diskOption in diskProvisionOptions"
						data-ng-model="diskProvOption">
					</select> </label>
			 </cv-plain-accordion>
		</div>
</fmt:bundle>