<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
 <fmt:bundle basename="localization.restore">
		<!-- showVM will be true when we get destination servers..If users doesn't have access to servers then we will only allow user to choose Vm name and do retsore -->
		<span class="setup-content">
			<span class="{{serverMessage.type}} serverMessage">{{serverMessage.message}}</span>
		</span>
		<div class="setup-content" data-ng-show="!showVM">
			<!-- <span class="{{serverMessage.type}} serverMessage">{{serverMessage.message}}</span>-->
			<form name="vmFullRestoreFormNoServer" novalidate class='vm-full-restore-form' data-cv-submit="restoreVms()" autocomplete ="off" >
				<label  for="displayName" class="data-store-label"><!-- !!! STYLE --><cv:msg key="label.changeVmDisplayName" bundle="restore"/>
					<input  type="text" name="displayName" data-ng-model="restoreData.vmOptions.displayName" required/>
					<span class="help-block" data-ng-show="cv.vmFullRestoreFormNoServer.needsAttention(vmFullRestoreFormNoServer.displayName)"><fmt:message key="error.displayName" /></span>
				</label>
			
				<div class="button-container" >
					<fmt:bundle basename="localization.messages">
						<button id="vmFullRestoreOracleCloudInfrastructure_button_#2224" type="button" class="btn btn-default setup-btn--hidden cvBusyOnAjax" data-ng-click="cancel()"><fmt:message key="Cancel" /></button> 
						<button id="vmFullRestoreOracleCloudInfrastructure_button_#3354" type="submit"  class="btn btn-primary cvBusyOnAjax"><fmt:message key="Submit" /></button> 
					</fmt:bundle>
				</div>
			</form>
		</div>
		<div class="setup-content" data-ng-show="showVM">			
				<div class="global-options">
					<div>
						<label for="serverId">
							<cv:msg key="label.fsServer" bundle="restore"></cv:msg>
						<div class="company-multi-select" data-ng-if="!isOutOfPlaceRestore">
							<p class="no-margin">{{server.serverDetails.clientName}}</p>
							</div>
							<select data-ng-model="server.serverDetails"
									data-ng-options="server.name for server in servers" required
									data-ng-change="destinationServerChanged()"
									data-ng-if="isOutOfPlaceRestore">
							</select>							
						</label>
						<div  style="clear:both;"></div>
					</div>
					<!-- oci proxy always require for restore -->
					<div>
						<label for="destinationProxy" class="select-label restorePathLabel" ><!-- !!! STYLE --><cv:msg key="label.proxyClient" bundle="restore"></cv:msg>
							<select id="destinationProxy" name="destinationProxy"  data-ng-required="true"
									data-ng-model="restoreData.globalOptions.proxy"
									data-ng-options="ds as ds.clientName for ds in restoreData.globalOptions.proxyList track by (ds.clientName|lowercase)"
									data-ng-change="proxyServerChanged()">
									 
							</select>
							<span class="help-block"
									data-ng-show="showProxy && !restoreData.globalOptions.proxy.clientId">
									<fmt:message key="error.proxySelection" />
							</span>
						</label>
					</div>
					<div class="margin-10 text-left">
    					<cv-please-note  header='<cv:msg key="action.note" bundle="restoreJs" />' body='<cv:msg key="msg.ociProxySelectionHelpText" bundle="restore"/>'></cv-please-note>
					</div>
		<%-- 			<div data-ng-if="!isCrossRestore()" data-ng-disabled="restoreData.globalOptions.disableInPlaceRestore">
						<input name="showInPlaceRestore" id="showInPlaceRestore"
							type="checkbox" data-ng-model="restoreData.globalOptions.inPlaceRestore"
							data-ng-change="populateInPlaceOptions()">
						<label for="showInPlaceRestore" class="overwriteLabel"><cv:msg
							key="label.inPlaceRestore" bundle="restore" />
						</label>
					</div> --%>
					</div>
				<div class="local-options">
					<div class="error" data-ng-show="cv.vmFullRestoreForm.getAttempted() && showSomeVmsInvalidWarning()" ><fmt:message key="error.allInstanceOptions" /></div>
					
					<ul class="vm-full-restore-list">
						<li data-ng-show="multipleVmsSelected()">
							<a class="btn" data-ng-click="displayAllVmOptions()" data-ng-class="{'selected-value': restoreData.isAll()}"><fmt:message key="label.allInstances" /></a>
						</li>
						<li data-ng-repeat="vmOptions in restoreData.vmOptionsList">
							<a class="btn" data-ng-click="displayVmOptions(vmOptions)"
								title="{{vmOptions.browseData.displayName}}"
								data-ng-class="{'selected-value': restoreData.vmOptions == vmOptions}">{{vmOptions.browseData.displayName}}</a>
							<span  class="error" data-ng-show="cv.vmFullRestoreForm.getAttempted() && !isVmOptionValid(vmOptions)">*</span>
						</li>
					</ul>
				
					<form name="vmFullRestoreForm" novalidate class='vm-full-restore-form' data-cv-submit="restoreVms()" autocomplete ="off" >
						
						<div id="perVmOptions" class="mainFormContent hyperv-restore-form-content">
							<label data-ng-show="!restoreData.isAll()" for="displayName"
									class="data-store-label"><!-- !!! STYLE --><cv:msg key="label.changeInstanceDisplayName" bundle="restore"/>
								<input data-ng-disabled="isRestoreInPlace()" type="text" name="displayName"
									data-ng-model="restoreData.vmOptions.displayName" data-ng-required="!restoreData.isAll() && !isRestoreInPlace()" data-ng-pattern="instanceNamePattern" required/>
								<span class="help-block cv-help-block"
									data-ng-show="!isRestoreInPlace() && vmFullRestoreForm.displayName.$error && cv.vmFullRestoreForm.needsAttention(vmFullRestoreForm.displayName)">
									<fmt:message key="error.displayName" />
								</span>
								<span class="help-block cv-help-block"
									data-ng-show="!isRestoreInPlace() && vmFullRestoreForm.displayName.$error.pattern && cv.vmFullRestoreForm.needsAttention(vmFullRestoreForm.displayName)">
									<fmt:message key="error.displayName.pattern.oraclecloud" />
								</span>
								<br/>
							</label>
							
							<!-- prefix/suffix for vm display names on the all vms tab -->
							<div class="" data-ng-show="restoreData.isAll()">
							<input name="enablePrefixSuffix" id="enablePrefixSuffix" type="checkbox"
								data-ng-model="restoreData.globalOptions.enablePrefixSuffix" data-ng-disabled="isRestoreInPlace()" data-ng-change="prefixSuffixSelectorChanged()">
								<label for="enablePrefixSuffix" class="label-only restore-options-label"><cv:msg key="label.dispayNamePrefixSuffixTitleAmazon" bundle="restore"/></label>
								<label class="label-only restore-options-label">
									<input id="displayNamePrefix" type="radio" name="displayNamePrefixSuffix" value="prefix" data-ng-model="restoreData.prefixSuffixSelector"
										data-ng-disabled="!restoreData.globalOptions.enablePrefixSuffix || isRestoreInPlace()" data-ng-change="prefixSuffixNameChanged()"/><span class="restore-settings-right-padding"><cv:msg key="label.prefix" bundle="restore"/></span>
									<input id="displayNameSuffix" type="radio" name="displayNamePrefixSuffix" value="suffix" data-ng-model="restoreData.prefixSuffixSelector"
										data-ng-disabled="!restoreData.globalOptions.enablePrefixSuffix || isRestoreInPlace()" data-ng-change="prefixSuffixNameChanged()"/><span class="restore-settings-right-padding"><cv:msg key="label.suffix" bundle="restore"/></span>
									<input type="text" name="displayNamePrefixSuffix" placeholder="<cv:msg key="placeholder.prefixSuffixDisplayNameAmazon" bundle="restore"/>"
										data-ng-model="restoreData.displayNamePrefixSuffix" data-ng-disabled="!restoreData.globalOptions.enablePrefixSuffix" data-ng-blur="prefixSuffixNameChanged()"/>
								</label>					
							</div>
												
						<div data-ng-if="!isRestoreInPlace()">
							<!-- open a new modal to show user account information -->
							<label for="compartment" class="label-only restore-options-label"><cv:msg key="label.compartment" bundle="restore"></cv:msg> </label>
							<label for="compartment" class="select-label data-store-label" >
							
								<select id="compartment" name="compartment"
									data-ng-model="restoreData.vmOptions.compartment"
									data-ng-options="item as item.displayName for item in restoreData.vmOptions.compartmentList track by item.displayName"
									data-ng-required="true"		
									data-ng-disabled="!isCompartmentistAvailable()"															
									data-ng-change="compartmentChanged(restoreData.vmOptions.compartment, {{restoreData.vmOptions.compartment|| 'null'}})">
									 <option disabled value=''>{{getCompartmentDropdownText()}}</option>
								</select>
								<span class="help-block cv-help-block" data-ng-show="!restoreData.isAll() && !isCompartmentistAvailable() && cv.vmFullRestoreForm.getAttempted()">
									<cv:msg key="error.compartment" bundle="restore"></cv:msg>
								</span>
							</label>
							
							<!-- this looks like instance type needs some sort of dropdown -->
							<label class="label-only restore-options-label"><cv:msg key="label.shapes" bundle="restore"></cv:msg></label>
							<label for="instanceShape" class="select-label data-store-label" ><!-- !!! STYLE -->
								<select id="instanceShape" name="instanceShape"  data-ng-required="true"
										data-ng-model="restoreData.vmOptions.instanceShape"
										data-ng-disabled="!isInstanceShapeListAvailable()"
										data-ng-options="instanceShape as getinstanceShapeLabel(instanceShape) for instanceShape in restoreData.vmOptions.instanceShapeList track by instanceShape.name"
										data-ng-change="instanceShapeChanged(restoreData.vmOptions.instanceShape, {{restoreData.vmOptions.instanceShape || 'null'}})">
										<option disabled value=''>{{getInstanceShapeDropdownText()}}</option>
								</select>
								<span class="help-block cv-help-block" data-ng-show="!restoreData.isAll() && cv.vmFullRestoreForm.getAttempted() && !restoreData.vmOptions.instanceShape">
									<cv:msg key="error.shapes" bundle="restore"></cv:msg>
								</span>
							</label>						
							
							<label for="availabilityDomain" class="label-only restore-options-label"><cv:msg key="label.availabilityDomain" bundle="restore"></cv:msg>
									<cv-help-component help-text="<cv:msg key="msg.ociProxySelectionHelpText" bundle="restore"/>"></cv-help-component>
							</label>
							
							<label for="availabilityDomain" class="select-label data-store-label" >
							
								<select id="availabilityDomain" name="availabilityDomain"  data-ng-required="true"
											data-ng-model="restoreData.vmOptions.availabilityDomain"
											data-ng-disabled="!isAvailabilityDomainListAvailable()"
											data-ng-options="availabilityDomain as availabilityDomain.name for availabilityDomain in restoreData.vmOptions.availabilityDomainList track by availabilityDomain.name"
											data-ng-change="availabilityDomainChanged(restoreData.vmOptions.availabilityDomain, {{restoreData.vmOptions.availabilityDomain || 'null'}})">
											<option disabled value=''>{{getAvailabilityDropdownText()}}</option>
								</select>
								<span class="help-block cv-help-block" data-ng-show="!restoreData.isAll() && cv.vmFullRestoreForm.getAttempted() && !isAvailabilityDomainListAvailable()">
										<cv:msg key="error.availabilityDomain" bundle="restore"></cv:msg>
								</span>
							</label>
							
						<!-- open a new modal to show network settings information information -->
							<label for="networkSettings" class="label-only restore-options-label"><cv:msg key="label.virtualCloudNetwork" bundle="restore"></cv:msg></label>
							
							<label for="networkSettings" class="select-label data-store-label" >
								<select id="networkSettings" name="networkSettings"  data-ng-required="true"
											data-ng-model="restoreData.vmOptions.networkSettings"
											data-ng-disabled="!isNetworkSettingsListAvailable()"
											data-ng-options="networkInfo as networkInfo.networkName for networkInfo in restoreData.vmOptions.networkSettingsList track by optionsTracker(networkInfo)"
											data-ng-change="networkSettingsChanged(restoreData.vmOptions.networkSettings, {{restoreData.vmOptions.networkSettings || 'null'}})">
											<option disabled value=''>{{getNetworkSettingsDropdownText()}}</option>
								</select>
								<span class="help-block cv-help-block" data-ng-show="!restoreData.isAll() && cv.vmFullRestoreForm.getAttempted() && !isNetworkSettingsListAvailable()">
										<cv:msg key="error.virtualCloudNetwork" bundle="restore"></cv:msg>
								</span>
							</label>
							
							<label for="subnetSettings" class="label-only restore-options-label"><cv:msg key="label.subnet" bundle="restore"></cv:msg></label>							
							<label for="subnetSettings" class="select-label data-store-label" >
								<select id="subnetSettings" name="subnetSettings"  data-ng-required="true"
											data-ng-model="restoreData.vmOptions.subnetSettings"
											data-ng-disabled="!isSubnetSettingsListAvailable()"
											data-ng-options="subnetInfo as subnetInfo.name for subnetInfo in restoreData.vmOptions.subnetSettingsList track by optionsTracker(subnetInfo)"
											data-ng-change="subnetSettingsChanged(restoreData.vmOptions.subnetSettings, {{restoreData.vmOptions.subnetSettings || 'null'}})">
											<option disabled value=''>{{getSubnetSettingsDropdownText()}}</option>
								</select>
								<span class="help-block cv-help-block" data-ng-show="!restoreData.isAll() && cv.vmFullRestoreForm.getAttempted() && !isSubnetSettingsListAvailable()">
										<cv:msg key="error.subnet" bundle="restore"></cv:msg>
								</span>
							</label>
							<label for="stagingBucket" class="label-only restore-options-label"><cv:msg key="label.stagingBucket" bundle="restore"></cv:msg></label>
							<label for="stagingBucket" class="select-label data-store-label" >
								<select id="stagingBucket" name="stagingBucket"  data-ng-required="isCrossRestore()"
											data-ng-model="restoreData.vmOptions.stagingBucket"
											data-ng-disabled="!isStagingBucketListAvailable()"
											data-ng-options="bucketInfo.name for bucketInfo in restoreData.vmOptions.stagingBucketsList track by bucketInfo.name"
											data-ng-change="stagingBucketChanged(restoreData.vmOptions.stagingBucket, {{restoreData.vmOptions.stagingBucket || 'null'}})">
											<option disabled value=''>{{getStagingBucketDropdownText()}}</option>
								</select>
								<span class="help-block cv-help-block" data-ng-show="isCrossRestore() && !restoreData.isAll() && cv.vmFullRestoreForm.getAttempted() && !isStagingBucketListAvailable()">
										<cv:msg key="error.stagingBucket" bundle="restore"></cv:msg>
								</span>
							</label>	
														
							<input name="createPublicIp" id="createPublicIp" type="checkbox" data-ng-model="restoreData.vmOptions.createPublicIp" data-ng-change="createPublicIpChanged(restoreData.vmOptions.createPublicIp,{{restoreData.vmOptions.createPublicIp || 'null'}})"> 
                            <label for="createPublicIp" class="destination-vm"><cv:msg key="label.createPublicIp" bundle="restore" /></label>				
						</div>
					</div>
					<div class="button-container">
							<fmt:bundle basename="localization.messages">
								<button id="vmFullRestoreOracleCloudInfrastructure_button_#1513" type="button" class="btn btn-default setup-btn--hidden cvBusyOnAjax" data-ng-click="cancel()"><fmt:message key="Cancel" /></button> 
								<button id="vmFullRestoreOracleCloudInfrastructure_button_#5059" type="submit"  class="btn btn-primary cvBusyOnAjax" ><fmt:message key="Submit" /></button> 
							</fmt:bundle>
					</div>
				</form>
				</div>
				<label id="vmFullRestoreOracleCloudInfrastructure_label_powerOn" data-ng-click="restoreData.globalOptions.powerOn = !restoreData.globalOptions.powerOn" for="powerOn" class="overwriteLabel" ng-init="restoreData.globalOptions.powerOn=true">
					<toggle-control id="vmFullRestoreOracleCloudInfrastructure_toggle_powerOn" status="restoreData.globalOptions.powerOn ? 'enabled-activity' : 'disabled-activity'">
					</toggle-control><span><cv:msg key="label.powerInstanceOn" bundle="restore"/></span>
				</label>

				<label id="vmFullRestoreOracleCloudInfrastructure_label_overwrite" data-ng-click="restoreData.globalOptions.overwrite = !restoreData.globalOptions.overwrite; overwriteOptionChanged()">
					<toggle-control id="vmFullRestoreOracleCloudInfrastructure_toggle_overwrite" status="restoreData.globalOptions.overwrite ? 'enabled-activity' : 'disabled-activity'">
						</toggle-control><span><cv:msg key="warning.overwrite" bundle="restore" /></span>
				</label>
				<label>
					<div class="global-options remove-border-padding padding-top-10 padding-left-10">
						<cv-alert-me selected="false" text="<cv:msg key='label.notifyUserOnJobCompletion' bundle='messages'/>"></cv-alert-me>
					</div>
				</label>
		</div>
</fmt:bundle>
