<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.collectionsJs"></cv:cvMessages>
</script>
 <fmt:bundle basename="localization.restore">
		<!-- <div class="setup-title">
			<h1><fmt:message key="label.restoreOpts" /></h1>
		</div> -->
		<!-- showVM will be true when we get destination servers..If users doesn't have access to servers then we will only allow user to choose Vm name and do retsore -->
		<span class="setup-content">
			<span class="{{serverMessage.type}} serverMessage">{{serverMessage.message}}</span>
		</span>
		<div class="setup-content" data-ng-show="!showVM">
			<form name="vmFullRestoreFormNoServer" novalidate class='vm-full-restore-form' data-cv-submit="restoreVms()" autocomplete ="off" >
				<label  for="displayName" class="data-store-label"><!-- !!! STYLE --><cv:msg key="label.changeVmDisplayName" bundle="restore"/>
					<input  type="text" name="displayName" data-ng-model="restoreData.vmOptions.displayName" required/>
					<span class="help-block" data-ng-show="cv.vmFullRestoreFormNoServer.needsAttention(vmFullRestoreFormNoServer.displayName)"><fmt:message key="error.displayName" /></span>
				</label>
				<div class="button-container" >
					<fmt:bundle basename="localization.messages">
						<button id="vmFullRestoreOpenStack_button_#0864" type="button" class="btn btn-default setup-btn--hidden cvBusyOnAjax" data-ng-click="cancel()"><fmt:message key="Cancel" /></button> 
						<button id="vmFullRestoreOpenStack_button_#1969" type="submit"  class="btn btn-primary cvBusyOnAjax"><fmt:message key="Submit" /></button> 
					</fmt:bundle>
				</div>
			</form>
		</div>
		<div class="setup-content" data-ng-show="showVM">
				<div class="global-options">
				   <!-- Shows Virtualization Client-->
					<div>
						<label for="serverId" class="select-label restorePathLabel">
								<fmt:message key="label.fsServer" />
							<select data-ng-model="restoreData.globalOptions.serverDetails"
									data-ng-options="server.name for server in servers" required
									data-ng-change="destinationServerChanged()">
							</select>
						</label>
						<div  style="clear:both;"></div>
					</div>
				 <!-- Shows Destination Client(Proxies) -->
					<div data-ng-if="showProxy">
						<label for="destinationProxy" class="select-label restorePathLabel" ><!-- !!! STYLE --><cv:msg key="label.proxy" bundle="restore"></cv:msg>
							<select id="destinationProxy" name="destinationProxy"  data-ng-required="true"
									data-ng-model="restoreData.globalOptions.proxy"
									data-ng-options="ds as ds.clientName for ds in restoreData.globalOptions.proxyList track by (ds.clientName|lowercase)">
							</select>
						</label>
				   </div>
				</div>
				<!--  These are Vm specific restore Options -->
				<div class="local-options">
					<div class="error" data-ng-show="cv.vmFullRestoreForm.getAttempted() && showSomeVmsInvalidWarning() " ><fmt:message key="error.allVmOptions" /></div>
					<ul class="vm-full-restore-list">
						<li data-ng-show="multipleVmsSelected()">
							<a class="btn" data-ng-click="displayAllVmOptions()" data-ng-class="{'selected-value': restoreData.isAll()}"><fmt:message key="label.allvms" /></a>
						</li>
						<li data-ng-repeat="vmOptions in restoreData.vmOptionsList">
							<a class="btn" data-ng-click="displayVmOptions(vmOptions)"
								title="{{vmOptions.browseData.displayName}}"
								data-ng-class="{'selected-value': restoreData.vmOptions == vmOptions}">{{vmOptions.browseData.displayName}}</a>
							<span  class="error" data-ng-show="cv.vmFullRestoreForm.getAttempted() && !isVmOptionValid(vmOptions)">*</span>
						</li>
					</ul>
					<form name="vmFullRestoreForm" novalidate class='vm-full-restore-form' data-cv-submit="restoreVms()" autocomplete ="off" >
						<div id="perVmOptions" class="mainFormContent">
                        <div class="form-group">
						<div class="col-xs-12">
						<!-- Instance Name -->
							<label data-ng-show="!restoreData.isAll()" for="displayName"
									class="data-store-label"><!-- !!! STYLE --><cv:msg key="label.changeInstanceDisplayName" bundle="restore"/>
								<input data-ng-disabled="isRestoreInPlace()" type="text" name="displayName"
									data-ng-model="restoreData.vmOptions.displayName" data-ng-required="!restoreData.isAll() && !isRestoreInPlace()" />
								<span class="help-block"
									data-ng-show="!isRestoreInPlace() && vmFullRestoreForm.displayName.$error && cv.vmFullRestoreForm.needsAttention(vmFullRestoreForm.displayName)">
									<fmt:message key="error.displayName" />
								</span>
							</label>
					    </div>
					    </div>
							<!-- prefix/suffix for vm display names on the all vms tab -->
							<div class="" data-ng-show="restoreData.isAll()">
							<input name="enablePrefixSuffix" id="enablePrefixSuffix" type="checkbox"
								data-ng-model="restoreData.globalOptions.enablePrefixSuffix" data-ng-change="prefixSuffixSelectorChanged()">
								<label for="enablePrefixSuffix" class="label-only restore-options-label"><cv:msg key="label.dispayNamePrefixSuffixTitle" bundle="restore"/></label>
								<label class="label-only restore-options-label">
									<input id="displayNamePrefix" type="radio" name="displayNamePrefixSuffix" value="prefix" data-ng-model="restoreData.prefixSuffixSelector"
										data-ng-disabled="!restoreData.globalOptions.enablePrefixSuffix" data-ng-change="prefixSuffixNameChanged()"/><span class="restore-settings-right-padding"><cv:msg key="label.prefix" bundle="restore"/></span>
									<input id="displayNameSuffix" type="radio" name="displayNamePrefixSuffix" value="suffix" data-ng-model="restoreData.prefixSuffixSelector"
										data-ng-disabled="!restoreData.globalOptions.enablePrefixSuffix" data-ng-change="prefixSuffixNameChanged()"/><span class="restore-settings-right-padding"><cv:msg key="label.suffix" bundle="restore"/></span>
									<input type="text" name="displayNamePrefixSuffix" placeholder="<cv:msg key="placeholder.prefixSuffixDisplayName" bundle="restore"/>"
										data-ng-model="restoreData.displayNamePrefixSuffix" data-ng-disabled="!restoreData.globalOptions.enablePrefixSuffix" data-ng-blur="prefixSuffixNameChanged()"/>
								</label>
							</div>
							<!-- Availability Zones they are similar to host for other vendor -->
                            <div class="form-group">
							<div class="col-xs-12">
							<div class="input-group">
							<!-- destination Host -->
							<label for="availabilityZone" class="destination-vm"><cv:msg key="label.availabilityZone" bundle="restore"></cv:msg>
								 <input type="text"
								 name="destinationHost" id="destinationHost"
								value="{{restoreData.getCurrentHostDisplayName()}}"
								data-ng-required="true && !restoreData.isAll()" />
								<span class="help-block"
								data-ng-show="!restoreData.isAll() && restoreData.vmOptions.destinationHost === null && cv.vmFullRestoreForm.getAttempted()">
									<cv:msg key="error.availabilityZone" bundle="restore"></cv:msg>
							</span>
							</label>
							<span class="input-group-btn">
							<button id="vmFullRestoreOpenStack_button_#5105" type="button" 
								data-ng-click="openSelectDestinationHostDialog(restoreData.subClientEntity)"
								class="btn btn-default browse-btn" >
								<fmt:message key="label.browse" />
							</button>
							</span>
                           </div>
                           </div>
                           </div>
                           <!-- Volume types(Request type 3) -->
                           <div class="form-group">
							<div class="col-xs-12">
							<label for="data-store"	class="data-store-label">
							<cv:msg key="label.volumeType" bundle="collectionsJs"/>
							<select	id="data-store" name="dataStore"
								data-ng-required="false"
								data-ng-model="restoreData.vmOptions.dataStore"
								data-ng-disabled="!isDataStoreListAvailable()"
								data-ng-options="ds as ds.dataStoreName for ds in restoreData.vmOptions.dataStoreList track by ds.dataStoreName"
								data-ng-change="dataStoreChanged()">
								<!-- <option value=''>{{getDataStoreDropdownText()}}</option> -->
							</select>
							<span class="help-block" data-ng-show="!restoreData.isAll() && vmFullRestoreForm.dataStore.$error && cv.vmFullRestoreForm.needsAttention(vmFullRestoreForm.dataStore) && isDataStoreListAvailable()">
									<fmt:message key="error.volumeType" />
							</span>
							</label>
							</div>
							</div>
                           <!-- Flavor(Request type 8) -->
                           <div class="form-group">
							<div class="col-xs-12">
							<label for="flavor"	class="data-store-label">
							<fmt:message key="label.flavor" />
							<select	id="flavor" name="flavor"
								data-ng-required="false"
								data-ng-model="restoreData.vmOptions.flavor"
								data-ng-disabled="!isFlavorListAvailable()"
								data-ng-options="flavor as flavor.name for flavor in restoreData.vmOptions.flavorList track by flavor.name"
								data-ng-change="flavorChanged()">
								<!-- <option value=''>{{getFlavorDropdownText()}}</option> -->
							</select>
							<span class="help-block" data-ng-show="!restoreData.isAll() && vmFullRestoreForm.flavor.$error && cv.vmFullRestoreForm.needsAttention(vmFullRestoreForm.flavor) && isFlavorListAvailable()">
									<fmt:message key="error.flavor" />
							</span>
							</label>
							</div>
							</div>
                           <!-- Security Groups (Request type 10) -->
                            <div class="form-group">
							<div class="col-xs-12">
							<label for="securityGroup"	class="data-store-label">
							<fmt:message key="label.securityGroup" />
				
							<isteven-multi-select id="vmFullRestoreOpenStack_isteven-multi-select_#8030" 
													input-model="restoreData.vmOptions.securityGroupList"
													output-model="selectedSecurityGroup"
													button-label="groupName"
													item-label="groupName"
													tick-property="selected"
													directive-id="securityGroup"
													selection-mode="single"
													class="isteven-multi-select user-group-select single-select"
													helper-elements="filter"
													search-limit="10"
													max-labels="1"
													translation="localLang"
													on-item-click="securityGroupChanged(selectedSecurityGroup[0])">
											</isteven-multi-select>
							<span class="help-block" data-ng-show="!restoreData.isAll() && vmFullRestoreForm.securityGroup.$error && cv.vmFullRestoreForm.needsAttention(vmFullRestoreForm.securityGroup) && isSecurityGroupListAvailable()">
									<fmt:message key="error.securityGroup" />
							</span>
							</label>
							</div>
							</div>
							<!-- Key Pair(request type  11)-->
                           <div class="form-group">
							<div class="col-xs-12">
							<label for="keyPair"	class="data-store-label">
							<fmt:message key="label.keyPair" />
							<select	id="keyPair" name="keyPair"
								data-ng-required="false"
								data-ng-model="restoreData.vmOptions.keyPair"
								data-ng-disabled="!isKeyPairListAvailable()"
								data-ng-options="item as item.keyName for item in restoreData.vmOptions.keyPairList track by item.keyName"
								data-ng-change="keyPairChanged()">
								<!-- <option value=''>{{getKeyPairDropdownText()}}</option> -->
							</select>
							<span class="help-block" data-ng-show="!restoreData.isAll() && vmFullRestoreForm.keyPair.$error && cv.vmFullRestoreForm.needsAttention(vmFullRestoreForm.keyPair) && isKeyPairListAvailable()">
									<fmt:message key="error.keyPair" />
							</span>
							</label>
							</div>
							</div>
							 <div class="form-group">
							<div class="col-xs-12">
							<label for="network" class="destination-vm"><cv:msg key="label.networkInterface" bundle="restore"/>
								<select  id="network" name="network"  data-ng-required="true"
										data-ng-model="restoreData.vmOptions.networkInfo"
										data-ng-change="networkOptionChanged()"
										data-ng-options="item as item.networkDisplayName  for item in restoreData.vmOptions.networkList track by item.networkDisplayName">
								</select>
					       </label>
                            </div>
							</div>
						</div>
						<div class="button-container">
							<fmt:bundle basename="localization.messages">
								<button id="vmFullRestoreOpenStack_button_#4380" type="button" class="btn btn-default setup-btn--hidden cvBusyOnAjax" data-ng-click="cancel()"><fmt:message key="Cancel" /></button> 
								<button id="vmFullRestoreOpenStack_button_#2838" type="submit"  class="btn btn-primary cvBusyOnAjax" ><fmt:message key="Submit" /></button> 
							</fmt:bundle>
						</div>
					</form>
				</div>
				<label data-ng-click="restoreData.globalOptions.powerOn = !restoreData.globalOptions.powerOn" data-ng-show="showVM" for="powerOn" class="overwriteLabel">
					<toggle-control status="restoreData.globalOptions.powerOn ? 'enabled-activity' : 'disabled-activity'">
						</toggle-control><span><cv:msg key="label.powerInstanceOn" bundle="restore"/></span>
				</label>
				<label data-ng-click="restoreData.globalOptions.overwrite = !restoreData.globalOptions.overwrite; overwriteOptionChanged()" data-ng-show="showVM">
					<toggle-control status="restoreData.globalOptions.overwrite ? 'enabled-activity' : 'disabled-activity'">
						</toggle-control><span><cv:msg key="warning.overwrite" bundle="restore" /></span>
				</label>
				<label>
					<div class="global-options remove-border-padding padding-top-10 padding-left-10">
						<cv-alert-me selected="false" text="<cv:msg key='label.notifyUserOnJobCompletion' bundle='messages'/>"></cv-alert-me>
					</div>
				</label>
		</div>
</fmt:bundle>
