<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<fmt:bundle basename="localization.restore">
	<!-- showVM will be true if destination servers are available. If users do not have access to then servers, he will have access to only   choose a VM and restore -->
	<div class="setup-content" data-ng-show="!showVM">
		<span class="{{serverMessage.type}} serverMessage">{{serverMessage.message}}</span>
		<form name="vmFullRestoreForm" novalidate class='vm-full-restore-form'
			data-cv-submit="restoreVms()" autocomplete="off">
			<label for="displayName">
				<cv:msg key="label.instanceDisplayName" bundle="restore" /> <input
				type="text" name="displayName"
				data-ng-model="restoreData.vmOptions.displayName"
				data-ng-required="true" /> <span class="help-block"
				data-ng-show="vmFullRestoreForm.displayName.$error && cv.vmFullRestoreForm.needsAttention(vmFullRestoreForm.displayName)">
					<fmt:message key="error.displayName" />
			</span>
			</label>
			<div class="button-container">
				<fmt:bundle basename="localization.messages">
					<button id="vmFullRestoreGoogleCloud_button_#7476" type="button" class="btn btn-default setup-btn--hidden" 
						data-ng-click="cancel()">
						<fmt:message key="Cancel" />
					</button>
					<button id="vmFullRestoreGoogleCloud_button_#5883" type="submit" class="btn btn-primary"> 
						<fmt:message key="Submit" />
					</button>
				</fmt:bundle>
			</div>
		</form>
	</div>
	<div class="setup-content" data-ng-show="showVM">
		<span class="{{serverMessageTop.type}} serverMessage">{{serverMessageTop.message}}</span>
		<div class="global-options">
				<div data-ng-if="servers">
					<label for="serverId">
						<fmt:message key="label.fsServer"/>
							<div class="company-multi-select" data-ng-if="!isOutOfPlaceRestore">
								<p class="no-margin">{{restoreData.globalOptions.serverDetails.clientName}}</p>
							</div>
						 <select
						data-ng-model="restoreData.globalOptions.serverDetails"
						data-ng-disabled="ownVcenter.select"
						data-ng-options="server.name for server in servers" required
						data-ng-change="destinationServerChanged()"
						data-ng-if="isOutOfPlaceRestore">
					</select>
					</label>
				</div>
				<div data-ng-if="showProxy" class="setup-input-group text-left">
					<label for="destinationProxy" class="schedule-repeat-label inline-label">					
						<cv-help-text data-ng-if="distributeWorkload" help-text="label.proxy.auto.help" help-label="label.proxy"></cv-help-text>
						<span data-ng-if="!distributeWorkload">
							<cv:msg key="label.proxy" bundle="restore"></cv:msg>
						</span>
					</label>
					<div class="company-multi-select">
						<isteven-multi-select id="vmFullRestoreGoogleCloud_isteven-multi-select_#8259"
								input-model="restoreData.globalOptions.proxyList"
								output-model="selectedProxy"
								button-label="clientName"
								item-label="clientName"
								tick-property="selected"
								directive-id="proxy"
								selection-mode="single"
								class="isteven-multi-select user-group-select single-select"
								helper-elements="filter"
								search-limit="10"
								max-labels="1"
								translation="localLang"
								on-item-click="changeProxy(selectedProxy[0])">
						</isteven-multi-select>
					</div>
				</div>
				<!-- show an option to do out of place restore -->
<%-- 				<div
					data-ng-disabled="restoreData.globalOptions.disableInPlaceRestore || ownVcenter.select"
					data-ng-show="!isEndUser">
					<input name="showInPlaceRestore" id="showInPlaceRestore"
						type="checkbox"
						data-ng-model="restoreData.globalOptions.inPlaceRestore"
						data-ng-change="populateInPlaceOptions()"> <label
						for="showInPlaceRestore" class="overwriteLabel"><cv:msg
							key="label.inPlaceRestore" bundle="restore" /> </label>
				</div> --%>

		</div>
		<div class="local-options">
			<div class="error"
				data-ng-show="cv.vmFullRestoreForm.getAttempted() && showSomeVmsInvalidWarning()">
				<fmt:message key="error.allVmOptions" />
			</div>
			<div
				class="{{isRestoreInPlace() ? 'in-place-restore' : ''}}">
				<ul class="vm-full-restore-list">
					<li data-ng-show="multipleVmsSelected()"><a class="btn"
						data-ng-click="displayAllVmOptions()"
						data-ng-class="{'selected-value': restoreData.isAll()}"><fmt:message
								key="label.allvms" /></a></li>
					<li data-ng-repeat="vmOptions in restoreData.vmOptionsList"><a
						class="btn" data-ng-click="displayVmOptions(vmOptions)"
						title="{{vmOptions.browseData.displayName}}"
						data-ng-class="{'selected-value': restoreData.vmOptions == vmOptions}">{{vmOptions.browseData.displayName}}</a>
						<span class="error"
						data-ng-show="cv.vmFullRestoreForm.getAttempted() && !isVmOptionValid(vmOptions)">*</span>
					</li>
				</ul>
			</div>
			<form name="vmFullRestoreForm" novalidate
				class='vm-full-restore-form form-horizontal bootstrap-wrapper padding-bottom-0'
				data-cv-submit="restoreVms()" autocomplete="off">
				<div
					class="{{isRestoreInPlace() ? 'in-place-restore' : ''}}">
					<div id="perVmOptions" class="mainFormContent hyperv-restore-form-content">
						<div class="{{serverMessage.type}}"
							data-ng-bind="serverMessage.message"></div>
						<div class="form-group" data-ng-if="!restoreData.isAll()">
							<div class="col-xs-12">
								<label for="displayName"> <cv:msg
										key="label.instanceDisplayName" bundle="restore" /> <input
									type="text" name="displayName"
									data-ng-model="restoreData.vmOptions.displayName"
									data-ng-disabled="isRestoreInPlace()"
									data-ng-required="!restoreData.isAll() && !isRestoreInPlace()" />
									<span class="help-block"
									data-ng-show="!isRestoreInPlace() && vmFullRestoreForm.displayName.$error && cv.vmFullRestoreForm.needsAttention(vmFullRestoreForm.displayName)">
										<fmt:message key="error.displayName" />
									</span>
									<span class="help-block" data-ng-show="!isInstanceNameValid(restoreData.vmOptions.displayName)">
										<a href="https://cloud.google.com/compute/docs/labeling-resources#restrictions" target="_blank"><fmt:message key="error.instanceNameDoesNotMatchTheRequirements" /></a>
									</span>
								</label>
							</div>
						</div>
						<div data-ng-if="!isRestoreInPlace() && browseComplete">
							<cv-google-cloud-zone restore-data="restoreData" ctrl="ctrl">
							</cv-google-cloud-zone>
						</div>
						<div class="form-group" data-ng-if="!isRestoreInPlace()">
							<div class="col-xs-12">
								<label for="vmSizes"> <fmt:message
										key="label.machineType" /> <select id="vmSizes"
									name="vmSizes"
									data-ng-required="true && !restoreData.isAll()"
									data-ng-model="restoreData.vmOptions.vmSizes"
									data-ng-options="ds as getVMSizesDropdownLabel(ds) for ds in restoreData.vmOptions.vmSizesList track by ds.name"
									data-ng-change="vmSizeChanged(restoreData.vmOptions.vmSizes)">
										<option value=''>{{getVMSizesDropdownText()}}</option>
								</select> <span class="help-block"
									data-ng-show="!restoreData.isAll() && vmFullRestoreForm.vmSizes.$error && cv.vmFullRestoreForm.needsAttention(vmFullRestoreForm.vmSizes) && isVMSizesListAvailable()">
										<fmt:message key="error.machineType" />
								</span>
								</label>
							</div>
						</div>
						<div class="form-group" data-ng-if="!isRestoreInPlace()">
							<div class="col-xs-12">
								<input name="createPublicIP" id="createPublicIP" type="checkbox" data-ng-model="restoreData.vmOptions.hasPublicIP" data-ng-change="publicIPSelection()"> <label for="createPublicIP"><cv:msg
								key="label.externalIP" bundle="restore" /> </label>
							</div>
						</div>
						<div class="form-group" data-ng-if="!isRestoreInPlace() && !restoreData.isAll()">
							<cv-google-cloud-network 
								restore-data="restoreData"
								cross-restore="crossRestore">
							</cv-google-cloud-network>
						</div>
					</div>
				</div>
				<div class="button-container">
					<fmt:bundle basename="localization.messages">
						<button id="vmFullRestoreGoogleCloud_button_#5654" type="button" class="btn btn-default setup-btn--hidden" 
							data-ng-click="cancel()">
							<fmt:message key="Cancel" />
						</button>
						<button id="vmFullRestoreGoogleCloud_button_#0770" type="submit"
							class="btn cvBusyOnAjax btn-primary">
							<fmt:message key="Submit" />
						</button>
					</fmt:bundle>
				</div>
			</form>
		</div>
		<div class="row">
			<div class="col-xs-12">
				<label id="vmFullRestoreGoogleCloud_label_powerOn" data-ng-click="restoreData.globalOptions.powerOn = !restoreData.globalOptions.powerOn" for="powerOn" class="overwriteLabel" >
					<toggle-control id="vmFullRestoreGoogleCloud_toggle_powerOn" status="restoreData.globalOptions.powerOn ? 'enabled-activity' : 'disabled-activity'">
					</toggle-control><span><cv:msg key="label.powerOn" bundle="restore"/></span>
				</label>
			</div>
		</div>

		<div class="row"> 
			<div class="col-xs-12">
				<label id="vmFullRestoreGoogleCloud_label_overwrite" data-ng-click="restoreData.globalOptions.overwrite = !restoreData.globalOptions.overwrite; overwriteOptionChanged()">
						<toggle-control id="vmFullRestoreGoogleCloud_toggle_overwrite" status="restoreData.globalOptions.overwrite ? 'enabled-activity' : 'disabled-activity'">
						</toggle-control><span><cv:msg key="warning.overwrite" bundle="restore" /></span>
				</label>
			</div>
		</div>
		<div class="row">
            <div class="col-xs-12">
				<label>
					<div class="global-options remove-border-padding padding-top-10 padding-left-10">	
					<cv-alert-me selected="false" text="<cv:msg key='label.notifyUserOnJobCompletion' bundle='messages'/>"></cv-alert-me>
				</label>
            </div>
        </div>
	</div>
</fmt:bundle>