<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
 <fmt:bundle basename="localization.restore">
<div class="setup-title">
	<h1><fmt:message key="label.restoreOpts" /></h1>
</div>
<div class="setup-content" >
		<span class="{{serverMessage.type}} serverMessage">{{serverMessage.message}}</span>
	<form name="restoreForm" class="{{vmType}} restore-form" novalidate data-cv-submit="doRestore()" autocomplete="off">
		<div class="global-options destinationServerDiv margin-bottom-20">
				<label ><cv:msg key="label.proxy" bundle="restore"></cv:msg>
					<div class="company-multi-select">
							<isteven-multi-select id="vmFileRestore_isteven-multi-select_#2697" 
									input-model="restoreData.globalOptions.destinationServerList"
									output-model="selectedDestinationServer"
									button-label="clientName"
									item-label="clientName"
									directive-id="destinationServer"
									tick-property="selected"
									selection-mode="single"
									class="isteven-multi-select user-group-select single-select"
									helper-elements="filter"
									search-limit="10"
									max-labels="1"
									translation="localLang"
									on-item-click="destinationServerChanged(selectedDestinationServer[0])">
							</isteven-multi-select>
					</div>
				</label>
		</div>
		<div class="global-options remove-border-padding">
			<input style="display:none" type="text" name="fakeusernameremembered"/>
			<input style="display:none" type="password" name="fakepasswordremembered"/>
			<label><h4 class="text-left"><fmt:message key="label.impersonate" /></h4></label>
			<label>
				<fmt:message key="label.username" />
				<input type="text" name="vmLoginName" ng-model="destination.vmLoginName" autocomplete="new-password"/>
				<span class="help-block" data-ng-show="cv.restoreForm.needsAttention(restoreForm.vmLoginName)"><fmt:message key="error.userRequired" /></span>
			</label>
			<label>
				<fmt:message key="label.password" />
				<input type="password" name="vmPassword" ng-model="destination.vmPassword" autocomplete="new-password"/>
			</label>
			<label for="restorePath" class="restorePathLabel">
				<fmt:message key="label.path" />
				<button id="vmFileRestore_button_#7383" type="button" 
					data-ng-click="openSelectDestinationFolder(restoreData.subClientEntity)"
					class="btn btn-default browse-btn">
					<fmt:message key="label.browse" />
				</button>
				<input type="text" name="restorePath" id="restorePath" ng-model="destination.selectedPath" required>
				<span class="help-block" data-ng-show="cv.restoreForm.needsAttention(restoreForm.restorePath)"><fmt:message key="error.pathRequired" /></span>
			</label>
			<label data-ng-click="restoreData.globalOptions.overwrite = !restoreData.globalOptions.overwrite">
				<toggle-control status="restoreData.globalOptions.overwrite ? 'enabled-activity' : 'disabled-activity'">
				</toggle-control><span><cv:msg key="warning.overwrite" bundle="restore" /></span>
			</label>
			<label>
				<div class="global-options remove-border-padding padding-top-10">
					<cv-alert-me selected="false" text="<cv:msg key='label.notifyUserOnJobCompletion' bundle='messages'/>"></cv-alert-me>
				</div>
			</label>
		</div>
		<div class="button-container">
			<fmt:bundle basename="localization.messages">
				<button id="vmFileRestore_button_#7736" type="button" class="btn btn-default setup-btn--hidden" ng-click="cancel()"> 
					<fmt:message key="Cancel" />
				</button>
				<button id="vmFileRestore_button_#2388" class="btn cvBusyOnAjax btn-primary" type="submit" > 
					<fmt:message key="Submit" />
				</button>
			</fmt:bundle>
		</div>
	</form>
</div>
</fmt:bundle>
