<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
<cv:cvMessages bundle="localization.restoreJs"></cv:cvMessages>
<cv:cvMessages bundle="localization.restore"></cv:cvMessages>
</script>
<div data-ng-controller="vmFileLevelRestoreHyperVOptionsController">
<div class="setup-title">
	<h1><cv:msg key="label.restore" bundle="restore"/></h1>
</div>
<div class="setup-content" >
		<span class="{{serverMessage.type}} serverMessage">{{serverMessage.message}}</span>
	<form name="restoreForm" class="{{vmType}} restore-form" novalidate data-cv-submit="doRestore()" autocomplete="off">
		<div class="global-options destinationServerDiv">
				<label for="destinationServer" class="select-label restorePathLabel" ><!-- !!! STYLE --><cv:msg key="label.destinationServer" bundle="restore"/>
					<select id="destinationServer" name="destinationServer"  data-ng-required="true"
							data-ng-model="restoreData.globalOptions.destinationServer"
							data-ng-options="ds as ds.clientName for ds in restoreData.globalOptions.destinationServerList track by (ds.clientName|lowercase)"
							data-ng-change="destinationServerChanged()" >
					</select>
				</label>
		</div>
		<div class="global-options remove-border-padding">
			<div class="credentials"><!-- LOCALIZATION  -->
			<span class="border-title"><cv:msg key="label.impersonate" bundle="restore"/></span>
				<label>
					<cv:msg key="label.username" bundle="restore"/>
					<input type="text" name="vmLoginName" autocomplete="new-password" ng-model="vmLoginName"/>
					<span class="help-block" data-ng-show="cv.restoreForm.needsAttention(restoreForm.vmLoginName)"><cv:msg key="error.userRequired" bundle="restore"/></span>
				</label>
				<label>
					<cv:msg key="label.password" bundle="restore"/>
					<input type="password" name="vmPassword" autocomplete="new-password" ng-model="vmPassword" />
				</label>
			</div>
			<label for="restorePath" class="restorePathLabel">
				<cv:msg key="label.path" bundle="restore"/>
				<button id="vmFileLevelRestoreHyperV_button_#3431" type="button" 
					data-ng-click="openSelectDestinationFolder(restoreData.subClientEntity)"
					class="btn btn-default browse-btn">
					<cv:msg key="label.browse" bundle="restore"/>
				</button>
				<input type="text" name="restorePath" id="restorePath" ng-model="selectedPath" required>
				<span class="help-block" data-ng-show="cv.restoreForm.needsAttention(restoreForm.restorePath)"><cv:msg key="error.pathRequired" bundle="restore"/></span>
			</label>
			<div style="clear:both;">
				<input name="overwrite" id="overwrite" type="checkbox"  data-ng-model="restoreData.globalOptions.overwrite">
				<label for="overwrite" class="overwriteLabel"><cv:msg key="warning.overwrite" bundle="restore"/></label>
			</div>
		</div>
		<div class="button-container">
			<button id="vmFileLevelRestoreHyperV_button_#7037" type="button" class="btn btn-default setup-btn--hidden" ng-click="cancel()"> 
				<cv:msg key="action.cancel" bundle="restore"/>
			</button>
			<button id="vmFileLevelRestoreHyperV_button_#9394" class="btn cvBusyOnAjax btn-primary" type="submit" > 
				<cv:msg key="action.finish" bundle="restore"/>
			</button>
		</div>
	</form>
</div>
</div>
