
<!-- !!! Need these? -->
<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
<cv:cvMessages bundle="localization.restoreJs"></cv:cvMessages>
<cv:cvMessages bundle="localization.kubernetes"></cv:cvMessages>
</script>
 <fmt:bundle basename="localization.restore">
		<!-- <div class="{{enableSubRestoreTypes ? 'setup-content no-padding' : 'setup-content'}}"> -->
<form name="vmDiskRestoreForm" novalidate class='form-horizontal edit-users-grid-form bootstrap-wrapper vm-disk-restore-form' cv-submit="restoreVms()" autocomplete ="off" >
	<span class="server-message {{serverMessage.type}}">{{serverMessage.message}}</span>	
	<div >
		<!-- SELECT VOLUME TO (TEST) -->
		<div class="restore-form" data-ng-show="false">
			<div class=" option-group" >
				<label>
					<input type="radio" data-ng-model="model.vmType" value="thisVM" name="vmType" data-ng-change="resetCredentials()">
					<cv:msg key="label.myVM" bundle="restore"/><!-- {{dispName|vmNameForBreadCrumb}} -->
				</label>
				<label >
					<input type="radio" data-ng-model="model.vmType" value="otherVM" name="vmType"  data-ng-change="resetCredentials()">
					<fmt:message key="label.otherVm"/>
				</label>
			</div>
		</div>
		<!-- END OF SELECT VOLUME TO (TEST) -->
		<%-- <div data-ng-if="model.vmType=='otherVM'" class="form-group margin-right-0 margin-left-0 margin-top-10">
			<label for="serverId" class="col-xs-12 col-md-5 col-lg-5">
				<span data-ng-if="vendor && vendor==='AMAZON'"><cv:msg key="label.virtualizationClient" bundle="restore"/></span>
				<span data-ng-if="!vendor || (vendor && vendor!=='AMAZON')">
					<span><fmt:message key="label.destinationServer" /></span>
				</span>
			</label>
			
			<div class="col-xs-12 col-md-7 col-lg-7">
				<select id="serverId" data-ng-model="model.serverDetails"
						data-ng-options="server.name for server in servers" 
						required
						data-ng-change="destinationServerChanged()">
				</select>
			</div>
		</div > --%>
			<div data-ng-if="isKubernetes()">
				
					<cv-tabset-component control="tabControls" element='cvtile' on-select='setTabName' vendor-name='vendor'> 
						<cv-tab tabname='<cv:msg key="label.volume" bundle="kubernetes"/>' tabid='volume'> 
						</cv-tab> 
						<cv-tab tabname='<cv:msg key="label.fsDestination" bundle="kubernetes"/>' tabId='accessNode'> 
						</cv-tab> 
					</cv-tabset-component>
					<div class="setup-content padding-bottom-0" data-ng-if="browseType === 'vsDiskBrowse' && currentTabName !== 'accessNode'">
						<label><cv:msg key="header.type" bundle="vmsJs"></cv:msg>
							<div class="company-multi-select">
								<!-- In place -->
								<input class="no-float" id="inPlace" type="radio"
									name="restoreType" value="restoreVolumeInPlace"
									data-ng-model="inputType.volumeRestoreTypeSelector"
									ng-change="setRestoreTypeSelectorForVolumeRestore()" /> 
									<label for="inPlace"
									class="restore-settings-right-padding inline-label no-margin">
									<cv:msg key="label.restoreInPlace" bundle="restore"/>
									</label>
								<!-- Out of place -->
								<input id="outOfPlace" type="radio" name="restoreType"
									value="restoreVolumeOutOfPlace"
									data-ng-model="inputType.volumeRestoreTypeSelector"
									ng-change="setRestoreTypeSelectorForVolumeRestore()" /> <label for="outOfPlace"
									class="inline-label no-margin"> <cv:msg
										key="label.OOPRestore" bundle="restore" />
								</label>
							</div> 
						</label>
				</div>
			</div>
			
		<div class="form-group margin-right-0 margin-left-0" data-ng-if="vendor!=='AMAZON' || (vendor === 'AMAZON' && model.vmType !== 'thisVM')">
				<label class="col-xs-12 col-md-5 col-lg-5" >
					<span data-ng-if="!isAppSupportedVendor"><fmt:message key="label.destinationServer" /></span>
	 				<span data-ng-if="isAppSupportedVendor && currentTabName !== 'accessNode'"><fmt:message key="label.destinationServerKUBERNETES" /></span>
				</label>
				<div class="col-xs-12 col-md-7 col-lg-7" data-ng-if="isKubernetes() && currentTabName !== 'accessNode' && !isOutOfPlaceVolumeRestore">
					<p>{{selectedServer}}</p>
				</div>
				<div class="col-xs-12 col-md-7 col-lg-7" data-ng-if="(isKubernetes() && isOutOfPlaceVolumeRestore) || !isKubernetes()">
					<isteven-multi-select id="vmDiskRestore_isteven-multi-select_#5406" 
							input-model="servers"
							output-model="selectedServer"
							button-label="name"
							item-label="name"
							tick-property="selected"
							selection-mode="single"
							directive-id="destinationServer"
							class="isteven-multi-select user-group-select single-select"
							helper-elements="filter"
							search-limit="10"
							max-labels="1"
							translation="localLang"
							on-item-click="destinationServerChanged(selectedServer[0])">
					</isteven-multi-select>
			</div>
		</div>
		<!--  file restore, guest agent restore, download restore -->
        <div class="form-group margin-right-0 margin-left-0"  data-ng-if="model.vmType=='otherVM' && restoreData.globalOptions.proxyList.length > 0">
			<label class="col-xs-12 col-md-5 col-lg-5" for="destinationProxy" class="select-label restorePathLabel">
				<span data-ng-if="vendor && vendor==='AMAZON'">
					<span><cv:msg key="label.proxyClient" bundle="restore" /></span>
				</span>
				<span data-ng-if="!vendor || (vendor && vendor!=='AMAZON')">
					<span><fmt:message key="label.proxy" /></span>
				</span>
			</label>
				<div class="col-xs-12 col-md-7 col-lg-7">
						<isteven-multi-select id="vmDiskRestore_isteven-multi-select_#4918" 
								input-model="restoreData.globalOptions.proxyList"
								output-model="selectedProxy"
								button-label="clientName"
								item-label="clientName"
								tick-property="selected"
								directive-id="proxy"
								selection-mode="single"
								class="isteven-multi-select user-group-select single-select"
								helper-elements="filter"
								search-limit="10"
								max-labels="1"
								translation="localLang"
								on-item-click="changeProxy(selectedProxy[0])">
						</isteven-multi-select>
				</div>
		</div>
		
		<!-- volume -->
		<div data-ng-if="isKubernetes()">
			<div class="global-options remove-border-padding" data-ng-if="currentTabName === 'accessNode'">
				<label class="margin-left-10"><h4><fmt:message key="label.impersonate" /> </h4></label>
				<div  class="form-group margin-right-0 margin-left-0" >
					<label class="col-xs-12 col-md-5 col-lg-5">
						<fmt:message key="label.username" /> 
					</label>
					<div class="col-xs-12 col-md-7 col-lg-7">
						<input type="text" name="vmLoginName" ng-model="destinationNode.vmLoginName" autocomplete="new-password"/>
						<span class="help-block" data-ng-show="cv.restoreForm.needsAttention(restoreForm.vmLoginName)"><fmt:message key="error.userRequired" /></span>
					</div>
				</div>
			
				<div class="form-group margin-right-0 margin-left-0" >
					<label class="col-xs-12 col-md-5 col-lg-5">
						<fmt:message key="label.password" /> 
					</label>
					<div class="col-xs-12 col-md-7 col-lg-7">
					<input type="password" name="vmPassword" ng-model="destinationNode.vmPassword" autocomplete="new-password"/>
					</div>
				</div>
			</div>
			<div class="form-group margin-right-0 margin-left-0" data-ng-if="isOutOfPlaceVolumeRestore">
				<label class="col-xs-12 col-md-5 col-lg-5" for="destinationVolume">
					<cv:msg key="label.volume" bundle="kubernetes"/>
				</label>
				<div class="col-xs-12 col-md-7 col-lg-7">
					<div class="input-group">
						<input type="text" readonly name="volume" id="volume" value="{{restoreData.getCurrentDisplayName()}}" required />
								<span class="input-group-btn">
									<button id="vmDiskRestore_volume_button_#4586" type="button"  
										data-ng-click="openSelectVolumeDialog(restoreData.subClientEntity)"
										class="btn btn-default browse-btn">
										<fmt:message key="label.browse" />
									</button>
								</span>
					</div>
					<span class="help-block" data-ng-show="restoreData.diskOptions.destinationVm === null && cv.vmDiskRestoreForm.getAttempted()">{{destinationVmError}}</span>
				</div>
			</div>
			<div  class="form-group margin-right-0 margin-left-0" data-ng-if="isOutOfPlaceVolumeRestore || currentTabName === 'accessNode'">
				<label class="col-xs-12 col-md-5 col-lg-5" for="destinationVm">
					<fmt:message key="label.path"/>
				</label>
				<div class="col-xs-12 col-md-7 col-lg-7"  data-ng-if="isOutOfPlaceVolumeRestore">
						<input type="text" name="path" id="path" placeholder="<cv:msg key="placeholder.enterPath" bundle="kubernetes"/>" data-ng-model="destinationNode.selectedPath">
				</div>
				<div class="col-xs-12 col-md-7 col-lg-7" data-ng-if="currentTabName === 'accessNode'">
					<div class="input-group">
						<input type="text" readonly name="volume" id="volume" ng-model="destinationNode.selectedPath" required />
						<span class="input-group-btn">
							<button id="vmDiskRestore_path_button_#4586" type="button"  
									data-ng-click="openSelectPathDialog(restoreData.subClientEntity)"
									class="btn btn-default browse-btn">
								<fmt:message key="label.browse" />
							</button>
						</span>
					</div>
				</div>
			</div>
		</div>
		<!-- destination vm for AMAZON is a global option -->
		<div class="form-group margin-right-0 margin-left-0"  data-ng-if="model.vmType=='otherVM' && (vendor && vendor === 'AMAZON')">						
			<label class="col-xs-12 col-md-5 col-lg-5" for="destinationVm" class="restorePathLabel">
				<cv:msg key="label.restoreToExistingInstance" bundle="restore"/>
				<span class="help-block" data-ng-show="restoreData.globalOptions.destinationVm === null && cv.vmDiskRestoreForm.getAttempted()">
					<cv:msg key="error.destinationInstance" bundle="restore"/>
				</span>
			</label>
			
			<div class="col-xs-12 col-md-7 col-lg-7 input-group">
				<input type="text" readonly name="destinationVm" id="destinationVm" value="{{restoreData.getDisplayName()}}" required/>
				<span class="input-group-btn">
					<button id="vmDiskRestore_button_#6118" type="button" data-ng-click="openSelectDestinationVmDialog(restoreData.subClientEntity)" class="btn btn-default browse-btn"> 
						<fmt:message key="label.browse" />
					</button>
				</span>
			</div>
		</div>
		<div data-ng-if="advancedOptionsApplicable()" >
			<!-- Disk provisioning options  -->
			<div class="form-group margin-right-0 margin-left-0">
				<label class="col-xs-12 col-md-5 col-lg-5" for="diskProvOption" class="select-label">
					<cv:msg key="label.diskProvisioning" bundle="collectionsJs" />
				</label>
				 
				<div class="col-xs-12 col-md-7 col-lg-7">
				 	<isteven-multi-select id="vmDiskRestore_isteven-multi-select_#0315" 
						input-model="diskProvisionOptions"
						output-model="selectedDiskProvOption"
						button-label="name"
						directive-id="diskProvision"
						item-label="name"
						tick-property="selected"
						selection-mode="single"
						class="isteven-multi-select user-group-select single-select"
						helper-elements="None"
						max-labels="1"
						translation="localLang"
						on-item-click="changeDiskProvOption(selectedDiskProvOption[0].value)">
					 </isteven-multi-select>
				 </div>
			</div>
			
			<!-- Transport mode options  -->
			<div class="form-group margin-right-0 margin-left-0">
				<label class="col-xs-12 col-md-5 col-lg-5" for="transportMode" >
					<cv:msg key="label.transportMode" bundle="collectionsJs" />
				</label>
				
				<div class="col-xs-12 col-md-7 col-lg-7">
					<isteven-multi-select id="vmDiskRestore_isteven-multi-select_#6366" 
						input-model="transportModeTypes"
						output-model="selectedTransportModeType"
						button-label="name"
						item-label="name"
						tick-property="selected"
						directive-id="transportMode"
						selection-mode="single"
						class="isteven-multi-select user-group-select single-select"
						helper-elements="None"
						max-labels="1"
						translation="localLang"
						on-item-click="changeTransportModeType(selectedTransportModeType[0].value)">
					</isteven-multi-select>
				</div>
			</div>
		</div>
		
		<!-- Instance/VM selection  -->
		<div class="form-group margin-right-0 margin-left-0" data-ng-if="model.vmType==='thisVM'">
			<label class="col-xs-12 col-md-5 col-lg-5" for="destinationVM" >
				{{selectVMLabel}}
			</label>
			
			<div class="col-xs-12 col-md-7 col-lg-7">
				<isteven-multi-select id="vmDiskRestore_isteven-multi-select_#6727" 
					input-model="myVMList"
					output-model="restoreData.globalOptions.destinationVm"
					button-label="name"
					item-label="name"
					tick-property="selected"
					directive-id="destinationVM"
					selection-mode="single"
					class="isteven-multi-select user-group-select single-select"
					helper-elements="None"
					max-labels="1"
					translation="localLang"
					on-item-click="changeMyVM()">
				</isteven-multi-select>
			</div>
		</div>
	
		<div class="form-group margin-right-0 margin-left-0" data-ng-if="!isKubernetes()">
			<hr/>
			<div class="col-xs-12 col-md-5 col-lg-5 scrolling-div-300">
				<ul class="vm-disk-restore-list width-full" >
					<li data-ng-repeat="diskOptions in restoreData.diskOptionsList">
						<a class="btn" data-ng-click="displayDiskOptions(diskOptions)" data-ng-class="{'selected-value': restoreData.diskOptions == diskOptions}" title="{{diskOptions.browseData.displayName}}">{{diskOptions.browseData.displayName}}</a>
						<span data-ng-show="cv.vmDiskRestoreForm.getAttempted() && !isDiskOptionValid(diskOptions)">(!)</span>
					</li>
				</ul>
			</div>
			<div class="col-xs-12 col-md-7 col-lg-7 no-padding">
				<div id="vm-per-disk-options" class="mainFormContent">
					<div class="form-group">
<%-- 						<label class="col-xs-12" for="displayName"><cv:msg key="label.changeDiskName" bundle="restore" /></label> --%>
						<div class="col-xs-12">
							<input type="text"  
								name="displayName" id="displayName" data-ng-model="restoreData.diskOptions.displayName" 
								class="margin-bottom-0" data-ng-required="false" />
							<span class="parenthetical-text no-margin italic">{{diskNameHelpText}}</span>
						</div>
					</div>
					<div data-ng-if="model.vmType=='otherVM' && (!vendor || (vendor && vendor !=='AMAZON'))">
						<div class="form-group">
							<label class="col-xs-12" for="destinationVm">{{destinationVm}}</label>
							<div class="col-xs-12">
								<div class="input-group">
									<input type="text" readonly name="destinationVm" id="destinationVm" value="{{restoreData.getCurrentDisplayName()}}" required />
									<span class="input-group-btn">
										<button id="vmDiskRestore_button_#4586" type="button"  
										data-ng-click="openSelectDestinationVmDialog(restoreData.subClientEntity)"
										class="btn btn-default browse-btn">
											<fmt:message key="label.browse" />
										</button>
									</span>
								</div>
								<span class="help-block" data-ng-show="restoreData.diskOptions.destinationVm === null && cv.vmDiskRestoreForm.getAttempted()">{{destinationVmError}}</span>
							</div>
						</div>
		
						<div class="form-group" data-ng-if="vendor =='OPENSTACK'">
							<label class="col-xs-12" for="availabiltyZone"><cv:msg key="label.availabilityZone" bundle="restore"></cv:msg></label>
							<div class="col-xs-12">
								<div class="input-group">
									<input type="text" readonly name="availabilityZone" id="availabilityZone" value="{{restoreData.getCurrentHostDisplayName()}}" required />
				
									<span class="input-group-btn">
										<button id="vmDiskRestore_button_#2120" type="button" data-ng-click="openSelectDestinationHostDialog(restoreData.subClientEntity,isZone)" class="btn btn-default browse-btn"><fmt:message key="label.browse" /></button> 
									</span>
				
								</div>
								<span class="help-block"
										data-ng-show="restoreData.diskOptions.availabilityZone=== null && cv.vmDiskRestoreForm.getAttempted()"><cv:msg key="error.availabilityZone" bundle="restore"></cv:msg></span>
							</div>
						</div>
		
						<div class="form-group">
							<label class="col-xs-12" for="data-store">{{dataStoreText}}</label>
							<div class="col-xs-12">
								<div data-ng-disabled="restoreData.diskOptions.dataStore == defaultDataStore">
									<isteven-multi-select id="vmDiskRestore_isteven-multi-select_#1047" 
											input-model="restoreData.diskOptions.dataStoreList"
											output-model="selectedDataStore"
											button-label="label"
											item-label="label"
											tick-property="selected"
											directive-id="dataStore"
											selection-mode="single"
											class="isteven-multi-select user-group-select single-select"
											helper-elements="filter"
											search-limit="10"
											max-labels="1"
											translation="localLang"
											on-item-click="changeDataStore(selectedDataStore[0])">
									</isteven-multi-select>
								</div>
								<span class="help-block"
													data-ng-show="vmDiskRestoreForm.dataStore.$error && cv.vmDiskRestoreForm.needsAttention(vmDiskRestoreForm.dataStore) && isDataStoreListAvailable()">
													<fmt:message key="error.dataStore" />
								</span>
								<span class="help-block"
									data-ng-show="cv.vmDiskRestoreForm.getAttempted() && !restoreData.diskOptions.dataStoresAvailable">
									{{dataStoreError}}
								</span>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>	
		<!-- Overwrite checkbox  -->
		<div class="form-group margin-right-0 margin-left-0" data-ng-if="advancedOptionsApplicable() || vendor === 'KUBERNETES'">
			<div class="col-xs-12">
				<label data-ng-click="restoreData.globalOptions.overwrite = !restoreData.globalOptions.overwrite">
					<toggle-control status="restoreData.globalOptions.overwrite ? 'enabled-activity' : 'disabled-activity'">
					</toggle-control>&nbsp;<span><cv:msg key="warning.overwrite" bundle="restore" /></span>
				</label>
			</div>
		</div>
		
		<div data-ng-bind="serverMessage.message" ></div>
        <div class="form-group margin-right-0 margin-left-0">
            <div class="col-xs-12">
            	<cv-alert-me selected="false" text="<cv:msg key='label.notifyUserOnJobCompletion' bundle='messages'/>"></cv-alert-me>
            </div>
        </div>
		
		<!-- // end data-ng-if="!vendor || (vendor && vendor !=='AMAZON')" // -->
			
		<%-- <div id="per-disk-options" class="mainFormContent" data-ng-if="vendor && vendor==='AMAZON'">
			<div class="form-group">
				<div class="col-xs-12">
					<input type="text" name="displayName" 
					data-ng-model="restoreData.diskOptions.displayName" 
					data-ng-required="false"
					placeholder="<cv:msg key='label.renameAWSVolume' bundle='restore'/>" />
				</div>
			</div>
			
			<div class="form-group" data-ng-if="model.vmType=='thisVM'">
				<label class="col-xs-12" for="myVM"><cv:msg key="status.vms" bundle="vms" /></label>
				<div class="col-xs-12">
					<select id="myVM" name="myVM"  data-ng-required="true"
								data-ng-model="restoreData.diskOptions.destinationVm"
								data-ng-options="destVM as destVM.name for destVM in myVMList track by (destVM.name|lowercase)"
								data-ng-change="changeMyVM(data.myVM)">
					</select>
				</div>
			</div>
		</div> --%>
		<!-- // end data-ng-if="vendor && vendor==='AMAZON'" // -->
		<div class="modal-footer">
			<fmt:bundle basename="localization.messages">
				<button id="vmDiskRestore_button_#3426" type="button" class="btn btn-default setup-btn--hidden" data-ng-click="cancel()"><fmt:message key="Cancel" /></button> 
				<button id="vmDiskRestore_button_#2920" type="submit"  class="btn cvBusyOnAjax btn-primary"><fmt:message key="Submit" /></button> 
			</fmt:bundle>
		</div>
	</div> 
</form>
<div data-ng-show="cv.vmDiskRestoreForm.getAttempted() && showSomeDisksInvalidWarning()" ><span data-ng-if="vendor && vendor==='AMAZON'"><cv:msg key="error.allVolumeOptions" bundle="restore"/></span>
							<span data-ng-if="!vendor || (vendor && vendor!=='AMAZON')"><fmt:message key="error.allDiskOptions" /></span></div>
</fmt:bundle>
